/*
 * Decompiled with CFR 0.152.
 */
package xtrememp.visualization.spectrum;

import xtrememp.visualization.spectrum.BandGain;
import xtrememp.visualization.spectrum.FFT;

public class FrequencyBandGain
implements BandGain {
    private float bias;

    public FrequencyBandGain(float bias) {
        this.bias = bias;
    }

    @Override
    public float[] create(FFT fft, float sampleRate) {
        int oss = fft.getOutputSampleSize();
        float[] fqt = fft.calculateFrequencyTable(sampleRate);
        float[] bgTable = new float[oss];
        for (int i = 0; i < oss; ++i) {
            bgTable[i] = (fqt[i] / this.bias + 512.0f) / 512.0f * (this.bias * 1.5f);
        }
        return bgTable;
    }
}

