/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.CompileHandler;
import com.izforge.izpack.installer.CompileResult;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileExecutor;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;

public class CompileWorker
implements Runnable {
    private ArrayList jobs;
    private static final String SPEC_RESOURCE_NAME = "CompilePanel.Spec.xml";
    private VariableSubstitutor vs;
    private Thread compilationThread;
    private XMLElement spec;
    private AutomatedInstallData idata;
    private CompileHandler handler;
    private XMLElement compilerSpec;
    private ArrayList compilerList;
    private String compilerToUse;
    private XMLElement compilerArgumentsSpec;
    private ArrayList compilerArgumentsList;
    private String compilerArgumentsToUse;
    private CompileResult result = null;

    public CompileWorker(AutomatedInstallData idata, CompileHandler handler) throws IOException {
        this.idata = idata;
        this.handler = handler;
        this.vs = new VariableSubstitutor(idata.getVariables());
        this.compilationThread = null;
        if (!this.readSpec()) {
            throw new IOException("Error reading compilation specification");
        }
    }

    public ArrayList getAvailableCompilers() {
        this.readChoices(this.compilerSpec, this.compilerList);
        return this.compilerList;
    }

    public void setCompiler(String compiler) {
        this.compilerToUse = compiler;
    }

    public String getCompiler() {
        return this.compilerToUse;
    }

    public ArrayList getAvailableArguments() {
        this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
        return this.compilerArgumentsList;
    }

    public void setCompilerArguments(String arguments) {
        this.compilerArgumentsToUse = arguments;
    }

    public String getCompilerArguments() {
        return this.compilerArgumentsToUse;
    }

    public CompileResult getResult() {
        return this.result;
    }

    public void startThread() {
        this.compilationThread = new Thread((Runnable)this, "compilation thread");
        this.compilationThread.start();
    }

    public void run() {
        try {
            if (!this.collectJobs()) {
                String[] dummy_command = new String[]{"no command"};
                this.result = new CompileResult(this.idata.langpack.getString("CompilePanel.worker.nofiles"), dummy_command, "", "");
            } else {
                this.result = this.compileJobs();
            }
        }
        catch (Exception e) {
            this.result = new CompileResult();
            this.result.setStatus(23);
            this.result.setAction(27);
        }
        this.handler.stopAction();
    }

    private boolean readSpec() {
        InputStream input;
        try {
            input = ResourceManager.getInstance().getInputStream(SPEC_RESOURCE_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(new StdXMLBuilder());
        parser.setValidator(new NonValidator());
        try {
            parser.setReader(new StdXMLReader(input));
            this.spec = (XMLElement)parser.parse();
        }
        catch (Exception e) {
            System.out.println("Error parsing XML specification for compilation.");
            e.printStackTrace();
            return false;
        }
        if (!this.spec.hasChildren()) {
            return false;
        }
        this.compilerArgumentsList = new ArrayList();
        this.compilerList = new ArrayList();
        XMLElement global = this.spec.getFirstChildNamed("global");
        if (global != null) {
            this.compilerSpec = global.getFirstChildNamed("compiler");
            if (this.compilerSpec != null) {
                this.readChoices(this.compilerSpec, this.compilerList);
            }
            this.compilerArgumentsSpec = global.getFirstChildNamed("arguments");
            if (this.compilerArgumentsSpec != null) {
                this.readChoices(this.compilerArgumentsSpec, this.compilerArgumentsList);
            }
        }
        if (this.compilerList.size() == 0) {
            this.compilerList.add("javac");
            this.compilerList.add("jikes");
        }
        if (this.compilerArgumentsList.size() == 0) {
            this.compilerArgumentsList.add("-O -g:none");
            this.compilerArgumentsList.add("-O");
            this.compilerArgumentsList.add("-g");
            this.compilerArgumentsList.add("");
        }
        return true;
    }

    private void readChoices(XMLElement element, ArrayList result) {
        Vector choices = element.getChildrenNamed("choice");
        if (choices == null) {
            return;
        }
        result.clear();
        Iterator choice_it = choices.iterator();
        while (choice_it.hasNext()) {
            List osconstraints;
            XMLElement choice = (XMLElement)choice_it.next();
            String value = choice.getAttribute("value");
            if (value == null || !OsConstraint.oneMatchesCurrentSystem(osconstraints = OsConstraint.getOsList(choice))) continue;
            result.add(this.vs.substitute(value, "plain"));
        }
    }

    private boolean collectJobs() throws Exception {
        XMLElement data = this.spec.getFirstChildNamed("jobs");
        if (data == null) {
            return false;
        }
        ArrayList classpath = new ArrayList();
        this.jobs = new ArrayList();
        this.collectJobsRecursive(data, classpath);
        return true;
    }

    private CompileResult compileJobs() {
        CompilationJob first_job;
        CompileResult check_result;
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(this.compilerArgumentsToUse);
        while (tokenizer.hasMoreTokens()) {
            args.add(tokenizer.nextToken());
        }
        Iterator job_it = this.jobs.iterator();
        this.handler.startAction("Compilation", this.jobs.size());
        if (job_it.hasNext() && !(check_result = (first_job = (CompilationJob)this.jobs.get(0)).checkCompiler(this.compilerToUse, args)).isContinue()) {
            return check_result;
        }
        int job_no = 0;
        while (job_it.hasNext()) {
            CompilationJob job = (CompilationJob)job_it.next();
            this.handler.nextStep(job.getName(), job.getSize(), job_no++);
            CompileResult result = job.perform(this.compilerToUse, args);
            if (result.isContinue()) continue;
            return result;
        }
        Debug.trace("compilation finished.");
        return new CompileResult();
    }

    private CompilationJob collectJobsRecursive(XMLElement node, ArrayList classpath) throws Exception {
        Enumeration toplevel_tags = node.enumerateChildren();
        ArrayList ourclasspath = (ArrayList)classpath.clone();
        ArrayList<File> files = new ArrayList<File>();
        while (toplevel_tags.hasMoreElements()) {
            String finalname;
            String name;
            XMLElement child = (XMLElement)toplevel_tags.nextElement();
            if (child.getName().equals("classpath")) {
                this.changeClassPath(ourclasspath, child);
                continue;
            }
            if (child.getName().equals("job")) {
                CompilationJob subjob = this.collectJobsRecursive(child, ourclasspath);
                if (subjob == null) continue;
                this.jobs.add(subjob);
                continue;
            }
            if (child.getName().equals("directory")) {
                name = child.getAttribute("name");
                if (name == null) continue;
                finalname = this.vs.substitute(name, "plain");
                files.addAll(this.scanDirectory(new File(finalname)));
                continue;
            }
            if (child.getName().equals("file")) {
                name = child.getAttribute("name");
                if (name == null) continue;
                finalname = this.vs.substitute(name, "plain");
                files.add(new File(finalname));
                continue;
            }
            if (!child.getName().equals("packdepency")) continue;
            name = child.getAttribute("name");
            if (name == null) {
                System.out.println("invalid compilation spec: <packdepency> without name attribute");
                return null;
            }
            Iterator pack_it = this.idata.selectedPacks.iterator();
            boolean found = false;
            while (pack_it.hasNext()) {
                Pack pack = (Pack)pack_it.next();
                if (!pack.name.equals(name)) continue;
                found = true;
                break;
            }
            if (found) continue;
            Debug.trace("skipping job because pack " + name + " was not selected.");
            return null;
        }
        if (files.size() > 0) {
            return new CompilationJob(this.handler, this.idata.langpack, node.getAttribute("name"), files, ourclasspath);
        }
        return null;
    }

    private void changeClassPath(ArrayList classpath, XMLElement child) throws Exception {
        String sub;
        String add = child.getAttribute("add");
        if (add != null) {
            if (!new File(add = this.vs.substitute(add, "plain")).exists()) {
                if (!this.handler.emitWarning("Invalid classpath", "The path " + add + " could not be found.\nCompilation may fail.")) {
                    throw new Exception("Classpath " + add + " does not exist.");
                }
            } else {
                classpath.add(this.vs.substitute(add, "plain"));
            }
        }
        if ((sub = child.getAttribute("sub")) != null) {
            int cpidx = -1;
            sub = this.vs.substitute(sub, "plain");
            do {
                cpidx = classpath.indexOf(sub);
                classpath.remove(cpidx);
            } while (cpidx >= 0);
        }
    }

    private ArrayList scanDirectory(File path) {
        Debug.trace("scanning directory " + path.getAbsolutePath());
        ArrayList<File> result = new ArrayList<File>();
        if (!path.isDirectory()) {
            return result;
        }
        File[] entries = path.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            File f = entries[i];
            if (f == null) continue;
            if (f.isDirectory()) {
                result.addAll(this.scanDirectory(f));
                continue;
            }
            if (!f.isFile() || !f.getName().toLowerCase().endsWith(".java")) continue;
            result.add(f);
        }
        return result;
    }

    private static class CompilationJob {
        private CompileHandler listener;
        private String name;
        private ArrayList files;
        private ArrayList classpath;
        private LocaleDatabase langpack;
        private static final int MAX_CMDLINE_SIZE = 4096;

        public CompilationJob(CompileHandler listener, LocaleDatabase langpack, ArrayList files, ArrayList classpath) {
            this.listener = listener;
            this.langpack = langpack;
            this.name = null;
            this.files = files;
            this.classpath = classpath;
        }

        public CompilationJob(CompileHandler listener, LocaleDatabase langpack, String name, ArrayList files, ArrayList classpath) {
            this.listener = listener;
            this.langpack = langpack;
            this.name = name;
            this.files = files;
            this.classpath = classpath;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return "";
        }

        public int getSize() {
            return this.files.size();
        }

        public CompileResult perform(String compiler, ArrayList arguments) {
            Debug.trace("starting job " + this.name);
            int cmdline_len = 0;
            LinkedList<String> args = new LinkedList<String>(arguments);
            Iterator arg_it = args.iterator();
            while (arg_it.hasNext()) {
                cmdline_len += ((String)arg_it.next()).length() + 1;
            }
            args.add(0, compiler);
            cmdline_len += compiler.length() + 1;
            StringBuffer classpath_sb = new StringBuffer();
            Iterator cp_it = this.classpath.iterator();
            while (cp_it.hasNext()) {
                String cp = (String)cp_it.next();
                if (classpath_sb.length() > 0) {
                    classpath_sb.append(File.pathSeparatorChar);
                }
                classpath_sb.append(new File(cp).getAbsolutePath());
            }
            String classpath_str = classpath_sb.toString();
            if (classpath_str.length() > 0) {
                args.add("-classpath");
                cmdline_len += 11;
                args.add(classpath_str);
                cmdline_len += classpath_str.length() + 1;
            }
            int common_args_no = args.size();
            int common_args_len = cmdline_len;
            FileExecutor executor = new FileExecutor();
            String[] output = new String[2];
            String jobfiles = "";
            int fileno = 0;
            int last_fileno = 0;
            Iterator file_it = this.files.iterator();
            while (file_it.hasNext()) {
                File f = (File)file_it.next();
                String fpath = f.getAbsolutePath();
                Debug.trace("processing " + fpath);
                ++fileno;
                jobfiles = jobfiles + f.getName() + " ";
                args.add(fpath);
                if ((cmdline_len += fpath.length()) < 4096) continue;
                Debug.trace("compiling " + jobfiles);
                this.listener.progress(last_fileno, jobfiles);
                last_fileno = fileno;
                String[] full_cmdline = args.toArray(output);
                int retval = executor.executeCommand(full_cmdline, output);
                this.listener.progress(fileno, jobfiles);
                if (retval != 0) {
                    CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error"), full_cmdline, output[0], output[1]);
                    this.listener.handleCompileError(result);
                    if (!result.isContinue()) {
                        return result;
                    }
                } else {
                    ListIterator arg_it2 = args.listIterator(common_args_no);
                    while (arg_it2.hasNext()) {
                        File java_file = new File((String)arg_it2.next());
                        String basename = java_file.getName();
                        int dotpos = basename.lastIndexOf(46);
                        basename = basename.substring(0, dotpos) + ".class";
                        File class_file = new File(java_file.getParentFile(), basename);
                        if (class_file.exists()) continue;
                        CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.noclassfile") + java_file.getAbsolutePath(), full_cmdline, output[0], output[1]);
                        this.listener.handleCompileError(result);
                        if (result.isContinue()) break;
                        return result;
                    }
                }
                for (int i = args.size() - 1; i >= common_args_no; --i) {
                    args.removeLast();
                }
                cmdline_len = common_args_len;
                jobfiles = "";
            }
            if (cmdline_len > common_args_len) {
                this.listener.progress(last_fileno, jobfiles);
                String[] full_cmdline = args.toArray(output);
                int retval = executor.executeCommand(full_cmdline, output);
                this.listener.progress(fileno, jobfiles);
                if (retval != 0) {
                    CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error"), full_cmdline, output[0], output[1]);
                    this.listener.handleCompileError(result);
                    if (!result.isContinue()) {
                        return result;
                    }
                }
            }
            Debug.trace("job " + this.name + " done (" + fileno + " files compiled)");
            return new CompileResult();
        }

        public CompileResult checkCompiler(String compiler, ArrayList arguments) {
            String[] args_arr;
            int retval = 0;
            FileExecutor executor = new FileExecutor();
            String[] output = new String[2];
            Debug.trace("checking whether \"" + compiler + " -help\" works");
            Object args = new String[]{compiler, "-help"};
            retval = executor.executeCommand((String[])args, output);
            if (retval != 0) {
                CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.compilernotfound"), (String[])args, output[0], output[1]);
                this.listener.handleCompileError(result);
                if (!result.isContinue()) {
                    return result;
                }
            }
            Debug.trace("checking whether \"" + compiler + " -help +arguments\" works");
            args = new LinkedList(arguments);
            ((LinkedList)args).add(0, "-help");
            ((LinkedList)args).add(0, compiler);
            StringBuffer classpath_sb = new StringBuffer();
            Iterator cp_it = this.classpath.iterator();
            while (cp_it.hasNext()) {
                String cp = (String)cp_it.next();
                if (classpath_sb.length() > 0) {
                    classpath_sb.append(File.pathSeparatorChar);
                }
                classpath_sb.append(new File(cp).getAbsolutePath());
            }
            String classpath_str = classpath_sb.toString();
            if (classpath_str.length() > 0) {
                ((LinkedList)args).add("-classpath");
                ((LinkedList)args).add(classpath_str);
            }
            if ((retval = executor.executeCommand(args_arr = ((LinkedList)args).toArray(output), output)) != 0) {
                CompileResult result = new CompileResult(this.langpack.getString("CompilePanel.error.invalidarguments"), args_arr, output[0], output[1]);
                this.listener.handleCompileError(result);
                if (!result.isContinue()) {
                    return result;
                }
            }
            return new CompileResult();
        }
    }
}

