/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class FileUtil {
    public static ArrayList getFileContent(String fileName) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        File aFile = new File(fileName);
        if (!aFile.isFile()) {
            return result;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(aFile));
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return result;
        }
        String aLine = null;
        while ((aLine = reader.readLine()) != null) {
            result.add(aLine + "\n");
        }
        reader.close();
        return result;
    }

    public static boolean fileContains(String aFileName, String aSearchString) {
        return FileUtil.fileContains(aFileName, aSearchString, false);
    }

    public static boolean fileContains(String aFileName, String aSearchString, boolean caseInSensitiveSearch) {
        boolean result = false;
        String searchString = new String(caseInSensitiveSearch ? aSearchString.toLowerCase() : aSearchString);
        ArrayList fileContent = new ArrayList();
        try {
            fileContent = FileUtil.getFileContent(aFileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Iterator linesIter = fileContent.iterator();
        while (linesIter.hasNext()) {
            String currentline = (String)linesIter.next();
            if (caseInSensitiveSearch) {
                currentline = currentline.toLowerCase();
            }
            if (currentline.indexOf(searchString) <= -1) continue;
            result = true;
            break;
        }
        return result;
    }

    public static void main(String[] args) {
    }
}

