/*
 * Decompiled with CFR 0.152.
 */
package kj.ui.dsp;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import kj.dsp.KJDigitalSignalProcessor;
import kj.dsp.KJFFT;

public class KJScopeAndSpectrumAnalyser
extends Component
implements KJDigitalSignalProcessor {
    public static final int DISPLAY_MODE_SCOPE = 0;
    public static final int DISPLAY_MODE_SPECTRUM_ANALYSER = 1;
    public static final int DISPLAY_MODE_VU_METER = 2;
    public static final int DEFAULT_WIDTH = 256;
    public static final int DEFAULT_HEIGHT = 128;
    public static final int DEFAULT_SPECTRUM_ANALYSER_FFT_SAMPLE_SIZE = 512;
    public static final int DEFAULT_SPECTRUM_ANALYSER_BAND_COUNT = 20;
    public static final float DEFAULT_SPECTRUM_ANALYSER_DECAY = 0.03f;
    public static final Color DEFAULT_BACKGROUND_COLOR = new Color(0, 0, 128);
    public static final Color DEFAULT_SCOPE_COLOR = new Color(255, 192, 0);
    public static final float DEFAULT_VU_METER_DECAY = 0.02f;
    private Image bi;
    private int displayMode = 0;
    private Color scopeColor = DEFAULT_SCOPE_COLOR;
    private Color[] spectrumAnalyserColors = KJScopeAndSpectrumAnalyser.getDefaultSpectrumAnalyserColors();
    private int width;
    private int height;
    private int height_2;
    private KJFFT fft;
    private float[] old_FFT;
    private int saFFTSampleSize;
    private int saBands;
    private float saColorScale;
    private float saMultiplier;
    private float saDecay = 0.03f;
    private float sad;
    private float oldLeft;
    private float oldRight;
    private float vuDecay = 0.02f;
    private float vuColorScale;
    private long lfu = 0L;
    private int fc = 0;
    private int fps;
    private boolean showFPS = false;

    public KJScopeAndSpectrumAnalyser() {
        this.initialize();
    }

    private void computeColorScale() {
        this.saColorScale = (float)this.spectrumAnalyserColors.length / (float)this.height * 2.0f;
        this.vuColorScale = (float)this.spectrumAnalyserColors.length / (float)(this.width - 32) * 2.0f;
    }

    private void computeSAMultiplier() {
        this.saMultiplier = this.saFFTSampleSize / 2 / this.saBands;
    }

    private void drawScope(Graphics pGrp, float[] pSample) {
        int wSt;
        pGrp.setColor(this.scopeColor);
        int wLas = (int)(pSample[0] * (float)this.height_2) + this.height_2;
        int a = wSt = 2;
        int c = 0;
        while (c < this.width) {
            int wAs = (int)(pSample[a] * (float)this.height_2) + this.height_2;
            pGrp.drawLine(c, wLas, c + 1, wAs);
            wLas = wAs;
            a += wSt;
            ++c;
        }
    }

    private void drawSpectrumAnalyser(Graphics pGrp, float[] pSample, float pFrrh) {
        float c = 0.0f;
        float[] wFFT = this.fft.calculate(pSample);
        float wSadfrr = this.saDecay * pFrrh;
        float wBw = (float)this.width / (float)this.saBands;
        int a = 0;
        int bd = 0;
        while (bd < this.saBands) {
            float wFs = 0.0f;
            int b = 0;
            while ((float)b < this.saMultiplier) {
                wFs += wFFT[a + b];
                ++b;
            }
            if ((wFs *= (float)Math.log(bd + 2)) > 1.0f) {
                wFs = 1.0f;
            }
            if (wFs >= this.old_FFT[a] - wSadfrr) {
                this.old_FFT[a] = wFs;
            } else {
                int n = a;
                this.old_FFT[n] = this.old_FFT[n] - wSadfrr;
                if (this.old_FFT[a] < 0.0f) {
                    this.old_FFT[a] = 0.0f;
                }
                wFs = this.old_FFT[a];
            }
            this.drawSpectrumAnalyserBar(pGrp, (int)c, this.height, (int)wBw - 1, (int)(wFs * (float)this.height));
            c += wBw;
            a = (int)((float)a + this.saMultiplier);
            ++bd;
        }
    }

    private void drawVUMeter(Graphics pGrp, float[] pLeft, float[] pRight, float pFrrh) {
        float wLeft = 0.0f;
        float wRight = 0.0f;
        float wSadfrr = this.vuDecay * pFrrh;
        int a = 0;
        while (a < pLeft.length) {
            wLeft += Math.abs(pLeft[a]);
            wRight += Math.abs(pRight[a]);
            ++a;
        }
        wLeft = wLeft * 2.0f / (float)pLeft.length;
        wRight = wRight * 2.0f / (float)pRight.length;
        if (wLeft > 1.0f) {
            wLeft = 1.0f;
        }
        if (wRight > 1.0f) {
            wRight = 1.0f;
        }
        if (wLeft >= this.oldLeft - wSadfrr) {
            this.oldLeft = wLeft;
        } else {
            this.oldLeft -= wSadfrr;
            if (this.oldLeft < 0.0f) {
                this.oldLeft = 0.0f;
            }
        }
        if (wRight >= this.oldRight - wSadfrr) {
            this.oldRight = wRight;
        } else {
            this.oldRight -= wSadfrr;
            if (this.oldRight < 0.0f) {
                this.oldRight = 0.0f;
            }
        }
        int wHeight = (this.height >> 1) - 24;
        this.drawVolumeMeterBar(pGrp, 16, 16, (int)(this.oldLeft * (float)(this.width - 32)), wHeight);
        this.drawVolumeMeterBar(pGrp, 16, wHeight + 32, (int)(this.oldRight * (float)(this.width - 32)), wHeight);
    }

    private void drawSpectrumAnalyserBar(Graphics pGraphics, int pX, int pY, int pWidth, int pHeight) {
        float c = 0.0f;
        int a = pY;
        while (a >= pY - pHeight) {
            if ((c += this.saColorScale) < 256.0f) {
                pGraphics.setColor(this.spectrumAnalyserColors[(int)c]);
            }
            pGraphics.fillRect(pX, a, pWidth, 1);
            a -= 2;
        }
    }

    private void drawVolumeMeterBar(Graphics pGraphics, int pX, int pY, int pWidth, int pHeight) {
        float c = 0.0f;
        int a = pX;
        while (a <= pX + pWidth) {
            if ((c += this.vuColorScale) < 256.0f) {
                pGraphics.setColor(this.spectrumAnalyserColors[(int)c]);
            }
            pGraphics.fillRect(a, pY, 1, pHeight);
            a += 2;
        }
    }

    private synchronized Image getDoubleBuffer() {
        if (this.bi == null || this.bi.getWidth(null) != this.getSize().width || this.bi.getHeight(null) != this.getSize().height) {
            this.width = this.getSize().width;
            this.height = this.getSize().height;
            this.height_2 = this.height >> 1;
            this.computeColorScale();
            this.bi = this.getGraphicsConfiguration().createCompatibleVolatileImage(this.width, this.height);
        }
        return this.bi;
    }

    public static Color[] getDefaultSpectrumAnalyserColors() {
        Color[] wColors = new Color[256];
        int a = 0;
        while (a < 128) {
            wColors[a] = new Color(0, (a >> 1) + 192, 0);
            ++a;
        }
        a = 0;
        while (a < 64) {
            wColors[a + 128] = new Color(a << 2, 255, 0);
            ++a;
        }
        a = 0;
        while (a < 64) {
            wColors[a + 192] = new Color(255, 255 - (a << 2), 0);
            ++a;
        }
        return wColors;
    }

    public int getDisplayMode() {
        return this.displayMode;
    }

    public int getSpectrumAnalyserBandCount() {
        return this.saBands;
    }

    public float getSpectrumAnalyserDecay() {
        return this.saDecay;
    }

    public Color getScopeColor() {
        return this.scopeColor;
    }

    public Color[] getSpectrumAnalyserColors() {
        return this.spectrumAnalyserColors;
    }

    private void initialize() {
        this.setSize(256, 128);
        this.setBackground(DEFAULT_BACKGROUND_COLOR);
        this.prepareDisplayToggleListener();
        this.setSpectrumAnalyserBandCount(20);
        this.setSpectrumAnalyserFFTSampleSize(512);
    }

    public boolean isShowingFPS() {
        return this.showFPS;
    }

    public void paint(Graphics pGraphics) {
        pGraphics.drawImage(this.getDoubleBuffer(), 0, 0, null);
    }

    private void prepareDisplayToggleListener() {
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent pEvent) {
                if (pEvent.getButton() == 1) {
                    if (KJScopeAndSpectrumAnalyser.this.displayMode + 1 > 2) {
                        KJScopeAndSpectrumAnalyser.this.displayMode = 0;
                    } else {
                        KJScopeAndSpectrumAnalyser kJScopeAndSpectrumAnalyser = KJScopeAndSpectrumAnalyser.this;
                        kJScopeAndSpectrumAnalyser.displayMode = kJScopeAndSpectrumAnalyser.displayMode + 1;
                    }
                }
            }
        });
    }

    public synchronized void process(float[] pLeft, float[] pRight, float pFrameRateRatioHint) {
        Graphics wGrp = this.getDoubleBuffer().getGraphics();
        wGrp.setColor(this.getBackground());
        wGrp.fillRect(0, 0, this.getSize().width, this.getSize().height);
        switch (this.displayMode) {
            case 0: {
                this.drawScope(wGrp, this.stereoMerge(pLeft, pRight));
                break;
            }
            case 1: {
                this.drawSpectrumAnalyser(wGrp, this.stereoMerge(pLeft, pRight), pFrameRateRatioHint);
                break;
            }
            case 2: {
                this.drawVUMeter(wGrp, pLeft, pRight, pFrameRateRatioHint);
            }
        }
        if (this.showFPS) {
            if (System.currentTimeMillis() >= this.lfu + 1000L) {
                this.lfu = System.currentTimeMillis();
                this.fps = this.fc;
                this.fc = 0;
            }
            ++this.fc;
            wGrp.setColor(Color.yellow);
            wGrp.drawString("FPS: " + this.fps + " (FRRH: " + pFrameRateRatioHint + ")", 0, this.height - 1);
        }
        this.getGraphics().drawImage(this.getDoubleBuffer(), 0, 0, null);
    }

    public synchronized void setDisplayMode(int pMode) {
        this.displayMode = pMode;
    }

    public synchronized void setScopeColor(Color pColor) {
        this.scopeColor = pColor;
    }

    public synchronized void setShowFPS(boolean pState) {
        this.showFPS = pState;
    }

    public synchronized void setSpectrumAnalyserBandCount(int pCount) {
        this.saBands = pCount;
        this.computeSAMultiplier();
    }

    public synchronized void setSpectrumAnalyserDecay(float pDecay) {
        this.saDecay = pDecay;
    }

    public synchronized void setSpectrumAnalyserColors(Color[] pColors) {
        this.spectrumAnalyserColors = pColors;
        this.computeColorScale();
    }

    public synchronized void setSpectrumAnalyserFFTSampleSize(int pSize) {
        this.saFFTSampleSize = pSize;
        this.fft = new KJFFT(this.saFFTSampleSize);
        this.old_FFT = new float[this.saFFTSampleSize];
        this.computeSAMultiplier();
    }

    private float[] stereoMerge(float[] pLeft, float[] pRight) {
        int a = 0;
        while (a < pLeft.length) {
            pLeft[a] = (pLeft[a] + pRight[a]) / 2.0f;
            ++a;
        }
        return pLeft;
    }

    public void update(Graphics pGraphics) {
        this.paint(pGraphics);
    }
}

