/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.decoder;

import davaguine.jmac.decoder.APEDecompressCore;
import davaguine.jmac.decoder.IAPEDecompress;
import davaguine.jmac.info.WaveFormat;
import davaguine.jmac.tools.ByteBuffer;
import davaguine.jmac.tools.Crc32;
import davaguine.jmac.tools.JMACException;
import davaguine.jmac.tools.Prepare;
import java.io.IOException;

public class UnMAC {
    private boolean m_bInitialized = false;
    private int m_LastDecodedFrameIndex = -1;
    private int m_nRealFrame = 0;
    private IAPEDecompress m_pAPEDecompress = null;
    private Prepare m_pPrepare = null;
    private APEDecompressCore m_pAPEDecompressCore = null;
    public int m_nBlocksProcessed = 0;
    public Crc32 CRC = new Crc32();
    public long m_nStoredCRC;
    public WaveFormat m_wfeInput;

    public void Initialize(IAPEDecompress pAPEDecompress) {
        if (this.m_bInitialized) {
            this.Uninitialize();
        }
        if (pAPEDecompress == null) {
            this.Uninitialize();
            throw new JMACException("Error Initializing UnMAC");
        }
        this.m_pAPEDecompress = pAPEDecompress;
        this.m_LastDecodedFrameIndex = -1;
        this.m_pAPEDecompressCore = new APEDecompressCore(pAPEDecompress);
        this.m_pPrepare = new Prepare();
        this.m_bInitialized = true;
        this.m_wfeInput = this.m_pAPEDecompress.getApeInfoWaveFormatEx();
    }

    public void Uninitialize() {
        if (this.m_bInitialized) {
            this.m_pAPEDecompressCore = null;
            this.m_pPrepare = null;
            this.m_pAPEDecompress = null;
            this.m_LastDecodedFrameIndex = -1;
            this.m_bInitialized = false;
        }
    }

    public int DecompressFrame(ByteBuffer pOutputData, int FrameIndex) throws IOException {
        return this.DecompressFrameOld(pOutputData, FrameIndex);
    }

    public void SeekToFrame(int FrameIndex) throws IOException {
        if (this.m_pAPEDecompress.getApeInfoFileVersion() > 3800) {
            if (this.m_LastDecodedFrameIndex == -1 || FrameIndex - 1 != this.m_LastDecodedFrameIndex) {
                int SeekRemainder = (this.m_pAPEDecompress.getApeInfoSeekByte(FrameIndex) - this.m_pAPEDecompress.getApeInfoSeekByte(0)) % 4;
                this.m_pAPEDecompressCore.GetUnBitArrray().FillAndResetBitArray(this.m_nRealFrame == FrameIndex ? -1 : this.m_pAPEDecompress.getApeInfoSeekByte(FrameIndex) - SeekRemainder, SeekRemainder * 8);
                this.m_nRealFrame = FrameIndex;
            } else {
                this.m_pAPEDecompressCore.GetUnBitArrray().AdvanceToByteBoundary();
            }
        } else if (this.m_LastDecodedFrameIndex == -1 || FrameIndex - 1 != this.m_LastDecodedFrameIndex) {
            this.m_pAPEDecompressCore.GetUnBitArrray().FillAndResetBitArray(this.m_nRealFrame == FrameIndex ? -1 : this.m_pAPEDecompress.getApeInfoSeekByte(FrameIndex), this.m_pAPEDecompress.getApeInfoSeekBit(FrameIndex));
            this.m_nRealFrame = FrameIndex;
        }
    }

    private int DecompressFrameOld(ByteBuffer pOutputData, int FrameIndex) throws IOException {
        long nChecksum;
        if (FrameIndex >= this.m_pAPEDecompress.getApeInfoTotalFrames()) {
            return 0;
        }
        int nBlocks = 0;
        int n = nBlocks = FrameIndex + 1 >= this.m_pAPEDecompress.getApeInfoTotalFrames() ? this.m_pAPEDecompress.getApeInfoFinalFrameBlocks() : this.m_pAPEDecompress.getApeInfoBlocksPerFrame();
        if (nBlocks == 0) {
            throw new JMACException("Invalid Frame Index");
        }
        this.SeekToFrame(FrameIndex);
        long nSpecialCodes = 0L;
        long nStoredCRC = 0L;
        if ((this.m_pAPEDecompress.getApeInfoFormatFlags() & 2) <= 0) {
            nStoredCRC = this.m_pAPEDecompressCore.GetUnBitArrray().DecodeValue(1, 30);
            if (nStoredCRC == 0L) {
                nSpecialCodes = 3L;
            }
        } else {
            nStoredCRC = this.m_pAPEDecompressCore.GetUnBitArrray().DecodeValue(0);
            nSpecialCodes = 0L;
            if (this.m_pAPEDecompress.getApeInfoFileVersion() > 3820) {
                if ((nStoredCRC & Integer.MIN_VALUE) > 0L) {
                    nSpecialCodes = this.m_pAPEDecompressCore.GetUnBitArrray().DecodeValue(0);
                }
                nStoredCRC &= Integer.MAX_VALUE;
            }
        }
        if (this.m_pAPEDecompress.getApeInfoChannels() == 2) {
            this.m_pAPEDecompressCore.GenerateDecodedArrays(nBlocks, (int)nSpecialCodes, FrameIndex);
            this.m_pPrepare.unprepareOld(this.m_pAPEDecompressCore.m_pDataX, this.m_pAPEDecompressCore.m_pDataY, nBlocks, this.m_wfeInput, pOutputData, this.CRC, this.m_pAPEDecompress.getApeInfoFileVersion());
        } else if (this.m_pAPEDecompress.getApeInfoChannels() == 1) {
            this.m_pAPEDecompressCore.GenerateDecodedArrays(nBlocks, (int)nSpecialCodes, FrameIndex);
            this.m_pPrepare.unprepareOld(this.m_pAPEDecompressCore.m_pDataX, null, nBlocks, this.m_wfeInput, pOutputData, this.CRC, this.m_pAPEDecompress.getApeInfoFileVersion());
        }
        if (this.m_pAPEDecompress.getApeInfoFileVersion() > 3820) {
            this.CRC.finalizeCrc();
        }
        if ((this.m_pAPEDecompress.getApeInfoFormatFlags() & 2) <= 0 ? (nChecksum = this.CalculateOldChecksum(this.m_pAPEDecompressCore.m_pDataX, this.m_pAPEDecompressCore.m_pDataY, this.m_pAPEDecompress.getApeInfoChannels(), nBlocks)) != nStoredCRC : this.CRC.getCrc() != nStoredCRC) {
            throw new JMACException("Invalid Checksum");
        }
        this.m_LastDecodedFrameIndex = FrameIndex;
        return nBlocks;
    }

    private long CalculateOldChecksum(int[] pDataX, int[] pDataY, int nChannels, int nBlocks) {
        long nChecksum;
        block3: {
            block2: {
                nChecksum = 0L;
                if (nChannels != 2) break block2;
                for (int z = 0; z < nBlocks; ++z) {
                    int R = pDataX[z] - pDataY[z] / 2;
                    int L = R + pDataY[z];
                    nChecksum += (long)(Math.abs(R) + Math.abs(L));
                }
                break block3;
            }
            if (nChannels != 1) break block3;
            for (int z = 0; z < nBlocks; ++z) {
                nChecksum += (long)Math.abs(pDataX[z]);
            }
        }
        return nChecksum;
    }
}

