/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.tools.ByteArrayReader;
import davaguine.jmac.tools.ByteArrayWriter;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.JMACException;
import java.io.EOFException;
import java.io.IOException;

public class APETagFooter {
    public String m_cID = "APETAGEX";
    public int m_nVersion;
    public int m_nSize;
    public int m_nFields;
    public int m_nFlags;
    public static final int APE_TAG_FOOTER_BYTES = 32;
    public static final int CURRENT_APE_TAG_VERSION = 2000;

    APETagFooter() {
        this(0, 0);
    }

    APETagFooter(int nFields) {
        this(nFields, 0);
    }

    APETagFooter(int nFields, int nFieldBytes) {
        this.m_nFields = nFields;
        this.m_nFlags = 0x40000000;
        this.m_nSize = nFieldBytes + 32;
        this.m_nVersion = 2000;
    }

    public int GetTotalTagBytes() {
        return this.m_nSize + (this.GetHasHeader() ? 32 : 0);
    }

    public int GetFieldBytes() {
        return this.m_nSize - 32;
    }

    public int GetFieldsOffset() {
        return this.GetHasHeader() ? 32 : 0;
    }

    public int GetNumberFields() {
        return this.m_nFields;
    }

    public boolean GetHasHeader() {
        return (this.m_nFlags & Integer.MIN_VALUE) > 0;
    }

    public boolean GetIsHeader() {
        return (this.m_nFlags & 0x20000000) > 0;
    }

    public int GetVersion() {
        return this.m_nVersion;
    }

    public boolean GetIsValid(boolean bAllowHeader) {
        boolean bValid;
        boolean bl = bValid = this.m_cID.equals("APETAGEX") && this.m_nVersion <= 2000 && this.m_nFields <= 65536 && this.GetFieldBytes() <= 0x1000000;
        if (bValid && !bAllowHeader && this.GetIsHeader()) {
            bValid = false;
        }
        return bValid;
    }

    public static APETagFooter read(File file) throws IOException {
        file.seek(file.length() - 32L);
        APETagFooter tag = new APETagFooter();
        try {
            ByteArrayReader reader = new ByteArrayReader(file, 32);
            tag.m_cID = reader.readString(8, "US-ASCII");
            tag.m_nVersion = reader.readInt();
            tag.m_nSize = reader.readInt();
            tag.m_nFields = reader.readInt();
            tag.m_nFlags = reader.readInt();
            return tag;
        }
        catch (EOFException e) {
            throw new JMACException("Unsupported Format");
        }
    }

    public void write(ByteArrayWriter writer) {
        writer.writeString(this.m_cID, 8, "US-ASCII");
        writer.writeInt(this.m_nVersion);
        writer.writeInt(this.m_nSize);
        writer.writeInt(this.m_nFields);
        writer.writeInt(this.m_nFlags);
        writer.writeInt(0);
        writer.writeInt(0);
    }
}

