/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.info;

import davaguine.jmac.info.WAVInputSource;
import davaguine.jmac.info.WaveFormat;
import davaguine.jmac.tools.ByteBuffer;
import davaguine.jmac.tools.File;
import davaguine.jmac.tools.IntegerPointer;
import davaguine.jmac.tools.JMACException;
import java.io.IOException;

public abstract class InputSource {
    public InputSource(File pIO, WaveFormat pwfeSource, IntegerPointer pTotalBlocks, IntegerPointer pHeaderBytes, IntegerPointer pTerminatingBytes) throws IOException {
    }

    public InputSource(String pSourceName, WaveFormat pwfeSource, IntegerPointer pTotalBlocks, IntegerPointer pHeaderBytes, IntegerPointer pTerminatingBytes) throws IOException {
    }

    public abstract int GetData(ByteBuffer var1, int var2) throws IOException;

    public abstract void GetHeaderData(byte[] var1) throws IOException;

    public abstract void GetTerminatingData(byte[] var1) throws IOException;

    public abstract void Close() throws IOException;

    public static InputSource CreateInputSource(String pSourceName, WaveFormat pwfeSource, IntegerPointer pTotalBlocks, IntegerPointer pHeaderBytes, IntegerPointer pTerminatingBytes) throws IOException {
        if (pSourceName == null || pSourceName.length() == 0) {
            throw new JMACException("Bad Parameters");
        }
        int index = pSourceName.lastIndexOf(46);
        String pExtension = "";
        if (index >= 0) {
            pExtension = pSourceName.substring(pSourceName.lastIndexOf(46));
        }
        if (pExtension.toLowerCase().equals(".wav")) {
            return new WAVInputSource(pSourceName, pwfeSource, pTotalBlocks, pHeaderBytes, pTerminatingBytes);
        }
        throw new JMACException("Invalid Input File");
    }
}

