/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.prediction;

import davaguine.jmac.prediction.IPredictorDecompress;
import davaguine.jmac.prediction.NNFilter;
import davaguine.jmac.prediction.NNFilter16;
import davaguine.jmac.prediction.NNFilter256;
import davaguine.jmac.prediction.NNFilter32;
import davaguine.jmac.prediction.NNFilter64;
import davaguine.jmac.tools.JMACException;
import java.util.Arrays;

public class PredictorDecompressNormal3930to3950
extends IPredictorDecompress {
    private static final int HISTORY_ELEMENTS = 8;
    private static final int WINDOW_BLOCKS = 512;
    private static final int BUFFER_COUNT = 1;
    private static final int M_COUNT = 8;
    protected int[][] m_pBuffer = new int[1][];
    protected int[] m_aryM = new int[8];
    protected int m_pInputBuffer_i;
    protected int m_pInputBuffer_j;
    protected int m_nCurrentIndex;
    protected int m_nLastValue;
    protected NNFilter m_pNNFilter;
    protected NNFilter m_pNNFilter1;

    public PredictorDecompressNormal3930to3950(int nCompressionLevel, int nVersion) {
        super(nCompressionLevel, nVersion);
        this.m_pBuffer[0] = new int[520];
        if (nCompressionLevel == 1000) {
            this.m_pNNFilter = null;
            this.m_pNNFilter1 = null;
        } else if (nCompressionLevel == 2000) {
            this.m_pNNFilter = new NNFilter16(11, nVersion);
            this.m_pNNFilter1 = null;
        } else if (nCompressionLevel == 3000) {
            this.m_pNNFilter = new NNFilter64(11, nVersion);
            this.m_pNNFilter1 = null;
        } else if (nCompressionLevel == 4000) {
            this.m_pNNFilter = new NNFilter256(13, nVersion);
            this.m_pNNFilter1 = new NNFilter32(10, nVersion);
        } else {
            throw new JMACException("Unknown Compression Type");
        }
    }

    public int DecompressValue(int nInput, int notneeded) {
        int nRetVal;
        if (this.m_nCurrentIndex == 512) {
            System.arraycopy(this.m_pBuffer[0], 512, this.m_pBuffer[0], 0, 8);
            this.m_pInputBuffer_i = 0;
            this.m_pInputBuffer_j = 8;
            this.m_nCurrentIndex = 0;
        }
        if (this.m_pNNFilter1 != null) {
            nInput = this.m_pNNFilter1.Decompress(nInput);
        }
        if (this.m_pNNFilter != null) {
            nInput = this.m_pNNFilter.Decompress(nInput);
        }
        int p1 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 1];
        int p2 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 1] - this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 2];
        int p3 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 2] - this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 3];
        int p4 = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 3] - this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j - 4];
        this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j] = nInput + (p1 * this.m_aryM[0] + p2 * this.m_aryM[1] + p3 * this.m_aryM[2] + p4 * this.m_aryM[3] >> 9);
        if (nInput > 0) {
            this.m_aryM[0] = this.m_aryM[0] - ((p1 >> 30 & 2) - 1);
            this.m_aryM[1] = this.m_aryM[1] - ((p2 >> 30 & 2) - 1);
            this.m_aryM[2] = this.m_aryM[2] - ((p3 >> 30 & 2) - 1);
            this.m_aryM[3] = this.m_aryM[3] - ((p4 >> 30 & 2) - 1);
        } else if (nInput < 0) {
            this.m_aryM[0] = this.m_aryM[0] + ((p1 >> 30 & 2) - 1);
            this.m_aryM[1] = this.m_aryM[1] + ((p2 >> 30 & 2) - 1);
            this.m_aryM[2] = this.m_aryM[2] + ((p3 >> 30 & 2) - 1);
            this.m_aryM[3] = this.m_aryM[3] + ((p4 >> 30 & 2) - 1);
        }
        this.m_nLastValue = nRetVal = this.m_pBuffer[this.m_pInputBuffer_i][this.m_pInputBuffer_j] + (this.m_nLastValue * 31 >> 5);
        ++this.m_nCurrentIndex;
        ++this.m_pInputBuffer_j;
        return nRetVal;
    }

    public void Flush() {
        if (this.m_pNNFilter != null) {
            this.m_pNNFilter.Flush();
        }
        if (this.m_pNNFilter1 != null) {
            this.m_pNNFilter1.Flush();
        }
        Arrays.fill(this.m_pBuffer[0], 0, 8, 0);
        Arrays.fill(this.m_aryM, 0);
        this.m_aryM[0] = 360;
        this.m_aryM[1] = 317;
        this.m_aryM[2] = -109;
        this.m_aryM[3] = 98;
        this.m_pInputBuffer_i = 0;
        this.m_pInputBuffer_j = 8;
        this.m_nLastValue = 0;
        this.m_nCurrentIndex = 0;
    }
}

