/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.spi.tritonus;

import davaguine.jmac.decoder.IAPEDecompress;
import davaguine.jmac.spi.APEAudioFileFormatType;
import davaguine.jmac.spi.APEEncoding;
import davaguine.jmac.spi.APEPropertiesHelper;
import davaguine.jmac.spi.tritonus.APEAudioFileFormat;
import davaguine.jmac.spi.tritonus.APEAudioFormat;
import davaguine.jmac.tools.InputStreamFile;
import davaguine.jmac.tools.JMACException;
import davaguine.jmac.tools.RandomAccessFile;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.tritonus.share.sampled.file.TAudioFileReader;

public class APEAudioFileReader
extends TAudioFileReader {
    private static final int MAX_HEADER_SIZE = 16384;
    private static final int MARK_LIMIT = 16385;

    public APEAudioFileReader() {
        super(16385, true);
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream, long mediaLength) throws UnsupportedAudioFileException, IOException {
        IAPEDecompress decoder;
        try {
            decoder = IAPEDecompress.CreateIAPEDecompress(new InputStreamFile(stream));
        }
        catch (JMACException e) {
            throw new UnsupportedAudioFileException("Unsupported audio file");
        }
        catch (EOFException e) {
            throw new UnsupportedAudioFileException("Unsupported audio file");
        }
        HashMap fileProperties = new HashMap();
        HashMap formatProperties = new HashMap();
        APEPropertiesHelper.readProperties(decoder, fileProperties, formatProperties);
        APEAudioFormat format = new APEAudioFormat(APEEncoding.APE, decoder.getApeInfoSampleRate(), decoder.getApeInfoBitsPerSample(), decoder.getApeInfoChannels(), -1, -1.0f, false, formatProperties);
        return new APEAudioFileFormat(APEAudioFileFormatType.APE, (AudioFormat)((Object)format), -1, (int)mediaLength, fileProperties);
    }

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        IAPEDecompress decoder = null;
        RandomAccessFile io = new RandomAccessFile(file, "r");
        try {
            decoder = IAPEDecompress.CreateIAPEDecompress(io);
        }
        catch (JMACException e) {
            throw new UnsupportedAudioFileException("Unsupported audio file");
        }
        catch (EOFException e) {
            throw new UnsupportedAudioFileException("Unsupported audio file");
        }
        finally {
            ((davaguine.jmac.tools.File)io).close();
        }
        HashMap fileProperties = new HashMap();
        HashMap formatProperties = new HashMap();
        APEPropertiesHelper.readProperties(decoder, fileProperties, formatProperties);
        APEAudioFormat format = new APEAudioFormat(APEEncoding.APE, decoder.getApeInfoSampleRate(), decoder.getApeInfoBitsPerSample(), decoder.getApeInfoChannels(), -1, -1.0f, false, formatProperties);
        return new APEAudioFileFormat(APEAudioFileFormatType.APE, (AudioFormat)((Object)format), -1, (int)file.length(), fileProperties);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream;
        InputStream inputStream = new FileInputStream(file);
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(file);
            inputStream = new BufferedInputStream(inputStream, 16385);
            audioInputStream = new AudioInputStream(inputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        return audioInputStream;
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream, 16385);
        }
        return super.getAudioInputStream(stream);
    }
}

