/*
 * Decompiled with CFR 0.152.
 */
package davaguine.jmac.tools;

import davaguine.jmac.tools.ProgressCallback;

public class ProgressHelper {
    private ProgressCallback m_CallbackFunction = null;
    private int m_nTotalSteps;
    private int m_nCurrentStep;
    private int m_nLastCallbackFiredPercentageDone;

    public ProgressHelper(int nTotalSteps, ProgressCallback ProgressCallback2) {
        this.m_CallbackFunction = ProgressCallback2;
        this.m_nTotalSteps = nTotalSteps;
        this.m_nCurrentStep = 0;
        this.m_nLastCallbackFiredPercentageDone = 0;
        this.UpdateProgress(0);
    }

    public void UpdateStatus(String msg) {
        this.m_CallbackFunction.updateStatus(msg);
    }

    public void UpdateProgress() {
        this.UpdateProgress(-1, false);
    }

    public void UpdateProgress(int nCurrentStep) {
        this.UpdateProgress(nCurrentStep, false);
    }

    public void UpdateProgress(int nCurrentStep, boolean bForceUpdate) {
        this.m_nCurrentStep = nCurrentStep == -1 ? ++this.m_nCurrentStep : nCurrentStep;
        float fPercentageDone = (float)this.m_nCurrentStep / (float)Math.max(this.m_nTotalSteps, 1);
        int nPercentageDone = (int)(fPercentageDone * 1000.0f * 100.0f);
        if (nPercentageDone > 100000) {
            nPercentageDone = 100000;
        }
        if (this.m_CallbackFunction != null) {
            this.m_CallbackFunction.pPercentageDone = nPercentageDone;
            if (bForceUpdate || nPercentageDone - this.m_nLastCallbackFiredPercentageDone >= 1000) {
                this.m_CallbackFunction.callback(nPercentageDone);
                this.m_nLastCallbackFiredPercentageDone = nPercentageDone;
            }
        }
    }

    public void UpdateProgressComplete() {
        this.UpdateProgress(this.m_nTotalSteps, true);
    }

    public boolean isKillFlag() {
        return this.m_CallbackFunction != null ? this.m_CallbackFunction.killFlag : false;
    }
}

