/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp;

import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.sound.sampled.SourceDataLine;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerEvent;
import javazoom.jlgui.basicplayer.BasicPlayerException;
import javazoom.jlgui.basicplayer.BasicPlayerListener;
import javazoom.jlgui.player.amp.Loader;
import javazoom.jlgui.player.amp.equalizer.ui.EqualizerUI;
import javazoom.jlgui.player.amp.playlist.Playlist;
import javazoom.jlgui.player.amp.playlist.PlaylistFactory;
import javazoom.jlgui.player.amp.playlist.PlaylistItem;
import javazoom.jlgui.player.amp.playlist.ui.PlaylistUI;
import javazoom.jlgui.player.amp.skin.AbsoluteLayout;
import javazoom.jlgui.player.amp.skin.DropTargetAdapter;
import javazoom.jlgui.player.amp.skin.ImageBorder;
import javazoom.jlgui.player.amp.skin.PopupAdapter;
import javazoom.jlgui.player.amp.skin.Skin;
import javazoom.jlgui.player.amp.skin.UrlDialog;
import javazoom.jlgui.player.amp.tag.ui.TagSearch;
import javazoom.jlgui.player.amp.util.Config;
import javazoom.jlgui.player.amp.util.FileSelector;
import javazoom.jlgui.player.amp.util.ui.Preferences;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlayerUI
extends JPanel
implements ActionListener,
ChangeListener,
BasicPlayerListener {
    private static Log log = LogFactory.getLog((Class)PlayerUI.class);
    public static final int INIT = 0;
    public static final int OPEN = 1;
    public static final int PLAY = 2;
    public static final int PAUSE = 3;
    public static final int STOP = 4;
    public static final int TEXT_LENGTH_MAX = 30;
    public static final long SCROLL_PERIOD = 250L;
    private Skin ui = null;
    private Loader loader = null;
    private Config config = null;
    private JPopupMenu mainpopup = null;
    private JPopupMenu ejectpopup = null;
    private JCheckBoxMenuItem miPlaylist = null;
    private JCheckBoxMenuItem miEqualizer = null;
    private JMenuItem miPlayFile = null;
    private JMenuItem miPlayLocation = null;
    private PopupAdapter popupAdapter = null;
    private PopupAdapter ejectpopupAdapter = null;
    private BasicController theSoundPlayer = null;
    private Map audioInfo = null;
    private int playerState = 0;
    private String titleText = "jlGui 3.0 ".toUpperCase();
    private String currentTitle = "jlGui 3.0 ".toUpperCase();
    private String[] titleScrollLabel = null;
    private int scrollIndex = 0;
    private long lastScrollTime = 0L;
    private boolean scrollRight = true;
    private long secondsAmount = 0L;
    private Playlist playlist = null;
    private PlaylistUI playlistUI = null;
    private String currentFileOrURL = null;
    private String currentSongName = null;
    private PlaylistItem currentPlaylistItem = null;
    private boolean currentIsFile;
    private boolean posValueJump = false;
    private boolean posDragging = false;
    private double posValue = 0.0;
    private EqualizerUI equalizerUI = null;

    public PlayerUI() {
        this.setDoubleBuffered(true);
        this.ui = new Skin();
    }

    public void setEqualizerUI(EqualizerUI equalizerUI) {
        this.equalizerUI = equalizerUI;
    }

    public EqualizerUI getEqualizerUI() {
        return this.equalizerUI;
    }

    public PlaylistUI getPlaylistUI() {
        return this.playlistUI;
    }

    public void setPlaylistUI(PlaylistUI playlistUI) {
        this.playlistUI = playlistUI;
    }

    public Playlist getPlaylist() {
        return this.playlist;
    }

    public Config getConfig() {
        return this.config;
    }

    public Skin getSkin() {
        return this.ui;
    }

    public Loader getLoader() {
        return this.loader;
    }

    public void setController(BasicController basicController) {
        this.theSoundPlayer = basicController;
    }

    public BasicController getController() {
        return this.theSoundPlayer;
    }

    public void loadUI(Loader loader) {
        this.loader = loader;
        this.setLayout(new AbsoluteLayout());
        this.config = Config.getInstance();
        this.ui.setConfig(this.config);
        this.playlistUI = new PlaylistUI();
        this.playlistUI.setSkin(this.ui);
        this.playlistUI.setPlayer(this);
        this.equalizerUI = new EqualizerUI();
        this.equalizerUI.setSkin(this.ui);
        this.loadSkin();
        DropTargetAdapter dropTargetAdapter = new DropTargetAdapter(){

            public void processDrop(Object object) {
                PlayerUI.this.processDnD(object);
            }
        };
        DropTarget dropTarget = new DropTarget(this, 1, dropTargetAdapter, true);
    }

    public void loadSkin() {
        Object object;
        Object object2;
        log.info((Object)("Load PlayerUI (EDT=" + SwingUtilities.isEventDispatchThread() + ")"));
        this.removeAll();
        if (this.ui.getPath() != null) {
            log.info((Object)("Load default skin from " + this.ui.getPath()));
            this.ui.loadSkin(this.ui.getPath());
            this.config.setDefaultSkin(this.ui.getPath());
        } else if (this.config.getDefaultSkin() != null && !this.config.getDefaultSkin().trim().equals("")) {
            log.info((Object)("Load default skin from " + this.config.getDefaultSkin()));
            this.ui.loadSkin(this.config.getDefaultSkin());
        } else {
            object2 = this.getClass().getClassLoader();
            object = ((ClassLoader)object2).getResourceAsStream("javazoom/jlgui/player/amp/metrix.wsz");
            log.info((Object)"Load default skin for JAR");
            this.ui.loadSkin((InputStream)object);
        }
        object2 = new ImageBorder();
        ((ImageBorder)object2).setImage(this.ui.getMainImage());
        this.setBorder((Border)object2);
        this.add((Component)this.ui.getAcPrevious(), this.ui.getAcPrevious().getConstraints());
        this.ui.getAcPrevious().removeActionListener(this);
        this.ui.getAcPrevious().addActionListener(this);
        this.add((Component)this.ui.getAcPlay(), this.ui.getAcPlay().getConstraints());
        this.ui.getAcPlay().removeActionListener(this);
        this.ui.getAcPlay().addActionListener(this);
        this.add((Component)this.ui.getAcPause(), this.ui.getAcPause().getConstraints());
        this.ui.getAcPause().removeActionListener(this);
        this.ui.getAcPause().addActionListener(this);
        this.add((Component)this.ui.getAcStop(), this.ui.getAcStop().getConstraints());
        this.ui.getAcStop().removeActionListener(this);
        this.ui.getAcStop().addActionListener(this);
        this.add((Component)this.ui.getAcNext(), this.ui.getAcNext().getConstraints());
        this.ui.getAcNext().removeActionListener(this);
        this.ui.getAcNext().addActionListener(this);
        this.add((Component)this.ui.getAcEject(), this.ui.getAcEject().getConstraints());
        this.ui.getAcEject().removeActionListener(this);
        this.ui.getAcEject().addActionListener(this);
        this.add((Component)this.ui.getAcEqualizer(), this.ui.getAcEqualizer().getConstraints());
        this.ui.getAcEqualizer().removeActionListener(this);
        this.ui.getAcEqualizer().addActionListener(this);
        this.add((Component)this.ui.getAcPlaylist(), this.ui.getAcPlaylist().getConstraints());
        this.ui.getAcPlaylist().removeActionListener(this);
        this.ui.getAcPlaylist().addActionListener(this);
        this.add((Component)this.ui.getAcShuffle(), this.ui.getAcShuffle().getConstraints());
        this.ui.getAcShuffle().removeActionListener(this);
        this.ui.getAcShuffle().addActionListener(this);
        this.add((Component)this.ui.getAcRepeat(), this.ui.getAcRepeat().getConstraints());
        this.ui.getAcRepeat().removeActionListener(this);
        this.ui.getAcRepeat().addActionListener(this);
        this.add((Component)this.ui.getAcVolume(), this.ui.getAcVolume().getConstraints());
        this.ui.getAcVolume().removeChangeListener(this);
        this.ui.getAcVolume().addChangeListener(this);
        this.add((Component)this.ui.getAcBalance(), this.ui.getAcBalance().getConstraints());
        this.ui.getAcBalance().removeChangeListener(this);
        this.ui.getAcBalance().addChangeListener(this);
        this.add((Component)this.ui.getAcPosBar(), this.ui.getAcPosBar().getConstraints());
        this.ui.getAcPosBar().removeChangeListener(this);
        this.ui.getAcPosBar().addChangeListener(this);
        this.add((Component)this.ui.getAcMonoIcon(), this.ui.getAcMonoIcon().getConstraints());
        this.add((Component)this.ui.getAcStereoIcon(), this.ui.getAcStereoIcon().getConstraints());
        this.add((Component)this.ui.getAcTitleLabel(), this.ui.getAcTitleLabel().getConstraints());
        this.add((Component)this.ui.getAcSampleRateLabel(), this.ui.getAcSampleRateLabel().getConstraints());
        this.add((Component)this.ui.getAcBitRateLabel(), this.ui.getAcBitRateLabel().getConstraints());
        this.add((Component)this.ui.getAcPlayIcon(), this.ui.getAcPlayIcon().getConstraints());
        this.add((Component)this.ui.getAcTimeIcon(), this.ui.getAcTimeIcon().getConstraints());
        this.add((Component)this.ui.getAcMinuteH(), this.ui.getAcMinuteH().getConstraints());
        this.add((Component)this.ui.getAcMinuteL(), this.ui.getAcMinuteL().getConstraints());
        this.add((Component)this.ui.getAcSecondH(), this.ui.getAcSecondH().getConstraints());
        this.add((Component)this.ui.getAcSecondL(), this.ui.getAcSecondL().getConstraints());
        this.add((Component)this.ui.getAcTitleBar(), this.ui.getAcTitleBar().getConstraints());
        this.add((Component)this.ui.getAcMinimize(), this.ui.getAcMinimize().getConstraints());
        this.ui.getAcMinimize().removeActionListener(this);
        this.ui.getAcMinimize().addActionListener(this);
        this.add((Component)this.ui.getAcExit(), this.ui.getAcExit().getConstraints());
        this.ui.getAcExit().removeActionListener(this);
        this.ui.getAcExit().addActionListener(this);
        if (this.ui.getAcAnalyzer() != null) {
            this.add((Component)this.ui.getAcAnalyzer(), this.ui.getAcAnalyzer().getConstraints());
        }
        this.mainpopup = new JPopupMenu(this.ui.getResource("popup.title"));
        object = new JMenuItem("jlGui 3.0 - JavaZOOM");
        this.mainpopup.add((JMenuItem)object);
        this.mainpopup.addSeparator();
        JMenu jMenu = new JMenu(this.ui.getResource("popup.play"));
        this.miPlayFile = new JMenuItem(this.ui.getResource("popup.play.file"));
        this.miPlayFile.setActionCommand("PlayFileMI");
        this.miPlayFile.removeActionListener(this);
        this.miPlayFile.addActionListener(this);
        this.miPlayLocation = new JMenuItem(this.ui.getResource("popup.play.location"));
        this.miPlayLocation.setActionCommand("PlayLocationMI");
        this.miPlayLocation.removeActionListener(this);
        this.miPlayLocation.addActionListener(this);
        jMenu.add(this.miPlayFile);
        jMenu.add(this.miPlayLocation);
        this.mainpopup.add(jMenu);
        this.mainpopup.addSeparator();
        this.miPlaylist = new JCheckBoxMenuItem(this.ui.getResource("popup.playlist"));
        this.miPlaylist.setActionCommand("PlaylistMI");
        if (this.config.isPlaylistEnabled()) {
            this.miPlaylist.setState(true);
        }
        this.miPlaylist.removeActionListener(this);
        this.miPlaylist.addActionListener(this);
        this.mainpopup.add(this.miPlaylist);
        this.miEqualizer = new JCheckBoxMenuItem(this.ui.getResource("popup.equalizer"));
        this.miEqualizer.setActionCommand("EqualizerMI");
        if (this.config.isEqualizerEnabled()) {
            this.miEqualizer.setState(true);
        }
        this.miEqualizer.removeActionListener(this);
        this.miEqualizer.addActionListener(this);
        this.mainpopup.add(this.miEqualizer);
        this.mainpopup.addSeparator();
        object = new JMenuItem(this.ui.getResource("popup.preferences"));
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(80, 2, false));
        ((AbstractButton)object).setActionCommand("PreferencesMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        this.mainpopup.add((JMenuItem)object);
        JMenu jMenu2 = new JMenu(this.ui.getResource("popup.skins"));
        object = new JMenuItem(this.ui.getResource("popup.skins.browser"));
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(83, 8, false));
        ((AbstractButton)object).setActionCommand("SkinBrowserMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        jMenu2.add((JMenuItem)object);
        object = new JMenuItem(this.ui.getResource("popup.skins.load"));
        ((AbstractButton)object).setActionCommand("LoadSkinMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        jMenu2.add((JMenuItem)object);
        this.mainpopup.add(jMenu2);
        JMenu jMenu3 = new JMenu(this.ui.getResource("popup.playback"));
        object = new JMenuItem(this.ui.getResource("popup.playback.jump"));
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(74, 0, false));
        ((AbstractButton)object).setActionCommand("JumpFileMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        jMenu3.add((JMenuItem)object);
        object = new JMenuItem(this.ui.getResource("popup.playback.stop"));
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(86, 0, false));
        ((AbstractButton)object).setActionCommand("StopMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        jMenu3.add((JMenuItem)object);
        this.mainpopup.add(jMenu3);
        this.mainpopup.addSeparator();
        object = new JMenuItem(this.ui.getResource("popup.exit"));
        ((AbstractButton)object).setActionCommand("Exit");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        this.mainpopup.add((JMenuItem)object);
        this.ui.getAcTitleBar().removeMouseListener(this.popupAdapter);
        this.popupAdapter = new PopupAdapter(this.mainpopup);
        this.ui.getAcTitleBar().addMouseListener(this.popupAdapter);
        this.ejectpopup = new JPopupMenu();
        object = new JMenuItem(this.ui.getResource("popup.eject.openfile"));
        ((AbstractButton)object).setActionCommand("PlayFileMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        this.ejectpopup.add((JMenuItem)object);
        object = new JMenuItem(this.ui.getResource("popup.eject.openlocation"));
        ((AbstractButton)object).setActionCommand("PlayLocationMI");
        ((AbstractButton)object).removeActionListener(this);
        ((AbstractButton)object).addActionListener(this);
        this.ejectpopup.add((JMenuItem)object);
        this.ui.getAcEject().removeMouseListener(this.ejectpopupAdapter);
        this.ejectpopupAdapter = new PopupAdapter(this.ejectpopup);
        this.ui.getAcEject().addMouseListener(this.ejectpopupAdapter);
        if (this.equalizerUI != null) {
            this.equalizerUI.loadUI();
        }
        if (this.playlistUI != null) {
            this.playlistUI.loadUI();
        }
        this.validate();
        this.loader.loaded();
    }

    public boolean loadPlaylist(String string) {
        boolean bl = false;
        PlaylistFactory playlistFactory = PlaylistFactory.getInstance();
        this.playlist = playlistFactory.getPlaylist();
        if (this.playlist == null) {
            this.config.setPlaylistClassName("javazoom.jlgui.player.amp.playlist.BasePlaylist");
            this.playlist = playlistFactory.getPlaylist();
        }
        this.playlistUI.setPlaylist(this.playlist);
        if (string != null && !string.equals("")) {
            if (string.toLowerCase().endsWith(this.ui.getResource("playlist.extension.m3u")) || string.toLowerCase().endsWith(this.ui.getResource("playlist.extension.pls"))) {
                bl = this.playlist.load(string);
            } else {
                String string2 = string;
                if (!Config.startWithProtocol(string)) {
                    int n = string.lastIndexOf(File.separatorChar);
                    if (n != -1) {
                        string2 = string.substring(n + 1);
                    }
                    PlaylistItem playlistItem = new PlaylistItem(string2, string, -1L, true);
                    this.playlist.appendItem(playlistItem);
                    bl = true;
                } else {
                    PlaylistItem playlistItem = new PlaylistItem(string2, string, -1L, false);
                    this.playlist.appendItem(playlistItem);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public void stateChanged(ChangeEvent changeEvent) {
        Object object = changeEvent.getSource();
        if (object == this.ui.getAcVolume()) {
            Object[] objectArray = new Object[]{String.valueOf(this.ui.getAcVolume().getValue())};
            String string = MessageFormat.format(this.ui.getResource("slider.volume.text"), objectArray);
            this.ui.getAcTitleLabel().setAcText(string);
            try {
                int n = this.ui.getAcVolume().getValue();
                int n2 = this.ui.getAcVolume().getMaximum();
                if (n == 0) {
                    this.theSoundPlayer.setGain(0.0);
                } else {
                    this.theSoundPlayer.setGain((double)n / (double)n2);
                }
                this.config.setVolume(n);
            }
            catch (BasicPlayerException basicPlayerException) {
                log.debug((Object)"Cannot set gain", (Throwable)basicPlayerException);
            }
        } else if (object == this.ui.getAcBalance()) {
            Object[] objectArray = new Object[]{String.valueOf(Math.abs(this.ui.getAcBalance().getValue() * 100 / 5))};
            String string = null;
            string = this.ui.getAcBalance().getValue() > 0 ? MessageFormat.format(this.ui.getResource("slider.balance.text.right"), objectArray) : (this.ui.getAcBalance().getValue() < 0 ? MessageFormat.format(this.ui.getResource("slider.balance.text.left"), objectArray) : MessageFormat.format(this.ui.getResource("slider.balance.text.center"), objectArray));
            this.ui.getAcTitleLabel().setAcText(string);
            try {
                float f = (float)this.ui.getAcBalance().getValue() * 1.0f / 5.0f;
                this.theSoundPlayer.setPan((double)f);
            }
            catch (BasicPlayerException basicPlayerException) {
                log.debug((Object)"Cannot set pan", (Throwable)basicPlayerException);
            }
        } else if (object == this.ui.getAcPosBar()) {
            if (!this.ui.getAcPosBar().getValueIsAdjusting()) {
                if (this.posDragging) {
                    this.posDragging = false;
                    this.posValue = (double)this.ui.getAcPosBar().getValue() * 1.0 / 1000.0;
                    this.processSeek(this.posValue);
                }
            } else {
                this.posDragging = true;
                this.posValueJump = true;
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        final ActionEvent actionEvent2 = actionEvent;
        if (actionEvent.getActionCommand().equals("Pause")) {
            this.processActionEvent(actionEvent);
        } else if (actionEvent.getActionCommand().equals("Play") && this.playerState == 3) {
            this.processActionEvent(actionEvent);
        } else {
            new Thread("PlayerUIActionEvent"){

                public void run() {
                    PlayerUI.this.processActionEvent(actionEvent2);
                }
            }.start();
        }
    }

    public void processActionEvent(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        log.debug((Object)("Action=" + string + " (EDT=" + SwingUtilities.isEventDispatchThread() + ")"));
        if (string.equalsIgnoreCase("PreferencesMI")) {
            this.processPreferences(actionEvent.getModifiers());
        } else if (string.equals("SkinBrowserMI")) {
            this.processSkinBrowser(actionEvent.getModifiers());
        } else if (string.equals("JumpFileMI")) {
            this.processJumpToFile(actionEvent.getModifiers());
        } else if (string.equals("StopMI")) {
            this.processStop(16);
        } else if (actionEvent.getActionCommand().equals("LoadSkinMI")) {
            File[] fileArray = FileSelector.selectFile(this.loader, 1, false, this.ui.getResource("skin.extension"), this.ui.getResource("loadskin.dialog.filtername"), new File(this.config.getLastDir()));
            if (FileSelector.getInstance().getDirectory() != null) {
                this.config.setLastDir(FileSelector.getInstance().getDirectory().getPath());
            }
            if (fileArray != null) {
                String string2 = fileArray[0].getName();
                this.ui.setPath(this.config.getLastDir() + string2);
                this.loadSkin();
                this.config.setDefaultSkin(this.ui.getPath());
            }
        } else if (string.equals("Shuffle")) {
            if (this.ui.getAcShuffle().isSelected()) {
                this.config.setShuffleEnabled(true);
                if (this.playlist != null) {
                    this.playlist.shuffle();
                    this.playlistUI.initPlayList();
                    PlaylistItem playlistItem = this.playlist.getCursor();
                    this.setCurrentSong(playlistItem);
                }
            } else {
                this.config.setShuffleEnabled(false);
            }
        } else if (string.equals("Repeat")) {
            if (this.ui.getAcRepeat().isSelected()) {
                this.config.setRepeatEnabled(true);
            } else {
                this.config.setRepeatEnabled(false);
            }
        } else if (string.equals("PlayFileMI")) {
            this.processEject(16);
        } else if (string.equals("PlayLocationMI")) {
            this.processEject(4);
        } else if (string.equals("PlaylistMI")) {
            this.ui.getAcPlaylist().setSelected(this.miPlaylist.getState());
            this.togglePlaylist();
        } else if (string.equals("Playlist")) {
            this.togglePlaylist();
        } else if (string.equals("EqualizerMI")) {
            this.ui.getAcEqualizer().setSelected(this.miEqualizer.getState());
            this.toggleEqualizer();
        } else if (string.equals("EqualizerUI")) {
            this.toggleEqualizer();
        } else if (string.equals("Exit")) {
            this.closePlayer();
        } else if (string.equals("Minimize")) {
            this.loader.minimize();
        } else if (string.equals("Eject")) {
            this.processEject(actionEvent.getModifiers());
        } else if (string.equals("Play")) {
            this.processPlay(actionEvent.getModifiers());
        } else if (string.equals("Pause")) {
            this.processPause(actionEvent.getModifiers());
        } else if (string.equals("Stop")) {
            this.processStop(actionEvent.getModifiers());
        } else if (string.equals("Next")) {
            this.processNext(actionEvent.getModifiers());
        } else if (string.equals("Previous")) {
            this.processPrevious(actionEvent.getModifiers());
        }
    }

    public void opened(Object object, Map map) {
        this.audioInfo = map;
        log.debug((Object)map.toString());
    }

    public void stateUpdated(BasicPlayerEvent basicPlayerEvent) {
        this.processStateUpdated(basicPlayerEvent);
    }

    public void progress(int n, long l, byte[] byArray, Map map) {
        this.processProgress(n, l, byArray, map);
    }

    protected void processPreferences(int n) {
        Preferences preferences = Preferences.getInstance(this);
        preferences.setLocation(this.loader.getLocation().x, this.loader.getLocation().y);
        preferences.setSize(512, 350);
        preferences.setVisible(true);
    }

    protected void processSkinBrowser(int n) {
        Preferences preferences = Preferences.getInstance(this);
        preferences.selectSkinBrowserPane();
        preferences.setLocation(this.loader.getLocation().x, this.loader.getLocation().y);
        preferences.setSize(512, 350);
        preferences.setVisible(true);
    }

    protected void processJumpToFile(int n) {
        TagSearch tagSearch = new TagSearch(this);
        tagSearch.setIconImage(this.config.getIconParent().getImage());
        tagSearch.setSize(400, 300);
        tagSearch.setLocation(this.loader.getLocation());
        tagSearch.display();
    }

    protected void processEject(int n) {
        if (this.playerState == 2 || this.playerState == 3) {
            try {
                if (this.theSoundPlayer != null) {
                    this.theSoundPlayer.stop();
                }
            }
            catch (BasicPlayerException basicPlayerException) {
                log.info((Object)"Cannot stop", (Throwable)basicPlayerException);
            }
            this.playerState = 4;
        }
        if (this.playerState == 0 || this.playerState == 4 || this.playerState == 1) {
            PlaylistItem playlistItem = null;
            if (n == 16) {
                String string;
                File[] fileArray = FileSelector.selectFile(this.loader, 1, false, this.config.getExtensions(), this.ui.getResource("button.eject.filedialog.filtername"), new File(this.config.getLastDir()));
                if (FileSelector.getInstance().getDirectory() != null) {
                    this.config.setLastDir(FileSelector.getInstance().getDirectory().getPath());
                }
                if (fileArray != null && (string = fileArray[0].getName()) != null) {
                    if (string.toLowerCase().endsWith(this.ui.getResource("playlist.extension.m3u")) || string.toLowerCase().endsWith(this.ui.getResource("playlist.extension.pls"))) {
                        if (this.loadPlaylist(this.config.getLastDir() + string)) {
                            this.config.setPlaylistFilename(this.config.getLastDir() + string);
                            this.playlist.begin();
                            this.playlistUI.initPlayList();
                            this.setCurrentSong(this.playlist.getCursor());
                            this.playlistUI.repaint();
                        }
                    } else if (string.toLowerCase().endsWith(this.ui.getResource("skin.extension"))) {
                        this.ui.setPath(this.config.getLastDir() + string);
                        this.loadSkin();
                        this.config.setDefaultSkin(this.ui.getPath());
                    } else {
                        playlistItem = new PlaylistItem(string, this.config.getLastDir() + string, -1L, true);
                    }
                }
            } else if (n == 4) {
                UrlDialog urlDialog = new UrlDialog(this.config.getTopParent(), this.ui.getResource("button.eject.urldialog.title"), this.loader.getLocation().x, this.loader.getLocation().y + 10, this.config.getLastURL());
                urlDialog.show();
                if (urlDialog.getFile() != null) {
                    this.showTitle(this.ui.getResource("title.loading"));
                    if (urlDialog.getURL().toLowerCase().endsWith(this.ui.getResource("playlist.extension.m3u")) || urlDialog.getURL().toLowerCase().endsWith(this.ui.getResource("playlist.extension.pls"))) {
                        if (this.loadPlaylist(urlDialog.getURL())) {
                            this.config.setPlaylistFilename(urlDialog.getURL());
                            this.playlist.begin();
                            this.playlistUI.initPlayList();
                            this.setCurrentSong(this.playlist.getCursor());
                            this.playlistUI.repaint();
                        }
                    } else {
                        playlistItem = new PlaylistItem(urlDialog.getFile(), urlDialog.getURL(), -1L, false);
                    }
                    this.config.setLastURL(urlDialog.getURL());
                }
            }
            if (playlistItem != null && this.playlist != null) {
                this.playlist.removeAllItems();
                this.playlist.appendItem(playlistItem);
                this.playlist.nextCursor();
                this.playlistUI.initPlayList();
                this.setCurrentSong(playlistItem);
                this.playlistUI.repaint();
            }
        }
        this.ui.getAcPlayIcon().setIcon(2);
        this.ui.getAcTimeIcon().setIcon(1);
    }

    protected void processPlay(int n) {
        if (this.playlist.isModified()) {
            PlaylistItem playlistItem = this.playlist.getCursor();
            if (playlistItem == null) {
                this.playlist.begin();
                playlistItem = this.playlist.getCursor();
            }
            this.setCurrentSong(playlistItem);
            this.playlist.setModified(false);
            this.playlistUI.repaint();
        }
        if (this.playerState == 3) {
            try {
                this.theSoundPlayer.resume();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.error((Object)"Cannot resume", (Throwable)basicPlayerException);
            }
            this.playerState = 2;
            this.ui.getAcPlayIcon().setIcon(0);
            this.ui.getAcTimeIcon().setIcon(0);
        } else if (this.playerState == 2) {
            try {
                this.theSoundPlayer.stop();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.error((Object)"Cannot stop", (Throwable)basicPlayerException);
            }
            this.playerState = 2;
            this.secondsAmount = 0L;
            this.ui.getAcMinuteH().setAcText("0");
            this.ui.getAcMinuteL().setAcText("0");
            this.ui.getAcSecondH().setAcText("0");
            this.ui.getAcSecondL().setAcText("0");
            if (this.currentFileOrURL != null) {
                try {
                    if (this.currentIsFile) {
                        this.theSoundPlayer.open(this.openFile(this.currentFileOrURL));
                    } else {
                        this.theSoundPlayer.open(new URL(this.currentFileOrURL));
                    }
                    this.theSoundPlayer.play();
                }
                catch (Exception exception) {
                    log.error((Object)("Cannot read file : " + this.currentFileOrURL), (Throwable)exception);
                    this.showMessage(this.ui.getResource("title.invalidfile"));
                }
            }
        } else if (this.playerState == 4 || this.playerState == 1) {
            try {
                this.theSoundPlayer.stop();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.error((Object)"Stop failed", (Throwable)basicPlayerException);
            }
            if (this.currentFileOrURL != null) {
                try {
                    if (this.currentIsFile) {
                        this.theSoundPlayer.open(this.openFile(this.currentFileOrURL));
                    } else {
                        this.theSoundPlayer.open(new URL(this.currentFileOrURL));
                    }
                    this.theSoundPlayer.play();
                    this.titleText = this.currentSongName.toUpperCase();
                    int n2 = -1;
                    if (this.currentPlaylistItem != null) {
                        n2 = this.currentPlaylistItem.getBitrate();
                    }
                    if (n2 <= 0 && this.audioInfo.containsKey("bitrate")) {
                        n2 = (Integer)this.audioInfo.get("bitrate");
                    }
                    if (n2 <= 0 && this.audioInfo.containsKey("audio.framerate.fps") && this.audioInfo.containsKey("audio.framesize.bytes")) {
                        float f = ((Float)this.audioInfo.get("audio.framerate.fps")).floatValue();
                        int n3 = (Integer)this.audioInfo.get("audio.framesize.bytes");
                        n2 = Math.round((float)n3 * f * 8.0f);
                    }
                    int n4 = -1;
                    if (this.currentPlaylistItem != null) {
                        n4 = this.currentPlaylistItem.getChannels();
                    }
                    if (n4 <= 0 && this.audioInfo.containsKey("audio.channels")) {
                        n4 = (Integer)this.audioInfo.get("audio.channels");
                    }
                    float f = -1.0f;
                    if (this.currentPlaylistItem != null) {
                        f = this.currentPlaylistItem.getSamplerate();
                    }
                    if (f <= 0.0f && this.audioInfo.containsKey("audio.samplerate.hz")) {
                        f = ((Float)this.audioInfo.get("audio.samplerate.hz")).floatValue();
                    }
                    long l = -1L;
                    if (this.currentPlaylistItem != null) {
                        l = this.currentPlaylistItem.getLength();
                    }
                    if (l <= 0L && this.audioInfo.containsKey("duration")) {
                        l = (Long)this.audioInfo.get("duration") / 1000000L;
                    }
                    if (l <= 0L && this.audioInfo.containsKey("audio.length.bytes") && (l = (long)Math.round(this.getTimeLengthEstimation(this.audioInfo) / 1000L)) > 0L) {
                        int n5;
                        int n6;
                        int n7 = (int)Math.floor(l / 60L);
                        this.titleText = (n6 = (int)(l - (long)((n7 -= (n5 = (int)Math.floor(n7 / 60)) * 60) * 60) - (long)(n5 * 3600))) >= 10 ? "(" + n7 + ":" + n6 + ") " + this.titleText : "(" + n7 + ":0" + n6 + ") " + this.titleText;
                    }
                    n2 = Math.round(n2 / 1000);
                    this.ui.getAcSampleRateLabel().setAcText(String.valueOf(Math.round(f / 1000.0f)));
                    if (n2 > 999) {
                        this.ui.getAcBitRateLabel().setAcText((n2 /= 100) + "H");
                    } else {
                        this.ui.getAcBitRateLabel().setAcText(String.valueOf(n2));
                    }
                    if (n4 == 2) {
                        this.ui.getAcStereoIcon().setIcon(1);
                        this.ui.getAcMonoIcon().setIcon(0);
                    } else if (n4 == 1) {
                        this.ui.getAcStereoIcon().setIcon(0);
                        this.ui.getAcMonoIcon().setIcon(1);
                    }
                    this.showTitle(this.titleText);
                    this.ui.getAcMinuteH().setAcText("0");
                    this.ui.getAcMinuteL().setAcText("0");
                    this.ui.getAcSecondH().setAcText("0");
                    this.ui.getAcSecondL().setAcText("0");
                    this.ui.getAcPlayIcon().setIcon(0);
                    this.ui.getAcTimeIcon().setIcon(0);
                }
                catch (BasicPlayerException basicPlayerException) {
                    log.info((Object)("Stream error :" + this.currentFileOrURL), (Throwable)basicPlayerException);
                    this.showMessage(this.ui.getResource("title.invalidfile"));
                }
                catch (MalformedURLException malformedURLException) {
                    log.info((Object)("Stream error :" + this.currentFileOrURL), (Throwable)malformedURLException);
                    this.showMessage(this.ui.getResource("title.invalidfile"));
                }
                try {
                    this.theSoundPlayer.setGain((double)this.ui.getAcVolume().getValue() / (double)this.ui.getAcVolume().getMaximum());
                    this.theSoundPlayer.setPan((double)((float)this.ui.getAcBalance().getValue() / 10.0f));
                }
                catch (BasicPlayerException basicPlayerException) {
                    log.info((Object)"Cannot set control", (Throwable)basicPlayerException);
                }
                this.playerState = 2;
                log.info((Object)this.titleText);
            }
        }
    }

    public void processPause(int n) {
        if (this.playerState == 2) {
            try {
                this.theSoundPlayer.pause();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.error((Object)"Cannot pause", (Throwable)basicPlayerException);
            }
            this.playerState = 3;
            this.ui.getAcPlayIcon().setIcon(1);
            this.ui.getAcTimeIcon().setIcon(1);
        } else if (this.playerState == 3) {
            try {
                this.theSoundPlayer.resume();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.info((Object)"Cannot resume", (Throwable)basicPlayerException);
            }
            this.playerState = 2;
            this.ui.getAcPlayIcon().setIcon(0);
            this.ui.getAcTimeIcon().setIcon(0);
        }
    }

    public void processStop(int n) {
        if (this.playerState == 3 || this.playerState == 2) {
            try {
                this.theSoundPlayer.stop();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.info((Object)"Cannot stop", (Throwable)basicPlayerException);
            }
            this.playerState = 4;
            this.secondsAmount = 0L;
            this.ui.getAcPosBar().setValue(0);
            this.ui.getAcPlayIcon().setIcon(2);
            this.ui.getAcTimeIcon().setIcon(1);
        }
    }

    public void processNext(int n) {
        this.playlist.nextCursor();
        this.playlistUI.nextCursor();
        PlaylistItem playlistItem = this.playlist.getCursor();
        this.setCurrentSong(playlistItem);
    }

    public void processPrevious(int n) {
        this.playlist.previousCursor();
        this.playlistUI.nextCursor();
        PlaylistItem playlistItem = this.playlist.getCursor();
        this.setCurrentSong(playlistItem);
    }

    public void processStateUpdated(BasicPlayerEvent basicPlayerEvent) {
        log.debug((Object)("Player:" + basicPlayerEvent + " (EDT=" + SwingUtilities.isEventDispatchThread() + ")"));
        int n = basicPlayerEvent.getCode();
        Object object = basicPlayerEvent.getDescription();
        if (n == 8) {
            if (this.playerState == 3 || this.playerState == 2) {
                this.playlist.nextCursor();
                this.playlistUI.nextCursor();
                PlaylistItem playlistItem = this.playlist.getCursor();
                this.setCurrentSong(playlistItem);
            }
        } else if (n == 2) {
            this.lastScrollTime = System.currentTimeMillis();
            this.posValueJump = false;
            if (this.audioInfo.containsKey("basicplayer.sourcedataline") && this.ui.getAcAnalyzer() != null) {
                this.ui.getAcAnalyzer().setupDSP((SourceDataLine)this.audioInfo.get("basicplayer.sourcedataline"));
                this.ui.getAcAnalyzer().startDSP((SourceDataLine)this.audioInfo.get("basicplayer.sourcedataline"));
            }
        } else if (n == 6) {
            this.posValueJump = true;
        } else if (n == 7) {
            try {
                this.theSoundPlayer.setGain((double)this.ui.getAcVolume().getValue() / (double)this.ui.getAcVolume().getMaximum());
                this.theSoundPlayer.setPan((double)((float)this.ui.getAcBalance().getValue() / 10.0f));
            }
            catch (BasicPlayerException basicPlayerException) {
                log.debug((Object)basicPlayerException);
            }
        } else if (n == 0) {
            if (object instanceof URL || object instanceof InputStream) {
                this.showTitle(this.ui.getResource("title.buffering"));
            }
        } else if (n == 3 && this.ui.getAcAnalyzer() != null) {
            this.ui.getAcAnalyzer().stopDSP();
            this.ui.getAcAnalyzer().repaint();
        }
    }

    public void processProgress(int n, long l, byte[] byArray, Map map) {
        int n2;
        int n3 = -1;
        long l2 = -1L;
        if (this.currentPlaylistItem != null) {
            l2 = this.currentPlaylistItem.getLength();
        }
        if (l2 <= 0L) {
            l2 = Math.round(this.getTimeLengthEstimation(this.audioInfo) / 1000L);
        }
        if (l2 <= 0L) {
            l2 = -1L;
        }
        if (this.audioInfo.containsKey("basicplayer.sourcedataline") && this.ui.getAcAnalyzer() != null) {
            this.ui.getAcAnalyzer().writeDSP(byArray);
        }
        if (this.audioInfo.containsKey("audio.length.bytes")) {
            n3 = (Integer)this.audioInfo.get("audio.length.bytes");
        }
        float f = -1.0f;
        if (n > 0 && n3 > 0) {
            f = (float)n * 1.0f / (float)n3 * 1.0f;
        }
        if (this.audioInfo.containsKey("audio.type")) {
            String string = (String)this.audioInfo.get("audio.type");
            if (string.equalsIgnoreCase("mp3")) {
                String string2;
                if (map.containsKey("mp3.shoutcast.metadata.StreamTitle") && (string2 = ((String)map.get("mp3.shoutcast.metadata.StreamTitle")).trim()).length() > 0 && this.currentPlaylistItem != null) {
                    String string3 = " (" + this.currentPlaylistItem.getFormattedDisplayName() + ")";
                    if (!this.currentPlaylistItem.getFormattedName().equals(string2 + string3)) {
                        this.currentPlaylistItem.setFormattedDisplayName(string2 + string3);
                        this.showTitle((string2 + string3).toUpperCase());
                        this.playlistUI.paintList();
                    }
                }
                if (map.containsKey("mp3.equalizer")) {
                    this.equalizerUI.setBands((float[])map.get("mp3.equalizer"));
                }
                this.secondsAmount = l2 > 0L ? (long)((float)l2 * f) : -1L;
            } else if (string.equalsIgnoreCase("wave")) {
                this.secondsAmount = (long)((float)l2 * f);
            } else {
                this.secondsAmount = Math.round(l / 1000000L);
                this.equalizerUI.setBands(null);
            }
        } else {
            this.secondsAmount = Math.round(l / 1000000L);
            this.equalizerUI.setBands(null);
        }
        if (this.secondsAmount < 0L) {
            this.secondsAmount = Math.round(l / 1000000L);
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = (int)this.secondsAmount;
        int n9 = (int)Math.floor(n8 / 60);
        if ((n8 = n8 - (n9 -= (n2 = (int)Math.floor(n9 / 60)) * 60) * 60 - n2 * 3600) < 10) {
            n4 = 0;
            n5 = n8;
        } else {
            n4 = n8 / 10;
            n5 = n8 - n8 / 10 * 10;
        }
        if (n9 < 10) {
            n6 = 0;
            n7 = n9;
        } else {
            n6 = n9 / 10;
            n7 = n9 - n9 / 10 * 10;
        }
        this.ui.getAcMinuteH().setAcText(String.valueOf(n6));
        this.ui.getAcMinuteL().setAcText(String.valueOf(n7));
        this.ui.getAcSecondH().setAcText(String.valueOf(n4));
        this.ui.getAcSecondL().setAcText(String.valueOf(n5));
        if (l2 != 0L) {
            if (!this.posValueJump) {
                int n10 = Math.round(this.secondsAmount * 1000L / l2);
                this.ui.getAcPosBar().setValue(n10);
            }
        } else {
            this.ui.getAcPosBar().setValue(0);
        }
        long l3 = System.currentTimeMillis();
        long l4 = this.lastScrollTime;
        if (this.titleScrollLabel != null && this.titleScrollLabel.length > 0 && l3 - l4 > 250L) {
            this.lastScrollTime = l3;
            if (this.scrollRight) {
                ++this.scrollIndex;
                if (this.scrollIndex >= this.titleScrollLabel.length) {
                    --this.scrollIndex;
                    this.scrollRight = false;
                }
            } else {
                --this.scrollIndex;
                if (this.scrollIndex <= 0) {
                    this.scrollRight = true;
                }
            }
            this.ui.getAcTitleLabel().setAcText(this.titleScrollLabel[this.scrollIndex]);
        }
    }

    protected void processSeek(double d) {
        try {
            if (this.audioInfo != null && this.audioInfo.containsKey("audio.type")) {
                String string = (String)this.audioInfo.get("audio.type");
                if (string.equalsIgnoreCase("mp3") && this.audioInfo.containsKey("audio.length.bytes")) {
                    long l = Math.round((double)((Integer)this.audioInfo.get("audio.length.bytes")).intValue() * d);
                    log.debug((Object)("Seek value (MP3) : " + l));
                    this.theSoundPlayer.seek(l);
                } else if (string.equalsIgnoreCase("wave") && this.audioInfo.containsKey("audio.length.bytes")) {
                    long l = Math.round((double)((Integer)this.audioInfo.get("audio.length.bytes")).intValue() * d);
                    log.debug((Object)("Seek value (WAVE) : " + l));
                    this.theSoundPlayer.seek(l);
                } else {
                    this.posValueJump = false;
                }
            } else {
                this.posValueJump = false;
            }
        }
        catch (BasicPlayerException basicPlayerException) {
            log.error((Object)"Cannot skip", (Throwable)basicPlayerException);
            this.posValueJump = false;
        }
    }

    public void processDnD(Object object) {
        log.debug((Object)"Player DnD");
        if (object instanceof List) {
            List list = (List)object;
            if (list != null && list.size() > 0) {
                ArrayList<File> arrayList = new ArrayList<File>();
                ArrayList<File> arrayList2 = new ArrayList<File>();
                ListIterator listIterator = list.listIterator();
                while (listIterator.hasNext()) {
                    File file = (File)listIterator.next();
                    if (!file.exists() || !file.canRead()) continue;
                    if (file.isFile()) {
                        arrayList.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    arrayList2.add(file);
                }
                this.playFiles(arrayList);
            }
        } else if (object instanceof String) {
            String string = (String)object;
            if (string.length() > 0) {
                ArrayList<File> arrayList = new ArrayList<File>();
                ArrayList<File> arrayList3 = new ArrayList<File>();
                StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
                while (stringTokenizer.hasMoreTokens()) {
                    File file;
                    String string2 = stringTokenizer.nextToken();
                    if (string2.startsWith("file://") && (string2 = string2.substring(7, string2.length())).endsWith("\r")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (!(file = new File(string2)).exists() || !file.canRead()) continue;
                    if (file.isFile()) {
                        arrayList.add(file);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    arrayList3.add(file);
                }
                this.playFiles(arrayList);
            }
        } else {
            log.info((Object)"Unknown dropped objects");
        }
    }

    protected void playFiles(List list) {
        if (list.size() > 0) {
            this.playlist.removeAllItems();
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                File file = (File)listIterator.next();
                PlaylistItem playlistItem = null;
                if (file == null || (playlistItem = new PlaylistItem(file.getName(), file.getAbsolutePath(), -1L, true)) == null) continue;
                this.playlist.appendItem(playlistItem);
            }
            this.playlist.nextCursor();
            this.playlistUI.initPlayList();
            this.setCurrentSong(this.playlist.getCursor());
        }
    }

    public void setCurrentSong(PlaylistItem playlistItem) {
        int n = this.playerState;
        if (this.playerState == 3 || this.playerState == 2) {
            try {
                this.theSoundPlayer.stop();
            }
            catch (BasicPlayerException basicPlayerException) {
                log.error((Object)"Cannot stop", (Throwable)basicPlayerException);
            }
            this.playerState = 4;
            this.secondsAmount = 0L;
            this.ui.getAcPlayIcon().setIcon(2);
            this.ui.getAcTimeIcon().setIcon(0);
        }
        this.playerState = 1;
        if (playlistItem != null) {
            playlistItem.getTagInfo();
            this.currentSongName = playlistItem.getFormattedName();
            this.currentFileOrURL = playlistItem.getLocation();
            this.currentIsFile = playlistItem.isFile();
            this.currentPlaylistItem = playlistItem;
        } else if (this.config.isRepeatEnabled()) {
            if (this.playlist != null) {
                if (this.playlist.getPlaylistSize() > 0) {
                    this.playlist.begin();
                    PlaylistItem playlistItem2 = this.playlist.getCursor();
                    if (playlistItem2 != null) {
                        playlistItem2.getTagInfo();
                        this.currentSongName = playlistItem2.getFormattedName();
                        this.currentFileOrURL = playlistItem2.getLocation();
                        this.currentIsFile = playlistItem2.isFile();
                        this.currentPlaylistItem = playlistItem2;
                    }
                } else {
                    this.currentSongName = "jlGui 3.0 ";
                    this.currentFileOrURL = null;
                    this.currentIsFile = false;
                    this.currentPlaylistItem = null;
                }
            }
        } else {
            this.currentSongName = "jlGui 3.0 ";
            this.currentFileOrURL = null;
            this.currentIsFile = false;
            this.currentPlaylistItem = null;
        }
        if (this.currentIsFile) {
            this.ui.getAcPosBar().setEnabled(true);
            this.ui.getAcPosBar().setHideThumb(false);
        } else {
            this.config.setLastURL(this.currentFileOrURL);
            this.ui.getAcPosBar().setEnabled(false);
            this.ui.getAcPosBar().setHideThumb(true);
        }
        this.titleText = this.currentSongName.toUpperCase();
        this.showMessage(this.titleText);
        if (n == 2 || n == 3) {
            this.processPlay(16);
        }
    }

    public void showTitle(String string) {
        if (string != null) {
            this.currentTitle = string;
            this.titleScrollLabel = null;
            this.scrollIndex = 0;
            this.scrollRight = true;
            if (string.length() > 30) {
                int n = string.length() - 30 + 1;
                this.titleScrollLabel = new String[n];
                for (int i = 0; i < n; ++i) {
                    String string2;
                    this.titleScrollLabel[i] = string2 = string.substring(i, 30 + i);
                }
                string = string.substring(0, 30);
            }
            this.ui.getAcTitleLabel().setAcText(string);
        }
    }

    public void showMessage(String string) {
        this.showTitle(string);
        this.ui.getAcSampleRateLabel().setAcText("  ");
        this.ui.getAcBitRateLabel().setAcText("   ");
        this.ui.getAcStereoIcon().setIcon(0);
        this.ui.getAcMonoIcon().setIcon(0);
        this.ui.getAcMinuteH().setAcText("0");
        this.ui.getAcMinuteL().setAcText("0");
        this.ui.getAcSecondH().setAcText("0");
        this.ui.getAcSecondL().setAcText("0");
    }

    protected void togglePlaylist() {
        if (this.ui.getAcPlaylist().isSelected()) {
            this.miPlaylist.setState(true);
            this.config.setPlaylistEnabled(true);
            this.loader.togglePlaylist(true);
        } else {
            this.miPlaylist.setState(false);
            this.config.setPlaylistEnabled(false);
            this.loader.togglePlaylist(false);
        }
    }

    protected void toggleEqualizer() {
        if (this.ui.getAcEqualizer().isSelected()) {
            this.miEqualizer.setState(true);
            this.config.setEqualizerEnabled(true);
            this.loader.toggleEqualizer(true);
        } else {
            this.miEqualizer.setState(false);
            this.config.setEqualizerEnabled(false);
            this.loader.toggleEqualizer(false);
        }
    }

    protected File openFile(String string) {
        return new File(string);
    }

    protected void closePlayer() {
        if (this.playerState == 3 || this.playerState == 2) {
            try {
                if (this.theSoundPlayer != null) {
                    this.theSoundPlayer.stop();
                }
            }
            catch (BasicPlayerException basicPlayerException) {
                log.error((Object)"Cannot stop", (Throwable)basicPlayerException);
            }
        }
        if (this.theSoundPlayer != null) {
            this.config.setAudioDevice(((BasicPlayer)this.theSoundPlayer).getMixerName());
        }
        if (this.ui.getAcAnalyzer() != null) {
            if (this.ui.getAcAnalyzer().getDisplayMode() == 2) {
                this.config.setVisualMode("off");
            } else if (this.ui.getAcAnalyzer().getDisplayMode() == 0) {
                this.config.setVisualMode("oscillo");
            } else {
                this.config.setVisualMode("spectrum");
            }
        }
        if (this.playlist != null) {
            this.playlist.save("default.m3u");
            this.config.setPlaylistFilename("default.m3u");
        }
        this.loader.close();
    }

    public String getCurrentTitle() {
        return this.currentTitle;
    }

    public long getTimeLengthEstimation(Map map) {
        long l = -1L;
        int n = -1;
        if (map != null) {
            if (map.containsKey("audio.length.bytes")) {
                n = (Integer)map.get("audio.length.bytes");
            }
            if (map.containsKey("duration")) {
                l = (int)((Long)map.get("duration")).longValue() / 1000;
            } else {
                int n2 = -1;
                int n3 = -1;
                float f = -1.0f;
                int n4 = -1;
                if (map.containsKey("audio.samplesize.bits")) {
                    n2 = (Integer)map.get("audio.samplesize.bits");
                }
                if (map.containsKey("audio.channels")) {
                    n3 = (Integer)map.get("audio.channels");
                }
                if (map.containsKey("audio.samplerate.hz")) {
                    f = ((Float)map.get("audio.samplerate.hz")).floatValue();
                }
                if (map.containsKey("audio.framesize.bytes")) {
                    n4 = (Integer)map.get("audio.framesize.bytes");
                }
                l = n2 > 0 ? (long)((int)(1000.0f * (float)n / (f * (float)n3 * (float)(n2 / 8)))) : (long)((int)(1000.0f * (float)n / (f * (float)n4)));
            }
        }
        return l;
    }

    public void pressStart() {
        this.ui.getAcPlay().doClick();
    }

    public void pressPause() {
        this.ui.getAcPause().doClick();
    }

    public void pressStop() {
        this.ui.getAcStop().doClick();
    }

    public void pressNext() {
        this.ui.getAcNext().doClick();
    }

    public void pressPrevious() {
        this.ui.getAcPrevious().doClick();
    }

    public void pressEject() {
        this.ui.getAcEject().doClick();
    }
}

