/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javazoom.jlgui.basicplayer.BasicController;
import javazoom.jlgui.basicplayer.BasicPlayer;
import javazoom.jlgui.basicplayer.BasicPlayerListener;
import javazoom.jlgui.player.amp.Loader;
import javazoom.jlgui.player.amp.PlayerUI;
import javazoom.jlgui.player.amp.skin.DragAdapter;
import javazoom.jlgui.player.amp.util.Config;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandalonePlayer
extends JFrame
implements Loader {
    private static Log log = LogFactory.getLog((Class)StandalonePlayer.class);
    private String initConfig = "jlgui.ini";
    private String initSong = null;
    private String showPlaylist = null;
    private String showEqualizer = null;
    private String showDsp = null;
    private String skinPath = null;
    private String skinVersion = "1";
    private boolean autoRun = false;
    private PlayerUI mp = null;
    private JWindow eqWin = null;
    private JWindow plWin = null;
    private int eqFactor = 2;
    private Config config = null;
    private boolean playlistfound = false;

    public static void main(String[] stringArray) {
        final StandalonePlayer standalonePlayer = new StandalonePlayer();
        standalonePlayer.parseParameters(stringArray);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                standalonePlayer.loadUI();
                standalonePlayer.loadJS();
                standalonePlayer.loadPlaylist();
                standalonePlayer.boot();
            }
        });
    }

    private void parseParameters(String[] stringArray) {
        String string = null;
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string = stringArray[i];
            if (string.startsWith("-")) {
                if (string.toLowerCase().equals("-init")) {
                    if (++i >= stringArray.length) {
                        StandalonePlayer.usage("init value missing");
                    }
                    if (Config.startWithProtocol(string2 = stringArray[i])) {
                        this.initConfig = string2;
                        continue;
                    }
                    this.initConfig = string2.replace('\\', '/').replace('/', File.separatorChar);
                    continue;
                }
                if (string.toLowerCase().equals("-song")) {
                    if (++i >= stringArray.length) {
                        StandalonePlayer.usage("song value missing");
                    }
                    if (Config.startWithProtocol(string2 = stringArray[i])) {
                        this.initSong = string2;
                        continue;
                    }
                    this.initSong = string2.replace('\\', '/').replace('/', File.separatorChar);
                    continue;
                }
                if (string.toLowerCase().equals("-start")) {
                    this.autoRun = true;
                    continue;
                }
                if (string.toLowerCase().equals("-showplaylist")) {
                    this.showPlaylist = "true";
                    continue;
                }
                if (string.toLowerCase().equals("-showequalizer")) {
                    this.showEqualizer = "true";
                    continue;
                }
                if (string.toLowerCase().equals("-disabledsp")) {
                    this.showDsp = "false";
                    continue;
                }
                if (string.toLowerCase().equals("-skin")) {
                    if (++i >= stringArray.length) {
                        StandalonePlayer.usage("skin value missing");
                    }
                    if (Config.startWithProtocol(string2 = stringArray[i])) {
                        this.skinPath = string2;
                        continue;
                    }
                    this.skinPath = string2.replace('\\', '/').replace('/', File.separatorChar);
                    continue;
                }
                if (string.toLowerCase().equals("-v")) {
                    if (++i >= stringArray.length) {
                        StandalonePlayer.usage("skin version value missing");
                    }
                    this.skinVersion = stringArray[i];
                    continue;
                }
                StandalonePlayer.usage("Unknown parameter : " + string);
                continue;
            }
            StandalonePlayer.usage("Invalid parameter :" + string);
        }
    }

    private void boot() {
        if (this.autoRun) {
            this.mp.pressStart();
        }
    }

    public void loadJS() {
        BasicPlayer basicPlayer = new BasicPlayer();
        List list = basicPlayer.getMixers();
        if (list != null) {
            Iterator iterator = list.iterator();
            String string = this.config.getAudioDevice();
            boolean bl = false;
            if (string != null && string.length() > 0) {
                while (iterator.hasNext()) {
                    if (!((String)iterator.next()).equals(string)) continue;
                    basicPlayer.setMixerName(string);
                    bl = true;
                    break;
                }
            }
            if (!bl && (iterator = list.iterator()).hasNext()) {
                string = (String)iterator.next();
                basicPlayer.setMixerName(string);
            }
        }
        basicPlayer.addBasicPlayerListener((BasicPlayerListener)this.mp);
        this.mp.setController((BasicController)basicPlayer);
    }

    public void loadPlaylist() {
        this.playlistfound = this.initSong != null && !this.initSong.equals("") ? this.mp.loadPlaylist(this.initSong) : this.mp.loadPlaylist(this.config.getPlaylistFilename());
    }

    public void loadUI() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            log.debug((Object)exception);
        }
        this.config = Config.getInstance();
        this.config.load(this.initConfig);
        this.config.setTopParent(this);
        if (this.showPlaylist != null) {
            if (this.showPlaylist.equalsIgnoreCase("true")) {
                this.config.setPlaylistEnabled(true);
            } else {
                this.config.setPlaylistEnabled(false);
            }
        }
        if (this.showEqualizer != null) {
            if (this.showEqualizer.equalsIgnoreCase("true")) {
                this.config.setEqualizerEnabled(true);
            } else {
                this.config.setEqualizerEnabled(false);
            }
        }
        this.eqFactor = this.config.isPlaylistEnabled() ? 2 : 1;
        this.setTitle("jlGui 3.0 ");
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL uRL = classLoader.getResource("javazoom/jlgui/player/amp/jlguiicon.gif");
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            this.setIconImage(imageIcon.getImage());
            this.config.setIconParent(imageIcon);
        }
        this.setUndecorated(true);
        this.mp = new PlayerUI();
        if (this.showDsp != null && this.showDsp.equalsIgnoreCase("false")) {
            this.mp.getSkin().setDspEnabled(false);
        }
        if (this.skinPath != null) {
            this.mp.getSkin().setPath(this.skinPath);
        }
        this.mp.getSkin().setSkinVersion(this.skinVersion);
        this.mp.loadUI(this);
        this.setContentPane(this.mp);
        this.setSize(new Dimension(this.mp.getSkin().getMainWidth(), this.mp.getSkin().getMainHeight()));
        this.eqWin = new JWindow(this);
        this.eqWin.setContentPane(this.mp.getEqualizerUI());
        this.eqWin.setSize(new Dimension(this.mp.getSkin().getMainWidth(), this.mp.getSkin().getMainHeight()));
        this.eqWin.setVisible(false);
        this.plWin = new JWindow(this);
        this.plWin.setContentPane(this.mp.getPlaylistUI());
        this.plWin.setSize(new Dimension(this.mp.getSkin().getMainWidth(), this.mp.getSkin().getMainHeight()));
        this.plWin.setVisible(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StandalonePlayer.this.close();
            }
        });
        this.setKeyBoardShortcut();
        this.setLocation(this.config.getXLocation(), this.config.getYLocation());
        this.setVisible(true);
        if (this.config.isPlaylistEnabled()) {
            this.plWin.setVisible(true);
        }
        if (this.config.isEqualizerEnabled()) {
            this.eqWin.setVisible(true);
        }
    }

    public void setKeyBoardShortcut() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(74, 0, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(80, 2, false);
        KeyStroke keyStroke3 = KeyStroke.getKeyStroke(83, 8, false);
        KeyStroke keyStroke4 = KeyStroke.getKeyStroke(86, 0, false);
        String string = "TAGSEARCH";
        String string2 = "PREFERENCES";
        String string3 = "SKINBROWSER";
        String string4 = "STOPPLAYER";
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StandalonePlayer.this.mp != null) {
                    StandalonePlayer.this.mp.processJumpToFile(actionEvent.getModifiers());
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StandalonePlayer.this.mp != null) {
                    StandalonePlayer.this.mp.processPreferences(actionEvent.getModifiers());
                }
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StandalonePlayer.this.mp != null) {
                    StandalonePlayer.this.mp.processSkinBrowser(actionEvent.getModifiers());
                }
            }
        };
        AbstractAction abstractAction4 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StandalonePlayer.this.mp != null) {
                    StandalonePlayer.this.mp.processStop(16);
                }
            }
        };
        this.setKeyboardAction(string, keyStroke, abstractAction);
        this.setKeyboardAction(string2, keyStroke2, abstractAction2);
        this.setKeyboardAction(string3, keyStroke3, abstractAction3);
        this.setKeyboardAction(string4, keyStroke4, abstractAction4);
    }

    public void setKeyboardAction(String string, KeyStroke keyStroke, Action action) {
        this.mp.getInputMap(2).put(keyStroke, string);
        this.mp.getActionMap().put(string, action);
        this.mp.getPlaylistUI().getInputMap(1).put(keyStroke, string);
        this.mp.getPlaylistUI().getActionMap().put(string, action);
        this.mp.getEqualizerUI().getInputMap(1).put(keyStroke, string);
        this.mp.getEqualizerUI().getActionMap().put(string, action);
    }

    public void loaded() {
        DragAdapter dragAdapter = new DragAdapter(this);
        this.mp.getSkin().getAcTitleBar().addMouseListener(dragAdapter);
        this.mp.getSkin().getAcTitleBar().addMouseMotionListener(dragAdapter);
    }

    public void close() {
        log.info((Object)"Close player");
        this.config.setLocation(this.getLocation().x, this.getLocation().y);
        this.config.save();
        this.dispose();
        this.exit(0);
    }

    public void togglePlaylist(boolean bl) {
        if (this.plWin != null) {
            if (bl) {
                if (this.config.isEqualizerEnabled()) {
                    this.eqFactor = 2;
                    this.eqWin.setLocation(this.getLocation().x, this.getLocation().y + this.mp.getSkin().getMainHeight() * this.eqFactor);
                }
                this.plWin.setVisible(true);
            } else {
                this.plWin.setVisible(false);
                if (this.config.isEqualizerEnabled()) {
                    this.eqFactor = 1;
                    this.eqWin.setLocation(this.getLocation().x, this.getLocation().y + this.mp.getSkin().getMainHeight() * this.eqFactor);
                }
            }
        }
    }

    public void toggleEqualizer(boolean bl) {
        if (this.eqWin != null) {
            if (bl) {
                this.eqFactor = this.config.isPlaylistEnabled() ? 2 : 1;
                this.eqWin.setLocation(this.getLocation().x, this.getLocation().y + this.mp.getSkin().getMainHeight() * this.eqFactor);
                this.eqWin.setVisible(true);
            } else {
                this.eqWin.setVisible(false);
            }
        }
    }

    public void minimize() {
        this.setState(1);
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.plWin != null) {
            this.plWin.setLocation(this.getLocation().x, this.getLocation().y + this.getHeight());
        }
        if (this.eqWin != null) {
            this.eqWin.setLocation(this.getLocation().x, this.getLocation().y + this.eqFactor * this.getHeight());
        }
    }

    public Point getLocation() {
        return super.getLocation();
    }

    public void exit(int n) {
        System.exit(n);
    }

    protected static void usage(String string) {
        System.out.println("jlGui 3.0  : " + string);
        System.out.println("");
        System.out.println("jlGui 3.0  : Usage");
        System.out.println("              java javazoom.jlgui.player.amp.Player [-skin skinFilename] [-song audioFilename] [-start] [-showplaylist] [-showequalizer] [-disabledsp] [-init configFilename] [-v skinversion]");
        System.out.println("");
        System.out.println("              skinFilename   : Filename or URL to a Winamp Skin2.x");
        System.out.println("              audioFilename  : Filename or URL to initial song or playlist");
        System.out.println("              start          : Starts playing song (from the playlist)");
        System.out.println("              showplaylist   : Show playlist");
        System.out.println("              showequalizer  : Show equalizer");
        System.out.println("              disabledsp     : Disable spectrum/time visual");
        System.out.println("");
        System.out.println("              Advanced parameters :");
        System.out.println("              skinversion    : 1 or 2 (default 1)");
        System.out.println("              configFilename : Filename or URL to jlGui initial configuration (playlist,skin,parameters ...)");
        System.out.println("                               Initial configuration won't be overriden by -skin and -song arguments");
        System.out.println("");
        System.out.println("Homepage    : http://www.javazoom.net");
        System.exit(0);
    }
}

