/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlgui.player.amp.util.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import javazoom.jlgui.player.amp.PlayerUI;
import javazoom.jlgui.player.amp.util.Config;
import javazoom.jlgui.player.amp.util.ui.NodeItem;
import javazoom.jlgui.player.amp.util.ui.PreferenceItem;

public class Preferences
extends JFrame
implements TreeSelectionListener,
ActionListener {
    private static Preferences instance = null;
    private JTree tree = null;
    private ResourceBundle bundle = null;
    private DefaultMutableTreeNode options = null;
    private DefaultMutableTreeNode filetypes = null;
    private DefaultMutableTreeNode device = null;
    private DefaultMutableTreeNode proxy = null;
    private DefaultMutableTreeNode plugins = null;
    private DefaultMutableTreeNode visual = null;
    private DefaultMutableTreeNode visuals = null;
    private DefaultMutableTreeNode output = null;
    private DefaultMutableTreeNode skins = null;
    private DefaultMutableTreeNode browser = null;
    private JScrollPane treePane = null;
    private JScrollPane workPane = null;
    private JButton close = null;
    private PlayerUI player = null;

    public Preferences(PlayerUI playerUI) {
        this.player = playerUI;
        this.setDefaultCloseOperation(2);
        ImageIcon imageIcon = Config.getInstance().getIconParent();
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
    }

    public static synchronized Preferences getInstance(PlayerUI playerUI) {
        if (instance == null) {
            instance = new Preferences(playerUI);
            instance.loadUI();
        }
        return instance;
    }

    private void loadUI() {
        this.bundle = ResourceBundle.getBundle("javazoom/jlgui/player/amp/util/ui/preferences");
        this.setTitle(this.getResource("title"));
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        if (this.getResource("tree.options") != null) {
            this.options = new DefaultMutableTreeNode(this.getResource("tree.options"));
            if (this.getResource("tree.options.device") != null) {
                this.device = new DefaultMutableTreeNode();
                this.device.setUserObject(new NodeItem(this.getResource("tree.options.device"), this.getResource("tree.options.device.impl")));
                this.options.add(this.device);
            }
            if (this.getResource("tree.options.visual") != null) {
                this.visual = new DefaultMutableTreeNode();
                this.visual.setUserObject(new NodeItem(this.getResource("tree.options.visual"), this.getResource("tree.options.visual.impl")));
                this.options.add(this.visual);
            }
            if (this.getResource("tree.options.filetypes") != null) {
                this.filetypes = new DefaultMutableTreeNode();
                this.filetypes.setUserObject(new NodeItem(this.getResource("tree.options.filetypes"), this.getResource("tree.options.filetypes.impl")));
                this.options.add(this.filetypes);
            }
            if (this.getResource("tree.options.system") != null) {
                this.proxy = new DefaultMutableTreeNode();
                this.proxy.setUserObject(new NodeItem(this.getResource("tree.options.system"), this.getResource("tree.options.system.impl")));
                this.options.add(this.proxy);
            }
            defaultMutableTreeNode.add(this.options);
        }
        if (this.getResource("tree.plugins") != null) {
            this.plugins = new DefaultMutableTreeNode(this.getResource("tree.plugins"));
            if (this.getResource("tree.plugins.visualization") != null) {
                this.visuals = new DefaultMutableTreeNode();
                this.visuals.setUserObject(new NodeItem(this.getResource("tree.plugins.visualization"), this.getResource("tree.plugins.visualization.impl")));
                this.plugins.add(this.visuals);
            }
            if (this.getResource("tree.plugins.output") != null) {
                this.output = new DefaultMutableTreeNode();
                this.output.setUserObject(new NodeItem(this.getResource("tree.plugins.output"), this.getResource("tree.plugins.output.impl")));
                this.plugins.add(this.output);
            }
            defaultMutableTreeNode.add(this.plugins);
        }
        if (this.getResource("tree.skins") != null) {
            this.skins = new DefaultMutableTreeNode(this.getResource("tree.skins"));
            if (this.getResource("tree.skins.browser") != null) {
                this.browser = new DefaultMutableTreeNode();
                this.browser.setUserObject(new NodeItem(this.getResource("tree.skins.browser"), this.getResource("tree.skins.browser.impl")));
                this.skins.add(this.browser);
            }
            defaultMutableTreeNode.add(this.skins);
        }
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.setRootVisible(false);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        this.tree.addTreeSelectionListener(this);
        int n = 0;
        while (n < this.tree.getRowCount()) {
            this.tree.expandRow(n++);
        }
        this.tree.setBorder(new EmptyBorder(1, 4, 1, 2));
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 0.3;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.treePane = new JScrollPane(this.tree);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.treePane, "Center");
        if (this.getResource("button.close") != null) {
            this.close = new JButton(this.getResource("button.close"));
            this.close.addActionListener(this);
            jPanel.add((Component)this.close, "South");
        }
        this.getContentPane().add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.workPane = new JScrollPane(new JPanel());
        this.getContentPane().add((Component)this.workPane, gridBagConstraints);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        PreferenceItem preferenceItem;
        Object object;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.isLeaf() && (object = defaultMutableTreeNode.getUserObject()) != null && object instanceof NodeItem && (preferenceItem = this.getPreferenceItem(((NodeItem)object).getImpl())) != null) {
            preferenceItem.setPlayer(this.player);
            preferenceItem.loadUI();
            preferenceItem.setParentFrame(this);
            this.workPane.setViewportView(preferenceItem);
        }
    }

    public void selectSkinBrowserPane() {
        Object[] objectArray = this.browser.getPath();
        this.tree.setSelectionPath(new TreePath(objectArray));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.close) {
            if (this.player != null) {
                Config config = this.player.getConfig();
                config.save();
            }
            this.dispose();
        }
    }

    public String getResource(String string) {
        String string2 = null;
        if (string != null) {
            try {
                string2 = this.bundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }

    public PreferenceItem getPreferenceItem(String string) {
        PreferenceItem preferenceItem = null;
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod("getInstance", null);
                preferenceItem = (PreferenceItem)method.invoke(null, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return preferenceItem;
    }
}

