/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.audio;

import java.util.Arrays;
import net.sourceforge.dvb.projectx.audio.AudioFormat;

public class AudioFormatWAV
extends AudioFormat {
    private final int[] WaveChunks = new int[]{1463899717, 1668637984, 1684108385, 1717658484, 1718449184, 1768846196, 1818321516, 1818850164, 1819572340, 1852798053, 1886155636, 1936552044};
    private final String[] LSB_mode = new String[]{"F", "X"};
    private final String[] compression = new String[]{"", "PCM", "MPEG", "MPEG-L3", "AC3"};

    public String displayHeader() {
        return "RIF" + this.LSB_mode[this.getLastID()] + ", " + (this.getLastModeExtension() > 0 ? this.compression[this.getLastModeExtension()] : "tag 0x" + Integer.toHexString(this.getLastLayer())) + ", " + this.getLastChannel() + "-ch, " + this.getLastSamplingFrequency() + "Hz, " + this.getLastSize() + "bit, " + (double)this.getLastBitrate() / 1000.0 + "kbps";
    }

    public int parseHeader(byte[] byArray, int n) {
        this.setINTEL(false);
        if (byArray[n] != 82 || byArray[n + 1] != 73 || byArray[n + 2] != 70) {
            return -1;
        }
        if (byArray[n + 3] == 70) {
            this.setINTEL(true);
        } else if (byArray[n + 3] != 88) {
            return -2;
        }
        this.setID(this.isINTEL() ? 0 : 1);
        this.setEmphasis(0);
        this.setProtectionBit(1);
        Arrays.sort(this.WaveChunks);
        if (this.littleEndian(byArray, n + 8, 4, false) != this.WaveChunks[0]) {
            return -3;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n + 12;
        while (n4 < byArray.length - 4) {
            n2 = this.littleEndian(byArray, n4, 4, false);
            if (Arrays.binarySearch(this.WaveChunks, n2) >= 0) {
                if (n2 == this.WaveChunks[4]) {
                    n3 = this.littleEndian(byArray, n4 + 4, 4, this.isINTEL());
                    this.setLayer(this.littleEndian(byArray, n4 + 8, 2, this.isINTEL()));
                    this.setChannel(this.littleEndian(byArray, n4 + 10, 2, this.isINTEL()));
                    this.setSamplingFrequency(this.littleEndian(byArray, n4 + 12, 4, this.isINTEL()));
                    this.setBitrate(this.littleEndian(byArray, n4 + 16, 4, this.isINTEL()) * 8);
                    this.setMode(this.littleEndian(byArray, n4 + 20, 2, this.isINTEL()));
                    this.setSize(this.littleEndian(byArray, n4 + 22, 2, this.isINTEL()));
                } else if (n2 == this.WaveChunks[2]) {
                    n3 = this.littleEndian(byArray, n4 + 4, 4, this.isINTEL());
                    this.setSizeBase(n3);
                    this.setEmphasis(n4 + 8);
                } else {
                    n3 = this.littleEndian(byArray, n4 + 4, 4, this.isINTEL());
                }
                n4 += n3 + 3;
            }
            ++n4;
        }
        if (this.getBitrate() < 1 || this.getSamplingFrequency() < 1 || this.getChannel() < 1) {
            return -4;
        }
        this.setPaddingBit(0);
        this.setPrivateBit(0);
        this.setCopyright(0);
        this.setOriginal(0);
        this.setFrameTimeLength(90000.0 / (double)this.getSamplingFrequency());
        switch (this.getLayer()) {
            case 1: {
                this.setModeExtension(1);
                return 1;
            }
            case 80: {
                this.setModeExtension(2);
                return 0;
            }
            case 85: {
                this.setModeExtension(3);
                return 0;
            }
            case 8192: {
                this.setModeExtension(4);
                return 0;
            }
        }
        this.setModeExtension(0);
        return 0;
    }
}

