/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.JobProcessing;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.io.IDDBufferedOutputStream;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.VBI;
import net.sourceforge.dvb.projectx.video.Video;

public class StreamDemultiplexer {
    private boolean ptsover = false;
    private boolean misshead = false;
    private boolean first = true;
    private boolean overlap = false;
    private boolean seqhead = false;
    private boolean isPTSwritten = false;
    private boolean isEnabled = true;
    private boolean isH264 = false;
    private boolean WriteNonVideo;
    private boolean WriteVideo;
    private boolean Debug;
    private boolean DecodeVBI;
    private boolean RebuildPTS;
    private boolean RebuildPictPTS;
    private boolean Streamtype_MpgVideo;
    private boolean Streamtype_MpgAudio;
    private boolean Streamtype_Ac3Audio;
    private boolean Streamtype_PcmAudio;
    private boolean Streamtype_Teletext;
    private boolean Streamtype_Subpicture;
    private boolean AddSequenceEndcode;
    private boolean RenameVideo;
    private boolean CreateD2vIndex;
    private boolean CreateM2sIndex;
    private boolean SplitProjectFile;
    private boolean CreateCellTimes;
    private boolean CreateInfoIndex;
    private boolean AppendPidToFileName;
    private boolean AppendLangToFileName;
    private boolean EnableHDDemux;
    private long AddOffset = 0L;
    private long target_position = 0L;
    private long ptsoffset = 0L;
    private long pts = -1L;
    private long lastPTS = -1L;
    private int pack = -1;
    private int pes_ID = 0;
    private int newID = 0;
    private int PID = 0;
    private int es_streamtype = 0;
    private int subid = 511;
    private int pes_streamtype = 0;
    private int lfn = -1;
    private int buffersize = 1024;
    private int sourcetype = 0;
    private int[] MPGVideotype = new int[]{-1};
    private int StreamNumber = -1;
    private String FileName = "";
    private String parentname = "";
    private String[] type = new String[]{"ac", "tt", "mp", "mv", "pc", "sp", "vp"};
    private String[] source = new String[]{".$spes$", ".$ppes$", ".$ts$", ".$pva$"};
    private String[] videoext = new String[]{".mpv", ".mpv", ".264", ".m1v", ".m2v", ".264"};
    private IDDBufferedOutputStream out;
    private DataOutputStream pts_log;
    private ByteArrayOutputStream vidbuf;
    private ByteArrayOutputStream vptsbytes;
    private ByteArrayOutputStream packet;
    private DataOutputStream vpts;
    private byte[] subpicture_header;
    private byte[] lpcm_header;

    public StreamDemultiplexer(JobCollection jobCollection) {
        byte[] byArray = new byte[10];
        byArray[0] = 83;
        byArray[1] = 80;
        this.subpicture_header = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = 80;
        byArray2[1] = 67;
        byArray2[2] = 77;
        this.lpcm_header = byArray2;
        this.getSettings(jobCollection);
    }

    public StreamDemultiplexer(JobCollection jobCollection, long l) {
        byte[] byArray = new byte[10];
        byArray[0] = 83;
        byArray[1] = 80;
        this.subpicture_header = byArray;
        byte[] byArray2 = new byte[10];
        byArray2[0] = 80;
        byArray2[1] = 67;
        byArray2[2] = 77;
        this.lpcm_header = byArray2;
        this.getSettings(jobCollection);
        this.ptsoffset = l;
    }

    public void PTSOffset(long l) {
        this.ptsoffset = l;
    }

    public boolean StreamEnabled() {
        switch (this.newID >>> 4) {
            case 14: {
                return this.Streamtype_MpgVideo;
            }
            case 12: 
            case 13: {
                return this.Streamtype_MpgAudio;
            }
            case 8: {
                return this.Streamtype_Ac3Audio;
            }
            case 10: {
                return this.Streamtype_PcmAudio;
            }
            case 9: {
                return this.Streamtype_Teletext;
            }
            case 2: 
            case 3: {
                return this.Streamtype_Subpicture;
            }
        }
        return this.isEnabled;
    }

    public String[] close(JobProcessing jobProcessing, String string) {
        String string2 = String.valueOf(this.FileName) + ".pts";
        String[] stringArray = new String[]{this.FileName, string2, this.type[this.es_streamtype], this.parentname};
        try {
            if (this.out == null) {
                stringArray[0] = "";
                return stringArray;
            }
            this.out.flush();
            this.out.close();
            this.pts_log.flush();
            this.pts_log.close();
            if (new File(string2).length() < 10L) {
                CommonParsing.logAlias(jobProcessing, string, string2);
            }
            if (new File(this.FileName).length() < 10L) {
                Common.setMessage("-> temp. Filesize < 10 Bytes");
                new File(this.FileName).delete();
                new File(string2).delete();
                stringArray[0] = "";
            } else {
                if (this.AppendPidToFileName) {
                    stringArray[3] = String.valueOf(this.parentname) + this.formatIDString(this.getPID(), this.getID(), this.subID());
                }
                if (this.AppendLangToFileName) {
                    stringArray[3] = String.valueOf(stringArray[3]) + jobProcessing.getAudioStreamLanguage(this.getPID());
                }
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return stringArray;
    }

    public String closeVideo(JobProcessing jobProcessing, String string) {
        String string2 = "-1";
        List list = jobProcessing.getCellTimes();
        int[] nArray = jobProcessing.getStatusVariables();
        try {
            if (this.AddSequenceEndcode && jobProcessing.getExportedVideoFrameNumber() > 0) {
                if (this.MPGVideotype[0] < 2) {
                    this.out.write(Video.getSequenceEndCode());
                    jobProcessing.countMediaFilesExportLength(4L);
                    jobProcessing.countAllMediaFilesExportLength(4L);
                } else {
                    byte[] byArray = new byte[5];
                    byArray[3] = 1;
                    byArray[4] = 10;
                    this.out.write(byArray);
                    jobProcessing.countMediaFilesExportLength(5L);
                    jobProcessing.countAllMediaFilesExportLength(5L);
                }
            }
            this.packet.close();
            this.vidbuf.flush();
            this.vidbuf.close();
            this.out.flush();
            this.out.close();
            this.pts_log.flush();
            this.pts_log.close();
            this.vpts.flush();
            this.vpts.close();
            this.vptsbytes.flush();
            this.vptsbytes.close();
            String string3 = "";
            if (new File(this.FileName).length() < 10L) {
                new File(this.FileName).delete();
                if (!this.WriteVideo && new File(String.valueOf(this.FileName) + ".pts").length() > 16L) {
                    string2 = String.valueOf(this.FileName) + ".pts";
                } else {
                    new File(String.valueOf(this.FileName) + ".pts").delete();
                }
            } else {
                File file;
                int n = this.RenameVideo || this.CreateD2vIndex || this.SplitProjectFile ? 0 : 3;
                string3 = this.parentname;
                if (this.AppendPidToFileName) {
                    string3 = String.valueOf(string3) + this.formatIDString(this.getPID(), this.getID(), this.subID());
                }
                if ((file = new File(string3 = String.valueOf(string3) + this.videoext[this.MPGVideotype[0] + n])).exists()) {
                    file.delete();
                }
                Common.renameTo(new File(this.FileName), file);
                string2 = String.valueOf(this.FileName) + ".pts";
                CommonParsing.setVideoHeader(jobProcessing, string3, string2, nArray, this.MPGVideotype);
                if (this.CreateCellTimes && !list.isEmpty()) {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(String.valueOf(string) + "CellTimes.txt"));
                    int n2 = 0;
                    while (n2 < list.size()) {
                        bufferedWriter.write(list.get(n2).toString());
                        bufferedWriter.newLine();
                        ++n2;
                    }
                    bufferedWriter.close();
                    Common.setMessage(Resource.getString("demux.msg.celltimes", string));
                    long l = new File(String.valueOf(string) + "CellTimes.txt").length();
                    jobProcessing.countMediaFilesExportLength(l);
                    jobProcessing.countAllMediaFilesExportLength(l);
                }
                list.clear();
            }
            if (this.CreateM2sIndex) {
                if (new File(string3).exists()) {
                    String string4 = string3.toString().substring(0, string3.toString().lastIndexOf("."));
                    this.out.renameVideoIddTo(string4);
                } else {
                    this.out.deleteIdd();
                }
            }
            if (this.CreateInfoIndex) {
                if (new File(string3).exists()) {
                    String string5 = string3.toString();
                    this.out.renameVideoInfoTo(string5);
                } else {
                    this.out.deleteInfo();
                }
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return string2;
    }

    private String formatIDString(int n, int n2, int n3) {
        String string = "";
        string = String.valueOf(string) + "{0x" + Common.adaptString(Integer.toHexString(n).toUpperCase(), 4);
        string = String.valueOf(string) + "-0x" + Common.adaptString(Integer.toHexString(n2).toUpperCase(), 2);
        string = String.valueOf(string) + "-0x" + Common.adaptString(Integer.toHexString(n3).toUpperCase(), 2);
        string = String.valueOf(string) + "}";
        return string;
    }

    public int getID() {
        return this.pes_ID;
    }

    public int getNum() {
        return this.lfn;
    }

    public int getPID() {
        return this.PID;
    }

    public long getPTS() {
        return this.pts;
    }

    public int getPackCount() {
        return this.pack;
    }

    private void getSettings(JobCollection jobCollection) {
        this.Streamtype_MpgVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_MpgVideo);
        this.Streamtype_MpgAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_MpgAudio);
        this.Streamtype_Ac3Audio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Ac3Audio);
        this.Streamtype_PcmAudio = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_PcmAudio);
        this.Streamtype_Teletext = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Teletext);
        this.Streamtype_Subpicture = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Subpicture);
        this.AddOffset = jobCollection.getSettings().getBooleanProperty(Keys.KEY_additionalOffset) ? 90L * (long)jobCollection.getSettings().getIntProperty(Keys.KEY_ExportPanel_additionalOffset_Value) : 0L;
        this.WriteNonVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeAudio);
        this.WriteVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_WriteOptions_writeVideo);
        this.Debug = jobCollection.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        this.DecodeVBI = jobCollection.getSettings().getBooleanProperty(Keys.KEY_Streamtype_Vbi);
        this.RebuildPTS = jobCollection.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_rebuildPTS);
        this.RebuildPictPTS = jobCollection.getSettings().getBooleanProperty(Keys.KEY_SubtitlePanel_rebuildPictPTS);
        this.AddSequenceEndcode = jobCollection.getSettings().getBooleanProperty(Keys.KEY_VideoPanel_addEndcode);
        this.RenameVideo = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_renameVideo);
        this.CreateD2vIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createD2vIndex);
        this.CreateM2sIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createM2sIndex);
        this.SplitProjectFile = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile);
        this.CreateCellTimes = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createCellTimes);
        this.CreateInfoIndex = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createInfoIndex);
        this.AppendPidToFileName = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_appendPidToFileName);
        this.AppendLangToFileName = jobCollection.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_appendLangToFileName);
        this.EnableHDDemux = jobCollection.getSettings().getBooleanProperty(Keys.KEY_enableHDDemux);
    }

    public int getStreamNumber() {
        return this.StreamNumber;
    }

    public int getStreamType() {
        return this.pes_streamtype;
    }

    public int getType() {
        return this.es_streamtype;
    }

    public int getnewID() {
        return this.newID;
    }

    public void init(JobCollection jobCollection, String string, int n, int n2, int n3) {
        this.lfn = n2;
        this.buffersize = n;
        this.sourcetype = n3;
        this.initNonVideo(jobCollection, string);
    }

    public void init2(JobCollection jobCollection, String string) {
        this.initNonVideo(jobCollection, string);
    }

    private void initNonVideo(JobCollection jobCollection, String string) {
        this.parentname = string;
        this.setFileName();
        this.target_position = 0L;
        this.getSettings(jobCollection);
        try {
            this.out = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), this.buffersize);
            this.pts_log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.FileName) + ".pts"), 65535));
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void initVideo(JobCollection jobCollection, String string, int n, int n2, int n3) {
        this.getSettings(jobCollection);
        this.parentname = string;
        this.lfn = n2;
        this.buffersize = n;
        this.sourcetype = n3;
        this.setFileName();
        this.es_streamtype = 3;
        this.MPGVideotype[0] = -1;
        try {
            this.out = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), this.buffersize);
            if (this.CreateM2sIndex) {
                this.out.InitIdd(this.FileName, 1);
            }
            if (this.CreateInfoIndex) {
                this.out.InitInfo(this.FileName);
            }
            this.pts_log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.FileName) + ".pts"), 65535));
            this.pts_log.write(CommonParsing.PTSVideoHeader);
            this.packet = new ByteArrayOutputStream();
            this.vidbuf = new ByteArrayOutputStream();
            this.vptsbytes = new ByteArrayOutputStream();
            this.vpts = new DataOutputStream(this.vptsbytes);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public void initVideo2(JobCollection jobCollection, String string) {
        this.getSettings(jobCollection);
        this.parentname = string;
        this.setFileName();
        this.first = true;
        this.MPGVideotype[0] = -1;
        try {
            this.out = new IDDBufferedOutputStream(new FileOutputStream(this.FileName), this.buffersize);
            if (this.CreateM2sIndex) {
                this.out.InitIdd(this.FileName, 1);
            }
            if (this.CreateInfoIndex) {
                this.out.InitInfo(this.FileName);
            }
            this.pts_log = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(String.valueOf(this.FileName) + ".pts"), 65535));
            this.pts_log.write(CommonParsing.PTSVideoHeader);
            this.packet.reset();
            this.vidbuf.reset();
            this.vptsbytes.reset();
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
    }

    public boolean isTTX() {
        return this.es_streamtype == 1;
    }

    public void resetVideo() {
        if (this.vidbuf != null) {
            this.vidbuf.reset();
        }
        if (this.packet != null) {
            this.packet.reset();
        }
        if (this.vptsbytes != null) {
            this.vptsbytes.reset();
        }
        this.first = true;
    }

    private void setFileName() {
        this.FileName = String.valueOf(this.parentname) + this.source[this.sourcetype] + this.lfn + "-" + Long.toHexString(0xFFFFFFL & System.currentTimeMillis()).toUpperCase();
    }

    public void setID(int n) {
        this.pes_ID = n;
    }

    public void setPID(int n) {
        this.PID = n;
    }

    public void setStreamEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public void setStreamNumber(int n) {
        this.StreamNumber = n;
    }

    public void setStreamType(int n) {
        this.pes_streamtype = n;
    }

    public void setTTX(boolean bl) {
        if (bl) {
            this.es_streamtype = 1;
        }
    }

    public void setType(int n) {
        this.es_streamtype = n;
    }

    public void setnewID(int n) {
        this.newID = n;
    }

    public void setsubID(int n) {
        this.subid = n;
    }

    public int subID() {
        return this.subid;
    }

    /*
     * Unable to fully structure code
     */
    public void write(JobProcessing var1_1, byte[] var2_2, int var3_3, int var4_4, boolean var5_5) {
        var6_6 = false;
        var7_7 = 0;
        var8_8 = var3_3;
        var9_9 = 0;
        ++this.pack;
        if (var5_5) {
            if (CommonParsing.validateStartcode(var2_2, var8_8) < 0) {
                Common.setMessage(String.valueOf(Resource.getString("demux.error.audio.startcode")) + " " + this.pack + " (" + Integer.toHexString(this.PID) + "/" + Integer.toHexString(this.pes_ID) + "/" + Integer.toHexString(this.newID) + "/" + this.es_streamtype + ")");
                return;
            }
            this.pes_ID = CommonParsing.getPES_IdField(var2_2, var8_8);
            var4_4 = CommonParsing.getPES_LengthField(var2_2, var8_8);
            v0 = var6_6 = (this.pes_streamtype == 1 || this.pes_streamtype == 3) && (4 & var2_2[6 + var8_8]) != 0;
            if (this.pes_ID == 190) {
                return;
            }
            if (this.pes_streamtype == 2) {
                block34: while (true) {
                    switch (192 & var2_2[6 + var8_8]) {
                        case 64: {
                            var8_8 += 2;
                            continue block34;
                        }
                        case 128: {
                            var8_8 += 3;
                            continue block34;
                        }
                        case 192: {
                            ++var8_8;
                            continue block34;
                        }
                    }
                    switch (48 & var2_2[6 + var8_8]) {
                        default: {
                            continue block34;
                        }
                        case 32: {
                            var7_7 = 5;
                            break block34;
                        }
                        case 48: {
                            var7_7 = 10;
                            break block34;
                        }
                        case 16: {
                            var8_8 += 5;
                            break block34;
                        }
                        case 0: {
                            ++var8_8;
                            break block34;
                        }
                    }
                    break;
                }
            } else {
                var7_7 = CommonParsing.getPES_ExtensionLengthField(var2_2, var8_8);
                if (this.pes_ID == 189 && var7_7 == 36 && (255 & var2_2[9 + var7_7 + var8_8]) >>> 4 == 1) {
                    var9_9 = 1;
                } else if (this.pes_ID == 189 && var7_7 == 36 && (255 & var2_2[9 + var7_7 + var8_8]) == 153) {
                    var9_9 = 1;
                }
                if ((128 & var2_2[7 + var8_8]) == 0) {
                    var8_8 += var7_7;
                    var7_7 = 0;
                }
                var8_8 += 3;
            }
            this.es_streamtype = this.pes_ID == 189 ? var9_9 : 2;
            v1 = this.subid = !(this.es_streamtype != 0 && this.es_streamtype != 6 && this.es_streamtype != 1 || (this.pes_streamtype != 1 || var6_6 == false && this.es_streamtype != 1) && this.pes_streamtype != 3) ? 255 & var2_2[9 + (255 & var2_2[8 + var3_3]) + var3_3] : 0;
            if (this.isTTX()) {
                this.subid &= 31;
            }
            switch (this.subid >>> 4) {
                case 8: {
                    if (this.pes_streamtype != 1 && this.pes_streamtype != 2) break;
                    this.subid = 0;
                    break;
                }
                case 0: {
                    if (var6_6 && this.subid == 9) break;
                }
                default: {
                    if (this.pes_streamtype == 3) break;
                    this.subid = 0;
                }
                case 1: 
                case 2: 
                case 3: 
                case 9: 
                case 10: 
            }
            switch (this.subid >>> 4) {
                case 10: {
                    this.es_streamtype = 4;
                    break;
                }
                case 2: 
                case 3: {
                    this.es_streamtype = 5;
                    break;
                }
                case 9: {
                    if (!var6_6) break;
                    if (this.pes_streamtype == 2 || this.pes_streamtype == 1) {
                        this.subid = 0;
                    }
                    if (this.DecodeVBI) {
                        VBI.parsePES(var2_2, var3_3);
                    }
                    return;
                }
                default: {
                    return;
                }
                case 0: 
                case 1: 
                case 8: 
            }
            var4_4 -= var8_8 - var3_3 + var7_7;
            var8_8 += 6;
        }
        if (!this.WriteNonVideo) {
            return;
        }
        if (this.out == null) {
            return;
        }
        try {
            block71: {
                if (this.RebuildPTS && this.es_streamtype == 1) {
                    if (var1_1.getBorrowedPts() != this.lastPTS) {
                        this.lastPTS = var1_1.getBorrowedPts();
                        this.pts_log.writeLong(this.lastPTS);
                        this.pts_log.writeLong(this.target_position);
                        if (this.Debug) {
                            System.out.println(" stolen ttx PTS: " + this.lastPTS + " /ao " + this.AddOffset + " /tp " + this.target_position);
                        }
                    }
                } else if (this.RebuildPictPTS && this.es_streamtype == 5) {
                    if (var1_1.getBorrowedPts() != this.lastPTS) {
                        this.pts = this.lastPTS = var1_1.getBorrowedPts();
                        this.pts_log.writeLong(this.lastPTS);
                        this.pts_log.writeLong(this.target_position);
                        if (this.Debug) {
                            System.out.println(" stolen subpic PTS: " + this.lastPTS + " /ao " + this.AddOffset + " /tp " + this.target_position);
                        }
                    }
                } else if (var7_7 > 0 && var4_4 >= 0) {
                    this.pts = CommonParsing.getPTSfromBytes(var2_2, var8_8);
                    this.pts -= var1_1.getNextFileStartPts();
                    this.pts &= 0xFFFFFFFFL;
                    if ((this.pts & 0xFF000000L) == 0xFF000000L) {
                        this.ptsover = true;
                    }
                    if (this.ptsover && this.pts < 0xF0000000L) {
                        this.pts |= 0x100000000L;
                    }
                    this.pts += this.ptsoffset;
                    this.pts += this.AddOffset;
                    if (this.lastPTS != this.pts) {
                        if ((this.es_streamtype == 2 || this.es_streamtype == 0 || this.es_streamtype == 6 || this.es_streamtype == 4) && this.lastPTS != -1L && Math.abs(this.lastPTS - this.pts) > 100000L) {
                            Common.setMessage("!> ID 0x" + Integer.toHexString(this.pes_ID).toUpperCase() + " (sub 0x" + Integer.toHexString(this.subid).toUpperCase() + ") packet# " + this.pack + ", big PTS difference: this " + this.pts + ", prev. " + this.lastPTS);
                        }
                        this.pts_log.writeLong(this.pts);
                        this.pts_log.writeLong(this.target_position);
                    }
                    if (this.Debug) {
                        System.out.println(" pda PTS: " + this.pts + "/ " + this.AddOffset + "/ " + this.target_position);
                    }
                    this.lastPTS = this.pts;
                }
                if (this.newID == 192 && var1_1.getBorrowedPts() != this.lastPTS) {
                    var1_1.setBorrowedPts(this.lastPTS);
                }
                switch (this.subid >>> 4) {
                    case 10: {
                        ++var8_8;
                        --var4_4;
                        break;
                    }
                    case 8: {
                        var8_8 += 4;
                        var4_4 -= 4;
                        break;
                    }
                    case 1: {
                        ++var8_8;
                        --var4_4;
                        break;
                    }
                    case 2: 
                    case 3: {
                        ++var8_8;
                        --var4_4;
                    }
                }
                if (this.subid == 9) {
                    var8_8 += 4;
                    var4_4 -= 4;
                }
                if (var4_4 <= 0) {
                    return;
                }
                if (var7_7 <= 0) break block71;
                switch (this.es_streamtype) {
                    case 5: {
                        CommonParsing.setValue(this.subpicture_header, 2, 8, true, this.pts);
                        this.target_position += (long)this.writePacket(this.subpicture_header);
                        if (CommonParsing.nextBits(var2_2, (var8_8 + var7_7) * 8, 16) == 15) {
                            this.out.write(255 & var4_4 + 3 >>> 8);
                            this.out.write(255 & var4_4 + 3);
                            this.out.write(0);
                            this.target_position += 3L;
                        }
                        ** GOTO lbl176
                    }
                    case 4: {
                        CommonParsing.setValue(this.lpcm_header, 3, 5, true, this.pts);
                        this.lpcm_header[8] = (byte)(255 & var4_4 >>> 8);
                        this.lpcm_header[9] = (byte)(255 & var4_4);
                        this.target_position += (long)this.writePacket(this.lpcm_header);
                        ** GOTO lbl176
                    }
                    default: {
                        ** if (this.subid != 9) goto lbl-1000
                    }
                }
            }
            if (this.es_streamtype == 5 && var6_6 && CommonParsing.nextBits(var2_2, (var8_8 + var7_7) * 8, 16) == 15) {
                CommonParsing.setValue(this.subpicture_header, 2, 8, true, 0L);
                this.target_position += (long)this.writePacket(this.subpicture_header);
                this.out.write(255 & var4_4 + 3 >>> 8);
                this.out.write(255 & var4_4 + 3);
                this.out.write(0);
                this.target_position += 3L;
            }
lbl176:
            // 5 sources

            if (this.subid == 9) lbl-1000:
            // 2 sources

            {
                var10_10 = 0;
                while (var10_10 < var4_4) {
                    this.target_position += (long)this.writePacket(var2_2, var8_8 + var7_7 + var10_10, 2);
                    var10_10 += 3;
                }
            } else lbl-1000:
            // 2 sources

            {
                this.target_position += (long)this.writePacket(var2_2, var8_8 + var7_7, var4_4);
            }
        }
        catch (IOException var10_11) {
            Common.setExceptionMessage(var10_11);
        }
    }

    public void write(JobProcessing jobProcessing, byte[] byArray, boolean bl) {
        this.write(jobProcessing, byArray, 0, byArray.length, bl);
    }

    private int writePacket(byte[] byArray) throws IOException {
        return this.writePacket(byArray, 0, byArray.length);
    }

    private int writePacket(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n >= byArray.length) {
            Common.setMessage("!> packet writing: index out of bounds, ignore it.. (" + Integer.toHexString(this.getPID()) + " / " + Integer.toHexString(this.getID()) + " / " + Integer.toHexString(this.getnewID()) + " / " + this.getPackCount() + " -- " + byArray.length + " / " + n + " / " + n2 + ") @ PTS " + Common.formatTime_1(this.lastPTS / 90L));
            return 0;
        }
        if (n + n2 > byArray.length) {
            Common.setMessage("!> packet writing: length index out of bounds, shortened.. (" + Integer.toHexString(this.getPID()) + " / " + Integer.toHexString(this.getID()) + " / " + Integer.toHexString(this.getnewID()) + " / " + this.getPackCount() + " -- " + byArray.length + " / " + n + " / " + n2 + ") @ PTS " + Common.formatTime_1(this.lastPTS / 90L));
            n2 = byArray.length - n;
        }
        this.out.write(byArray, n, n2);
        return n2;
    }

    public void writeVideo(JobProcessing jobProcessing, byte[] byArray, int n, int n2, boolean bl, List list, List list2) {
        int n3 = 0;
        int n4 = n;
        byte[] byArray2 = null;
        int[] nArray = jobProcessing.getStatusVariables();
        ++this.pack;
        if (!bl) {
            if (jobProcessing.getPvaVideoPts() != -1L) {
                n4 -= 4;
                n3 += 4;
            }
        } else {
            if (CommonParsing.validateStartcode(byArray, n4) < 0) {
                Common.setMessage(String.valueOf(Resource.getString("demux.error.video.startcode")) + " " + this.pack + " (" + Integer.toHexString(this.PID) + "/" + Integer.toHexString(this.pes_ID) + "/" + Integer.toHexString(this.newID) + "/" + this.es_streamtype + ")");
                return;
            }
            this.pes_ID = CommonParsing.getPES_IdField(byArray, n4);
            n2 = CommonParsing.getPES_LengthField(byArray, n4);
            if (this.pes_streamtype == 2) {
                block18: while (true) {
                    switch (0xC0 & byArray[6 + n4]) {
                        case 64: {
                            n4 += 2;
                            continue block18;
                        }
                        case 128: {
                            n4 += 3;
                            continue block18;
                        }
                        case 192: {
                            ++n4;
                            continue block18;
                        }
                    }
                    switch (0x30 & byArray[6 + n4]) {
                        default: {
                            continue block18;
                        }
                        case 32: {
                            n3 = 5;
                            break block18;
                        }
                        case 48: {
                            n3 = 10;
                            break block18;
                        }
                        case 16: {
                            n4 += 5;
                            break block18;
                        }
                        case 0: {
                            ++n4;
                            break block18;
                        }
                    }
                    break;
                }
            } else {
                n3 = CommonParsing.getPES_ExtensionLengthField(byArray, n4);
                if ((0x80 & byArray[7 + n4]) == 0) {
                    n4 += n3;
                    n3 = 0;
                }
                n4 += 3;
            }
            n2 -= n4 - n + n3;
            n4 += 6;
        }
        if (n3 > 0 && n2 >= 0) {
            this.pts = !bl ? jobProcessing.getPvaVideoPts() : CommonParsing.getPTSfromBytes(byArray, n4);
            this.pts -= jobProcessing.getNextFileStartPts();
            this.pts &= 0xFFFFFFFFL;
            if ((this.pts & 0xFF000000L) == 0xFF000000L) {
                this.ptsover = true;
            }
            if (this.ptsover && this.pts < 0xF0000000L) {
                this.pts |= 0x100000000L;
            }
            this.pts += this.ptsoffset;
            if (this.Debug) {
                System.out.println(" pdv PTS: " + this.pts);
            }
            this.isPTSwritten = false;
        }
        try {
            if (n2 <= 0) {
                Common.setMessage(String.valueOf(Resource.getString("demux.error.video.payload")) + " (" + this.pack + "/" + byArray.length + "/" + n4 + "/" + n3 + "/" + n2 + ")");
            } else {
                this.packet.write(byArray, n4 + n3, n2);
            }
            this.packet.flush();
            byArray2 = this.packet.toByteArray();
            this.packet.reset();
            boolean bl2 = false;
            boolean bl3 = true;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n7 < byArray2.length - 3) {
                int n10 = CommonParsing.validateStartcode(byArray2, n7);
                if (n10 < 0) {
                    n7 += -n10 - 1;
                } else {
                    int n11 = CommonParsing.getPES_IdField(byArray2, n7);
                    if (!this.EnableHDDemux) {
                        this.isH264 = false;
                    }
                    if (this.isH264) {
                        if (n7 != 0 && byArray2[n7 - 1] == 0 && (0x80 & n11) == 0) {
                            --n7;
                            n6 = 3 & n11 >> 5;
                            n5 = 0x1F & n11;
                            if (this.Debug) {
                                System.out.println("i " + n7 + " /NAL ref " + n6 + " /unit " + n5);
                            }
                            switch (n5) {
                                case 1: 
                                case 5: {
                                    if (this.isPTSwritten || this.pts == -1L) break;
                                    this.vpts.writeLong(this.pts);
                                    this.vpts.writeLong(n9);
                                    this.vpts.flush();
                                    this.isPTSwritten = true;
                                    break;
                                }
                                case 7: {
                                    this.vidbuf.write(byArray2, 0, n8);
                                    if (!this.first) {
                                        jobProcessing.getGop().h264test(jobProcessing, this.out, this.vidbuf.toByteArray(), this.vptsbytes.toByteArray(), this.pts_log, this.parentname, this.MPGVideotype, list, list2);
                                    }
                                    this.vptsbytes.reset();
                                    this.vidbuf.reset();
                                    if (!this.isPTSwritten && this.pts != -1L) {
                                        this.vpts.writeLong(this.pts);
                                        this.vpts.writeLong(0L);
                                        this.vpts.flush();
                                        this.isPTSwritten = true;
                                    }
                                    this.first = false;
                                    bl2 = true;
                                    this.vidbuf.write(byArray2, n8, byArray2.length - n8);
                                    break;
                                }
                                case 9: {
                                    n8 = n7;
                                    n9 = this.vidbuf.size();
                                    break;
                                }
                            }
                            n7 += 2;
                        }
                    } else {
                        if (this.MPGVideotype[0] < 0) {
                            boolean bl4 = this.isH264 = n7 > 0 && byArray2[n7 - 1] == 0 && (0x9F & n11) == 9;
                        }
                        if (!this.isH264) {
                            if (!this.isPTSwritten && bl3 && n11 == 0) {
                                if (this.MPGVideotype[0] < 0) {
                                    this.MPGVideotype[0] = 0;
                                }
                                if (this.misshead && n7 < 3) {
                                    this.misshead = false;
                                } else {
                                    if (this.pts != -1L) {
                                        this.vpts.writeLong(this.pts);
                                        this.vpts.writeLong(this.vidbuf.size());
                                        this.vpts.flush();
                                    }
                                    this.isPTSwritten = true;
                                    bl3 = false;
                                    n7 += 8;
                                }
                            } else if (n11 == 179 || n11 == 183 || n11 == 184) {
                                if (this.MPGVideotype[0] < 0) {
                                    this.MPGVideotype[0] = 0;
                                }
                                if (n11 == 179) {
                                    this.seqhead = true;
                                }
                                if (n11 == 184 && this.seqhead && this.vidbuf.size() < 400) {
                                    this.seqhead = false;
                                } else {
                                    this.vidbuf.write(byArray2, n8, n7);
                                    if (!this.first) {
                                        jobProcessing.getGop().goptest(jobProcessing, this.out, this.vidbuf.toByteArray(), this.vptsbytes.toByteArray(), this.pts_log, this.parentname, this.MPGVideotype, list, list2);
                                    }
                                    this.vptsbytes.reset();
                                    this.vidbuf.reset();
                                    if (jobProcessing.getSplitSize() > 0L && jobProcessing.getSplitSize() < jobProcessing.getAllMediaFilesExportLength()) {
                                        return;
                                    }
                                    if (this.SplitProjectFile && jobProcessing.getProjectFileExportLength() > jobProcessing.getProjectFileSplitSize()) {
                                        int n12 = jobProcessing.getProjectFileD2V().getPart() + 1;
                                        String string = String.valueOf(this.parentname) + "[" + n12 + "].mpv";
                                        if (this.WriteVideo && this.AddSequenceEndcode && jobProcessing.getExportedVideoFrameNumber() > 0) {
                                            this.out.write(Video.getSequenceEndCode());
                                            jobProcessing.countMediaFilesExportLength(4L);
                                            jobProcessing.countAllMediaFilesExportLength(4L);
                                        }
                                        this.out.flush();
                                        this.out.close();
                                        this.out = new IDDBufferedOutputStream(new FileOutputStream(string), this.buffersize);
                                        if (this.CreateM2sIndex) {
                                            this.out.InitIdd(string, 1);
                                        }
                                        if (this.CreateInfoIndex) {
                                            this.out.InitInfo(string);
                                        }
                                        jobProcessing.getProjectFileD2V().setFile(string);
                                        jobProcessing.setProjectFileExportLength(0L);
                                    }
                                    if (!this.isPTSwritten && bl3) {
                                        if (this.pts != -1L) {
                                            this.vpts.writeLong(this.pts);
                                            this.vpts.writeLong(this.vidbuf.size());
                                            this.vpts.flush();
                                        }
                                        this.isPTSwritten = true;
                                    }
                                    if (n11 != 183) {
                                        this.vidbuf.write(byArray2, n7, byArray2.length - n7);
                                        if (n11 == 184) {
                                            jobProcessing.setSequenceHeader(false);
                                            if (jobProcessing.getSplitPart() > 0) {
                                                this.first = false;
                                            }
                                        } else if (n11 == 179) {
                                            jobProcessing.setSequenceHeader(true);
                                            this.first = false;
                                        }
                                        bl2 = true;
                                        this.misshead = false;
                                        break;
                                    }
                                    Common.setMessage(String.valueOf(Resource.getString("demux.msg.skip.sec")) + " " + nArray[6]);
                                    this.first = true;
                                    jobProcessing.setSequenceHeader(false);
                                    n7 += 3;
                                }
                            }
                        }
                    }
                }
                ++n7;
            }
            if (!bl2) {
                if (byArray2.length > 2) {
                    this.vidbuf.write(byArray2, 0, byArray2.length - 3);
                    this.packet.write(byArray2, byArray2.length - 3, 3);
                    this.misshead = true;
                } else {
                    this.vidbuf.write(byArray2);
                }
            }
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        if (this.vidbuf.size() > 6144000) {
            this.vptsbytes.reset();
            this.vidbuf.reset();
            this.packet.reset();
            Common.setMessage(Resource.getString("demux.error.gop.toobig"));
            this.misshead = false;
            this.first = true;
        }
    }

    public void writeVideo(JobProcessing jobProcessing, byte[] byArray, boolean bl, List list, List list2) {
        this.writeVideo(jobProcessing, byArray, 0, byArray.length, bl, list, list2);
    }

    public void writeVideoES(JobProcessing jobProcessing, IDDBufferedOutputStream iDDBufferedOutputStream, byte[] byArray, byte[] byArray2, DataOutputStream dataOutputStream, String string, int[] nArray, List list, List list2, boolean bl) {
        jobProcessing.getGop().goptest(jobProcessing, iDDBufferedOutputStream, byArray, byArray2, dataOutputStream, string, nArray, list, list2, bl);
    }
}

