/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.dvb.projectx.parser;

import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.dvb.projectx.common.Common;
import net.sourceforge.dvb.projectx.common.JobCollection;
import net.sourceforge.dvb.projectx.common.Keys;
import net.sourceforge.dvb.projectx.common.Resource;
import net.sourceforge.dvb.projectx.parser.CommonParsing;
import net.sourceforge.dvb.projectx.parser.StreamBuffer;
import net.sourceforge.dvb.projectx.parser.StreamConverter;
import net.sourceforge.dvb.projectx.parser.StreamDemultiplexer;
import net.sourceforge.dvb.projectx.parser.StreamParserBase;
import net.sourceforge.dvb.projectx.parser.TS_PMTParser;
import net.sourceforge.dvb.projectx.thirdparty.TS;
import net.sourceforge.dvb.projectx.xinput.XInputFile;

public class StreamParserTS
extends StreamParserBase {
    private StreamBuffer streambuffer;
    private ArrayList usedPIDs;
    private List TSPidlist;
    private PushbackInputStream inputstream;
    private TS_PMTParser pmt_parser;
    private boolean HumaxAdaption;
    private boolean HandanAdaption;
    private boolean JepssenAdaption;
    private boolean KoscomAdaption;
    private boolean Debug;
    private long count;
    private byte TS_SyncByte = (byte)71;
    private byte[] hav_chunk = new byte[]{91, 72, 79, 74, 73, 78, 32, 65};
    private byte[] tmp_chunk = new byte[36];
    private int TS_BufferSize = 189;
    private int TS_PacketLength = 188;
    private int PidMask = 8191;
    private int MaxBufferSize = 6000000;
    private int PushbackBufferSize = 225;

    private boolean checkDynamicPMT(int n) {
        return false;
    }

    private long checkNextComagSegment(JobCollection jobCollection, int n) {
        XInputFile xInputFile = (XInputFile)jobCollection.getInputFile(n);
        if (xInputFile.getStreamInfo().getStreamSubType() != 6) {
            return 0L;
        }
        int n2 = 48128;
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        long l = 65536L;
        if (n < jobCollection.getPrimaryInputFileSegments() - 1) {
            try {
                xInputFile.randomAccessSingleRead(byArray, xInputFile.length() - (long)n2);
                XInputFile xInputFile2 = (XInputFile)jobCollection.getInputFile(n + 1);
                if (xInputFile2.getStreamInfo().getStreamSubType() != 6) {
                    return 0L;
                }
                xInputFile2.randomAccessSingleRead(byArray2, l);
                int n3 = 0;
                while (n3 < n2) {
                    if (byArray2[n3] != byArray[n3]) {
                        return l + (long)n3;
                    }
                    ++n3;
                }
                return l + (long)n2;
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
        return l;
    }

    private long checkNextJepssenKoscomSegment(JobCollection jobCollection, int n, int n2) {
        block6: {
            int n3;
            if (!this.JepssenAdaption && !this.KoscomAdaption) {
                return 0L;
            }
            byte[] byArray = new byte[200];
            long l = 246496L;
            int n4 = n3 = this.JepssenAdaption ? 4 : 68;
            if (n >= jobCollection.getPrimaryInputFileSegments() - 1) break block6;
            try {
                ((XInputFile)jobCollection.getInputFile(n + 1)).randomAccessSingleRead(byArray, l);
                int n5 = 0;
                while (n5 < n3) {
                    if (byArray[n5] != 0) {
                        return 0L;
                    }
                    ++n5;
                }
                if (byArray[n3 + this.TS_PacketLength - n2] == this.TS_SyncByte) {
                    return l + (long)n3;
                }
            }
            catch (IOException iOException) {
                Common.setExceptionMessage(iOException);
            }
        }
        return 0L;
    }

    private void getEventInfo(XInputFile xInputFile) {
        int n = xInputFile.getStreamInfo().getStreamFullType();
        int n2 = 0;
        if (n == 261) {
            n2 = 4;
        } else if (n == 517) {
            n2 = 0;
        } else {
            TS.setEventInfo(null, null, null);
            return;
        }
        int n3 = 3760;
        byte[] byArray = new byte[n3];
        try {
            Common.setMessage("-> fetching event info ");
            xInputFile.randomAccessSingleRead(byArray, 0L);
            byte[] byArray2 = new byte[24];
            System.arraycopy(byArray, 28, byArray2, 0, 24);
            byte[] byArray3 = new byte[131];
            System.arraycopy(byArray, n2 + 81, byArray3, 0, 131);
            byte[] byArray4 = new byte[1164];
            System.arraycopy(byArray, n2 + 224, byArray4, 0, 1164);
            TS.setEventInfo(byArray2, byArray3, byArray4);
            Common.setMessage("-> event info cached from TF5X00 header " + (n2 == 0 ? "DVB-C" : "DVB-S/T"));
        }
        catch (Exception exception) {
            Common.setMessage("!> error fetching event info from TF header");
        }
    }

    private void loadUsablePids(JobCollection jobCollection) {
        if (CommonParsing.isInfoScan() && jobCollection.getPIDCount() == 0) {
            jobCollection.addPID(this.usedPIDs.toArray());
            Common.setActiveCollection(Common.getProcessedCollection());
            Common.getGuiInterface().updateCollectionPanel(Common.getActiveCollection());
        }
    }

    /*
     * Unable to fully structure code
     */
    public String parseStream(JobCollection var1_1, XInputFile var2_2, int var3_3, int var4_4, String var5_5) {
        var6_6 = var1_1.getJobProcessing();
        this.setFileName(var1_1, var6_6, var2_2);
        var5_5 = "-1";
        var7_7 = var1_1.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg1);
        var8_8 = var1_1.getSettings().getBooleanProperty(Keys.KEY_MessagePanel_Msg2);
        this.Debug = var1_1.getSettings().getBooleanProperty(Keys.KEY_DebugLog);
        var9_9 = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_joinPackets);
        var10_10 = var1_1.getSettings().getBooleanProperty(Keys.KEY_Input_getEnclosedPackets);
        var11_11 = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_ignoreScrambled);
        var12_12 = var1_1.getSettings().getBooleanProperty(Keys.KEY_Conversion_PcrCounter);
        var13_13 = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_blindSearch);
        StreamParserBase.CreateD2vIndex = var1_1.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_createD2vIndex);
        StreamParserBase.SplitProjectFile = var1_1.getSettings().getBooleanProperty(Keys.KEY_ExternPanel_splitProjectFile);
        this.setOverheadSize(var1_1);
        var14_14 = var1_1.getSettings().getBooleanProperty(Keys.KEY_useAutoPidFilter);
        var15_15 = var1_1.getSettings().getBooleanProperty(Keys.KEY_ExportPanel_Export_Overlap);
        this.HumaxAdaption = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_HumaxAdaption);
        this.HandanAdaption = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_FinepassAdaption);
        this.JepssenAdaption = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_JepssenAdaption);
        this.KoscomAdaption = var1_1.getSettings().getBooleanProperty(Keys.KEY_TS_KoscomAdaption);
        var16_16 = false;
        var17_17 = false;
        var18_18 = false;
        var19_19 = false;
        var20_20 = false;
        var21_21 = false;
        var22_22 = false;
        var26_23 = false;
        var27_24 = new byte[this.TS_BufferSize];
        var28_25 = new byte[4];
        var30_26 = Integer.parseInt(var1_1.getSettings().getProperty(Keys.KEY_ExportPanel_Infoscan_Value));
        var31_27 = var1_1.getSettings().getIntProperty(Keys.KEY_CutMode);
        var33_28 = 0;
        var34_29 = 0;
        var35_30 = 0;
        var36_31 = 0;
        var37_32 = -1;
        var38_33 = -1;
        var39_34 = 0;
        var40_35 = 0;
        var41_36 = 0;
        var42_37 = 0;
        var44_38 = 6;
        var45_39 = 9;
        var46_40 = 0;
        var47_41 = 0;
        var49_42 = 0;
        var50_43 = new int[]{128, 144, 192, 224, 160, 32};
        var6_6.clearStatusVariables();
        var51_44 = var6_6.getStatusVariables();
        var52_45 = 0L;
        var54_46 = 0L;
        var56_47 = 0L;
        var58_48 = 0L;
        this.count = 0L;
        var60_49 = 0L;
        var64_50 = 0L;
        var66_51 = new long[var1_1.getPrimaryInputFileSegments()];
        var67_52 = 0x100000L * (long)(var1_1.getSettings().getIntProperty(Keys.KEY_ExportPanel_Overlap_Value) + 1);
        StreamParserBase.streamconverter = new StreamConverter();
        this.usedPIDs = new ArrayList<E>();
        var71_53 = var2_2.getFileID();
        StreamParserBase.demuxList = var6_6.getTSDemuxList();
        this.TSPidlist = var6_6.getTSPidList();
        if (var6_6.getSplitPart() == 0) {
            this.TSPidlist.clear();
            StreamParserBase.demuxList.clear();
        } else {
            var72_54 = 0;
            while (var72_54 < this.TSPidlist.size()) {
                this.streambuffer = (StreamBuffer)this.TSPidlist.get(var72_54);
                this.streambuffer.reset();
                this.streambuffer.setStarted(false);
                ++var72_54;
            }
            var73_57 = 0;
            while (var73_57 < StreamParserBase.demuxList.size()) {
                StreamParserBase.streamdemultiplexer = (StreamDemultiplexer)StreamParserBase.demuxList.get(var73_57);
                if (StreamParserBase.streamdemultiplexer.getnewID() != 0) {
                    v0 = StreamParserBase.streamdemultiplexer.getType();
                    var50_43[v0] = var50_43[v0] + 1;
                }
                if (StreamParserBase.streamdemultiplexer.getNum() != -1) {
                    if (StreamParserBase.streamdemultiplexer.getType() == 3) {
                        StreamParserBase.streamdemultiplexer.initVideo2(var1_1, StreamParserBase.fparent);
                    } else {
                        StreamParserBase.streamdemultiplexer.init2(var1_1, StreamParserBase.fparent);
                    }
                }
                ++var73_57;
            }
        }
        if (var6_6.getSplitPart() == 0) {
            var72_55 = var2_2.getStreamInfo();
            var73_58 = var72_55.getPIDs();
            if (var73_58.length > 0) {
                Common.setMessage(String.valueOf(Resource.getString("parseTS.sid")) + Common.adaptString(Integer.toHexString(var73_58[0]).toUpperCase(), 4));
                Common.setMessage(Resource.getString("parseTS.pmt.refers", Common.adaptString(Integer.toHexString(var73_58[1]).toUpperCase(), 4)));
                var38_33 = var73_58[1];
                this.pmt_parser = new TS_PMTParser(var73_58[0], var73_58[1]);
                Common.setMessage(Resource.getString("ScanInfo.Video"));
                Common.setMessage(var72_55.getVideo());
                Common.setMessage(Resource.getString("ScanInfo.Audio"));
                Common.setMessage(var72_55.getAudio());
                Common.setMessage(Resource.getString("ScanInfo.Teletext"));
                Common.setMessage(var72_55.getTeletext());
                Common.setMessage(Resource.getString("ScanInfo.Subpicture"));
                Common.setMessage(var72_55.getSubpicture());
                Common.setMessage("");
                var74_60 = 1;
                while (var74_60 < var73_58.length) {
                    this.streambuffer = new StreamBuffer();
                    this.TSPidlist.add(this.streambuffer);
                    this.streambuffer.setPID(var73_58[var74_60]);
                    ++var74_60;
                }
                var6_6.setAudioStreamInfo(var72_55.getAudioStreams());
            } else {
                Common.setMessage(Resource.getString("parseTS.no.pmt"));
            }
        }
        this.initConversion(var1_1, StreamParserBase.fparent, var4_4, 4, var6_6.getSplitPart());
        if (StreamParserBase.CreateD2vIndex || StreamParserBase.SplitProjectFile) {
            var6_6.getProjectFileD2V().Init(StreamParserBase.fparent);
        }
        var6_6.setMinBitrate(262143);
        var6_6.setMaxBitrate(0);
        var6_6.setExportedVideoFrameNumber(0);
        var6_6.setEndPtsOfGop(-10000L);
        var6_6.setSequenceHeader(true);
        var6_6.setAllMediaFilesExportLength(0L);
        var6_6.setProjectFileExportLength(0L);
        var6_6.setCutByteposition(0L);
        var72_56 = var14_14 != false ? var2_2.getStreamInfo().getMediaPIDs() : var1_1.getPIDsAsInteger();
        var73_59 = new int[var72_56.length];
        var74_60 = 0;
        while (var74_60 < var73_59.length) {
            var73_59[var74_60] = this.PidMask & var72_56[var74_60];
            ++var74_60;
        }
        if (var73_59.length > 0) {
            Arrays.sort(var73_59);
            var75_61 = " ";
            var76_64 = 0;
            while (var76_64 < var73_59.length) {
                var75_61 = String.valueOf(var75_61) + "0x" + Integer.toHexString(var73_59[var76_64]).toUpperCase() + " ";
                ++var76_64;
            }
            Common.setMessage(String.valueOf(Resource.getString("parseTS.special.pids")) + ": {" + var75_61 + "}");
            var22_22 = true;
        }
        try {
            this.getEventInfo((XInputFile)var1_1.getInputFile(0));
            var75_62 = 0;
            while (var75_62 < var66_51.length) {
                var2_2 = (XInputFile)var1_1.getInputFile(var75_62);
                var66_51[var75_62] = var60_49;
                var60_49 += var2_2.length();
                ++var75_62;
            }
            var2_2 = (XInputFile)var1_1.getInputFile(var6_6.getFileNumber());
            this.count = var66_51[var6_6.getFileNumber()];
            var60_49 = this.count + var2_2.length();
            if (var6_6.getSplitSize() > 0L) {
                var64_50 = var6_6.getLastHeaderBytePosition();
                var64_50 -= var15_15 == false ? 0L : var67_52;
                var6_6.setLastGopTimecode(0L);
                var6_6.setLastGopPts(0L);
                var6_6.setLastSimplifiedPts(0L);
            }
            var76_65 = var1_1.getCutpointList();
            var77_66 = var1_1.getChapterpointList();
            if (var31_27 == 0 && var76_65.size() > 0 && CommonParsing.getCutCounter() == 0) {
                var64_50 = Long.parseLong(var76_65.get(CommonParsing.getCutCounter()).toString()) - (var4_4 == 0 ? StreamParserBase.OverheadSize : 0L);
            }
            if (var64_50 < 0L) {
                var64_50 = this.count;
            } else if (var64_50 < this.count) {
                var78_67 = var66_51.length;
                while (var78_67 > 0) {
                    if (var66_51[var78_67 - 1] > var64_50) {
                        var6_6.countFileNumber(-1);
                    }
                    --var78_67;
                }
            } else if (var64_50 > this.count) {
                var78_67 = var6_6.getFileNumber() + 1;
                while (var78_67 < var66_51.length) {
                    if (var66_51[var78_67] <= var64_50) {
                        var6_6.countFileNumber(1);
                        ++var78_67;
                        continue;
                    }
                    break;
                }
            }
            var2_2 = (XInputFile)var1_1.getInputFile(var6_6.getFileNumber());
            var25_69 = var2_2.getStreamInfo().getStreamSubType() == 5;
            this.count = var66_51[var6_6.getFileNumber()];
            if (var6_6.getFileNumber() > 0) {
                Common.setMessage(String.valueOf(Resource.getString("parseTS.continue")) + " " + var2_2);
            }
            var62_70 = this.count;
            var60_49 = this.count + var2_2.length();
            this.inputstream = new PushbackInputStream(var2_2.getInputStream(var64_50 - var62_70), this.PushbackBufferSize);
            this.count += var64_50 - var62_70;
            Common.updateProgressBar(String.valueOf(var4_4 == 0 ? Resource.getString("parseTS.demuxing") : Resource.getString("parseTS.converting")) + " " + Resource.getString("parseTS.dvb.mpeg") + " " + var2_2.getName(), this.count - var62_70, var60_49 - var62_70);
            var69_71 = this.count + 0x100000L * (long)var30_26;
            block27: while (true) {
                block159: {
                    block164: {
                        block165: {
                            block158: {
                                block163: {
                                    block160: {
                                        block162: {
                                            block161: {
                                                if (this.count >= var60_49) break block159;
                                                while (this.pause()) {
                                                }
                                                if (CommonParsing.isProcessCancelled() || CommonParsing.isInfoScan() && this.count > var69_71) {
                                                    CommonParsing.setProcessCancelled(false);
                                                    var6_6.setSplitSize(0L);
                                                    break;
                                                }
                                                if (var6_6.getCutComparePoint() + 20L < (long)var6_6.getSourceVideoFrameNumber()) {
                                                    var20_20 = true;
                                                    break;
                                                }
                                                if (var31_27 == 0 && var76_65.size() > 0 && CommonParsing.getCutCounter() == var76_65.size() && (CommonParsing.getCutCounter() & 1) == 0 && this.count > Long.parseLong(var76_65.get(CommonParsing.getCutCounter() - 1).toString()) + StreamParserBase.OverheadSize) {
                                                    var20_20 = true;
                                                    break;
                                                }
                                                var26_23 = false;
                                                if (var16_16 && var9_9) break block160;
                                                var49_42 = this.inputstream.read(var27_24, 0, this.TS_BufferSize);
                                                if (var49_42 != this.TS_PacketLength || var60_49 - this.count != (long)var49_42) break block161;
                                                var27_24[this.TS_PacketLength] = this.TS_SyncByte;
                                                break block162;
                                            }
                                            if (var49_42 >= this.TS_BufferSize || !var9_9) break block162;
                                            Common.setMessage(String.valueOf(Resource.getString("parseTS.incomplete")) + " " + this.count);
                                            this.count += (long)var49_42;
                                            break block159;
                                        }
                                        if (var25_69 && var49_42 == this.TS_BufferSize) {
                                            this.inputstream.read(var28_25, 0, 4);
                                            v1 = var26_23 = var28_25[3] == this.TS_SyncByte;
                                            if (var26_23) {
                                                var27_24[this.TS_PacketLength] = this.TS_SyncByte;
                                                this.count += 4L;
                                            } else {
                                                this.inputstream.unread(var28_25, 0, 4);
                                            }
                                        }
                                    }
                                    this.skipLeadingHumaxDataChunk(var27_24);
                                    this.skipLeadingJepssenDataChunk(var27_24);
                                    this.skipLeadingKoscomDataChunk(var27_24);
                                    this.skipLeadingHandanDataChunk(var27_24);
                                    if (!(this.skipJepssenDataChunk(var27_24) || this.skipKoscomDataChunk(var27_24) || this.skipHumaxDataChunk(var27_24))) {
                                        if (var27_24[0] != this.TS_SyncByte || var10_10 && var27_24[this.TS_PacketLength] != this.TS_SyncByte) {
                                            if (var25_69 && var16_16 && var9_9) {
                                                this.inputstream.read(var28_25, 0, 4);
                                                v2 = var26_23 = var28_25[3] == this.TS_SyncByte;
                                                if (var26_23) {
                                                    var27_24[this.TS_PacketLength] = this.TS_SyncByte;
                                                    this.count += 4L;
                                                    Common.setMessage(Resource.getString("parseTS.comp.ok"));
                                                } else {
                                                    this.inputstream.unread(var28_25, 0, 4);
                                                }
                                            }
                                            if (!var26_23) {
                                                if (var8_8 && !var21_21) {
                                                    Common.setMessage(String.valueOf(Resource.getString("parseTS.missing.sync")) + " " + this.count);
                                                }
                                                if (var16_16 && var9_9) {
                                                    Common.setMessage(Resource.getString("parseTS.comp.failed"));
                                                    this.inputstream.unread(var27_24, 190 - var49_42, var49_42 - 1);
                                                    var16_16 = false;
                                                    ++this.count;
                                                } else {
                                                    var78_67 = 1;
                                                    while (var78_67 < this.TS_BufferSize) {
                                                        if (var27_24[var78_67] == this.TS_SyncByte) break;
                                                        ++var78_67;
                                                    }
                                                    this.inputstream.unread(var27_24, var78_67, this.TS_BufferSize - var78_67);
                                                    this.count += (long)var78_67;
                                                }
                                                var21_21 = true;
                                                continue;
                                            }
                                        } else if (var16_16 && var9_9) {
                                            Common.setMessage(Resource.getString("parseTS.comp.ok"));
                                        }
                                    }
                                    if (var26_23) {
                                        this.count -= 4L;
                                    }
                                    if (var8_8 && var21_21) {
                                        Common.setMessage(String.valueOf(Resource.getString("parseTS.found.sync")) + " " + this.count);
                                    }
                                    var21_21 = false;
                                    this.inputstream.unread(var27_24, this.TS_PacketLength, 1);
                                    var6_6.setLastHeaderBytePosition(this.count);
                                    var52_45 = this.count;
                                    if (var16_16 && var9_9) {
                                        this.count += (long)(var49_42 - 1);
                                        var16_16 = false;
                                    } else {
                                        this.count += (long)this.TS_PacketLength;
                                    }
                                    if (var26_23) {
                                        this.count += 4L;
                                    }
                                    ++var58_48;
                                    var18_18 = (128 & var27_24[1]) != 0;
                                    var17_17 = (64 & var27_24[1]) != 0;
                                    var32_75 = (31 & var27_24[1]) << 8 | 255 & var27_24[2];
                                    var33_28 = (192 & var27_24[3]) >>> 6;
                                    var34_29 = (48 & var27_24[3]) >>> 4;
                                    var35_30 = 15 & var27_24[3];
                                    var36_31 = var34_29 > 1 ? (255 & var27_24[4]) + 1 : 0;
                                    Common.updateProgressBar(this.count - var62_70, var60_49 - var62_70);
                                    if (var22_22 && Arrays.binarySearch(var73_59, var32_75) < 0) continue;
                                    if (var4_4 == 5) {
                                        StreamParserBase.streamconverter.write(var6_6, var27_24, 0, this.TS_PacketLength, null, var52_45, CommonParsing.isInfoScan(), var76_65);
                                        continue;
                                    }
                                    if ((var34_29 & 1) == 0) continue;
                                    if (var18_18 || var36_31 > 183 || var36_31 > 180 && var17_17) {
                                        if (!var7_7) continue;
                                        Common.setMessage(String.valueOf(Resource.getString("parseTS.bit.error", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4), String.valueOf(var58_48), String.valueOf(this.count - (long)this.TS_PacketLength))) + " (" + var36_31 + " / " + var17_17 + ")");
                                        continue;
                                    }
                                    var39_34 = var17_17 != false ? CommonParsing.getIntValue(var27_24, 4 + var36_31, 4, false) : 0;
                                    var40_35 = var17_17 != false ? var39_34 >>> 16 : 0;
                                    var24_73 = false;
                                    var78_67 = 0;
                                    while (var78_67 < this.TSPidlist.size()) {
                                        this.streambuffer = (StreamBuffer)this.TSPidlist.get(var78_67);
                                        v3 = var24_73 = var32_75 == this.streambuffer.getPID();
                                        if (var24_73) break;
                                        ++var78_67;
                                    }
                                    if (!var24_73) {
                                        this.streambuffer = new StreamBuffer();
                                        this.TSPidlist.add(this.streambuffer);
                                        this.streambuffer.setPID(var32_75);
                                        if (var32_75 == this.PidMask) {
                                            Common.setMessage(Resource.getString("parseTS.stuffing"));
                                            this.streambuffer.setneeded(false);
                                        }
                                    }
                                    if (this.Debug) {
                                        System.out.println("pk " + var58_48 + " /pid " + Integer.toHexString(var32_75) + " /pes " + Integer.toHexString(var39_34) + " /tn " + this.streambuffer.isneeded() + " /er " + var18_18 + " /st " + var17_17 + " /sc " + var33_28 + " /ad " + var34_29 + " /al " + var36_31);
                                    }
                                    if (!this.streambuffer.isneeded()) continue;
                                    if (var11_11) {
                                        if (var33_28 > 0) {
                                            if (this.streambuffer.getScram()) continue;
                                            this.streambuffer.setScram(true);
                                            Common.setMessage(Resource.getString("parseTS.scrambled", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4), String.valueOf(var58_48), String.valueOf(this.count - (long)this.TS_PacketLength)));
                                            continue;
                                        }
                                        if (this.streambuffer.getScram()) {
                                            this.streambuffer.setScram(false);
                                            Common.setMessage(Resource.getString("parseTS.clear", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4), String.valueOf(var58_48), String.valueOf(this.count - (long)this.TS_PacketLength)));
                                        }
                                    }
                                    if (var7_7 && (var12_12 || !var12_12 && (1 & var34_29) != 0)) {
                                        if (this.streambuffer.getCounter() != -1) {
                                            if (this.streambuffer.isStarted() && var35_30 != this.streambuffer.getCounter()) {
                                                Common.setMessage(String.valueOf(Resource.getString("parseTS.outof.sequence", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4), String.valueOf(var58_48), String.valueOf(this.count - (long)this.TS_PacketLength), String.valueOf(var35_30), String.valueOf(this.streambuffer.getCounter()))) + " (~" + Common.formatTime_1((long)(CommonParsing.getVideoFramerate() / 90.0 * (double)var6_6.getExportedVideoFrameNumber())) + ")");
                                                this.streambuffer.setCounter(var35_30);
                                            }
                                            this.streambuffer.count();
                                        } else {
                                            this.streambuffer.setCounter(var35_30);
                                            this.streambuffer.count();
                                        }
                                    }
                                    if (var17_17) break block163;
                                    if (this.streambuffer.isneeded() && this.streambuffer.isStarted()) {
                                        this.streambuffer.writeData(var27_24, 4 + var36_31, 184 - var36_31);
                                    }
                                    if (this.streambuffer.getDataSize() > this.MaxBufferSize) {
                                        Common.setMessage("!> 0x" + Integer.toHexString(this.streambuffer.getPID()).toUpperCase() + ", buffered packet exceeds maximum size, flushed...");
                                        this.streambuffer.reset();
                                    }
                                    break block164;
                                }
                                var23_72 = false;
                                var47_41 = 0;
                                if (this.streambuffer.getID() == -1 && var39_34 == 445) {
                                    var41_36 = 0;
                                    var46_40 = 0;
                                    try {
                                        var41_36 = 255 & var27_24[12 + var36_31];
                                        var46_40 = 13 + var36_31 + var41_36;
                                        v4 = var23_72 = var41_36 == 36 && (255 & var27_24[var46_40]) >>> 4 == 1;
                                        if (!var23_72) {
                                            v5 = var23_72 = var41_36 == 36 && (255 & var27_24[var46_40]) == 153;
                                        }
                                        if (var23_72) break block158;
                                        var47_41 = (255 & var27_24[var46_40]) == 32 && (255 & var27_24[var46_40 + 1]) == 0 && (255 & var27_24[var46_40 + 2]) == 15 ? 32 : 0;
                                    }
                                    catch (ArrayIndexOutOfBoundsException var79_78) {
                                        Common.setMessage(String.valueOf(Resource.getString("parseTS.io.error")) + " / " + var41_36 + " / " + var46_40);
                                        Common.setExceptionMessage(var79_78);
                                        this.streambuffer.reset();
                                        this.streambuffer.setStarted(false);
                                        continue;
                                    }
                                }
                            }
                            this.streambuffer.setStarted(true);
                            if (this.streambuffer.getID() != -1) break block165;
                            this.streambuffer.setID(var39_34);
                            var79_79 = "";
                            switch (-16 & var39_34) {
                                case 480: {
                                    var79_79 = Resource.getString("idtype.mpeg.video");
                                    this.streambuffer.setDemux(StreamParserBase.demuxList.size());
                                    StreamParserBase.streamdemultiplexer = new StreamDemultiplexer(var1_1);
                                    StreamParserBase.streamdemultiplexer.setPID(var32_75);
                                    StreamParserBase.streamdemultiplexer.setID(var39_34);
                                    v6 = var50_43[3];
                                    var50_43[3] = v6 + 1;
                                    StreamParserBase.streamdemultiplexer.setnewID(v6);
                                    StreamParserBase.streamdemultiplexer.setsubID(0);
                                    StreamParserBase.streamdemultiplexer.setType(3);
                                    StreamParserBase.streamdemultiplexer.setStreamType(var3_3);
                                    StreamParserBase.demuxList.add(StreamParserBase.streamdemultiplexer);
                                    if (var4_4 == 0) {
                                        if (var50_43[3] - 1 == 224) {
                                            StreamParserBase.streamdemultiplexer.initVideo(var1_1, StreamParserBase.fparent, this.MainBufferSize / StreamParserBase.demuxList.size(), StreamParserBase.demuxList.size(), 2);
                                            break;
                                        }
                                        var79_79 = String.valueOf(var79_79) + Resource.getString("idtype.ignored");
                                        this.streambuffer.setneeded(false);
                                        break;
                                    }
                                    var79_79 = String.valueOf(var79_79) + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(var50_43[3] - 1).toUpperCase();
                                    break;
                                }
                                case 448: 
                                case 464: {
                                    var79_79 = Resource.getString("idtype.mpeg.audio");
                                    this.streambuffer.setDemux(StreamParserBase.demuxList.size());
                                    StreamParserBase.streamdemultiplexer = new StreamDemultiplexer(var1_1);
                                    StreamParserBase.streamdemultiplexer.setPID(var32_75);
                                    StreamParserBase.streamdemultiplexer.setID(var39_34);
                                    v7 = var50_43[2];
                                    var50_43[2] = v7 + 1;
                                    StreamParserBase.streamdemultiplexer.setnewID(v7);
                                    StreamParserBase.streamdemultiplexer.setsubID(0);
                                    StreamParserBase.streamdemultiplexer.setType(2);
                                    StreamParserBase.streamdemultiplexer.setStreamType(var3_3);
                                    StreamParserBase.demuxList.add(StreamParserBase.streamdemultiplexer);
                                    if (var4_4 == 0) {
                                        StreamParserBase.streamdemultiplexer.init(var1_1, StreamParserBase.fparent, this.MainBufferSize / StreamParserBase.demuxList.size(), StreamParserBase.demuxList.size(), 2);
                                        break;
                                    }
                                    var79_79 = String.valueOf(var79_79) + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(var50_43[2] - 1).toUpperCase();
                                    break;
                                }
                            }
                            switch (var39_34) {
                                case 445: {
                                    var79_79 = Resource.getString("idtype.private.stream");
                                    var79_79 = String.valueOf(var79_79) + (var23_72 != false ? " (TTX) " : "") + (var47_41 != 0 ? " (SubID 0x" + Integer.toHexString(var47_41).toUpperCase() + ")" : "");
                                    this.streambuffer.setDemux(StreamParserBase.demuxList.size());
                                    StreamParserBase.streamdemultiplexer = new StreamDemultiplexer(var1_1);
                                    StreamParserBase.streamdemultiplexer.setPID(var32_75);
                                    StreamParserBase.streamdemultiplexer.setID(var39_34);
                                    StreamParserBase.streamdemultiplexer.setsubID(var47_41);
                                    StreamParserBase.streamdemultiplexer.setTTX(var23_72);
                                    if (var23_72) {
                                        v8 = var50_43[1];
                                        var50_43[1] = v8 + 1;
                                        StreamParserBase.streamdemultiplexer.setnewID(v8);
                                        StreamParserBase.streamdemultiplexer.setType(1);
                                    } else if (var47_41 == 32) {
                                        v9 = var50_43[5];
                                        var50_43[5] = v9 + 1;
                                        StreamParserBase.streamdemultiplexer.setnewID(v9);
                                        StreamParserBase.streamdemultiplexer.setType(5);
                                    } else {
                                        v10 = var50_43[0];
                                        var50_43[0] = v10 + 1;
                                        StreamParserBase.streamdemultiplexer.setnewID(v10);
                                        StreamParserBase.streamdemultiplexer.setType(0);
                                    }
                                    StreamParserBase.streamdemultiplexer.setStreamType(var47_41 == 32 ? 3 : 1);
                                    StreamParserBase.demuxList.add(StreamParserBase.streamdemultiplexer);
                                    if (var4_4 == 0) {
                                        StreamParserBase.streamdemultiplexer.init(var1_1, StreamParserBase.fparent, this.MainBufferSize / StreamParserBase.demuxList.size(), StreamParserBase.demuxList.size(), 2);
                                    }
                                    if (var4_4 != 0 && var47_41 != 0) {
                                        var79_79 = String.valueOf(var79_79) + Resource.getString("idtype.ignored");
                                        this.streambuffer.setneeded(false);
                                    }
                                    if (var4_4 != 0 && !var23_72) {
                                        var79_79 = String.valueOf(var79_79) + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(var50_43[0] - 1).toUpperCase();
                                    }
                                    if (var4_4 == 0 || !var23_72) ** GOTO lbl468
                                    var79_79 = String.valueOf(var79_79) + " " + Resource.getString("idtype.mapped.to") + Integer.toHexString(var50_43[1] - 1).toUpperCase();
                                    ** GOTO lbl468
                                }
                                case 447: {
                                    Common.setMessage(Resource.getString("parseTS.priv.stream2.ignored", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4)));
                                    this.streambuffer.setneeded(false);
                                    continue block27;
                                }
lbl468:
                                // 3 sources

                                default: {
                                    if (var14_14 && var32_75 == var38_33 && var40_35 == 2) {
                                        var79_79 = "(PMT) (" + (this.count - (long)this.TS_PacketLength) + " #" + var58_48 + ") ";
                                        Common.setMessage("ok> PID 0x" + Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4) + " " + var79_79);
                                        this.usedPIDs.add("0x" + Integer.toHexString(var32_75));
                                        break;
                                    }
                                    if (!var79_79.equals("")) {
                                        var79_79 = String.valueOf(var79_79) + " (" + (this.count - (long)this.TS_PacketLength) + " #" + var58_48 + ") ";
                                        Common.setMessage(Resource.getString("parseTS.pid.has.pes", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4), Integer.toHexString(255 & var39_34).toUpperCase(), var79_79));
                                        this.usedPIDs.add("0x" + Integer.toHexString(var32_75));
                                        break;
                                    }
                                    if (var32_75 == 0 && var40_35 == 0) {
                                        var79_79 = "(PAT)";
                                    } else if (var32_75 == 1 && var40_35 == 1) {
                                        var79_79 = "(CAT)";
                                    } else if (var32_75 == 2 && var40_35 == 3) {
                                        var79_79 = "(TSDT)";
                                    } else if (var32_75 == 16 && (var40_35 == 6 || var40_35 == 64 || var40_35 == 65)) {
                                        var79_79 = "(NIT)";
                                    } else if (var32_75 == 17 && (var40_35 == 66 || var40_35 == 70)) {
                                        var79_79 = "(SDT)";
                                    } else if (var32_75 == 17 && var40_35 == 74) {
                                        var79_79 = "(BAT)";
                                    } else if (var32_75 == 18 && var40_35 >= 78 && var40_35 <= 111) {
                                        var79_79 = "(EIT)";
                                    } else if (var32_75 == 19 && var40_35 == 113) {
                                        var79_79 = "(RST)";
                                    } else if (var32_75 == 31 && var40_35 == 127) {
                                        var79_79 = "(SIT)";
                                    } else if (var32_75 == 30 && var40_35 == 126) {
                                        var79_79 = "(DIT)";
                                    } else if (var32_75 == 20 && var40_35 == 112) {
                                        var79_79 = "(TDS)";
                                    } else if (var32_75 == 20 && var40_35 == 115) {
                                        var79_79 = "(TOT)";
                                    } else if (var40_35 == 114 && var32_75 >= 16 && var32_75 <= 20) {
                                        var79_79 = "(ST)";
                                    } else {
                                        switch (var40_35) {
                                            case 2: {
                                                var79_79 = "(PMT)";
                                                break;
                                            }
                                            case 4: {
                                                var79_79 = "(PSI)";
                                                break;
                                            }
                                            case 130: {
                                                var79_79 = "(EMM)";
                                                break;
                                            }
                                            case 128: 
                                            case 129: 
                                            case 131: 
                                            case 132: {
                                                var79_79 = "(ECM)";
                                                break;
                                            }
                                            case 64: 
                                            case 65: 
                                            case 66: 
                                            case 67: 
                                            case 68: 
                                            case 69: 
                                            case 71: 
                                            case 72: 
                                            case 73: 
                                            case 75: 
                                            case 76: 
                                            case 77: 
                                            case 255: {
                                                var79_79 = "(res.)";
                                                break;
                                            }
                                            default: {
                                                if (var40_35 >= 4 && var40_35 <= 63 || var40_35 >= 116 && var40_35 <= 125) {
                                                    var79_79 = "(res.)";
                                                    break;
                                                }
                                                if (var40_35 >= 128 && var40_35 < 255) {
                                                    var79_79 = "(user def. 0x" + Integer.toHexString(var40_35).toUpperCase() + ")";
                                                    break;
                                                }
                                                var79_79 = String.valueOf(var79_79) + "(payload: ";
                                                var80_81 = 0;
                                                while (var80_81 < 8) {
                                                    var81_83 = Integer.toHexString(255 & var27_24[4 + var36_31 + var80_81]).toUpperCase();
                                                    var79_79 = String.valueOf(var79_79) + " " + (var81_83.length() < 2 ? "0" + var81_83 : var81_83);
                                                    ++var80_81;
                                                }
                                                var79_79 = String.valueOf(var79_79) + " ..)";
                                            }
                                        }
                                    }
                                    if (var33_28 > 0 && !var11_11) {
                                        var79_79 = String.valueOf(var79_79) + " (0x" + Long.toHexString(this.count - (long)this.TS_PacketLength).toUpperCase() + " #" + var58_48 + ") ";
                                        if (!this.streambuffer.getScram()) {
                                            Common.setMessage(Resource.getString("parseTS.scrambled.notignored", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4), var79_79));
                                        }
                                        this.streambuffer.setScram(true);
                                        this.streambuffer.setStarted(false);
                                        this.streambuffer.setID(-1);
                                        this.streambuffer.reset();
                                        continue block27;
                                    }
                                    var79_79 = String.valueOf(var79_79) + " (" + (this.count - (long)this.TS_PacketLength) + " #" + var58_48 + ") ";
                                    Common.setMessage("!> PID 0x" + Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4) + " " + var79_79 + Resource.getString("parseTS.ignored"));
                                    if (!var13_13 || var79_79.indexOf("pay") == -1) {
                                        this.streambuffer.setneeded(false);
                                        continue block27;
                                    }
                                    this.streambuffer.setID(-1);
                                    continue block27;
                                }
                            }
                        }
                        if (this.checkDynamicPMT(var32_75)) {
                            this.streambuffer.reset();
                            this.streambuffer.writeData(var27_24, 4 + var36_31, 184 - var36_31);
                            continue;
                        }
                        if (this.streambuffer.getDemux() == -1 || !this.streambuffer.isneeded()) continue;
                        StreamParserBase.streamdemultiplexer = (StreamDemultiplexer)StreamParserBase.demuxList.get(this.streambuffer.getDemux());
                        if (StreamParserBase.streamdemultiplexer.StreamEnabled()) {
                            var29_74 = this.streambuffer.getData().toByteArray();
                            if (var29_74.length < 6) {
                                if (StreamParserBase.streamdemultiplexer.getPackCount() != -1) {
                                    Common.setMessage(Resource.getString("parseTS.lackof.pes", Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4)));
                                }
                            } else if (CommonParsing.validateStartcode(var29_74, 0) < 0) {
                                Common.setMessage("!> PID 0x" + Common.adaptString(Integer.toHexString(var32_75).toUpperCase(), 4) + " - invalid start_code of buffered packet..");
                            } else {
                                var42_37 = CommonParsing.getPES_LengthField(var29_74, 0);
                                var43_76 = var44_38 + var42_37;
                                var48_77 = StreamParserBase.streamdemultiplexer.getID();
                                if (StreamParserBase.streamdemultiplexer.getType() != 3) {
                                    if (var4_4 == 0) {
                                        StreamParserBase.streamdemultiplexer.write(var6_6, var29_74, 0, var43_76, true);
                                    } else {
                                        StreamParserBase.streamconverter.write(var6_6, var29_74, StreamParserBase.streamdemultiplexer, var52_45, CommonParsing.isInfoScan(), var76_65);
                                    }
                                } else {
                                    var43_76 = var4_4 == 0 ? 65532 : 6144;
                                    var79_80 = 0;
                                    var81_84 = var43_76;
                                    var82_85 = (243 & var29_74[6]) << 16;
                                    while (var79_80 < var29_74.length) {
                                        if (var29_74.length - var79_80 < var81_84) {
                                            var81_84 = var29_74.length - var79_80;
                                        }
                                        if (var79_80 == 0) {
                                            CommonParsing.setPES_LengthField(var29_74, var79_80, var81_84 - var44_38);
                                            if (var4_4 == 0) {
                                                StreamParserBase.streamdemultiplexer.writeVideo(var6_6, var29_74, var79_80, var81_84, true, var76_65, var77_66);
                                                var6_6.setCutByteposition(var52_45);
                                            } else {
                                                StreamParserBase.streamconverter.write(var6_6, var29_74, var79_80, StreamParserBase.streamdemultiplexer, var52_45, CommonParsing.isInfoScan(), var76_65);
                                            }
                                        } else {
                                            var80_81 = var79_80 - var45_39;
                                            CommonParsing.setValue(var29_74, var80_81, 4, false, 256 | var48_77);
                                            CommonParsing.setPES_LengthField(var29_74, var80_81, var81_84 + 3);
                                            CommonParsing.setValue(var29_74, var80_81 + var44_38, 3, false, var82_85);
                                            if (var4_4 == 0) {
                                                StreamParserBase.streamdemultiplexer.writeVideo(var6_6, var29_74, var80_81, var81_84 + 3, true, var76_65, var77_66);
                                                var6_6.setCutByteposition(var52_45);
                                            } else {
                                                StreamParserBase.streamconverter.write(var6_6, var29_74, var80_81, StreamParserBase.streamdemultiplexer, var52_45, CommonParsing.isInfoScan(), var76_65);
                                            }
                                        }
                                        var79_80 += var81_84;
                                    }
                                }
                            }
                        }
                        var29_74 = null;
                        this.streambuffer.reset();
                        this.streambuffer.writeData(var27_24, 4 + var36_31, 184 - var36_31);
                    }
                    var51_44[5] = var51_44[5] + 1;
                    if (var4_4 != 0) {
                        var6_6.setLastHeaderBytePosition(this.count);
                    }
                    if (var6_6.getSplitSize() <= 0L || var6_6.getSplitSize() >= var6_6.getAllMediaFilesExportLength()) {
                        continue;
                    }
                }
                if (var6_6.getSplitSize() > 0L && var6_6.getSplitSize() < var6_6.getAllMediaFilesExportLength() || var6_6.getFileNumber() >= var1_1.getPrimaryInputFileSegments() - 1) break;
                this.inputstream.close();
                var78_68 = this.checkNextComagSegment(var1_1, var6_6.getFileNumber());
                if (var78_68 == 0L) {
                    var78_68 = this.checkNextJepssenKoscomSegment(var1_1, var6_6.getFileNumber(), var49_42);
                }
                var25_69 = (var80_82 = (XInputFile)var1_1.getInputFile(var6_6.countFileNumber(1))).getStreamInfo().getStreamSubType() == 5;
                this.count = var60_49 + var78_68;
                this.inputstream = new PushbackInputStream(var80_82.getInputStream(var78_68), this.PushbackBufferSize);
                var60_49 += var80_82.length();
                var62_70 = this.count;
                this.addCellTimeFromFileSegment(var6_6);
                Common.setMessage(String.valueOf(Resource.getString("parseTS.actual.vframes")) + " " + var6_6.getExportedVideoFrameNumber());
                Common.setMessage(String.valueOf(Resource.getString("parseTS.switch.to")) + " " + var80_82 + " (" + Common.formatNumber(var80_82.length()) + " bytes) @ " + var62_70);
                Common.updateProgressBar(String.valueOf(var4_4 == 0 ? Resource.getString("parseTS.demuxing") : Resource.getString("parseTS.converting")) + " " + Resource.getString("parseTS.dvb.mpeg") + " " + var80_82.getName());
                if (!var9_9 || var49_42 >= this.TS_PacketLength || var80_82.length() < (long)(this.TS_BufferSize - var49_42)) continue;
                var16_16 = true;
                var49_42 = this.inputstream.read(var27_24, var49_42, this.TS_BufferSize - var49_42);
                Common.setMessage(Resource.getString("parseTS.tryto.complete"));
            }
            Common.setMessage(Resource.getString("parseTS.packs", String.valueOf(var51_44[5]), String.valueOf(this.count * 100L / var60_49), String.valueOf(this.count)));
            if ((this.count >= var60_49 || var20_20) && var6_6.getSplitSize() > 0L) {
                var6_6.setSplitLoopActive(false);
            }
            this.inputstream.close();
            var5_5 = this.processElementaryStreams(var5_5, var4_4, var51_44, var1_1, var6_6);
            this.loadUsablePids(var1_1);
        }
        catch (IOException var75_63) {
            Common.setExceptionMessage(var75_63);
        }
        return var5_5;
    }

    private boolean skipHumaxDataChunk(byte[] byArray) {
        boolean bl = false;
        if (!this.HumaxAdaption) {
            return bl;
        }
        if (byArray[0] != this.TS_SyncByte || byArray[this.TS_PacketLength] != 127) {
            return bl;
        }
        return bl ^ true;
    }

    private boolean skipJepssenDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 36;
        if (!this.JepssenAdaption) {
            return bl;
        }
        if (byArray[this.TS_PacketLength] == this.TS_SyncByte) {
            return bl;
        }
        try {
            this.inputstream.read(this.tmp_chunk, 0, n);
            if (this.tmp_chunk[2] == 0 && this.tmp_chunk[3] == 0 && this.tmp_chunk[35] == this.TS_SyncByte) {
                if (this.Debug) {
                    int n2 = (0xFF & this.tmp_chunk[1]) << 16 | (0xFF & this.tmp_chunk[0]) << 8 | 0xFF & byArray[this.TS_PacketLength];
                    System.out.println("Jepssen hd chunk: " + n2);
                }
                byArray[this.TS_PacketLength] = this.TS_SyncByte;
                this.count += (long)n;
                return bl ^ true;
            }
            this.inputstream.unread(this.tmp_chunk, 0, n);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return bl;
    }

    private boolean skipKoscomDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 4;
        if (!this.KoscomAdaption) {
            return bl;
        }
        if (byArray[this.TS_PacketLength] == this.TS_SyncByte) {
            return bl;
        }
        try {
            this.inputstream.read(this.tmp_chunk, 0, n);
            if (this.tmp_chunk[1] == 0 && this.tmp_chunk[2] == 0 && this.tmp_chunk[3] == this.TS_SyncByte) {
                byArray[this.TS_PacketLength] = this.TS_SyncByte;
                this.count += (long)n;
                return bl ^ true;
            }
            this.inputstream.unread(this.tmp_chunk, 0, n);
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    private boolean skipLeadingHandanDataChunk(byte[] var1_1) {
        var2_2 = false;
        var3_3 = 512;
        var4_4 = this.TS_PacketLength;
        var6_5 = this.TS_BufferSize;
        var7_6 = this.hav_chunk.length;
        if (!this.HandanAdaption) {
            return var2_2;
        }
        if (var1_1[0] == this.TS_SyncByte && var1_1[this.TS_PacketLength] != this.TS_SyncByte) ** GOTO lbl32
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var5_7 = 0;
            while (var4_4 > 0 && var1_1[var4_4] != this.hav_chunk[var5_7]) {
                --var4_4;
            }
            while (var4_4 > 0 && var5_7 < var7_6 && var4_4 + var5_7 < var6_5) {
                if (var1_1[var4_4 + var5_7] != this.hav_chunk[var5_7]) break;
                ++var5_7;
            }
            if (var5_7 <= 0) continue;
            if (var5_7 < var7_6 && var4_4 + var5_7 < var6_5) {
                --var4_4;
                continue;
            }
            try {
                this.inputstream.skip(var3_3 - (var6_5 - var4_4));
                this.inputstream.read(var1_1, var4_4, var6_5 - var4_4);
                this.count += (long)var3_3;
                return var2_2 ^ true;
            }
            catch (IOException var8_8) {
                Common.setExceptionMessage(var8_8);
                break;
            }
lbl32:
            // 3 sources

            ** while (var4_4 > 0)
        }
lbl33:
        // 2 sources

        return var2_2;
    }

    private boolean skipLeadingHumaxDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 1184;
        if (!this.HumaxAdaption) {
            return bl;
        }
        if (byArray[0] != 127 || byArray[1] != 65 || byArray[2] != 4 || byArray[3] != -3) {
            return bl;
        }
        try {
            this.inputstream.skip(n - this.TS_BufferSize);
            this.inputstream.read(byArray, 0, this.TS_BufferSize);
            this.count += (long)n;
            return bl ^ true;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return bl;
        }
    }

    private boolean skipLeadingJepssenDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 36;
        if (!this.JepssenAdaption) {
            return bl;
        }
        if (byArray[2] != 0 || byArray[3] != 0 || byArray[4] != 0 || byArray[36] != this.TS_SyncByte) {
            return bl;
        }
        try {
            if (this.Debug) {
                int n2 = CommonParsing.getIntValue(byArray, 0, 3, false);
                System.out.println("Jepssen hd chunk: " + n2);
            }
            this.inputstream.unread(byArray, n, this.TS_BufferSize - n);
            this.inputstream.read(byArray, 0, this.TS_BufferSize);
            this.count += (long)n;
            return bl ^ true;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return bl;
        }
    }

    private boolean skipLeadingKoscomDataChunk(byte[] byArray) {
        boolean bl = false;
        int n = 4;
        if (!this.KoscomAdaption) {
            return bl;
        }
        if (byArray[2] != 0 || byArray[3] != 0 || byArray[4] != this.TS_SyncByte) {
            return bl;
        }
        try {
            this.inputstream.unread(byArray, n, this.TS_BufferSize - n);
            this.inputstream.read(byArray, 0, this.TS_BufferSize);
            this.count += (long)n;
            return bl ^ true;
        }
        catch (IOException iOException) {
            Common.setExceptionMessage(iOException);
            return bl;
        }
    }
}

