/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.StringTokenizer;

public final class FileUtil {
    public static final String EXT_PORTFOLIO = ".lst";
    public static final String EXT_POPUP = ".pop";
    public static final String EXT_CONFIG = ".cfg";
    public static final String EXT_INDIZES = ".ind";
    public static final String EXT_XCHGRATE = ".xch";
    private static final String pathsep;
    private static final String filesep;
    private static final String userDir;
    private static String lastFindPath;
    private static String homeDir;
    private static String moduleDir;

    static {
        String string;
        pathsep = System.getProperty("path.separator");
        filesep = System.getProperty("file.separator");
        userDir = String.valueOf(System.getProperty("user.dir")) + filesep;
        lastFindPath = "";
        homeDir = "";
        moduleDir = null;
        String string2 = String.valueOf(FileUtil.getWorkingDirectory()) + "Einstellungen";
        if (new File(string2).exists()) {
            homeDir = String.valueOf(string2) + filesep;
        } else {
            homeDir = String.valueOf(System.getProperty("user.home")) + filesep;
            if (SysUtil.isMacOSX()) {
                string = String.valueOf(homeDir) + "Library" + filesep + "Preferences" + filesep;
                String string3 = String.valueOf(homeDir) + FileUtil.getDefaultUnixFilename();
                String string4 = String.valueOf(string) + FileUtil.getDefaultFilename();
                new File(string3).renameTo(new File(string4));
                new File(String.valueOf(string3) + EXT_PORTFOLIO).renameTo(new File(String.valueOf(string4) + EXT_PORTFOLIO));
                new File(String.valueOf(string3) + EXT_POPUP).renameTo(new File(String.valueOf(string4) + EXT_POPUP));
                new File(String.valueOf(string3) + EXT_CONFIG).renameTo(new File(String.valueOf(string4) + EXT_CONFIG));
                new File(String.valueOf(string3) + EXT_INDIZES).renameTo(new File(String.valueOf(string4) + EXT_INDIZES));
                homeDir = string;
            }
        }
        string = String.valueOf(FileUtil.getWorkingDirectory()) + "Module";
        if (new File(string).exists()) {
            moduleDir = String.valueOf(string) + filesep;
        }
    }

    private FileUtil() {
    }

    private static String getHomeDirectory() {
        return homeDir;
    }

    public static String getWorkingDirectory() {
        return userDir;
    }

    public static String getModuleDirectory() {
        return moduleDir;
    }

    private static String getDefaultFile() {
        return String.valueOf(FileUtil.getHomeDirectory()) + (SysUtil.isAUnix() ? FileUtil.getDefaultUnixFilename() : FileUtil.getDefaultFilename());
    }

    private static String getDefaultUnixFilename() {
        return "." + FileUtil.getDefaultFilename().toLowerCase();
    }

    private static String getDefaultFilename() {
        return "AktienMan";
    }

    public static String getAMDirectory(boolean bl) {
        String string = FileUtil.getDefaultFile();
        if (bl) {
            string = String.valueOf(string) + filesep;
        }
        return string;
    }

    public static void createAMDirectory() {
        File file = new File(FileUtil.getAMDirectory(false));
        if (!file.exists()) {
            file.mkdir();
        }
    }

    public static String getConfigFile() {
        return String.valueOf(FileUtil.getDefaultFile()) + EXT_CONFIG;
    }

    public static String getExchangeRateFile() {
        return String.valueOf(FileUtil.getDefaultFile()) + EXT_XCHGRATE;
    }

    public static String getIndexFile() {
        return String.valueOf(FileUtil.getDefaultFile()) + EXT_INDIZES;
    }

    public static String getPopupFile() {
        return String.valueOf(FileUtil.getDefaultFile()) + EXT_POPUP;
    }

    public static String getDefaultPortfolioFile() {
        return String.valueOf(FileUtil.getDefaultFile()) + EXT_PORTFOLIO;
    }

    public static String findLocalFile(String string) {
        Object object;
        if (lastFindPath.length() > 0 && ((File)(object = new File(String.valueOf(lastFindPath) + string))).exists()) {
            return String.valueOf(lastFindPath) + string;
        }
        object = new StringTokenizer(System.getProperty("java.class.path"), pathsep);
        while (((StringTokenizer)object).hasMoreTokens()) {
            File file;
            String string2 = ((StringTokenizer)object).nextToken();
            if (string2.endsWith(".zip") || string2.endsWith(".jar")) continue;
            if (!string2.endsWith(filesep)) {
                string2 = String.valueOf(string2) + filesep;
            }
            if ((file = new File(String.valueOf(string2) + string)).length() <= 0L) continue;
            lastFindPath = string2;
            return String.valueOf(lastFindPath) + string;
        }
        return string;
    }
}

