/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public final class IndexCanvas
extends Component {
    private static final String TITEL = ": ";
    private static final long EQUAL = 10L;
    private static final long UPDOWN = 100L;
    private static final long HIGHLOW = 200L;
    private FontMetrics metrics = null;
    private String title;
    private String datum;
    private String nummax;
    private String[] titlemax;
    private long punkte;
    private long vortag;
    private int symidx;

    public IndexCanvas(String string, int n) {
        this(string, n, new String[]{string}, "9,99");
    }

    public IndexCanvas(String string, int n, String[] stringArray, String string2) {
        this(string, n, stringArray, string2, 0L, 0L, "");
    }

    public IndexCanvas(String string, int n, String[] stringArray, String string2, long l, long l2, String string3) {
        this.title = string;
        this.symidx = n;
        this.nummax = string2;
        this.titlemax = stringArray;
        this.setValues(l, l2, string3);
    }

    public int getIndex() {
        return this.symidx;
    }

    public synchronized void setValues(long l, long l2, String string) {
        this.punkte = l;
        this.vortag = l2;
        this.datum = string.trim();
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private String getTitle() {
        return String.valueOf(this.title) + TITEL;
    }

    private synchronized String getDatum() {
        return " (" + this.datum + ") ";
    }

    private synchronized long getProz() {
        long l = 0L;
        if (this.vortag > 0L && this.punkte > 0L) {
            l = 100000L * this.punkte / this.vortag - 100000L;
            if (l > 0L) {
                l += 5L;
            } else if (l < 0L) {
                l -= 5L;
            }
            l /= 10L;
        }
        return l;
    }

    private synchronized String getDiff() {
        if (this.vortag > 0L && this.punkte > 0L) {
            long l = this.punkte - this.vortag;
            String string = String.valueOf(l < 0L ? " " : " +") + NumUtil.get00String(l);
            long l2 = this.getProz();
            return String.valueOf(string) + (l2 < 0L ? " " : " +") + NumUtil.get00String(l2) + "%";
        }
        return "";
    }

    private synchronized int getWidth() {
        this.checkMetrics();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.titlemax.length) {
            int n4;
            if (this.titlemax[n3] != null && (n4 = this.metrics.stringWidth(String.valueOf(this.titlemax[n3]) + TITEL)) > n2) {
                n2 = n4;
            }
            ++n3;
        }
        n += n2;
        String string = this.punkte > 0L ? NumUtil.get00String(this.punkte) : "n/a";
        int n5 = this.metrics.stringWidth(string);
        n2 = this.metrics.stringWidth(this.nummax) - n5;
        if (n2 > 0) {
            n += n2;
        }
        return n + n5 + this.metrics.stringWidth(this.getDatum()) + 10 + this.metrics.stringWidth(this.getDiff());
    }

    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        this.checkMetrics();
        int n = 0;
        int n2 = this.metrics.getAscent();
        int n3 = n2 + this.metrics.getDescent() - 10;
        graphics.setColor(Color.black);
        graphics.drawString(this.getTitle(), n, n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.titlemax.length) {
            int n6;
            if (this.titlemax[n5] != null && (n6 = this.metrics.stringWidth(String.valueOf(this.titlemax[n5]) + TITEL)) > n4) {
                n4 = n6;
            }
            ++n5;
        }
        n += n4;
        String string = this.punkte > 0L ? NumUtil.get00String(this.punkte) : "n/a";
        int n7 = this.metrics.stringWidth(string);
        n4 = this.metrics.stringWidth(this.nummax) - n7;
        if (n4 > 0) {
            n += n4;
        }
        graphics.drawString(string, n, n2);
        String string2 = this.getDatum();
        graphics.drawString(string2, n += n7, n2);
        n += this.metrics.stringWidth(string2);
        long l = this.getProz();
        if (l >= 100L) {
            graphics.drawImage(Images.ARROW_HI, n, n3, this);
        } else if (l >= 10L) {
            graphics.drawImage(Images.ARROW_UP, n, n3, this);
        } else if (l <= -100L) {
            graphics.drawImage(Images.ARROW_LO, n, n3, this);
        } else if (l <= -10L) {
            graphics.drawImage(Images.ARROW_DOWN, n, n3, this);
        } else {
            graphics.drawImage(Images.ARROW_EQUAL, n, n3, this);
        }
        n += 10;
        String string3 = this.getDiff();
        if (l >= 200L) {
            graphics.setColor(Color.green.darker());
        } else if (l <= -200L) {
            graphics.setColor(Color.red);
        }
        graphics.drawString(string3, n, n2);
    }

    public Dimension getPreferredSize() {
        this.checkMetrics();
        return new Dimension(this.getWidth(), this.metrics.getHeight());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    private void checkMetrics() {
        if (this.metrics == null) {
            Font font = this.getFont();
            if (font == null) {
                font = new Font("Dialog", 0, 10);
                this.setFont(font);
            }
            this.metrics = this.getFontMetrics(font);
        }
    }
}

