/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.fontchooser;

import java.awt.Font;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jhotdraw.gui.fontchooser.FontFamilyNode;

public class FontFaceNode
implements MutableTreeNode,
Comparable<FontFaceNode>,
Cloneable {
    private FontFamilyNode parent;
    private Font typeface;
    private String name;

    public FontFaceNode(Font typeface) {
        this.typeface = typeface;
        this.name = this.beautifyName(typeface.getPSName());
    }

    protected String beautifyName(String name) {
        String lcName;
        int p = name.lastIndexOf(45);
        if (p != -1) {
            lcName = (name = name.substring(p + 1)).toLowerCase();
            if (lcName.equals("plain")) {
                name = "Plain";
            } else if (lcName.equals("bolditalic")) {
                name = "Bold Italic";
            } else if (lcName.equals("italic")) {
                name = "Italic";
            } else if (lcName.equals("bold")) {
                name = "Bold";
            }
        } else {
            lcName = name.toLowerCase();
            name = lcName.endsWith("plain") ? "Plain" : (lcName.endsWith("boldoblique") ? "Bold Oblique" : (lcName.endsWith("bolditalic") ? "Bold Italic" : (lcName.endsWith("bookita") ? "Book Italic" : (lcName.endsWith("bookit") ? "Book Italic" : (lcName.endsWith("demibold") ? "Demi Bold" : (lcName.endsWith("semiita") ? "Semi Italic" : (lcName.endsWith("italic") ? "Italic" : (lcName.endsWith("book") ? "Book" : (lcName.endsWith("bold") ? "Bold" : (lcName.endsWith("bol") ? "Bold" : (lcName.endsWith("oblique") ? "Oblique" : (lcName.endsWith("regular") ? "Regular" : (lcName.endsWith("semi") ? "Semi" : "Plain")))))))))))));
        }
        StringBuilder buf = new StringBuilder();
        char prev = name.charAt(0);
        buf.append(prev);
        for (int i = 1; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (prev != ' ' && prev != '-' && Character.isUpperCase(ch) && !Character.isUpperCase(prev) || Character.isDigit(ch) && !Character.isDigit(prev)) {
                buf.append(' ');
            }
            buf.append(ch);
            prev = ch;
        }
        name = buf.toString();
        return name;
    }

    public void setName(String newValue) {
        this.name = newValue;
    }

    public String getName() {
        return this.name;
    }

    public Font getFont() {
        return this.typeface;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void remove(int index) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void remove(MutableTreeNode node) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void setUserObject(Object object) {
        throw new UnsupportedOperationException("Not allowed.");
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    @Override
    public void setParent(MutableTreeNode newParent) {
        this.parent = (FontFamilyNode)newParent;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        throw new IndexOutOfBoundsException("" + childIndex);
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    @Override
    public int compareTo(FontFaceNode that) {
        return this.name.compareTo(that.name);
    }

    public FontFaceNode clone() {
        FontFaceNode that;
        try {
            that = (FontFaceNode)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError("Clone failed");
            error.initCause(ex);
            throw error;
        }
        that.parent = null;
        return that;
    }

    public boolean isEditable() {
        return false;
    }
}

