/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.SliderUI;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.SelectionComponentRepainter;
import org.jhotdraw.gui.FigureAttributeEditorHandler;
import org.jhotdraw.gui.JAttributeSlider;
import org.jhotdraw.gui.JAttributeTextField;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.gui.plaf.palette.PaletteButtonUI;
import org.jhotdraw.gui.plaf.palette.PaletteFormattedTextFieldUI;
import org.jhotdraw.gui.plaf.palette.PaletteSliderUI;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.gui.AbstractToolBar;
import org.jhotdraw.samples.svg.gui.SelectionComponentDisplayer;
import org.jhotdraw.samples.svg.gui.SelectionOpacityIcon;
import org.jhotdraw.text.JavaNumberFormatter;
import org.jhotdraw.util.ResourceBundleUtil;

public class FigureToolBar
extends AbstractToolBar {
    private SelectionComponentDisplayer displayer;
    private ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.svg.Labels");

    public FigureToolBar() {
        this.setName(this.labels.getString(this.getID() + ".toolbar"));
        this.setDisclosureStateCount(3);
    }

    @Override
    public void setEditor(DrawingEditor newValue) {
        DrawingEditor oldValue = this.getEditor();
        if (this.displayer != null) {
            this.displayer.dispose();
            this.displayer = null;
        }
        super.setEditor(newValue);
        if (newValue != null) {
            this.displayer = new SelectionComponentDisplayer(this.editor, this);
        }
    }

    @Override
    protected JComponent createDisclosedComponent(int state) {
        JPanel p = null;
        switch (state) {
            case 1: {
                p = new JPanel();
                p.setOpaque(false);
                p.setLayout(new GridBagLayout());
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacityPopupButton.add(opacitySlider);
                this.labels.configureToolBarButton(opacityPopupButton, "attribute.figureOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, this.getClass().getResource(this.labels.getString("attribute.figureOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                opacityPopupButton.setPopupAnchor(4);
                new SelectionComponentRepainter(this.editor, opacityPopupButton);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.weighty = 1.0;
                gbc.anchor = 23;
                p.add((Component)opacityPopupButton, gbc);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, opacitySlider, this.editor);
                break;
            }
            case 2: {
                p = new JPanel();
                p.setOpaque(false);
                p.setLayout(new GridBagLayout());
                p.setBorder(new EmptyBorder(5, 5, 5, 8));
                JAttributeTextField opacityField = new JAttributeTextField();
                opacityField.setColumns(3);
                opacityField.setToolTipText(this.labels.getString("attribute.figureOpacity.toolTipText"));
                opacityField.setHorizontalAlignment(4);
                opacityField.putClientProperty("Palette.Component.segmentPosition", "first");
                opacityField.setUI((PaletteFormattedTextFieldUI)PaletteFormattedTextFieldUI.createUI(opacityField));
                opacityField.setFormatterFactory(JavaNumberFormatter.createFormatterFactory(0.0, 1.0, 100.0));
                opacityField.setHorizontalAlignment(10);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, opacityField, this.editor);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 1;
                gbc.gridy = 0;
                gbc.insets = new Insets(0, 0, 0, 0);
                gbc.anchor = 23;
                gbc.weightx = 1.0;
                p.add(opacityField, gbc);
                JPopupButton opacityPopupButton = new JPopupButton();
                JAttributeSlider opacitySlider = new JAttributeSlider(1, 0, 100, 100);
                opacityPopupButton.add(opacitySlider);
                this.labels.configureToolBarButton(opacityPopupButton, "attribute.figureOpacity");
                opacityPopupButton.setUI((PaletteButtonUI)PaletteButtonUI.createUI(opacityPopupButton));
                opacityPopupButton.setIcon(new SelectionOpacityIcon(this.editor, SVGAttributeKeys.OPACITY, (AttributeKey<Color>)SVGAttributeKeys.FILL_COLOR, (AttributeKey<Color>)SVGAttributeKeys.STROKE_COLOR, this.getClass().getResource(this.labels.getString("attribute.figureOpacity.icon")), (Shape)new Rectangle(5, 5, 6, 6), (Shape)new Rectangle(4, 4, 7, 7)));
                opacityPopupButton.setPopupAnchor(4);
                new SelectionComponentRepainter(this.editor, opacityPopupButton);
                gbc = new GridBagConstraints();
                gbc.gridx = 2;
                gbc.gridy = 0;
                gbc.anchor = 23;
                gbc.weighty = 1.0;
                gbc.insets = new Insets(0, 0, 0, 0);
                p.add((Component)opacityPopupButton, gbc);
                opacitySlider.setUI((SliderUI)PaletteSliderUI.createUI(opacitySlider));
                opacitySlider.setScaleFactor(100.0);
                new FigureAttributeEditorHandler<Double>(SVGAttributeKeys.OPACITY, opacitySlider, this.editor);
            }
        }
        return p;
    }

    @Override
    protected String getID() {
        return "figure";
    }

    private void initComponents() {
    }
}

