/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.YahooStockFormat;
import org.yccheok.jstock.gui.Utils;

public abstract class AbstractYahooStockServer
implements StockServer {
    private static final int MAX_STOCK_PER_ITERATION = 180;
    private static final int NUM_OF_RETRY = 2;
    private static final String YAHOO_STOCK_FORMAT = "&f=snxspsosl1shsgsvsc1sp2sk3sb3sb6sb2sa5sd1t1";

    protected abstract String getYahooCSVBasedURL();

    private boolean isToleranceAllowed(int currSize, int expectedSize) {
        if (currSize >= expectedSize) {
            return true;
        }
        if (expectedSize <= 0) {
            return true;
        }
        return currSize > 0;
    }

    @Override
    public List<Stock> getStocks(List<Code> codes) throws StockNotFoundException {
        return this._getStocks(codes);
    }

    @Override
    public Stock getStock(Code code) throws StockNotFoundException {
        return this._getStock(code);
    }

    private List<Stock> _getStocks(List<Code> codes) throws StockNotFoundException {
        String codeString;
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        if (codes.isEmpty()) {
            return stocks;
        }
        int time = codes.size() / 180;
        int remainder = codes.size() % 180;
        for (int i = 0; i < time; ++i) {
            int start = i * 180;
            int end = start + 180;
            StringBuilder stringBuilder = new StringBuilder(this.getYahooCSVBasedURL());
            StringBuilder codeBuilder = new StringBuilder();
            ArrayList<Code> expectedCodes = new ArrayList<Code>();
            int endLoop = end - 1;
            for (int j = start; j < endLoop; ++j) {
                String codeString2 = null;
                try {
                    codeString2 = URLEncoder.encode(codes.get(j).toString(), "UTF-8");
                }
                catch (UnsupportedEncodingException ex) {
                    throw new StockNotFoundException(null, ex);
                }
                codeBuilder.append(codeString2).append("+");
                expectedCodes.add(codes.get(j));
            }
            codeString = null;
            try {
                codeString = URLEncoder.encode(codes.get(end - 1).toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new StockNotFoundException(null, ex);
            }
            codeBuilder.append(codeString);
            expectedCodes.add(codes.get(end - 1));
            String _code = codeBuilder.toString();
            stringBuilder.append(_code).append(YAHOO_STOCK_FORMAT);
            String location = stringBuilder.toString();
            boolean success = false;
            for (int retry = 0; retry < 2; ++retry) {
                String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
                if (respond == null) continue;
                List<Stock> tmpStocks = YahooStockFormat.getInstance().parse(respond);
                if (tmpStocks.size() != 180) {
                    int expectedSize;
                    if (retry != 1) continue;
                    assert (expectedCodes.size() == 180);
                    int currSize = tmpStocks.size();
                    if (this.isToleranceAllowed(currSize, expectedSize = expectedCodes.size())) {
                        HashSet<Code> currCodes = new HashSet<Code>();
                        ArrayList<Stock> emptyStocks = new ArrayList<Stock>();
                        for (Stock stock : tmpStocks) {
                            currCodes.add(stock.code);
                        }
                        for (Code code : expectedCodes) {
                            if (currCodes.contains(code)) continue;
                            emptyStocks.add(Utils.getEmptyStock(code, Symbol.newInstance(code.toString())));
                        }
                        tmpStocks.addAll(emptyStocks);
                    } else {
                        throw new StockNotFoundException("Expect " + expectedSize + " stock(s), but only receive " + currSize + " stock(s) from " + location);
                    }
                }
                stocks.addAll(tmpStocks);
                success = true;
                break;
            }
            if (success) continue;
            throw new StockNotFoundException("Stock size (" + stocks.size() + ") inconsistent with code size (" + codes.size() + ")");
        }
        int start = codes.size() - remainder;
        int end = start + remainder;
        StringBuilder stringBuilder = new StringBuilder(this.getYahooCSVBasedURL());
        StringBuilder codeBuilder = new StringBuilder();
        ArrayList<Code> expectedCodes = new ArrayList<Code>();
        int endLoop = end - 1;
        for (int i = start; i < endLoop; ++i) {
            codeString = null;
            try {
                codeString = URLEncoder.encode(codes.get(i).toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new StockNotFoundException("", ex);
            }
            codeBuilder.append(codeString).append("+");
            expectedCodes.add(codes.get(i));
        }
        String codeString3 = null;
        try {
            codeString3 = URLEncoder.encode(codes.get(end - 1).toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new StockNotFoundException("", ex);
        }
        codeBuilder.append(codeString3);
        expectedCodes.add(codes.get(end - 1));
        String _code = codeBuilder.toString();
        stringBuilder.append(_code).append(YAHOO_STOCK_FORMAT);
        String location = stringBuilder.toString();
        for (int retry = 0; retry < 2; ++retry) {
            String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
            if (respond == null) continue;
            List<Stock> tmpStocks = YahooStockFormat.getInstance().parse(respond);
            if (tmpStocks.size() != remainder) {
                int expectedSize;
                if (retry != 1) continue;
                int currSize = tmpStocks.size();
                if (this.isToleranceAllowed(currSize, expectedSize = expectedCodes.size())) {
                    HashSet<Code> currCodes = new HashSet<Code>();
                    ArrayList<Stock> emptyStocks = new ArrayList<Stock>();
                    for (Stock stock : tmpStocks) {
                        currCodes.add(stock.code);
                    }
                    for (Code code : expectedCodes) {
                        if (currCodes.contains(code)) continue;
                        emptyStocks.add(Utils.getEmptyStock(code, Symbol.newInstance(code.toString())));
                    }
                    tmpStocks.addAll(emptyStocks);
                } else {
                    throw new StockNotFoundException("Expect " + expectedSize + " stock(s), but only receive " + currSize + " stock(s) from " + location);
                }
            }
            stocks.addAll(tmpStocks);
            break;
        }
        if (stocks.size() != codes.size()) {
            throw new StockNotFoundException("Stock size (" + stocks.size() + ") inconsistent with code size (" + codes.size() + ")");
        }
        return stocks;
    }

    private Stock _getStock(Code code) throws StockNotFoundException {
        String _code;
        StringBuilder stringBuilder = new StringBuilder(this.getYahooCSVBasedURL());
        try {
            _code = URLEncoder.encode(code.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new StockNotFoundException(code.toString(), ex);
        }
        stringBuilder.append(_code).append(YAHOO_STOCK_FORMAT);
        String location = stringBuilder.toString();
        for (int retry = 0; retry < 2; ++retry) {
            String respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location);
            if (respond == null) continue;
            List<Stock> stocks = YahooStockFormat.getInstance().parse(respond);
            if (stocks.size() != 1) break;
            return stocks.get(0);
        }
        throw new StockNotFoundException(code.toString());
    }
}

