/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.Subject;

public class RealTimeStockMonitor
extends Subject<RealTimeStockMonitor, List<Stock>> {
    private volatile long delay;
    private static final long MIN_DELAY = 5000L;
    private static final long MIN_DELAY_COUNTER = 3L;
    private final int maxThread;
    private final int maxStockSizePerScan;
    private List<StockServerFactory> stockServerFactories;
    private final List<Code> stockCodes;
    private final HashMap<Code, Integer> rowStockCodeMapping;
    private final List<StockMonitor> stockMonitors;
    private final ReadWriteLock stockCodesReadWriteLock;
    private final Lock stockCodesReaderLock;
    private final Lock stockCodesWriterLock;
    private static final Log log = LogFactory.getLog(RealTimeStockMonitor.class);

    public RealTimeStockMonitor(int maxThread, int maxStockSizePerScan, long delay) {
        if (maxThread <= 0 || maxStockSizePerScan <= 0 || delay <= 0L) {
            throw new IllegalArgumentException("maxThread : " + maxThread + ", maxStockSizePerScan : " + maxStockSizePerScan + ", delay : " + delay);
        }
        this.maxThread = maxThread;
        this.maxStockSizePerScan = maxStockSizePerScan;
        this.delay = delay;
        this.stockServerFactories = new CopyOnWriteArrayList<StockServerFactory>();
        this.stockCodes = new CopyOnWriteArrayList<Code>();
        this.rowStockCodeMapping = new HashMap();
        this.stockMonitors = new ArrayList<StockMonitor>();
        this.stockCodesReadWriteLock = new ReentrantReadWriteLock();
        this.stockCodesReaderLock = this.stockCodesReadWriteLock.readLock();
        this.stockCodesWriterLock = this.stockCodesReadWriteLock.writeLock();
    }

    public synchronized void setStockServerFactories(List<StockServerFactory> factories) {
        this.stockServerFactories = factories;
    }

    public synchronized boolean addStockCode(Code code) {
        if (this.rowStockCodeMapping.containsKey(code)) {
            return false;
        }
        boolean status = this.stockCodes.add(code);
        this.rowStockCodeMapping.put(code, this.stockCodes.size() - 1);
        return status;
    }

    public synchronized boolean isEmpty() {
        return this.stockCodes.isEmpty();
    }

    public synchronized int getNumOfStockCode() {
        return this.stockCodes.size();
    }

    public synchronized Code getStockCode(int index) {
        return this.stockCodes.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean clearStockCodes() {
        this.stockCodesWriterLock.lock();
        try {
            this.stockCodes.clear();
            this.rowStockCodeMapping.clear();
        }
        finally {
            this.stockCodesWriterLock.unlock();
        }
        while (this.stockMonitors.size() > 0) {
            StockMonitor stockMonitor = this.stockMonitors.remove(this.stockMonitors.size() - 1);
            stockMonitor._stop();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean removeStockCode(Code code) {
        this.stockCodesWriterLock.lock();
        boolean status = false;
        try {
            Integer row = this.rowStockCodeMapping.get(code);
            if (row == null) {
                boolean bl = status;
                return bl;
            }
            status = null != this.stockCodes.remove(row);
            this.rowStockCodeMapping.remove(code);
            int ei = this.stockCodes.size();
            for (int i = row.intValue(); i < ei; ++i) {
                this.rowStockCodeMapping.put(this.stockCodes.get(i), i);
            }
        }
        finally {
            this.stockCodesWriterLock.unlock();
        }
        int numOfMonitorRequired = this.getNumOfRequiredThread();
        if (this.stockMonitors.size() > numOfMonitorRequired) {
            log.info((Object)("After removing : current thread size=" + this.stockMonitors.size() + ",numOfMonitorRequired=" + numOfMonitorRequired));
            StockMonitor stockMonitor = this.stockMonitors.remove(this.stockMonitors.size() - 1);
            stockMonitor._stop();
            log.info((Object)("After removing : current thread size=" + this.stockMonitors.size() + ",numOfMonitorRequired=" + numOfMonitorRequired));
        }
        return status;
    }

    public synchronized void resume() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor._resume();
        }
    }

    public synchronized void suspend() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor._suspend();
        }
    }

    public synchronized void startNewThreadsIfNecessary() {
        int numOfMonitorRequired = this.getNumOfRequiredThread();
        assert (numOfMonitorRequired <= this.maxThread);
        for (int i = this.stockMonitors.size(); i < numOfMonitorRequired; ++i) {
            log.info((Object)("Before adding : current thread size=" + this.stockMonitors.size() + ",numOfMonitorRequired=" + numOfMonitorRequired));
            StockMonitor stockMonitor = new StockMonitor(i * this.maxStockSizePerScan);
            this.stockMonitors.add(stockMonitor);
            stockMonitor.start();
            log.info((Object)("After adding : current thread size=" + this.stockMonitors.size() + ",numOfMonitorRequired=" + numOfMonitorRequired));
        }
    }

    public synchronized void stop() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor._stop();
            try {
                stockMonitor.join();
            }
            catch (InterruptedException exp) {
                log.error(null, (Throwable)exp);
            }
        }
        this.stockMonitors.clear();
    }

    public synchronized void refresh() {
        for (StockMonitor stockMonitor : this.stockMonitors) {
            stockMonitor.refresh();
        }
    }

    public synchronized long getDelay() {
        return this.delay;
    }

    public synchronized void setDelay(int delay) {
        this.delay = delay;
    }

    private int getNumOfRequiredThread() {
        int numOfThreadRequired = this.stockCodes.size() / this.maxStockSizePerScan + (this.stockCodes.size() % this.maxStockSizePerScan == 0 ? 0 : 1);
        return Math.min(numOfThreadRequired, this.maxThread);
    }

    public int getTotalScanned() {
        int totalScanned = 0;
        for (StockMonitor stockMonitor : this.stockMonitors) {
            totalScanned += stockMonitor.getTotalScanned();
        }
        return totalScanned;
    }

    private class StockMonitor
    extends Thread {
        private boolean suspend = false;
        private volatile boolean isRefresh = false;
        private volatile int minDelayCounter = 0;
        private volatile int totalScanned = 0;
        private final int index;
        private volatile Thread thread;

        public StockMonitor(int index) {
            this.index = index;
            this.thread = this;
        }

        private synchronized void _wait() throws InterruptedException {
            while (this.suspend) {
                this.wait();
            }
        }

        public synchronized void _resume() {
            this.suspend = false;
            this.notify();
        }

        public synchronized void _suspend() {
            this.suspend = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thisThread = Thread.currentThread();
            int step = RealTimeStockMonitor.this.maxStockSizePerScan * RealTimeStockMonitor.this.maxThread;
            block11: while (thisThread == this.thread) {
                block12: while (true) {
                    try {
                        while (thisThread == this.thread) {
                            block21: {
                                try {
                                    this._wait();
                                }
                                catch (InterruptedException exp) {
                                    log.error(null, (Throwable)exp);
                                    if (this.isRefresh) break block21;
                                    this.thread = null;
                                    continue block11;
                                }
                            }
                            int pass = 0;
                            int fail = 0;
                            int currIndex = this.index;
                            while (thisThread == this.thread) {
                                ListIterator listIterator = null;
                                RealTimeStockMonitor.this.stockCodesReaderLock.lock();
                                try {
                                    int stockCodesSize = RealTimeStockMonitor.this.stockCodes.size();
                                    if (currIndex < stockCodesSize) {
                                        listIterator = RealTimeStockMonitor.this.stockCodes.listIterator(currIndex);
                                    }
                                }
                                finally {
                                    RealTimeStockMonitor.this.stockCodesReaderLock.unlock();
                                }
                                if (listIterator == null) break;
                                ArrayList<Code> codes = new ArrayList<Code>();
                                for (int i = 0; listIterator.hasNext() && i < RealTimeStockMonitor.this.maxStockSizePerScan && thisThread == this.thread; ++i) {
                                    codes.add((Code)listIterator.next());
                                }
                                int size = codes.size();
                                fail += size;
                                for (StockServerFactory factory : RealTimeStockMonitor.this.stockServerFactories) {
                                    StockServer stockServer = factory.getStockServer();
                                    if (stockServer == null) continue;
                                    List<Stock> stocks = null;
                                    try {
                                        stocks = stockServer.getStocks(codes);
                                    }
                                    catch (StockNotFoundException exp) {
                                        if (thisThread != this.thread) break;
                                        log.error(codes, (Throwable)exp);
                                        continue;
                                    }
                                    if (thisThread != this.thread) break;
                                    this.totalScanned = (pass += size) + (fail -= size);
                                    RealTimeStockMonitor.this.notify(RealTimeStockMonitor.this, stocks);
                                    break;
                                }
                                currIndex += step;
                            }
                            this.totalScanned = pass + fail;
                            try {
                                if (fail == 0) {
                                    Thread.sleep(RealTimeStockMonitor.this.delay);
                                    continue block12;
                                }
                                if ((long)this.minDelayCounter < 3L) {
                                    ++this.minDelayCounter;
                                    Thread.sleep(5000L);
                                    continue block12;
                                }
                                Thread.sleep(RealTimeStockMonitor.this.delay);
                                continue block12;
                            }
                            catch (InterruptedException exp) {
                                log.error((Object)("index=" + this.index), (Throwable)exp);
                                if (!this.isRefresh) {
                                    this.thread = null;
                                    continue block11;
                                }
                                this.isRefresh = false;
                            }
                        }
                        continue block11;
                    }
                    catch (Exception exp) {
                        log.error((Object)"Our thread just recover from unexpected error", (Throwable)exp);
                        continue block11;
                    }
                }
            }
        }

        public synchronized void refresh() {
            if (this.suspend) {
                return;
            }
            this.isRefresh = true;
            this.minDelayCounter = 0;
            this.totalScanned = 0;
            this.interrupt();
        }

        public void _stop() {
            this.thread = null;
            this.interrupt();
        }

        public int getTotalScanned() {
            return this.totalScanned;
        }
    }
}

