/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.DividendServer;
import org.yccheok.jstock.engine.Duration;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.portfolio.Dividend;

public class YahooDividendServer
implements DividendServer {
    private static final int NUM_OF_RETRY = 2;
    private static final Log log = LogFactory.getLog(YahooDividendServer.class);

    @Override
    public List<Dividend> getDividends(Code code, Duration duration) {
        StringBuilder stringBuilder = new StringBuilder("http://ichart.finance.yahoo.com/table.csv?s=");
        try {
            String codeString = URLEncoder.encode(code.toString(), "UTF-8");
            stringBuilder.append(codeString);
        }
        catch (UnsupportedEncodingException ex) {
            log.error(null, (Throwable)ex);
            return Collections.emptyList();
        }
        SimpleDate startDate = duration.getStartDate();
        stringBuilder.append("&a=").append(startDate.getMonth());
        stringBuilder.append("&b=").append(startDate.getDate());
        stringBuilder.append("&c=").append(startDate.getYear());
        SimpleDate endDate = duration.getEndDate();
        stringBuilder.append("&d=").append(endDate.getMonth());
        stringBuilder.append("&e=").append(endDate.getDate());
        stringBuilder.append("&f=").append(endDate.getYear());
        stringBuilder.append("&g=v&ignore=.csv");
        String location = stringBuilder.toString();
        String respond = null;
        for (int retry = 0; retry < 2 && (respond = Utils.getResponseBodyAsStringBasedOnProxyAuthOption(location)) == null; ++retry) {
        }
        if (respond == null) {
            return Collections.emptyList();
        }
        String[] stockDatas = respond.split("\r\n|\r|\n");
        int length = stockDatas.length;
        ArrayList<Dividend> dividends = new ArrayList<Dividend>();
        for (int i = 1; i < length; ++i) {
            double amount;
            int date;
            int month;
            int year;
            String[] dates;
            String[] fields = stockDatas[i].split(",");
            if (fields.length != 2 || (dates = fields[0].split("-")).length != 3) continue;
            try {
                year = Integer.parseInt(dates[0]);
                month = Integer.parseInt(dates[1]) - 1;
                date = Integer.parseInt(dates[2]);
                amount = Double.parseDouble(fields[1]);
            }
            catch (NumberFormatException ex) {
                log.error(null, (Throwable)ex);
                continue;
            }
            SimpleDate simpleDate = new SimpleDate(year, month, date);
            if (!duration.isContains(simpleDate)) continue;
            Dividend dividend = new Dividend(StockInfo.newInstance(code, Symbol.newInstance(code.toString())), amount, simpleDate);
            dividends.add(dividend);
        }
        return dividends;
    }
}

