/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.engine;

import au.com.bytecode.opencsv.CSVParser;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockFormat;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.engine.Utils;

public class YahooStockFormat
implements StockFormat {
    private static long now = 0L;
    private static final StockFormat stockFormat = new YahooStockFormat();
    private static final Pattern commaNotBetweenQuotes = Pattern.compile("(?<!\"),(?!\")");
    private static final Pattern quotePattern = Pattern.compile("\"");
    private static final Pattern percentagePattern = Pattern.compile("%");
    private static final Log log = LogFactory.getLog(YahooStockFormat.class);

    private YahooStockFormat() {
    }

    private boolean isCorruptedData(double price) {
        return price > 1048576.0 || price < 0.0;
    }

    private boolean isTooOldTimestamp(long timestamp) {
        if (timestamp == 0L) {
            return false;
        }
        if (now == 0L) {
            long localNow = org.yccheok.jstock.gui.Utils.getGoogleServerTimestamp();
            now = localNow != 0L ? localNow : System.currentTimeMillis();
        }
        return Utils.getDifferenceInDays(timestamp, now) > 13L;
    }

    @Override
    public List<Stock> parse(String source) {
        String[] strings;
        ArrayList<Stock> stocks = new ArrayList<Stock>();
        if (source == null) {
            return stocks;
        }
        for (String string : strings = source.split("\r\n|\r|\n")) {
            String[] fields;
            String stringDigitWithoutComma = commaNotBetweenQuotes.matcher(string).replaceAll("");
            CSVParser csvParser = new CSVParser();
            try {
                fields = csvParser.parseLine(stringDigitWithoutComma);
            }
            catch (IOException ex) {
                log.error(null, (Throwable)ex);
                continue;
            }
            int length = fields.length;
            Code code = null;
            Symbol symbol = null;
            String name = null;
            Stock.Board board = null;
            Stock.Industry industry = null;
            double prevPrice = 0.0;
            double openPrice = 0.0;
            double lastPrice = 0.0;
            double highPrice = 0.0;
            double lowPrice = 0.0;
            long volume = 0L;
            double changePrice = 0.0;
            double changePricePercentage = 0.0;
            int lastVolume = 0;
            double buyPrice = 0.0;
            int buyQuantity = 0;
            double sellPrice = 0.0;
            int sellQuantity = 0;
            double secondBuyPrice = 0.0;
            int secondBuyQuantity = 0;
            double secondSellPrice = 0.0;
            int secondSellQuantity = 0;
            double thirdBuyPrice = 0.0;
            int thirdBuyQuantity = 0;
            double thirdSellPrice = 0.0;
            int thirdSellQuantity = 0;
            long timestamp = 0L;
            if (length >= 1) {
                code = Code.newInstance(quotePattern.matcher(fields[0]).replaceAll("").trim());
                if (length >= 2) {
                    name = quotePattern.matcher(fields[1]).replaceAll("").trim();
                    symbol = Symbol.newInstance(name.toString());
                    if (length >= 3) {
                        try {
                            board = Stock.Board.valueOf(quotePattern.matcher(fields[2]).replaceAll("").trim());
                        }
                        catch (IllegalArgumentException exp) {
                            board = Stock.Board.Unknown;
                        }
                        industry = Stock.Industry.Unknown;
                        if (length >= 5) {
                            try {
                                prevPrice = Double.parseDouble(fields[4]);
                            }
                            catch (NumberFormatException exp) {
                                // empty catch block
                            }
                            if (length >= 7) {
                                try {
                                    openPrice = Double.parseDouble(fields[6]);
                                }
                                catch (NumberFormatException exp) {
                                    // empty catch block
                                }
                                if (length >= 9) {
                                    try {
                                        lastPrice = Double.parseDouble(fields[8]);
                                    }
                                    catch (NumberFormatException exp) {
                                        // empty catch block
                                    }
                                    if (length >= 11) {
                                        try {
                                            highPrice = Double.parseDouble(fields[10]);
                                        }
                                        catch (NumberFormatException exp) {
                                            // empty catch block
                                        }
                                        if (length >= 13) {
                                            try {
                                                lowPrice = Double.parseDouble(fields[12]);
                                            }
                                            catch (NumberFormatException exp) {
                                                // empty catch block
                                            }
                                            if (length >= 15) {
                                                try {
                                                    volume = Long.parseLong(fields[14]);
                                                }
                                                catch (NumberFormatException exp) {
                                                    // empty catch block
                                                }
                                                if (length >= 17) {
                                                    try {
                                                        changePrice = Double.parseDouble(quotePattern.matcher(fields[16]).replaceAll("").trim());
                                                    }
                                                    catch (NumberFormatException exp) {
                                                        // empty catch block
                                                    }
                                                    if (length >= 19) {
                                                        String _changePricePercentage = quotePattern.matcher(fields[18]).replaceAll("");
                                                        _changePricePercentage = percentagePattern.matcher(_changePricePercentage).replaceAll("");
                                                        try {
                                                            changePricePercentage = Double.parseDouble(_changePricePercentage);
                                                        }
                                                        catch (NumberFormatException exp) {
                                                            // empty catch block
                                                        }
                                                        if (length >= 21) {
                                                            try {
                                                                lastVolume = Integer.parseInt(fields[20]);
                                                            }
                                                            catch (NumberFormatException exp) {
                                                                // empty catch block
                                                            }
                                                            if (length >= 23) {
                                                                try {
                                                                    buyPrice = Double.parseDouble(fields[22]);
                                                                }
                                                                catch (NumberFormatException exp) {
                                                                    // empty catch block
                                                                }
                                                                if (length >= 25) {
                                                                    try {
                                                                        buyQuantity = Integer.parseInt(fields[24]);
                                                                    }
                                                                    catch (NumberFormatException exp) {
                                                                        // empty catch block
                                                                    }
                                                                    if (length >= 27) {
                                                                        try {
                                                                            sellPrice = Double.parseDouble(fields[26]);
                                                                        }
                                                                        catch (NumberFormatException exp) {
                                                                            // empty catch block
                                                                        }
                                                                        if (length >= 29) {
                                                                            try {
                                                                                sellQuantity = Integer.parseInt(fields[28]);
                                                                            }
                                                                            catch (NumberFormatException exp) {
                                                                                // empty catch block
                                                                            }
                                                                            if (length >= 32) {
                                                                                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy hh:mmaa");
                                                                                String date_and_time = quotePattern.matcher(fields[30]).replaceAll("").trim() + " " + quotePattern.matcher(fields[31]).replaceAll("").trim();
                                                                                try {
                                                                                    Date serverDate = dateFormat.parse(date_and_time);
                                                                                    timestamp = serverDate.getTime();
                                                                                }
                                                                                catch (ParseException exp) {
                                                                                    // empty catch block
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (code == null || symbol == null || name == null || board == null || industry == null || this.isCorruptedData(lastPrice) || this.isTooOldTimestamp(timestamp) || length > 28 && fields[28].equalsIgnoreCase("N/A") && fields[26].equalsIgnoreCase("N/A") && org.yccheok.jstock.portfolio.Utils.essentiallyEqual(lastPrice, 0.0) && fields[24].equalsIgnoreCase("N/A") && fields[22].equalsIgnoreCase("N/A") && fields[20].equalsIgnoreCase("N/A") && fields[18].equalsIgnoreCase("N/A") && fields[16].equalsIgnoreCase("N/A") && fields[14].equalsIgnoreCase("N/A") && fields[12].equalsIgnoreCase("N/A") && fields[10].equalsIgnoreCase("N/A") && fields[6].equalsIgnoreCase("N/A") && fields[4].equalsIgnoreCase("N/A")) continue;
            if (timestamp == 0L) {
                timestamp = System.currentTimeMillis();
            }
            Stock stock = new Stock(code, symbol, name, board, industry, prevPrice, openPrice, lastPrice, highPrice, lowPrice, volume, changePrice, changePricePercentage, lastVolume, buyPrice, buyQuantity, sellPrice, sellQuantity, secondBuyPrice, secondBuyQuantity, secondSellPrice, secondSellQuantity, thirdBuyPrice, thirdBuyQuantity, thirdSellPrice, thirdSellQuantity, timestamp);
            stocks.add(stock);
        }
        return stocks;
    }

    public static StockFormat getInstance() {
        return stockFormat;
    }
}

