/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.portfolio.BrokingFirm;

public class JStockOptions {
    public static final Color DEFAULT_NORMAL_TEXT_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR = new Color(50, 150, 0);
    public static final Color DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR = new Color(200, 0, 50);
    public static final Color DEFAULT_FIRST_ROW_BACKGROUND_COLOR = Color.WHITE;
    public static final Color DEFAULT_SECOND_ROW_BACKGROUND_COLOR = new Color(255, 255, 204);
    public static final Color DEFAULT_AUTO_UPDATE_FOREGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_AUTO_UPDATE_BACKGROUND_COLOR = Color.RED;
    public static final Color DEFAULT_FALL_BELOW_ALERT_FOREGROUND_COLOR = Color.YELLOW;
    public static final Color DEFAULT_FALL_BELOW_ALERT_BACKGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_RISE_ABOVE_ALERT_FOREGROUND_COLOR = Color.YELLOW;
    public static final Color DEFAULT_RISE_ABOVE_ALERT_BACKGROUND_COLOR = Color.BLACK;
    public static final Color DEFAULT_CHAT_SYSTEM_MESSAGE_COLOR = Color.RED;
    public static final Color DEFAULT_CHAT_OWN_MESSAGE_COLOR = new Color(169, 169, 169);
    public static final Color DEFAULT_CHAT_OTHER_MESSAGE_COLOR = new Color(100, 149, 237);
    private static final YellowInformationBoxOption DEFAULT_YELLOW_INFORMATION_BOX_OPTION = YellowInformationBoxOption.Follow;
    private static final StockInputSuggestionListOption DEFAULT_STOCK_INPUT_SUGGESTION_LIST_OPTION = StockInputSuggestionListOption.TwoColumns;
    private static final int DEFAULT_HISTORY_DURATION = 10;
    private boolean soundEnabled = false;
    private boolean singleIndicatorAlert = true;
    private boolean popupMessage = true;
    private boolean sendEmail = false;
    private String email = "";
    private String emailPassword = "";
    private String CCEmail = "";
    private String googleCalendarUsername = "";
    private String googleCalendarPassword = "";
    private boolean SMSEnabled = false;
    @Deprecated
    private transient boolean passwordProtectedIndicator;
    @Deprecated
    private transient String indicatorPassword;
    private String proxyServer = "";
    private int proxyPort = -1;
    private int scanningSpeed = 10000;
    private int alertSpeed = 5;
    private String looknFeel = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private Color normalTextForegroundColor;
    private Color lowerNumericalValueForegroundColor;
    private Color higherNumericalValueForegroundColor;
    private Color firstRowBackgroundColor;
    private Color secondRowBackgroundColor;
    private Color autoUpdateForegroundColor;
    private Color autoUpdateBackgroundColor;
    @Deprecated
    private transient Color alertForegroundColor;
    @Deprecated
    private transient Color alertBackgroundColor;
    private Color fallBelowAlertForegroundColor;
    private Color fallBelowAlertBackgroundColor;
    private Color riseAboveAlertForegroundColor;
    private Color riseAboveAlertBackgroundColor;
    private boolean enableColorChange = false;
    private boolean enableColorAlert = false;
    private List<BrokingFirm> brokingFirms = new ArrayList<BrokingFirm>();
    private int selectedBrokingFirmIndex = -1;
    private boolean isAutoBrokerFeeCalculationEnabled = false;
    private double expectedProfitPercentage = 10.0;
    private Country country;
    private boolean isAutoUpdateNewsEnabled = true;
    @Deprecated
    private transient long newsVersion;
    private String newsID = "";
    private int historyDuration = 10;
    private boolean isChatEnabled = false;
    private String chatUsername = "";
    private String chatPassword = "";
    private boolean isChatSoundNotificationEnabled = true;
    private boolean isChatFlashNotificationEnabled = true;
    private Color chatSystemMessageColor;
    private Color chatOwnMessageColor;
    private Color chatOtherMessageColor;
    private transient Credentials credentials = null;
    private String proxyAuthPassword = "";
    private String proxyAuthUserName = "";
    private boolean isProxyAuthEnabled = false;
    private boolean rememberGoogleAccountEnabled = false;
    private String googleUsername = "";
    private String googlePassword = "";
    private String lastFileIODirectory = System.getProperty("user.home");
    private String lastFileNameExtensionDescription = "CSV Documents (*.csv)";
    private Map<Country, Class> primaryStockServerFactoryClasses = new EnumMap<Country, Class>(Country.class);
    private Boolean primaryStockServerFactoryClassesIsValidForMalaysia = true;
    private int lastSelectedPageIndex = 0;
    private int lastSelectedSellPortfolioChartIndex = 0;
    private int lastSelectedBuyPortfolioChartIndex = 0;
    private int maxSMSPerDay = -1;
    @Deprecated
    private transient String portfolioName = org.yccheok.jstock.portfolio.Utils.getDefaultPortfolioName();
    private Map<Country, String> portfolioNames = new EnumMap<Country, String>(Country.class);
    @Deprecated
    private transient String watchlistName = org.yccheok.jstock.watchlist.Utils.getDefaultWatchlistName();
    private Map<Country, String> watchlistNames = new EnumMap<Country, String>(Country.class);
    private YellowInformationBoxOption yellowInformationBoxOption = YellowInformationBoxOption.Follow;
    private StockInputSuggestionListOption stockInputSuggestionListOption = StockInputSuggestionListOption.OneColumn;
    private Locale locale = Locale.getDefault();
    private BoundsEx boundsEx = null;
    private Map<Country, String> currencies = new EnumMap<Country, String>(Country.class);
    private Map<Country, Boolean> currencyExchangeEnable = new EnumMap<Country, Boolean>(Country.class);
    private Map<Country, Country> localCurrencyCountries = new EnumMap<Country, Country>(Country.class);
    private Map<Country, Boolean> penceToPoundConversionEnabled = new EnumMap<Country, Boolean>(Country.class);
    private Map<Country, Boolean> fourDecimalPlacesEnabled = new EnumMap<Country, Boolean>(Country.class);
    private int applicationVersionID = Utils.getApplicationVersionID();
    private ChartTheme chartTheme = ChartTheme.Light;
    private boolean isFeeCalculationEnabled = false;
    private boolean isDynamicChartVisible = false;

    public JStockOptions() {
        this.country = Country.Malaysia;
        this.normalTextForegroundColor = DEFAULT_NORMAL_TEXT_FOREGROUND_COLOR;
        this.higherNumericalValueForegroundColor = DEFAULT_HIGHER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        this.lowerNumericalValueForegroundColor = DEFAULT_LOWER_NUMERICAL_VALUE_FOREGROUND_COLOR;
        this.firstRowBackgroundColor = DEFAULT_FIRST_ROW_BACKGROUND_COLOR;
        this.secondRowBackgroundColor = DEFAULT_SECOND_ROW_BACKGROUND_COLOR;
        this.autoUpdateForegroundColor = DEFAULT_AUTO_UPDATE_FOREGROUND_COLOR;
        this.autoUpdateBackgroundColor = DEFAULT_AUTO_UPDATE_BACKGROUND_COLOR;
        this.fallBelowAlertForegroundColor = DEFAULT_FALL_BELOW_ALERT_FOREGROUND_COLOR;
        this.fallBelowAlertBackgroundColor = DEFAULT_FALL_BELOW_ALERT_BACKGROUND_COLOR;
        this.riseAboveAlertForegroundColor = DEFAULT_RISE_ABOVE_ALERT_FOREGROUND_COLOR;
        this.riseAboveAlertBackgroundColor = DEFAULT_RISE_ABOVE_ALERT_BACKGROUND_COLOR;
        this.chatSystemMessageColor = DEFAULT_CHAT_SYSTEM_MESSAGE_COLOR;
        this.chatOwnMessageColor = DEFAULT_CHAT_OWN_MESSAGE_COLOR;
        this.chatOtherMessageColor = DEFAULT_CHAT_OTHER_MESSAGE_COLOR;
        this.yellowInformationBoxOption = DEFAULT_YELLOW_INFORMATION_BOX_OPTION;
        this.stockInputSuggestionListOption = DEFAULT_STOCK_INPUT_SUGGESTION_LIST_OPTION;
        this.locale = Locale.getDefault();
    }

    public boolean isAutoBrokerFeeCalculationEnabled() {
        return this.isAutoBrokerFeeCalculationEnabled;
    }

    public void setAutoBrokerFeeCalculationEnabled(boolean isAutoBrokerFeeCalculationEnabled) {
        this.isAutoBrokerFeeCalculationEnabled = isAutoBrokerFeeCalculationEnabled;
    }

    public void insensitiveCopy(JStockOptions jStockOptions) {
        this.singleIndicatorAlert = jStockOptions.singleIndicatorAlert;
        this.popupMessage = jStockOptions.popupMessage;
        this.scanningSpeed = jStockOptions.scanningSpeed;
        this.alertSpeed = jStockOptions.alertSpeed;
        this.looknFeel = jStockOptions.looknFeel;
        this.normalTextForegroundColor = jStockOptions.normalTextForegroundColor;
        this.lowerNumericalValueForegroundColor = jStockOptions.lowerNumericalValueForegroundColor;
        this.higherNumericalValueForegroundColor = jStockOptions.higherNumericalValueForegroundColor;
        this.firstRowBackgroundColor = jStockOptions.firstRowBackgroundColor;
        this.secondRowBackgroundColor = jStockOptions.secondRowBackgroundColor;
        this.autoUpdateForegroundColor = jStockOptions.autoUpdateForegroundColor;
        this.autoUpdateBackgroundColor = jStockOptions.autoUpdateBackgroundColor;
        this.fallBelowAlertForegroundColor = jStockOptions.fallBelowAlertForegroundColor;
        this.fallBelowAlertBackgroundColor = jStockOptions.fallBelowAlertBackgroundColor;
        this.riseAboveAlertForegroundColor = jStockOptions.riseAboveAlertForegroundColor;
        this.riseAboveAlertBackgroundColor = jStockOptions.riseAboveAlertBackgroundColor;
        this.enableColorChange = jStockOptions.enableColorChange;
        this.enableColorAlert = jStockOptions.enableColorAlert;
        this.brokingFirms = jStockOptions.brokingFirms;
        this.selectedBrokingFirmIndex = jStockOptions.selectedBrokingFirmIndex;
        this.isAutoBrokerFeeCalculationEnabled = jStockOptions.isAutoBrokerFeeCalculationEnabled;
        this.expectedProfitPercentage = jStockOptions.expectedProfitPercentage;
        this.country = jStockOptions.country;
        this.isAutoUpdateNewsEnabled = jStockOptions.isAutoUpdateNewsEnabled;
        this.historyDuration = jStockOptions.historyDuration;
        this.isChatSoundNotificationEnabled = jStockOptions.isChatSoundNotificationEnabled;
        this.isChatFlashNotificationEnabled = jStockOptions.isChatFlashNotificationEnabled;
        this.chatSystemMessageColor = jStockOptions.chatSystemMessageColor;
        this.chatOwnMessageColor = jStockOptions.chatOwnMessageColor;
        this.chatOtherMessageColor = jStockOptions.chatOtherMessageColor;
        this.penceToPoundConversionEnabled = jStockOptions.penceToPoundConversionEnabled;
        this.fourDecimalPlacesEnabled = jStockOptions.fourDecimalPlacesEnabled;
        this.primaryStockServerFactoryClasses = jStockOptions.primaryStockServerFactoryClasses;
        this.lastSelectedPageIndex = jStockOptions.lastSelectedPageIndex;
        this.lastSelectedSellPortfolioChartIndex = jStockOptions.lastSelectedSellPortfolioChartIndex;
        this.lastSelectedBuyPortfolioChartIndex = jStockOptions.lastSelectedBuyPortfolioChartIndex;
        this.maxSMSPerDay = jStockOptions.maxSMSPerDay;
        this.portfolioNames = new EnumMap<Country, String>(jStockOptions.portfolioNames);
        this.watchlistNames = new EnumMap<Country, String>(jStockOptions.watchlistNames);
        this.yellowInformationBoxOption = jStockOptions.yellowInformationBoxOption;
        this.stockInputSuggestionListOption = jStockOptions.stockInputSuggestionListOption;
        this.currencies = new EnumMap<Country, String>(jStockOptions.currencies);
        this.currencyExchangeEnable = new EnumMap<Country, Boolean>(jStockOptions.currencyExchangeEnable);
        this.localCurrencyCountries = new EnumMap<Country, Country>(jStockOptions.localCurrencyCountries);
        this.penceToPoundConversionEnabled = new EnumMap<Country, Boolean>(jStockOptions.penceToPoundConversionEnabled);
        this.fourDecimalPlacesEnabled = new EnumMap<Country, Boolean>(jStockOptions.fourDecimalPlacesEnabled);
        this.chartTheme = jStockOptions.getChartTheme();
        this.isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled;
        this.isDynamicChartVisible = jStockOptions.isDynamicChartVisible;
    }

    public JStockOptions insensitiveClone() {
        JStockOptions jStockOptions = new JStockOptions();
        jStockOptions.singleIndicatorAlert = this.singleIndicatorAlert;
        jStockOptions.popupMessage = this.popupMessage;
        jStockOptions.scanningSpeed = this.scanningSpeed;
        jStockOptions.alertSpeed = this.alertSpeed;
        jStockOptions.looknFeel = this.looknFeel;
        jStockOptions.normalTextForegroundColor = this.normalTextForegroundColor;
        jStockOptions.lowerNumericalValueForegroundColor = this.lowerNumericalValueForegroundColor;
        jStockOptions.higherNumericalValueForegroundColor = this.higherNumericalValueForegroundColor;
        jStockOptions.firstRowBackgroundColor = this.firstRowBackgroundColor;
        jStockOptions.secondRowBackgroundColor = this.secondRowBackgroundColor;
        jStockOptions.autoUpdateForegroundColor = this.autoUpdateForegroundColor;
        jStockOptions.autoUpdateBackgroundColor = this.autoUpdateBackgroundColor;
        jStockOptions.fallBelowAlertForegroundColor = this.fallBelowAlertForegroundColor;
        jStockOptions.fallBelowAlertBackgroundColor = this.fallBelowAlertBackgroundColor;
        jStockOptions.riseAboveAlertForegroundColor = this.riseAboveAlertForegroundColor;
        jStockOptions.riseAboveAlertBackgroundColor = this.riseAboveAlertBackgroundColor;
        jStockOptions.enableColorChange = this.enableColorChange;
        jStockOptions.enableColorAlert = this.enableColorAlert;
        jStockOptions.brokingFirms = this.brokingFirms;
        jStockOptions.selectedBrokingFirmIndex = this.selectedBrokingFirmIndex;
        jStockOptions.isAutoBrokerFeeCalculationEnabled = this.isAutoBrokerFeeCalculationEnabled;
        jStockOptions.expectedProfitPercentage = this.expectedProfitPercentage;
        jStockOptions.country = this.country;
        jStockOptions.isAutoUpdateNewsEnabled = this.isAutoUpdateNewsEnabled;
        jStockOptions.historyDuration = this.historyDuration;
        jStockOptions.isChatSoundNotificationEnabled = this.isChatSoundNotificationEnabled;
        jStockOptions.isChatFlashNotificationEnabled = this.isChatFlashNotificationEnabled;
        jStockOptions.chatSystemMessageColor = this.chatSystemMessageColor;
        jStockOptions.chatOwnMessageColor = this.chatOwnMessageColor;
        jStockOptions.chatOtherMessageColor = this.chatOtherMessageColor;
        jStockOptions.penceToPoundConversionEnabled = this.penceToPoundConversionEnabled;
        jStockOptions.fourDecimalPlacesEnabled = this.fourDecimalPlacesEnabled;
        jStockOptions.primaryStockServerFactoryClasses = this.primaryStockServerFactoryClasses;
        jStockOptions.lastSelectedPageIndex = this.lastSelectedPageIndex;
        jStockOptions.lastSelectedSellPortfolioChartIndex = this.lastSelectedSellPortfolioChartIndex;
        jStockOptions.lastSelectedBuyPortfolioChartIndex = this.lastSelectedBuyPortfolioChartIndex;
        jStockOptions.maxSMSPerDay = this.maxSMSPerDay;
        jStockOptions.portfolioNames = new EnumMap<Country, String>(this.portfolioNames);
        jStockOptions.watchlistNames = new EnumMap<Country, String>(this.watchlistNames);
        jStockOptions.yellowInformationBoxOption = this.yellowInformationBoxOption;
        jStockOptions.stockInputSuggestionListOption = this.stockInputSuggestionListOption;
        jStockOptions.currencies = new EnumMap<Country, String>(this.currencies);
        jStockOptions.currencyExchangeEnable = new EnumMap<Country, Boolean>(this.currencyExchangeEnable);
        jStockOptions.localCurrencyCountries = new EnumMap<Country, Country>(this.localCurrencyCountries);
        jStockOptions.penceToPoundConversionEnabled = new EnumMap<Country, Boolean>(jStockOptions.penceToPoundConversionEnabled);
        jStockOptions.fourDecimalPlacesEnabled = new EnumMap<Country, Boolean>(jStockOptions.fourDecimalPlacesEnabled);
        jStockOptions.chartTheme = this.chartTheme;
        jStockOptions.isFeeCalculationEnabled = this.isFeeCalculationEnabled;
        jStockOptions.isDynamicChartVisible = this.isDynamicChartVisible;
        return jStockOptions;
    }

    private Object readResolve() {
        if (this.lastSelectedPageIndex < 0) {
            this.lastSelectedPageIndex = 0;
        }
        if (this.lastSelectedSellPortfolioChartIndex < 0) {
            this.lastSelectedSellPortfolioChartIndex = 0;
        }
        if (this.lastSelectedBuyPortfolioChartIndex < 0) {
            this.lastSelectedBuyPortfolioChartIndex = 0;
        }
        if (this.brokingFirms == null) {
            this.brokingFirms = new ArrayList<BrokingFirm>();
        }
        if (this.country == null) {
            this.country = Country.Malaysia;
        }
        if (this.historyDuration <= 0) {
            this.historyDuration = 10;
        }
        if (this.getChatUsername() == null) {
            this.setChatUsername("");
        }
        if (this.getChatPassword() == null) {
            this.setChatPassword("");
        }
        if (this.getChatSystemMessageColor() == null) {
            this.setChatSystemMessageColor(DEFAULT_CHAT_SYSTEM_MESSAGE_COLOR);
        }
        if (this.getChatOwnMessageColor() == null) {
            this.setChatOwnMessageColor(DEFAULT_CHAT_OWN_MESSAGE_COLOR);
        }
        if (this.getChatOtherMessageColor() == null) {
            this.setChatOtherMessageColor(DEFAULT_CHAT_OTHER_MESSAGE_COLOR);
        }
        if (this.getFallBelowAlertForegroundColor() == null) {
            this.setFallBelowAlertForegroundColor(DEFAULT_FALL_BELOW_ALERT_FOREGROUND_COLOR);
        }
        if (this.getFallBelowAlertBackgroundColor() == null) {
            this.setFallBelowAlertBackgroundColor(DEFAULT_FALL_BELOW_ALERT_BACKGROUND_COLOR);
        }
        if (this.getRiseAboveAlertForegroundColor() == null) {
            this.setRiseAboveAlertForegroundColor(DEFAULT_RISE_ABOVE_ALERT_FOREGROUND_COLOR);
        }
        if (this.getRiseAboveAlertBackgroundColor() == null) {
            this.setRiseAboveAlertBackgroundColor(DEFAULT_RISE_ABOVE_ALERT_BACKGROUND_COLOR);
        }
        if (this.proxyAuthUserName == null) {
            this.proxyAuthUserName = "";
        }
        if (this.proxyAuthPassword == null) {
            this.proxyAuthPassword = "";
        }
        if (this.getGoogleUsername() == null) {
            this.setGoogleUsername("");
        }
        if (this.getGooglePassword() == null) {
            this.setGooglePassword("");
        }
        this.setCredentials((Credentials)new NTCredentials(this.proxyAuthUserName, Utils.decrypt(this.proxyAuthPassword), "", ""));
        if (this.getLastFileIODirectory() == null) {
            this.setLastFileIODirectory("");
        }
        if (this.getLastSavedFileNameExtensionDescription() == null) {
            this.setLastFileNameExtensionDescription("CSV Documents (*.csv)");
        }
        if (this.getGoogleCalendarUsername() == null) {
            this.setGoogleCalendarUsername("");
            this.setSMSEnabled(false);
        }
        if (this.getGoogleCalendarPassword() == null) {
            this.setGoogleCalendarPassword("");
            this.setSMSEnabled(false);
        }
        if (this.primaryStockServerFactoryClasses == null) {
            this.primaryStockServerFactoryClasses = new EnumMap<Country, Class>(Country.class);
        }
        if (this.portfolioNames == null) {
            this.portfolioNames = new EnumMap<Country, String>(Country.class);
        }
        if (this.watchlistNames == null) {
            this.watchlistNames = new EnumMap<Country, String>(Country.class);
        }
        if (this.maxSMSPerDay <= 0) {
            this.maxSMSPerDay = -1;
        }
        if (this.getNewsID() == null) {
            this.setNewsID("");
        }
        if (this.yellowInformationBoxOption == null) {
            this.yellowInformationBoxOption = YellowInformationBoxOption.Follow;
        }
        if (this.stockInputSuggestionListOption == null) {
            this.stockInputSuggestionListOption = StockInputSuggestionListOption.OneColumn;
        }
        if (this.getCCEmail() == null) {
            this.setCCEmail("");
        }
        if (this.getLocale() == null) {
            this.setLocale(Locale.getDefault());
        }
        if (this.currencies == null) {
            this.currencies = new EnumMap<Country, String>(Country.class);
        }
        if (this.currencyExchangeEnable == null) {
            this.currencyExchangeEnable = new EnumMap<Country, Boolean>(Country.class);
        }
        if (this.localCurrencyCountries == null) {
            this.localCurrencyCountries = new EnumMap<Country, Country>(Country.class);
        }
        if (this.penceToPoundConversionEnabled == null) {
            this.penceToPoundConversionEnabled = new EnumMap<Country, Boolean>(Country.class);
        }
        if (!this.penceToPoundConversionEnabled.containsKey((Object)Country.UnitedKingdom)) {
            this.penceToPoundConversionEnabled.put(Country.UnitedKingdom, true);
        }
        if (this.fourDecimalPlacesEnabled == null) {
            this.fourDecimalPlacesEnabled = new EnumMap<Country, Boolean>(Country.class);
        }
        if (this.primaryStockServerFactoryClassesIsValidForMalaysia == null || !this.primaryStockServerFactoryClassesIsValidForMalaysia.booleanValue()) {
            this.primaryStockServerFactoryClasses.remove((Object)Country.Malaysia);
            this.primaryStockServerFactoryClassesIsValidForMalaysia = true;
        }
        if (this.locale.getCountry().equals(Locale.FRANCE.getCountry()) && this.locale.getLanguage().equals(Locale.ENGLISH.getLanguage())) {
            this.locale = Locale.FRANCE;
        }
        if (this.chartTheme == null) {
            this.chartTheme = ChartTheme.Light;
        }
        if (this.scanningSpeed <= 1000) {
            this.scanningSpeed = 10000;
        }
        return this;
    }

    public int getBrokingFirmSize() {
        return this.brokingFirms.size();
    }

    public BrokingFirm getBrokingFirm(int index) {
        return this.brokingFirms.get(index);
    }

    public int getSelectedBrokingFirmIndex() {
        return this.selectedBrokingFirmIndex;
    }

    public void setSelectedBrokingFirmIndex(int selectedBrokingFirmIndex) {
        this.selectedBrokingFirmIndex = selectedBrokingFirmIndex;
    }

    public void clearBrokingFirms() {
        this.brokingFirms.clear();
    }

    public void addBrokingFirm(BrokingFirm brokingFirm) {
        this.brokingFirms.add(brokingFirm);
    }

    public BrokingFirm getSelectedBrokingFirm() {
        if (this.selectedBrokingFirmIndex < 0 || this.selectedBrokingFirmIndex >= this.getBrokingFirmSize()) {
            return null;
        }
        return this.brokingFirms.get(this.selectedBrokingFirmIndex);
    }

    public String getLooknFeel() {
        return this.looknFeel;
    }

    public void setLookNFeel(String looknFeel) {
        this.looknFeel = looknFeel;
    }

    public boolean isSingleIndicatorAlert() {
        return this.singleIndicatorAlert;
    }

    public void setSingleIndicatorAlert(boolean singleIndicatorAlert) {
        this.singleIndicatorAlert = singleIndicatorAlert;
    }

    public boolean isPopupMessage() {
        return this.popupMessage;
    }

    public void setPopupMessage(boolean popupMessage) {
        this.popupMessage = popupMessage;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmailPassword() {
        return this.emailPassword;
    }

    public void setEmailPassword(String emailPassword) {
        this.emailPassword = emailPassword;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public void setProxyServer(String proxyServer) {
        this.proxyServer = proxyServer;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getScanningSpeed() {
        return this.scanningSpeed;
    }

    public int getAlertSpeed() {
        return this.alertSpeed;
    }

    public void setScanningSpeed(int scanningSpeed) {
        this.scanningSpeed = scanningSpeed;
    }

    public void setAlertSpeed(int alertSpeed) {
        this.alertSpeed = alertSpeed;
    }

    public Color getNormalTextForegroundColor() {
        return this.normalTextForegroundColor;
    }

    public void setNormalTextForegroundColor(Color normalTextForegroundColor) {
        this.normalTextForegroundColor = normalTextForegroundColor;
    }

    public Color getLowerNumericalValueForegroundColor() {
        return this.lowerNumericalValueForegroundColor;
    }

    public void setLowerNumericalValueForegroundColor(Color lowerNumericalValueForegroundColor) {
        this.lowerNumericalValueForegroundColor = lowerNumericalValueForegroundColor;
    }

    public Color getHigherNumericalValueForegroundColor() {
        return this.higherNumericalValueForegroundColor;
    }

    public void setHigherNumericalValueForegroundColor(Color higherNumericalValueForegroundColor) {
        this.higherNumericalValueForegroundColor = higherNumericalValueForegroundColor;
    }

    public Color getFirstRowBackgroundColor() {
        return this.firstRowBackgroundColor;
    }

    public void setFirstRowBackgroundColor(Color firstRowBackgroundColor) {
        this.firstRowBackgroundColor = firstRowBackgroundColor;
    }

    public Color getSecondRowBackgroundColor() {
        return this.secondRowBackgroundColor;
    }

    public void setSecondRowBackgroundColor(Color secondRowBackgroundColor) {
        this.secondRowBackgroundColor = secondRowBackgroundColor;
    }

    public Color getAutoUpdateForegroundColor() {
        return this.autoUpdateForegroundColor;
    }

    public void setAutoUpdateForegroundColor(Color autoUpdateForegroundColor) {
        this.autoUpdateForegroundColor = autoUpdateForegroundColor;
    }

    public Color getAutoUpdateBackgroundColor() {
        return this.autoUpdateBackgroundColor;
    }

    public void setAutoUpdateBackgroundColor(Color autoUpdateBackgroundColor) {
        this.autoUpdateBackgroundColor = autoUpdateBackgroundColor;
    }

    public boolean isEnableColorChange() {
        return this.enableColorChange;
    }

    public void setEnableColorChange(boolean enableColorChange) {
        this.enableColorChange = enableColorChange;
    }

    public boolean isAutoUpdateNewsEnabled() {
        return this.isAutoUpdateNewsEnabled;
    }

    public boolean isChatEnabled() {
        return this.isChatEnabled;
    }

    public boolean isChatSoundNotificationEnabled() {
        return this.isChatSoundNotificationEnabled;
    }

    public boolean isChatFlashNotificationEnabled() {
        return this.isChatFlashNotificationEnabled;
    }

    public void setAutoUpdateNewsEnabled(boolean isAutoUpdateNewsEnabled) {
        this.isAutoUpdateNewsEnabled = isAutoUpdateNewsEnabled;
    }

    public void setChatEnabled(boolean isChatEnabled) {
        this.isChatEnabled = isChatEnabled;
    }

    public void setChatFlashNotificationEnabled(boolean isChatFlashNotificationEnabled) {
        this.isChatFlashNotificationEnabled = isChatFlashNotificationEnabled;
    }

    public void setChatSoundNotificationEnabled(boolean isChatSoundNotificationEnabled) {
        this.isChatSoundNotificationEnabled = isChatSoundNotificationEnabled;
    }

    public double getExpectedProfitPercentage() {
        return this.expectedProfitPercentage;
    }

    public void setExpectedProfitPercentage(double expectedProfitPercentage) {
        this.expectedProfitPercentage = expectedProfitPercentage;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public int getHistoryDuration() {
        return this.historyDuration;
    }

    public void setHistoryDuration(int historyDuration) {
        this.historyDuration = historyDuration;
    }

    public String getChatUsername() {
        return this.chatUsername;
    }

    public void setChatUsername(String chatUsername) {
        this.chatUsername = chatUsername;
    }

    public Color getChatSystemMessageColor() {
        return this.chatSystemMessageColor;
    }

    public void setChatSystemMessageColor(Color chatSystemMessageColor) {
        this.chatSystemMessageColor = chatSystemMessageColor;
    }

    public Color getChatOwnMessageColor() {
        return this.chatOwnMessageColor;
    }

    public void setChatOwnMessageColor(Color chatOwnMessageColor) {
        this.chatOwnMessageColor = chatOwnMessageColor;
    }

    public Color getChatOtherMessageColor() {
        return this.chatOtherMessageColor;
    }

    public void setChatOtherMessageColor(Color chatOtherMessageColor) {
        this.chatOtherMessageColor = chatOtherMessageColor;
    }

    public String getChatPassword() {
        return this.chatPassword;
    }

    public void setChatPassword(String chatPassword) {
        this.chatPassword = chatPassword;
    }

    public boolean isEnableColorAlert() {
        return this.enableColorAlert;
    }

    public void setEnableColorAlert(boolean enableColorAlert) {
        this.enableColorAlert = enableColorAlert;
    }

    public String getProxyAuthPassword() {
        return this.proxyAuthPassword;
    }

    public void setProxyAuthPassword(String proxyAuthPassword) {
        this.proxyAuthPassword = proxyAuthPassword;
        this.setCredentials((Credentials)new NTCredentials(this.proxyAuthUserName, Utils.decrypt(this.proxyAuthPassword), "", ""));
    }

    public String getProxyAuthUserName() {
        return this.proxyAuthUserName;
    }

    public void setProxyAuthUserName(String proxyAuthUserName) {
        this.proxyAuthUserName = proxyAuthUserName;
        this.setCredentials((Credentials)new NTCredentials(this.proxyAuthUserName, Utils.decrypt(this.proxyAuthPassword), "", ""));
    }

    public boolean isProxyAuthEnabled() {
        return this.isProxyAuthEnabled;
    }

    public void setIsProxyAuthEnabled(boolean isProxyAuthEnabled) {
        this.isProxyAuthEnabled = isProxyAuthEnabled;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public String getLastFileIODirectory() {
        return this.lastFileIODirectory;
    }

    public void setLastFileIODirectory(String lastFileIODirectory) {
        this.lastFileIODirectory = lastFileIODirectory;
    }

    public String getLastSavedFileNameExtensionDescription() {
        return this.lastFileNameExtensionDescription;
    }

    public void setLastFileNameExtensionDescription(String lastFileNameExtensionDescription) {
        this.lastFileNameExtensionDescription = lastFileNameExtensionDescription;
    }

    public int getLastSelectedPageIndex() {
        return this.lastSelectedPageIndex;
    }

    public void setLastSelectedPageIndex(int lastSelectedPageIndex) {
        this.lastSelectedPageIndex = lastSelectedPageIndex;
    }

    public int getLastSelectedBuyPortfolioChartIndex() {
        return this.lastSelectedBuyPortfolioChartIndex;
    }

    public void setLastSelectedBuyPortfolioChartIndex(int lastSelectedBuyPortfolioChartIndex) {
        this.lastSelectedBuyPortfolioChartIndex = lastSelectedBuyPortfolioChartIndex;
    }

    public int getLastSelectedSellPortfolioChartIndex() {
        return this.lastSelectedSellPortfolioChartIndex;
    }

    public void setLastSelectedSellPortfolioChartIndex(int lastSelectedSellPortfolioChartIndex) {
        this.lastSelectedSellPortfolioChartIndex = lastSelectedSellPortfolioChartIndex;
    }

    public String getGoogleCalendarUsername() {
        return this.googleCalendarUsername;
    }

    public void setGoogleCalendarUsername(String googleCalendarUsername) {
        this.googleCalendarUsername = googleCalendarUsername;
    }

    public String getGoogleCalendarPassword() {
        return this.googleCalendarPassword;
    }

    public void setGoogleCalendarPassword(String googleCalendarPassword) {
        this.googleCalendarPassword = googleCalendarPassword;
    }

    public boolean isSMSEnabled() {
        return this.SMSEnabled;
    }

    public void setSMSEnabled(boolean SMSEnabled) {
        this.SMSEnabled = SMSEnabled;
    }

    public Class addPrimaryStockServerFactoryClass(Country country, Class c) {
        return this.primaryStockServerFactoryClasses.put(country, c);
    }

    public Class getPrimaryStockServerFactoryClass(Country country) {
        return this.primaryStockServerFactoryClasses.get((Object)country);
    }

    public String getWatchlistName() {
        String p = this.watchlistNames.get((Object)this.country);
        if (p == null) {
            return org.yccheok.jstock.watchlist.Utils.getDefaultWatchlistName();
        }
        return p;
    }

    public String getPortfolioName() {
        String p = this.portfolioNames.get((Object)this.country);
        if (p == null) {
            return org.yccheok.jstock.portfolio.Utils.getDefaultPortfolioName();
        }
        return p;
    }

    public void setPortfolioName(String p) {
        this.portfolioNames.put(this.country, p);
    }

    public void setWatchlistName(String watchlistName) {
        this.watchlistNames.put(this.country, watchlistName);
    }

    public int getMaxSMSPerDay() {
        return this.maxSMSPerDay;
    }

    public void setMaxSMSPerDay(int maxSMSPerDay) {
        this.maxSMSPerDay = maxSMSPerDay;
    }

    public String getNewsID() {
        return this.newsID;
    }

    public void setNewsID(String newsID) {
        this.newsID = newsID;
    }

    public boolean isPenceToPoundConversionEnabled() {
        Boolean b = this.penceToPoundConversionEnabled.get((Object)this.country);
        if (b == null) {
            return false;
        }
        return b;
    }

    public boolean isFourDecimalPlacesEnabled() {
        Boolean b = this.fourDecimalPlacesEnabled.get((Object)this.country);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void setPenceToPoundConversionEnabled(boolean penceToPoundConversionEnabled) {
        this.penceToPoundConversionEnabled.put(this.country, penceToPoundConversionEnabled);
    }

    public void setFourDecimalPlacesEnabled(boolean fourDecimalPlacesEnabled) {
        this.fourDecimalPlacesEnabled.put(this.country, fourDecimalPlacesEnabled);
    }

    public boolean isRememberGoogleAccountEnabled() {
        return this.rememberGoogleAccountEnabled;
    }

    public void setRememberGoogleAccountEnabled(boolean rememberGoogleAccountEnabled) {
        this.rememberGoogleAccountEnabled = rememberGoogleAccountEnabled;
    }

    public String getGoogleUsername() {
        return this.googleUsername;
    }

    public void setGoogleUsername(String googleUsername) {
        this.googleUsername = googleUsername;
    }

    public String getGooglePassword() {
        return this.googlePassword;
    }

    public void setGooglePassword(String googlePassword) {
        this.googlePassword = googlePassword;
    }

    public boolean isSoundEnabled() {
        return this.soundEnabled;
    }

    public void setSoundEnabled(boolean soundEnabled) {
        this.soundEnabled = soundEnabled;
    }

    public String getCurrencySymbol(Country c) {
        String currecySymbol = this.currencies.get((Object)c);
        if (currecySymbol == null) {
            return Utils.getDefaultCurrencySymbol();
        }
        return currecySymbol;
    }

    public void setCurrencySymbol(Country c, String s) {
        this.currencies.put(c, s);
    }

    public boolean isCurrencyExchangeEnable(Country c) {
        Boolean flag = this.currencyExchangeEnable.get((Object)c);
        if (flag != null) {
            return flag;
        }
        return false;
    }

    public void setCurrencyExchangeEnable(Country country, boolean enable) {
        this.currencyExchangeEnable.put(country, enable);
    }

    public Country getLocalCurrencyCountry(Country country) {
        Country localCountry = this.localCurrencyCountries.get((Object)country);
        if (localCountry != null) {
            return localCountry;
        }
        return country;
    }

    public void setLocalCurrencyCountry(Country country, Country localCurrencyCountry) {
        this.localCurrencyCountries.put(country, localCurrencyCountry);
    }

    public YellowInformationBoxOption getYellowInformationBoxOption() {
        return this.yellowInformationBoxOption;
    }

    public void setYellowInformationBoxOption(YellowInformationBoxOption yellowInformationBoxOption) {
        this.yellowInformationBoxOption = yellowInformationBoxOption;
    }

    public String getCCEmail() {
        return this.CCEmail;
    }

    public void setCCEmail(String CCEmail) {
        this.CCEmail = CCEmail;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public BoundsEx getBoundsEx() {
        return this.boundsEx;
    }

    public void setBoundsEx(BoundsEx boundsEx) {
        this.boundsEx = boundsEx;
    }

    public Color getFallBelowAlertForegroundColor() {
        return this.fallBelowAlertForegroundColor;
    }

    public void setFallBelowAlertForegroundColor(Color fallBelowAlertForegroundColor) {
        this.fallBelowAlertForegroundColor = fallBelowAlertForegroundColor;
    }

    public Color getFallBelowAlertBackgroundColor() {
        return this.fallBelowAlertBackgroundColor;
    }

    public void setFallBelowAlertBackgroundColor(Color fallBelowAlertBackgroundColor) {
        this.fallBelowAlertBackgroundColor = fallBelowAlertBackgroundColor;
    }

    public Color getRiseAboveAlertForegroundColor() {
        return this.riseAboveAlertForegroundColor;
    }

    public void setRiseAboveAlertForegroundColor(Color riseAboveAlertForegroundColor) {
        this.riseAboveAlertForegroundColor = riseAboveAlertForegroundColor;
    }

    public Color getRiseAboveAlertBackgroundColor() {
        return this.riseAboveAlertBackgroundColor;
    }

    public void setRiseAboveAlertBackgroundColor(Color riseAboveAlertBackgroundColor) {
        this.riseAboveAlertBackgroundColor = riseAboveAlertBackgroundColor;
    }

    public StockInputSuggestionListOption getStockInputSuggestionListOption() {
        return this.stockInputSuggestionListOption;
    }

    public void setStockInputSuggestionListOption(StockInputSuggestionListOption stockInputSuggestionListOption) {
        this.stockInputSuggestionListOption = stockInputSuggestionListOption;
    }

    public int getApplicationVersionID() {
        return this.applicationVersionID;
    }

    public void setApplicationVersionID(int applicationVersionID) {
        this.applicationVersionID = applicationVersionID;
    }

    public ChartTheme getChartTheme() {
        return this.chartTheme;
    }

    public void setChartTheme(ChartTheme chartTheme) {
        this.chartTheme = chartTheme;
    }

    public boolean isFeeCalculationEnabled() {
        return this.isFeeCalculationEnabled;
    }

    public boolean isDynamicChartVisible() {
        return this.isDynamicChartVisible;
    }

    public void setFeeCalculationEnabled(boolean isFeeCalculationEnabled) {
        this.isFeeCalculationEnabled = isFeeCalculationEnabled;
    }

    public void setDynamicChartVisible(boolean isDynamicChartVisible) {
        this.isDynamicChartVisible = isDynamicChartVisible;
    }

    public static enum ChartTheme {
        Light,
        Dark;

    }

    public static enum YellowInformationBoxOption {
        Stay,
        Follow,
        Hide;

    }

    public static enum StockInputSuggestionListOption {
        OneColumn,
        TwoColumns;

    }

    public static class BoundsEx {
        public final Rectangle bounds;
        public final int extendedState;

        public BoundsEx(Rectangle bounds, int extendedState) {
            this.bounds = bounds;
            this.extendedState = extendedState;
        }
    }
}

