/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.NumberFormatter;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.DateField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.MatchType;
import org.yccheok.jstock.engine.Observer;
import org.yccheok.jstock.engine.ResultType;
import org.yccheok.jstock.engine.SimpleDate;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.engine.StockInfo;
import org.yccheok.jstock.engine.StockInfoDatabase;
import org.yccheok.jstock.engine.Symbol;
import org.yccheok.jstock.gui.AjaxServiceProvider;
import org.yccheok.jstock.gui.AutoCompleteJComboBox;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.MessagesBundle;
import org.yccheok.jstock.portfolio.BrokingFirm;
import org.yccheok.jstock.portfolio.Contract;
import org.yccheok.jstock.portfolio.Transaction;

public class NewBuyTransactionJDialog
extends JDialog {
    private static final Log log = LogFactory.getLog(NewBuyTransactionJDialog.class);
    private Transaction transaction = null;
    private String transactionComment = "";
    private Stock stock = null;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JFormattedTextField jFormattedTextField1;
    private JFormattedTextField jFormattedTextField2;
    private JFormattedTextField jFormattedTextField3;
    private JFormattedTextField jFormattedTextField4;
    private JFormattedTextField jFormattedTextField5;
    private JFormattedTextField jFormattedTextField6;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JSpinner jSpinner1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public NewBuyTransactionJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        if (isFeeCalculationEnabled) {
            this.initComponents();
        } else {
            this.initComponentsWithFeeCalculationDisabled();
        }
        this.jPanel1.add((Component)Utils.getBusyJXLayer((AutoCompleteJComboBox)this.jComboBox1));
        if (this.shouldAutoCalculateBrokerFee()) {
            this.jFormattedTextField3.setEditable(false);
            this.jFormattedTextField4.setEditable(false);
            this.jFormattedTextField5.setEditable(false);
        }
        this.initAjaxProvider();
    }

    private void initComponentsWithFeeCalculationDisabled() {
        this.jComboBox1 = new AutoCompleteJComboBox();
        this.jLabel7 = new JLabel();
        this.jFormattedTextField3 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField4 = this.getCurrencyJFormattedTextField();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jFormattedTextField5 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField6 = this.getCurrencyJFormattedTextField();
        this.jLabel10 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jPanel3 = CalendarFactory.createDateField();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField1 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(110, 24));
        ((AutoCompleteJComboBox)this.jComboBox1).attachStockInfoObserver(this.getStockInfoObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachResultObserver(this.getResultObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachMatchObserver(this.getMatchObserver());
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.jLabel7.setText(bundle.getString("NewBuyTransactionJDialog_Broker"));
        this.jFormattedTextField3.setValue(new Double(0.0));
        this.jFormattedTextField3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField3KeyTyped(evt);
            }
        });
        this.jFormattedTextField4.setValue(new Double(0.0));
        this.jFormattedTextField4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField4KeyTyped(evt);
            }
        });
        this.jLabel8.setText(bundle.getString("NewBuyTransactionJDialog_Clearing"));
        this.jLabel9.setText(bundle.getString("NewBuyTransactionJDialog_StampDuty"));
        this.jFormattedTextField5.setValue(new Double(0.0));
        this.jFormattedTextField5.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField5KeyTyped(evt);
            }
        });
        this.jFormattedTextField6.setEditable(false);
        this.jFormattedTextField6.setFont(this.jFormattedTextField6.getFont().deriveFont(this.jFormattedTextField6.getFont().getStyle() | 1));
        this.jFormattedTextField6.setValue(new Double(0.0));
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1));
        this.jLabel10.setText(bundle.getString("NewBuyTransactionJDialog_NetValue"));
        this.setDefaultCloseOperation(2);
        this.setTitle(bundle.getString("NewBuyTransactionJDialog_Buy"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                NewBuyTransactionJDialog.this.formWindowClosed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewBuyTransactionJDialog_Transaction")));
        this.jLabel2.setText(bundle.getString("NewSellTransactionJDialog_Symbol"));
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.001), null, (Number)100.0));
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.jSpinner1.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setMaximumFractionDigits(4);
        numberEditor.getTextField().addMouseListener(this.getJFormattedTextFieldMouseListener());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewBuyTransactionJDialog.this.jSpinner1StateChanged(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 255, 255));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jPanel3.setPreferredSize(new Dimension(100, 20));
        this.jLabel4.setText(bundle.getString("NewBuyTransactionJDialog_Date"));
        this.jFormattedTextField1.setValue(new Double(0.0));
        this.jFormattedTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField1KeyTyped(evt);
            }
        });
        this.jFormattedTextField2.setEditable(false);
        this.jFormattedTextField2.setFont(this.jFormattedTextField2.getFont().deriveFont(this.jFormattedTextField2.getFont().getStyle() | 1));
        this.jFormattedTextField2.setValue(new Double(0.0));
        this.jLabel1.setText(bundle.getString("NewBuyTransactionJDialog_Unit"));
        this.jLabel3.setText(bundle.getString("NewBuyTransactionJDialog_Price"));
        this.jLabel5.setFont(this.jLabel5.getFont().deriveFont(this.jLabel5.getFont().getStyle() | 1));
        this.jLabel5.setText(bundle.getString("NewBuyTransactionJDialog_Value"));
        this.jLabel11.setText(bundle.getString("NewBuyTransactionJDialog_Code"));
        this.jTextField2.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel11).addComponent(this.jLabel5)).addGap(26, 26, 26).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jFormattedTextField2, -1, 109, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 109, Short.MAX_VALUE).addComponent(this.jTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 109, Short.MAX_VALUE).addComponent(this.jSpinner1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField1, -1, 109, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jFormattedTextField1, this.jPanel3, this.jSpinner1, this.jTextField1);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(11, 11, 11).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jLabel3)).addGap(18, 18, 18).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jFormattedTextField2, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.jFormattedTextField1, this.jFormattedTextField2, this.jPanel3, this.jSpinner1, this.jTextField1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("NewBuyTransactionJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBuyTransactionJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("NewBuyTransactionJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBuyTransactionJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewBuyTransactionJDialog_Stock")));
        this.jPanel1.setLayout(new FlowLayout(1, 15, 5));
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/inbox.png")));
        this.jPanel1.add(this.jLabel6);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private boolean shouldAutoCalculateBrokerFee() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        return jStockOptions.isAutoBrokerFeeCalculationEnabled() && jStockOptions.getSelectedBrokingFirm() != null;
    }

    private void initComponents() {
        this.jComboBox1 = new AutoCompleteJComboBox();
        this.jPanel2 = new JPanel();
        this.jTextField1 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jPanel3 = CalendarFactory.createDateField();
        this.jLabel4 = new JLabel();
        this.jFormattedTextField1 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField2 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField3 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField4 = this.getCurrencyJFormattedTextField();
        this.jFormattedTextField5 = this.getCurrencyJFormattedTextField();
        this.jLabel10 = new JLabel();
        this.jFormattedTextField6 = this.getCurrencyJFormattedTextField();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jPanel4 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jComboBox1.setEditable(true);
        this.jComboBox1.setPreferredSize(new Dimension(110, 24));
        ((AutoCompleteJComboBox)this.jComboBox1).attachStockInfoObserver(this.getStockInfoObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachResultObserver(this.getResultObserver());
        ((AutoCompleteJComboBox)this.jComboBox1).attachMatchObserver(this.getMatchObserver());
        this.setDefaultCloseOperation(2);
        ResourceBundle bundle = ResourceBundle.getBundle("org/yccheok/jstock/data/gui");
        this.setTitle(bundle.getString("NewBuyTransactionJDialog_Buy"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                NewBuyTransactionJDialog.this.formWindowClosed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewBuyTransactionJDialog_Transaction")));
        this.jLabel2.setText(bundle.getString("NewSellTransactionJDialog_Symbol"));
        this.jSpinner1.setModel(new SpinnerNumberModel((Number)100.0, Double.valueOf(0.001), null, (Number)100.0));
        JSpinner.NumberEditor numberEditor = (JSpinner.NumberEditor)this.jSpinner1.getEditor();
        DecimalFormat decimalFormat = numberEditor.getFormat();
        decimalFormat.setMaximumFractionDigits(4);
        numberEditor.getTextField().addMouseListener(this.getJFormattedTextFieldMouseListener());
        this.jSpinner1.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                NewBuyTransactionJDialog.this.jSpinner1StateChanged(evt);
            }
        });
        this.jPanel3.setBackground(new Color(204, 255, 255));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        this.jPanel3.setPreferredSize(new Dimension(100, 20));
        this.jLabel4.setText(bundle.getString("NewBuyTransactionJDialog_Date"));
        this.jFormattedTextField1.setValue(new Double(0.0));
        this.jFormattedTextField1.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField1KeyTyped(evt);
            }
        });
        this.jFormattedTextField2.setEditable(false);
        this.jFormattedTextField2.setValue(new Double(0.0));
        this.jFormattedTextField3.setValue(new Double(0.0));
        this.jFormattedTextField3.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField3KeyTyped(evt);
            }
        });
        this.jFormattedTextField4.setValue(new Double(0.0));
        this.jFormattedTextField4.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField4KeyTyped(evt);
            }
        });
        this.jFormattedTextField5.setValue(new Double(0.0));
        this.jFormattedTextField5.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                NewBuyTransactionJDialog.this.jFormattedTextField5KeyTyped(evt);
            }
        });
        this.jLabel10.setFont(this.jLabel10.getFont().deriveFont(this.jLabel10.getFont().getStyle() | 1));
        this.jLabel10.setText(bundle.getString("NewBuyTransactionJDialog_NetValue"));
        this.jFormattedTextField6.setEditable(false);
        this.jFormattedTextField6.setFont(this.jFormattedTextField6.getFont().deriveFont(this.jFormattedTextField6.getFont().getStyle() | 1));
        this.jFormattedTextField6.setValue(new Double(0.0));
        this.jLabel1.setText(bundle.getString("NewBuyTransactionJDialog_Unit"));
        this.jLabel3.setText(bundle.getString("NewBuyTransactionJDialog_Price"));
        this.jLabel5.setText(bundle.getString("NewBuyTransactionJDialog_Value"));
        this.jLabel7.setText(bundle.getString("NewBuyTransactionJDialog_Broker"));
        this.jLabel8.setText(bundle.getString("NewBuyTransactionJDialog_Clearing"));
        this.jLabel9.setText(bundle.getString("NewBuyTransactionJDialog_StampDuty"));
        this.jLabel11.setText(bundle.getString("NewBuyTransactionJDialog_Code"));
        this.jTextField2.setEditable(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jFormattedTextField6, -1, 109, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel5).addComponent(this.jLabel7).addComponent(this.jLabel8).addComponent(this.jLabel1).addComponent(this.jLabel4).addComponent(this.jLabel11)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextField2).addComponent(this.jTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jPanel3, -1, 109, Short.MAX_VALUE).addComponent(this.jSpinner1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField1, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField2, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField3, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField4, -1, 109, Short.MAX_VALUE).addComponent(this.jFormattedTextField5, -1, 109, Short.MAX_VALUE)))).addContainerGap()));
        jPanel2Layout.linkSize(0, this.jFormattedTextField1, this.jFormattedTextField2, this.jFormattedTextField3, this.jFormattedTextField4, this.jFormattedTextField5, this.jFormattedTextField6, this.jPanel3, this.jSpinner1, this.jTextField1);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(11, 11, 11).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel11).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField1, -2, -1, -2)).addGap(12, 12, 12).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel1)).addGap(9, 9, 9).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField1, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField2, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField3, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField4, -2, -1, -2).addComponent(this.jLabel8)).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel9)).addGroup(jPanel2Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jFormattedTextField5, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 26, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jFormattedTextField6, -2, -1, -2).addComponent(this.jLabel10)).addContainerGap()));
        jPanel2Layout.linkSize(1, this.jFormattedTextField1, this.jFormattedTextField2, this.jFormattedTextField3, this.jFormattedTextField4, this.jFormattedTextField5, this.jFormattedTextField6, this.jPanel3, this.jSpinner1, this.jTextField1);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/apply.png")));
        this.jButton1.setText(bundle.getString("NewBuyTransactionJDialog_OK"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBuyTransactionJDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton1);
        this.jButton2.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/button_cancel.png")));
        this.jButton2.setText(bundle.getString("NewBuyTransactionJDialog_Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewBuyTransactionJDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jPanel4.add(this.jButton2);
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(bundle.getString("NewBuyTransactionJDialog_Stock")));
        this.jPanel1.setLayout(new FlowLayout(1, 15, 5));
        this.jLabel6.setIcon(new ImageIcon(this.getClass().getResource("/images/16x16/inbox.png")));
        this.jPanel1.add(this.jLabel6);
        this.getContentPane().add((Component)this.jPanel1, "North");
        this.pack();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.transaction = null;
        this.setVisible(false);
        this.dispose();
    }

    public void setTransaction(Transaction transaction) {
        this.stock = transaction.getStock();
        Code code = this.stock.code;
        Symbol symbol = this.stock.symbol;
        Date date = transaction.getDate().getCalendar().getTime();
        double quantity = transaction.getQuantity();
        double price = transaction.getPrice();
        double value = transaction.getTotal();
        double brokerFee = transaction.getBroker();
        double clearingFee = transaction.getClearingFee();
        double stampDuty = transaction.getStampDuty();
        double netValue = transaction.getNetTotal();
        this.transactionComment = transaction.getComment();
        this.jTextField2.setText(code.toString());
        this.jTextField1.setText(symbol.toString());
        ((DateField)this.jPanel3).setValue((Object)date);
        this.jSpinner1.setValue(quantity);
        this.jFormattedTextField1.setValue(price);
        this.jFormattedTextField2.setValue(value);
        this.jFormattedTextField3.setValue(brokerFee);
        this.jFormattedTextField4.setValue(clearingFee);
        this.jFormattedTextField5.setValue(stampDuty);
        this.jFormattedTextField6.setValue(netValue);
    }

    private Transaction generateTransaction() {
        DateField dateField = (DateField)this.jPanel3;
        SimpleDate date = new SimpleDate((Date)dateField.getValue());
        Contract.Type type = Contract.Type.Buy;
        double unit = (Double)this.jSpinner1.getValue();
        double price = (Double)this.jFormattedTextField1.getValue();
        Contract.ContractBuilder builder = new Contract.ContractBuilder(this.stock.deriveStock(Symbol.newInstance(this.jTextField1.getText().trim())), date);
        Contract contract = builder.type(type).quantity(unit).price(price).build();
        double brokerFeeValue = (Double)this.jFormattedTextField3.getValue();
        double stampDutyValue = (Double)this.jFormattedTextField5.getValue();
        double clearingFeeValue = (Double)this.jFormattedTextField4.getValue();
        Transaction t = new Transaction(contract, brokerFeeValue, stampDutyValue, clearingFeeValue);
        t.setComment(this.transactionComment);
        return t;
    }

    private boolean isValidInput() {
        MainFrame m;
        Object object;
        if (this.stock == null && (object = this.jComboBox1.getItemAt(0)) != null && (m = (MainFrame)this.getParent()) != null) {
            StockInfoDatabase stockInfoDatabase = m.getStockInfoDatabase();
            if (stockInfoDatabase == null) {
                log.info((Object)"Database is not ready yet.");
            } else {
                String string = object.toString().trim();
                StockInfo stockInfo = stockInfoDatabase.searchStockInfo(string);
                assert (stockInfo != null);
                Code code = stockInfo.code;
                Symbol symbol = stockInfo.symbol;
                assert (symbol != null);
                assert (code != null);
                this.stock = Utils.getEmptyStock(code, symbol);
                this.jTextField2.setText(code.toString());
                this.jTextField1.setText(symbol.toString());
                return false;
            }
        }
        if (this.stock == null) {
            this.jComboBox1.requestFocus();
            JOptionPane.showMessageDialog(this, MessagesBundle.getString("warning_message_please_enter_stock_symbol"), MessagesBundle.getString("warning_title_please_enter_stock_symbol"), 2);
            return false;
        }
        if (this.jTextField1.getText().trim().length() <= 0) {
            this.jTextField1.setText(this.stock.symbol.toString());
            return false;
        }
        if (this.jFormattedTextField1.getText().length() <= 0) {
            this.jFormattedTextField1.requestFocus();
            return false;
        }
        if (this.jFormattedTextField2.getText().length() <= 0) {
            this.jFormattedTextField2.requestFocus();
            return false;
        }
        if (this.jFormattedTextField3.getText().length() <= 0) {
            this.jFormattedTextField3.requestFocus();
            return false;
        }
        if (this.jFormattedTextField4.getText().length() <= 0) {
            this.jFormattedTextField4.requestFocus();
            return false;
        }
        if (this.jFormattedTextField5.getText().length() <= 0) {
            this.jFormattedTextField5.requestFocus();
            return false;
        }
        if (this.jFormattedTextField6.getText().length() <= 0) {
            this.jFormattedTextField6.requestFocus();
            return false;
        }
        return true;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (!this.isValidInput()) {
            return;
        }
        this.commitEdit();
        this.transaction = this.generateTransaction();
        this.setVisible(false);
        this.dispose();
    }

    private void commitEdit() {
        try {
            this.jFormattedTextField1.commitEdit();
            this.jFormattedTextField2.commitEdit();
            this.jFormattedTextField3.commitEdit();
            this.jFormattedTextField4.commitEdit();
            this.jFormattedTextField5.commitEdit();
            this.jFormattedTextField6.commitEdit();
        }
        catch (ParseException ex) {
            log.error(null, (Throwable)ex);
        }
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewBuyTransactionJDialog.this._update();
            }
        });
    }

    private void _update() {
        this.commitEdit();
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        boolean isFeeCalculationEnabled = jStockOptions.isFeeCalculationEnabled();
        if (isFeeCalculationEnabled && this.shouldAutoCalculateBrokerFee()) {
            BrokingFirm brokingFirm = MainFrame.getInstance().getJStockOptions().getSelectedBrokingFirm();
            String name = this.jTextField1.getText();
            double unit = (Double)this.jSpinner1.getValue();
            double price = (Double)this.jFormattedTextField1.getValue();
            DateField dateField = (DateField)this.jPanel3;
            Date date = (Date)dateField.getValue();
            Contract.ContractBuilder builder = new Contract.ContractBuilder(Utils.getEmptyStock(Code.newInstance(name), Symbol.newInstance(name)), new SimpleDate(date));
            Contract contract = builder.type(Contract.Type.Buy).quantity(unit).price(price).build();
            double brokerFee = brokingFirm.brokerCalculate(contract);
            double clearingFee = brokingFirm.clearingFeeCalculate(contract);
            double stampDuty = brokingFirm.stampDutyCalculate(contract);
            this.jFormattedTextField3.setValue(brokerFee);
            this.jFormattedTextField4.setValue(clearingFee);
            this.jFormattedTextField5.setValue(stampDuty);
            this.jFormattedTextField2.setValue(price * unit);
            this.jFormattedTextField6.setValue(price * unit + brokerFee + clearingFee + stampDuty);
        } else {
            double unit = (Double)this.jSpinner1.getValue();
            double price = (Double)this.jFormattedTextField1.getValue();
            double brokerFee = (Double)this.jFormattedTextField3.getValue();
            double clearingFee = (Double)this.jFormattedTextField4.getValue();
            double stampDuty = (Double)this.jFormattedTextField5.getValue();
            this.jFormattedTextField2.setValue(price * unit);
            if (isFeeCalculationEnabled) {
                this.jFormattedTextField6.setValue(price * unit + brokerFee + clearingFee + stampDuty);
            } else {
                this.jFormattedTextField6.setValue(price * unit);
            }
        }
    }

    private void jSpinner1StateChanged(ChangeEvent evt) {
        this.update();
    }

    private void dettachAllAndStopAutoCompleteJComboBox() {
        ((AutoCompleteJComboBox)this.jComboBox1).dettachAll();
        ((AutoCompleteJComboBox)this.jComboBox1).stop();
    }

    private void formWindowClosed(WindowEvent evt) {
        this.dettachAllAndStopAutoCompleteJComboBox();
    }

    private void jFormattedTextField1KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField3KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField4KeyTyped(KeyEvent evt) {
        this.update();
    }

    private void jFormattedTextField5KeyTyped(KeyEvent evt) {
        this.update();
    }

    private MouseListener getJFormattedTextFieldMouseListener() {
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent e) {
                if (e.getClickCount() == 2) {
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTextField tf = (JTextField)e.getSource();
                        int offset = tf.viewToModel(e.getPoint());
                        tf.setCaretPosition(offset);
                    }
                });
            }
        };
        return ml;
    }

    private JFormattedTextField getCurrencyJFormattedTextField() {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(4);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setMinimum(Double.valueOf(0.0));
        formatter.setValueClass(Double.class);
        JFormattedTextField formattedTextField = new JFormattedTextField(formatter);
        formattedTextField.addMouseListener(this.getJFormattedTextFieldMouseListener());
        return formattedTextField;
    }

    public void setPrice(double price) {
        this.jFormattedTextField1.setValue(price);
        this.update();
    }

    public void setJComboBoxEnabled(boolean enable) {
        this.jComboBox1.setEnabled(enable);
    }

    public void setStock(Stock stock) {
        if (stock != null) {
            Symbol symbol = stock.symbol;
            Code code = stock.code;
            this.jTextField1.setText(symbol.toString());
            this.jTextField2.setText(code.toString());
            this.jTextField1.setCaretPosition(0);
            this.jTextField2.setCaretPosition(0);
        } else {
            this.jTextField1.setText("");
            this.jTextField2.setText("");
        }
        this.stock = stock;
    }

    public void setStockSelectionEnabled(boolean flag) {
        this.jComboBox1.setEnabled(flag);
    }

    private void initAjaxProvider() {
        JStockOptions jStockOptions = MainFrame.getInstance().getJStockOptions();
        Country country = jStockOptions.getCountry();
        AutoCompleteJComboBox autoCompleteJComboBox = (AutoCompleteJComboBox)this.jComboBox1;
        if (country == Country.India) {
            autoCompleteJComboBox.setAjaxProvider(AjaxServiceProvider.Google, Arrays.asList("NSE", "BOM"));
            autoCompleteJComboBox.setGreedyEnabled(true, Arrays.asList("N", "B"));
        } else {
            autoCompleteJComboBox.setAjaxProvider(AjaxServiceProvider.Yahoo, Collections.<String>emptyList());
            autoCompleteJComboBox.setGreedyEnabled(false, Collections.<String>emptyList());
        }
    }

    public void setStockInfoDatabase(StockInfoDatabase stockInfoDatabase) {
        ((AutoCompleteJComboBox)this.jComboBox1).setStockInfoDatabase(stockInfoDatabase);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    private Observer<AutoCompleteJComboBox, MatchType> getMatchObserver() {
        return new Observer<AutoCompleteJComboBox, MatchType>(){

            @Override
            public void update(AutoCompleteJComboBox subject, MatchType matchType) {
                assert (matchType != null);
                Code code = matchType.getCode();
                Symbol symbol = Symbol.newInstance(matchType.n);
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                NewBuyTransactionJDialog.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
                MainFrame.getInstance().addUserDefinedStockInfo(stockInfo);
            }
        };
    }

    private Observer<AutoCompleteJComboBox, ResultType> getResultObserver() {
        return new Observer<AutoCompleteJComboBox, ResultType>(){

            @Override
            public void update(AutoCompleteJComboBox subject, ResultType resultType) {
                assert (resultType != null);
                Code code = Code.newInstance(resultType.symbol);
                Symbol symbol = Symbol.newInstance(resultType.name);
                StockInfo stockInfo = StockInfo.newInstance(code, symbol);
                NewBuyTransactionJDialog.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
                MainFrame.getInstance().addUserDefinedStockInfo(stockInfo);
            }
        };
    }

    private Observer<AutoCompleteJComboBox, StockInfo> getStockInfoObserver() {
        return new Observer<AutoCompleteJComboBox, StockInfo>(){

            @Override
            public void update(AutoCompleteJComboBox subject, StockInfo stockInfo) {
                assert (stockInfo != null);
                NewBuyTransactionJDialog.this.addStockInfoFromAutoCompleteJComboBox(stockInfo);
            }
        };
    }

    private void addStockInfoFromAutoCompleteJComboBox(StockInfo stockInfo) {
        this.stock = Utils.getEmptyStock(stockInfo);
        this.jTextField1.setText(this.stock.symbol.toString());
        this.jTextField2.setText(this.stock.code.toString());
        this.jTextField1.setCaretPosition(0);
        this.jTextField2.setCaretPosition(0);
    }
}

