/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import com.l2fprod.common.swing.JButtonBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.yccheok.jstock.gui.JStockOptions;
import org.yccheok.jstock.gui.JStockOptionsObserver;
import org.yccheok.jstock.gui.OptionGUIJPanel;
import org.yccheok.jstock.gui.OptionsAlertJPanel;
import org.yccheok.jstock.gui.OptionsBrokerJPanel;
import org.yccheok.jstock.gui.OptionsColorJPanel;
import org.yccheok.jstock.gui.OptionsIndicatorJPanel;
import org.yccheok.jstock.gui.OptionsNetworkJPanel;
import org.yccheok.jstock.gui.OptionsSellAdvisorJPanel;
import org.yccheok.jstock.gui.OptionsSpeedJPanel;
import org.yccheok.jstock.gui.OptionsUpdateJPanel;
import org.yccheok.jstock.internationalization.GUIBundle;

public class OptionsJPanel
extends JPanel
implements JStockOptionsObserver {
    private Component currentComponent;
    private OptionsAlertJPanel optionsAlertJPanel;
    private OptionsNetworkJPanel optionsNetworkJPanel;
    private OptionsIndicatorJPanel optionsIndicatorJPanel;
    private OptionsSpeedJPanel optionsSpeedJPanel;
    private OptionsColorJPanel optionsColorJPanel;
    private OptionsBrokerJPanel optionsBrokerJPanel;
    private OptionsSellAdvisorJPanel optionsSellAdvisorJPanel;
    private OptionGUIJPanel optionsGUIJPanel;
    private OptionsUpdateJPanel optionsUpdateJPanel;
    private Map<String, JToggleButton> map = new HashMap<String, JToggleButton>();
    private ButtonGroup buttonGroup1;
    private JButtonBar jButtonBar1;

    public OptionsJPanel() {
        this.initComponents();
        this.initOptionsJPanels();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jButtonBar1 = new JButtonBar(1);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jButtonBar1, "West");
    }

    private void addButton(String title, String iconUrl, final Component component, JButtonBar bar, ButtonGroup group) {
        AbstractAction action = new AbstractAction(title, new ImageIcon(OptionsJPanel.class.getResource(iconUrl))){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsJPanel.this.show(component);
            }
        };
        JToggleButton button = new JToggleButton(action);
        button.setVerticalTextPosition(3);
        button.setHorizontalTextPosition(0);
        bar.add((Component)button);
        this.map.put(title, button);
        group.add(button);
        if (group.getSelection() == null) {
            button.setSelected(true);
            this.show(component);
        }
    }

    private void show(Component component) {
        if (this.currentComponent != null) {
            this.remove(this.currentComponent);
        }
        this.currentComponent = component;
        this.add("Center", this.currentComponent);
        this.revalidate();
        this.repaint();
    }

    private void initOptionsJPanels() {
        this.optionsAlertJPanel = new OptionsAlertJPanel();
        this.optionsIndicatorJPanel = new OptionsIndicatorJPanel();
        this.optionsNetworkJPanel = new OptionsNetworkJPanel();
        this.optionsSpeedJPanel = new OptionsSpeedJPanel();
        this.optionsColorJPanel = new OptionsColorJPanel();
        this.optionsBrokerJPanel = new OptionsBrokerJPanel();
        this.optionsSellAdvisorJPanel = new OptionsSellAdvisorJPanel();
        this.optionsGUIJPanel = new OptionGUIJPanel();
        this.optionsUpdateJPanel = new OptionsUpdateJPanel();
        this.addButton(GUIBundle.getString("OptionsJPanel_Broker"), "/images/32x32/calc.png", this.optionsBrokerJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Wealth"), "/images/32x32/money3.png", this.optionsSellAdvisorJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Alert"), "/images/32x32/bell.png", this.optionsAlertJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_GUI"), "/images/32x32/kchart.png", this.optionsGUIJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Speed"), "/images/32x32/clock.png", this.optionsSpeedJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Color"), "/images/32x32/colors.png", this.optionsColorJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Network"), "/images/32x32/connect_to_network.png", this.optionsNetworkJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Indicator"), "/images/32x32/find.png", this.optionsIndicatorJPanel, this.jButtonBar1, this.buttonGroup1);
        this.addButton(GUIBundle.getString("OptionsJPanel_Update"), "/images/32x32/epiphany-download.png", this.optionsUpdateJPanel, this.jButtonBar1, this.buttonGroup1);
    }

    @Override
    public void set(JStockOptions jStockOptions) {
        this.optionsBrokerJPanel.set(jStockOptions);
        this.optionsColorJPanel.set(jStockOptions);
        this.optionsAlertJPanel.set(jStockOptions);
        this.optionsNetworkJPanel.set(jStockOptions);
        this.optionsIndicatorJPanel.set(jStockOptions);
        this.optionsSpeedJPanel.set(jStockOptions);
        this.optionsSellAdvisorJPanel.set(jStockOptions);
        this.optionsGUIJPanel.set(jStockOptions);
        this.optionsUpdateJPanel.set(jStockOptions);
    }

    public void cancel() {
        this.optionsNetworkJPanel.cancel();
        this.optionsAlertJPanel.cancel();
        this.optionsUpdateJPanel.cancel();
    }

    @Override
    public boolean apply(JStockOptions jStockOptions) {
        if (!this.optionsBrokerJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Broker"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsGUIJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_GUI"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsColorJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Color"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsAlertJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Alert"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsIndicatorJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Indicator"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsNetworkJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Network"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsSpeedJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Speed"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsSellAdvisorJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Wealth"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        if (!this.optionsUpdateJPanel.apply(jStockOptions)) {
            JToggleButton button = this.map.get(GUIBundle.getString("OptionsJPanel_Update"));
            button.setSelected(true);
            button.doClick();
            return false;
        }
        return true;
    }

    public void select(String buttonMapKey) {
        JToggleButton button = this.map.get(buttonMapKey);
        if (button == null) {
            return;
        }
        button.setSelected(true);
        button.doClick();
    }
}

