/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui;

import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.JRadioButton;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.engine.BrazilYahooStockServerFactory;
import org.yccheok.jstock.engine.Code;
import org.yccheok.jstock.engine.Country;
import org.yccheok.jstock.engine.GoogleStockServerFactory;
import org.yccheok.jstock.engine.Index;
import org.yccheok.jstock.engine.KLSEInfoStockServerFactory;
import org.yccheok.jstock.engine.StockNotFoundException;
import org.yccheok.jstock.engine.StockServer;
import org.yccheok.jstock.engine.StockServerFactory;
import org.yccheok.jstock.engine.YahooStockServerFactory;
import org.yccheok.jstock.gui.MainFrame;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.internationalization.GUIBundle;

public class StockServerFactoryJRadioButton
extends JRadioButton {
    private Status status = Status.Busy;
    private final StockServerFactory stockServerFactory;
    private static final Log log = LogFactory.getLog(StockServerFactoryJRadioButton.class);

    public StockServerFactoryJRadioButton(StockServerFactory stockServerFactory) {
        this.stockServerFactory = stockServerFactory;
        this.setStatus(Status.Busy);
        this.setToolTipText("Checking for server health...");
        Class<?> c = stockServerFactory.getClass();
        if (c == GoogleStockServerFactory.class) {
            this.setEnabled(false);
        }
        this.initSwingWorker();
    }

    public static String toReadableText(StockServerFactory stockServerFactory) {
        Class<?> c = stockServerFactory.getClass();
        if (c == BrazilYahooStockServerFactory.class) {
            return GUIBundle.getString("StockServerFactoryJRadioButton_BrazilYahooStockServerFactory");
        }
        if (c == YahooStockServerFactory.class) {
            return GUIBundle.getString("StockServerFactoryJRadioButton_YahooStockServerFactory");
        }
        if (c == GoogleStockServerFactory.class) {
            return GUIBundle.getString("StockServerFactoryJRadioButton_GoogleStockServerFactory");
        }
        return c.getSimpleName();
    }

    private Health getServerHealth() {
        List<Index> is;
        int is_size;
        Country country = MainFrame.getInstance().getJStockOptions().getCountry();
        Health health = new Health();
        Class<?> c = this.stockServerFactory.getClass();
        Code code = Code.newInstance("MSFT");
        if (c == BrazilYahooStockServerFactory.class) {
            code = Code.newInstance("BBDC4.SA");
        } else if (c == YahooStockServerFactory.class) {
            code = country == Country.India ? Code.newInstance("TATAPOWER.NS") : Code.newInstance("MSFT");
        } else if (c == GoogleStockServerFactory.class) {
            code = country == Country.India ? Code.newInstance("TATAPOWER.NS") : Code.newInstance("MSFT");
        } else if (c == KLSEInfoStockServerFactory.class) {
            code = Code.newInstance("1295.KL");
        }
        StockServer stockServer = this.stockServerFactory.getStockServer();
        if (stockServer != null) {
            try {
                stockServer.getStock(code);
                health.stock = true;
            }
            catch (StockNotFoundException ex) {
                log.error(null, (Throwable)ex);
            }
        }
        if (null != this.stockServerFactory.getStockHistoryServer(code)) {
            health.history = true;
        }
        if ((is_size = (is = org.yccheok.jstock.engine.Utils.getStockIndices(country)).size()) == this.stockServerFactory.getMarketServer().getMarkets(is).size()) {
            health.market = true;
        }
        return health;
    }

    private String toHTML(Health health) {
        String html = "<html><body>";
        html = health == null || !health.market ? html + "Index : <b>Failed</b><br/>" : html + "Index : <b>Success</b><br/>";
        html = health == null || !health.stock ? html + "Stock : <b>Failed</b><br/>" : html + "Stock : <b>Success</b><br/>";
        html = health == null || !health.history ? html + "History : <b>Failed</b><br/>" : html + "History : <b>Success</b><br/>";
        html = html + "</body></html>";
        return html;
    }

    private void initSwingWorker() {
        SwingWorker<Health, Void> worker = new SwingWorker<Health, Void>(){

            @Override
            public Health doInBackground() {
                return StockServerFactoryJRadioButton.this.getServerHealth();
            }

            @Override
            public void done() {
                if (this.isCancelled()) {
                    return;
                }
                Health health = null;
                try {
                    health = (Health)this.get();
                }
                catch (InterruptedException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (ExecutionException ex) {
                    log.error(null, (Throwable)ex);
                }
                catch (CancellationException ex) {
                    log.error(null, (Throwable)ex);
                }
                if (health == null || !health.isGood()) {
                    StockServerFactoryJRadioButton.this.setStatus(Status.Failed);
                } else {
                    StockServerFactoryJRadioButton.this.setStatus(Status.Success);
                }
                StockServerFactoryJRadioButton.this.setToolTipText(StockServerFactoryJRadioButton.this.toHTML(health));
            }
        };
        worker.execute();
    }

    public StockServerFactory getStockServerFactory() {
        return this.stockServerFactory;
    }

    private void setStatus(Status status) {
        this.status = status;
        String text = StockServerFactoryJRadioButton.toReadableText(this.stockServerFactory);
        String label = "<html><table cellpadding=0><tr><td><img src=\"" + status.getFileName() + "\"/></td><td width=" + 3 + "><td>" + text + "</td></tr></table></html>";
        this.setText(label);
    }

    private static enum Status {
        Busy(Utils.toHTMLFileSrcFormat(Utils.getExtraDataDirectory() + "spinner.gif")),
        Success(Utils.toHTMLFileSrcFormat(Utils.getExtraDataDirectory() + "network-transmit-receive.png")),
        Failed(Utils.toHTMLFileSrcFormat(Utils.getExtraDataDirectory() + "network-error.png"));

        private final String fileName;

        private Status(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    private static class Health {
        public boolean market = false;
        public boolean history = false;
        public boolean stock = false;

        private Health() {
        }

        public boolean isGood() {
            return this.market && this.history && this.stock;
        }
    }
}

