/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.gui.analysis;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.yccheok.jstock.analysis.OperatorIndicator;
import org.yccheok.jstock.gui.Utils;
import org.yccheok.jstock.network.Utils;

public class IndicatorDownloadManager {
    private static final Log log = LogFactory.getLog(IndicatorDownloadManager.class);
    private final List<Info> indicatorDownloadInfos = new ArrayList<Info>();

    public boolean add(Info indicatorDownloadInfo) {
        return this.indicatorDownloadInfos.add(indicatorDownloadInfo);
    }

    public Info get(int index) {
        return this.indicatorDownloadInfos.get(index);
    }

    public int size() {
        return this.indicatorDownloadInfos.size();
    }

    public static String getIndicatorDownloadManagerDescriptionFileLocation(OperatorIndicator.Type operatorIndicatorType) {
        if (operatorIndicatorType == OperatorIndicator.Type.AlertIndicator) {
            return org.yccheok.jstock.network.Utils.getURL(Utils.Type.ALERT_INDICATOR_DOWNLOAD_MANAGER_XML);
        }
        if (operatorIndicatorType == OperatorIndicator.Type.ModuleIndicator) {
            return org.yccheok.jstock.network.Utils.getURL(Utils.Type.MODULE_INDICATOR_DOWNLOAD_MANAGER_XML);
        }
        throw new IllegalArgumentException();
    }

    public static void main(String[] args) {
        IndicatorDownloadManager.deploy();
    }

    public static void deploy() {
        IndicatorDownloadManager me;
        try {
            me = new IndicatorDownloadManager();
            me.add(Info.newInstance("MACD Down Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\MACDDownTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MACDDownTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MACDDownTrendSignal.html"));
            me.add(Info.newInstance("MACD Up Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\MACDUpTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MACDUpTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MACDUpTrendSignal.html"));
            me.add(Info.newInstance("MFI Down Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\MFIDownTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MFIDownTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MFIDownTrendSignal.html"));
            me.add(Info.newInstance("MFI Up Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\MFIUpTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MFIUpTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/MFIUpTrendSignal.html"));
            me.add(Info.newInstance("RSI Sell Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\RSISellSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/RSISellSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/RSISellSignal.html"));
            me.add(Info.newInstance("RSI Buy Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\RSIBuySignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/RSIBuySignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/RSIBuySignal.html"));
            me.add(Info.newInstance("CCI Sell Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\CCISellSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/CCISellSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/CCISellSignal.html"));
            me.add(Info.newInstance("CCI Buy Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\CCIBuySignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/CCIBuySignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/CCIBuySignal.html"));
            me.add(Info.newInstance("Doji", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\Doji.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/Doji.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/Doji.html"));
            Utils.toXML((Object)me, "C:\\Projects\\jstock-static\\war\\alert_indicators\\indicator_download_manager.xml");
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(IndicatorDownloadManager.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            me = new IndicatorDownloadManager();
            me.add(Info.newInstance("MACD Down Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\MACDDownTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MACDDownTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MACDDownTrendSignal.html"));
            me.add(Info.newInstance("MACD Up Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\MACDUpTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MACDUpTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MACDUpTrendSignal.html"));
            me.add(Info.newInstance("MFI Down Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\MFIDownTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MFIDownTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MFIDownTrendSignal.html"));
            me.add(Info.newInstance("MFI Up Trend Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\MFIUpTrendSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MFIUpTrendSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/MFIUpTrendSignal.html"));
            me.add(Info.newInstance("RSI Sell Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\RSISellSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/RSISellSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/RSISellSignal.html"));
            me.add(Info.newInstance("RSI Buy Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\RSIBuySignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/RSIBuySignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/RSIBuySignal.html"));
            me.add(Info.newInstance("CCI Sell Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\CCISellSignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/CCISellSignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/CCISellSignal.html"));
            me.add(Info.newInstance("CCI Buy Signal", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\CCIBuySignal.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/CCIBuySignal.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/CCIBuySignal.html"));
            me.add(Info.newInstance("Doji", OperatorIndicator.Type.AlertIndicator, org.yccheok.jstock.analysis.Utils.getChecksum("C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\Doji.zip"), org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/Doji.zip", org.yccheok.jstock.network.Utils.getJStockStaticServer() + "alert_indicators/zh/Doji.html"));
            Utils.toXML((Object)me, "C:\\Projects\\jstock-static\\war\\alert_indicators\\zh\\indicator_download_manager.xml");
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(IndicatorDownloadManager.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static final class Info {
        public final String projectName;
        public final OperatorIndicator.Type type;
        public final long checksum;
        public final URL fileURL;
        public final URL descriptionURL;

        private Info(String projectName, OperatorIndicator.Type type, long checksum, URL fileURL, URL descriptionURL) {
            if (descriptionURL == null || fileURL == null || projectName == null) {
                throw new IllegalArgumentException("Method arguments cannot be null");
            }
            this.projectName = projectName;
            this.type = type;
            this.checksum = checksum;
            this.fileURL = fileURL;
            this.descriptionURL = descriptionURL;
        }

        public static Info newInstance(String projectName, OperatorIndicator.Type type, long checksum, URL fileURL, URL descriptionURL) {
            return new Info(projectName, type, checksum, fileURL, descriptionURL);
        }

        public static Info newInstance(String projectName, OperatorIndicator.Type type, long checksum, String fileLocation, String descriptionLocation) throws MalformedURLException {
            return new Info(projectName, type, checksum, new URL(fileLocation), new URL(descriptionLocation));
        }
    }
}

