/*
 * Decompiled with CFR 0.152.
 */
package org.yccheok.jstock.portfolio;

import java.util.ArrayList;
import java.util.List;
import org.yccheok.jstock.engine.Stock;
import org.yccheok.jstock.portfolio.AbstractSummary;
import org.yccheok.jstock.portfolio.Dividend;

public class DividendSummary
extends AbstractSummary<Dividend> {
    private transient double total = 0.0;
    private volatile transient boolean needEvaluation = false;
    private List<Dividend> dividends = new ArrayList<Dividend>();

    public DividendSummary() {
    }

    public DividendSummary(DividendSummary dividendSummary) {
        int size = dividendSummary.size();
        for (int i = 0; i < size; ++i) {
            this.add(new Dividend((Dividend)dividendSummary.get(i)));
        }
    }

    public double getTotal() {
        double tmp = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            tmp += ((Dividend)this.get((int)i)).amount;
        }
        return tmp;
    }

    public double getTotal(Stock stock) {
        double tmp = 0.0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            Dividend dividend = (Dividend)this.get(i);
            if (!dividend.stockInfo.code.equals(stock.code)) continue;
            tmp += dividend.amount;
        }
        return tmp;
    }

    @Override
    protected Object readResolve() {
        super.readResolve();
        for (Dividend dividen : this.dividends) {
            this.add(dividen);
        }
        return this;
    }
}

