/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.docs;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Link;
import com.google.gdata.data.docs.DocumentExportRequestor;
import com.google.gdata.data.docs.ExportDocId;
import com.google.gdata.data.docs.ExportStatus;
import com.google.gdata.data.docs.ObjectNumber;
import com.google.gdata.data.docs.QueryParameter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentExportEntry
extends BaseEntry<DocumentExportEntry> {
    public DocumentExportEntry() {
    }

    public DocumentExportEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(DocumentExportEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(DocumentExportEntry.class, ExportDocId.getDefaultDescription(false, true));
        extProfile.declare(DocumentExportEntry.class, DocumentExportRequestor.class);
        extProfile.declare(DocumentExportEntry.class, ObjectNumber.class);
        extProfile.declare(DocumentExportEntry.class, QueryParameter.getDefaultDescription(false, true));
        extProfile.declare(DocumentExportEntry.class, ExportStatus.class);
    }

    public List<ExportDocId> getExportDocIds() {
        return this.getRepeatingExtension(ExportDocId.class);
    }

    public void addExportDocId(ExportDocId exportDocId) {
        this.getExportDocIds().add(exportDocId);
    }

    public boolean hasExportDocIds() {
        return this.hasRepeatingExtension(ExportDocId.class);
    }

    public DocumentExportRequestor getExportRequestor() {
        return (DocumentExportRequestor)this.getExtension(DocumentExportRequestor.class);
    }

    public void setExportRequestor(DocumentExportRequestor exportRequestor) {
        if (exportRequestor == null) {
            this.removeExtension(DocumentExportRequestor.class);
        } else {
            this.setExtension((Extension)exportRequestor);
        }
    }

    public boolean hasExportRequestor() {
        return this.hasExtension(DocumentExportRequestor.class);
    }

    public ObjectNumber getObjectNumber() {
        return (ObjectNumber)this.getExtension(ObjectNumber.class);
    }

    public void setObjectNumber(ObjectNumber objectNumber) {
        if (objectNumber == null) {
            this.removeExtension(ObjectNumber.class);
        } else {
            this.setExtension((Extension)objectNumber);
        }
    }

    public boolean hasObjectNumber() {
        return this.hasExtension(ObjectNumber.class);
    }

    public List<QueryParameter> getQueries() {
        return this.getRepeatingExtension(QueryParameter.class);
    }

    public void addQuery(QueryParameter query) {
        this.getQueries().add(query);
    }

    public boolean hasQueries() {
        return this.hasRepeatingExtension(QueryParameter.class);
    }

    public ExportStatus getStatus() {
        return (ExportStatus)this.getExtension(ExportStatus.class);
    }

    public void setStatus(ExportStatus status) {
        if (status == null) {
            this.removeExtension(ExportStatus.class);
        } else {
            this.setExtension((Extension)status);
        }
    }

    public boolean hasStatus() {
        return this.hasExtension(ExportStatus.class);
    }

    public Link getDocumentExportLink() {
        return this.getLink("http://schemas.google.com/docs/2007#export", "application/zip");
    }

    protected void validate() {
    }

    public String toString() {
        return "{DocumentExportEntry " + super.toString() + "}";
    }
}

