/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPanel;

public final class PrintFormatter
extends JPanel
implements Printable {
    public static String[] checkTypeNames = new String[]{"Standard", "Voucher", "Wallet"};
    static final int STANDARD_CHECKS = 0;
    static final int VOUCHER_CHECKS = 1;
    static final int WALLET_CHECKS = 2;
    final double[] checkHeight = new double[]{3.5, 3.5, 2.83};
    final double[][] checkPrintCoords = new double[][]{{6.95, 0.95}, {1.17, 1.45}, {6.95, 1.45}, {0.5, 1.77}, {0.87, 2.95}, {1.0, 2.1}};
    final double[][] voucherFieldPrintCoords = new double[][]{{6.0, 0.45}, {0.85, 0.45}, {0.6, 0.6}, {7.25, 0.6}, {7.25, 3.25}, {2.0, 3.25}, {0.5, 3.25}};
    final double[][] walletCheckPrintCoords = new double[][]{{0.45, 0.77}, {7.3, 0.77}, {3.15, 0.93}, {7.1, 0.93}, {0.45, 1.1}, {2.85, 1.1}, {0.7, 1.6}, {2.85, 1.45}, {0.45, 1.95}, {0.45, 2.25}, {3.1, 2.27}, {0.45, 2.6}};
    PLCash parent;
    PrintManager manager;
    Account account;
    Vector checks;
    int length = 0;
    int currentCheck = 0;
    int checkType;
    TreeMap pageMap;
    double pageWidth;
    double pageHeight;
    PageFormat pageFormat;
    int checksOnFirstPage;

    public PrintFormatter(PLCash pLCash, Account account, PrintManager printManager, PageFormat pageFormat, Vector vector, int n) {
        this.parent = pLCash;
        this.account = account;
        this.manager = printManager;
        this.pageFormat = pageFormat;
        this.checks = vector;
        this.length = this.checks.size();
        this.checksOnFirstPage = n;
        this.setForeground(Color.black);
        this.setBackground(Color.white);
        this.pageMap = new TreeMap();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = n == 0 ? this.checksOnFirstPage : 3;
        this.checkType = this.parent.programValues.db_checkType;
        this.pageWidth = this.pageFormat.getWidth();
        this.pageHeight = this.pageFormat.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.setFont(new Font("SansSerif", 0, (int)(this.pageWidth / 72.0)));
        graphics2D.setFont(this.getFont());
        graphics2D.setColor(Color.black);
        graphics2D.setClip((int)this.pageFormat.getImageableX(), (int)this.pageFormat.getImageableY(), (int)this.pageFormat.getImageableWidth(), (int)this.pageFormat.getImageableHeight());
        double d = this.parent.commonCode.interpolate(this.parent.programValues.db_CheckPrintDeltaX, 0.0, this.manager.physPageWidth, 0.0, this.pageWidth);
        double d2 = this.parent.commonCode.interpolate(this.parent.programValues.db_CheckPrintDeltaY, 0.0, this.manager.physPageHeight, 0.0, this.pageHeight);
        graphics2D.translate(d, d2);
        Object v = this.pageMap.get("" + n);
        if (v != null) {
            this.currentCheck = (Integer)v;
        }
        this.pageMap.put("" + n, new Integer(this.currentCheck));
        if (this.currentCheck < this.length && this.formatCheckPage(graphics2D, this.pageFormat, this.checkType, n2)) {
            return 0;
        }
        return 1;
    }

    private boolean formatCheckPage(Graphics2D graphics2D, PageFormat pageFormat, int n, int n2) {
        int n3;
        boolean bl = false;
        if (n == 0) {
            for (n3 = 0; n3 < n2 && this.currentCheck < this.length; ++n3) {
                this.formatStandardCheck(graphics2D, this.currentCheck, n3);
                ++this.currentCheck;
                bl = true;
            }
        } else if (n == 1 && this.currentCheck < this.length) {
            this.formatStandardCheck(graphics2D, this.currentCheck, 0);
            this.formatVoucherField(graphics2D, this.currentCheck, 1);
            this.formatVoucherField(graphics2D, this.currentCheck, 2);
            ++this.currentCheck;
            bl = true;
        }
        if (n == 2) {
            for (n3 = 0; n3 < n2 && this.currentCheck < this.length; ++n3) {
                this.formatWalletCheck(graphics2D, this.currentCheck, n3);
                ++this.currentCheck;
                bl = true;
            }
        }
        return bl;
    }

    private void formatStandardCheck(Graphics2D graphics2D, int n, int n2) {
        Transaction transaction = (Transaction)this.checks.get(n);
        double d = Math.abs(transaction.db_Amount);
        this.drawStringAtCoords(transaction.displayDate, graphics2D, this.checkPrintCoords[0], n2);
        this.drawStringAtCoords(transaction.db_Payee, graphics2D, this.checkPrintCoords[1], n2);
        String string = this.parent.commonCode.getCurrencyDollarCentString(d, false);
        this.drawStringAtCoords("**" + string, graphics2D, this.checkPrintCoords[2], n2);
        String string2 = NumberAsWords.convert(d);
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (stringBuffer.length() < 120) {
            stringBuffer.append("*");
        }
        this.drawStringAtCoords(stringBuffer.toString(), graphics2D, this.checkPrintCoords[3], n2);
        this.drawStringAtCoords(transaction.db_Memo, graphics2D, this.checkPrintCoords[4], n2);
        if (transaction.db_Address.length() > 0) {
            this.formatAddress(transaction.db_Address, graphics2D, this.checkPrintCoords[5], n2);
        }
    }

    private void formatWalletCheck(Graphics2D graphics2D, int n, int n2) {
        Transaction transaction = (Transaction)this.checks.get(n);
        double d = Math.abs(transaction.db_Amount);
        this.drawStringAtCoords(transaction.displayDate, graphics2D, this.walletCheckPrintCoords[0], n2);
        this.drawStringAtCoords(transaction.displayDate, graphics2D, this.walletCheckPrintCoords[1], n2);
        this.drawStringAtCoords(transaction.db_Payee, graphics2D, this.walletCheckPrintCoords[2], n2);
        String string = this.parent.commonCode.getCurrencyDollarCentString(d, false);
        this.drawStringAtCoords("**" + string, graphics2D, this.walletCheckPrintCoords[3], n2);
        this.drawStringAtCoords(transaction.db_Payee, graphics2D, this.walletCheckPrintCoords[4], n2);
        String string2 = NumberAsWords.convert(d);
        StringBuffer stringBuffer = new StringBuffer(string2);
        while (stringBuffer.length() < 80) {
            stringBuffer.append("*");
        }
        this.drawStringAtCoords(stringBuffer.toString(), graphics2D, this.walletCheckPrintCoords[5], n2);
        this.drawStringAtCoords(string, graphics2D, this.walletCheckPrintCoords[6], n2);
        if (transaction.db_Address.length() > 0) {
            this.formatAddress(transaction.db_Address, graphics2D, this.walletCheckPrintCoords[7], n2);
        }
        this.drawStringAtCoords(transaction.db_Memo, graphics2D, this.walletCheckPrintCoords[8], n2);
        this.drawStringAtCoords(transaction.db_Category, graphics2D, this.walletCheckPrintCoords[9], n2);
        this.drawStringAtCoords(transaction.db_Memo, graphics2D, this.walletCheckPrintCoords[10], n2);
        this.drawStringAtCoords(this.account.db_Name, graphics2D, this.walletCheckPrintCoords[11], n2);
    }

    private void formatVoucherField(Graphics2D graphics2D, int n, int n2) {
        Transaction transaction = (Transaction)this.checks.get(n);
        double d = Math.abs(transaction.db_Amount);
        this.drawStringAtCoords(transaction.displayDate, graphics2D, this.voucherFieldPrintCoords[0], n2);
        this.drawStringAtCoords(transaction.db_Payee, graphics2D, this.voucherFieldPrintCoords[1], n2);
        this.drawStringAtCoords(transaction.db_Category, graphics2D, this.voucherFieldPrintCoords[2], n2);
        String string = this.parent.commonCode.getCurrencyDollarCentString(d, false);
        this.drawStringAtCoords(string, graphics2D, this.voucherFieldPrintCoords[3], n2);
        this.drawStringAtCoords(string, graphics2D, this.voucherFieldPrintCoords[4], n2);
        this.drawStringAtCoords(transaction.db_Memo, graphics2D, this.voucherFieldPrintCoords[5], n2);
        this.drawStringAtCoords(this.account.db_Name, graphics2D, this.voucherFieldPrintCoords[6], n2);
    }

    private void formatAddress(String string, Graphics2D graphics2D, double[] dArray, double d) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        double d2 = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
        d2 = this.parent.commonCode.interpolate(d2, 0.0, this.pageHeight, 0.0, this.manager.physPageHeight);
        String[] stringArray = string.split("\\\\n");
        for (int i = 0; i < stringArray.length; ++i) {
            double[] dArray2 = new double[]{dArray[0], dArray[1] + (double)i * d2};
            this.drawStringAtCoords(stringArray[i], graphics2D, dArray2, d);
        }
    }

    private void showDebuggingRectangle(Graphics2D graphics2D, PageFormat pageFormat) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(pageFormat.getImageableX(), pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        graphics2D.draw(double_);
    }

    private void drawCircle(Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(100.0, 100.0, 200.0, 200.0);
        graphics2D.setColor(Color.red);
        graphics2D.draw(double_);
    }

    private void drawStringAtCoords(String string, Graphics2D graphics2D, double[] dArray, double d) {
        graphics2D.setColor(Color.black);
        double d2 = this.parent.commonCode.interpolate(dArray[0], 0.0, this.manager.physPageWidth, 0.0, this.pageWidth);
        double d3 = this.parent.commonCode.interpolate(dArray[1] + d * this.checkHeight[this.checkType], 0.0, this.manager.physPageHeight, 0.0, this.pageHeight);
        graphics2D.drawString(string, (float)d2, (float)d3);
    }
}

