/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.File;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class ReportGeneratorForm
extends JPanel {
    PLCash parent;
    ReportGenerator reportGenerator = null;
    final String defaultName = "Default";
    JListCheckBox accountCheckList;
    JListCheckBox categoryCheckList;
    DateRangeCalculator drc = null;
    ButtonGroup buttonGroup;
    public ReportDesignData reportDesign;
    boolean changed = false;
    boolean noUpdate = false;
    private JScrollPane accountListScrollPane;
    private JPanel accountsPanel;
    private JButton allButton;
    private JButton allItemsButton;
    private JCheckBox autoShowReportCheckBox;
    private JPanel bottomPanel;
    private JCheckBox caseCheckBox;
    private JPanel categoriesPanel;
    private JScrollPane categoryListScrollPane;
    private JButton clearAllButton;
    private JButton clearAllCatsButton;
    private JButton closeFormButton;
    private JCheckBox debugCheckBox;
    private JCheckBox depositItemCheckBox;
    private JCheckBox expenseCheckBox;
    private JCheckBox expenseItemCheckBox;
    private JCheckBox extendedCheckBox;
    private JRadioButton formatRadioButton1;
    private JRadioButton formatRadioButton2;
    private JTextField fromDateTextField;
    private JButton generateButton;
    private JButton helpButton;
    private JButton helpButton2;
    private JButton helpButton3;
    private JButton helpButton4;
    private JCheckBox incomeCheckBox;
    private JCheckBox incomeItemCheckBox;
    private JComboBox intervalComboBox;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JScrollPane jScrollPane1;
    private JButton listReportsButton;
    private JButton noItemsButton;
    private JCheckBox outlayItemCheckBox;
    private JComboBox periodComboBox;
    private JPanel reportPanel;
    private JTabbedPane reportTabbedPane;
    private JTextArea resultTextArea;
    private JButton saveButton;
    private JCheckBox searchCheckBox;
    private JComboBox searchComboBox;
    private JLabel searchLabel1;
    private JLabel searchLabel2;
    private JPanel searchPanel;
    private JButton selectAllButton;
    private JButton selectAllCatsButton;
    private JCheckBox showAllAccountsCheckBox;
    private JCheckBox showSubCategoriesCheckBox;
    private JLabel summaryLabel;
    private JCheckBox taxableCheckBox;
    private JCheckBox taxableItemCheckBox;
    private JComboBox titleComboBox;
    private JTextField toDateTextField;
    private JCheckBox transferItemCheckBox;
    private JButton viewReportButton;

    public ReportGeneratorForm(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
        this.reportTabbedPane.addTab(this.parent.browserSetupPanel.browserLabel, this.parent.browserSetupPanel);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.formatRadioButton1);
        this.buttonGroup.add(this.formatRadioButton2);
        this.drc = new DateRangeCalculator(this.parent);
        this.periodComboBox.setModel(new DefaultComboBoxModel<String>(DateRangeCalculator.periodList));
        this.intervalComboBox.setModel(new DefaultComboBoxModel<String>(DateRangeCalculator.intervalList));
        this.accountCheckList = new JListCheckBox();
        this.accountListScrollPane.setViewportView(this.accountCheckList);
        this.categoryCheckList = new JListCheckBox();
        this.categoryListScrollPane.setViewportView(this.categoryCheckList);
        this.loadReportTitles();
        this.loadReportDesign("Default");
    }

    private void generateReport() {
        if (this.reportDesign != null) {
            this.summaryLabel.setText("Results: ");
            this.parent.accountHandler.saveOpenAccountList();
            this.reportGenerator = new ReportGenerator(this.parent, this);
            if (this.reportGenerator.process()) {
                this.summarize();
                this.saveReport(this.reportGenerator.webPage, this.reportDesign.webPagePath);
                this.saveReport(this.reportGenerator.tsvPage, this.reportDesign.tsvPagePath);
                this.autoShowReport();
            }
        }
    }

    public void summarize() {
        String string = this.reportGenerator.summarizeSearch();
        if (this.reportDesign.db_enableSearching) {
            this.addResult(string + "\n");
        }
        this.summaryLabel.setText("Results: " + string);
    }

    private void autoShowReport() {
        if (this.parent.programValues.db_autoShowReport && this.reportGenerator.matches > 0) {
            this.showReport();
        }
    }

    public void changeTabs(String string) {
        this.reportTabbedPane.setSelectedIndex(this.reportTabbedPane.indexOfTab(string));
    }

    private void saveReport(String string, String string2) {
        try {
            File file = new File(string2);
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(string);
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Account[] getAccountList() {
        Vector vector = this.accountCheckList.getSelectedItems();
        return vector.toArray(new Account[vector.size()]);
    }

    public String[] getSelectedCategoryList() {
        Vector vector = this.categoryCheckList.getSelectedItems();
        return vector.toArray(new String[vector.size()]);
    }

    public String[] getFullCategoryList() {
        return this.parent.categoryHandler.getDataKeys();
    }

    public HashSet getSelectedCategoryHash() {
        return this.categoryCheckList.getSelectedHash();
    }

    private void setSelectAllCategories(boolean bl) {
        this.categoryCheckList.setSelectedAll(bl);
    }

    private void setSelectAllAccounts(boolean bl) {
        this.accountCheckList.setSelectedAll(bl);
    }

    private void loadReportTitles() {
        File file = new File(this.parent.programValues.db_ReportFilePath);
        File[] fileArray = file.listFiles();
        Vector<String> vector = new Vector<String>();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getPath();
                if (!string.endsWith(".txt")) continue;
                ReportDesignData reportDesignData = new ReportDesignData(this.parent, "");
                reportDesignData.readValues(string);
                vector.add(reportDesignData.db_reportTitle);
            }
        }
        if (vector.size() == 0) {
            vector.add("Default");
        }
        this.wrapPCB(this.titleComboBox).setDataList(vector.toArray());
    }

    private PriorityComboBox wrapPCB(Object object) {
        return (PriorityComboBox)object;
    }

    private void loadReportDesign(String string) {
        this.titleComboBox.setSelectedItem(string);
    }

    private void loadReportDesign() {
        if (!this.wrapPCB((Object)this.titleComboBox).busy) {
            this.saveReportDesign2();
            Object object = this.titleComboBox.getSelectedItem();
            if (object != null) {
                this.loadReportDesign2(object.toString());
            }
        }
    }

    private void loadReportDesign2(String string) {
        this.reportDesign = new ReportDesignData(this.parent, string);
        this.reportDesign.readValues();
        this.setShowAllAccounts(this.reportDesign.db_listAllAccounts);
        this.setShowSubCategories(this.reportDesign.db_listSubCategories);
        this.wrapPCB(this.searchComboBox).setDataList(this.reportDesign.getSearchList());
        String[] stringArray = this.reportDesign.getCategoryList();
        this.categoryCheckList.setSelected(stringArray, true);
        stringArray = this.reportDesign.getAccountList();
        this.accountCheckList.setSelected(stringArray, true);
        this.intervalComboBox.setSelectedIndex(this.reportDesign.db_interval);
        this.periodComboBox.setSelectedIndex(this.reportDesign.db_period);
        this.incomeCheckBox.setSelected(this.reportDesign.db_showIncomeCat);
        this.expenseCheckBox.setSelected(this.reportDesign.db_showExpenseCat);
        this.taxableCheckBox.setSelected(this.reportDesign.db_showTaxableCat);
        this.searchCheckBox.setSelected(this.reportDesign.db_enableSearching);
        this.setReportFormat(this.reportDesign.db_CategoryReportFormat);
        this.extendedCheckBox.setSelected(this.reportDesign.db_extendedFormat);
        this.autoShowReportCheckBox.setSelected(this.parent.programValues.db_autoShowReport);
        this.debugCheckBox.setSelected(this.parent.programValues.db_ShowDebugData);
        this.caseCheckBox.setSelected(this.parent.programValues.db_CaseSensitiveReportSearch);
        this.enableSearch();
        this.writeFilterItems();
        this.computeDateRange();
    }

    private void setCustomStartDate() {
        this.noUpdate = true;
        this.periodComboBox.setSelectedIndex(0);
        this.reportDesign.db_period = 0;
        this.noUpdate = false;
        this.reportDesign.db_startDate = this.parent.commonCode.timeForDisplayDateLenient(this.fromDateTextField.getText());
    }

    private void setCustomEndDate() {
        this.noUpdate = true;
        this.periodComboBox.setSelectedIndex(0);
        this.reportDesign.db_period = 0;
        this.noUpdate = false;
        this.reportDesign.db_endDate = this.parent.commonCode.timeForDisplayDateLenient(this.toDateTextField.getText());
    }

    private void updateShowIncomeCat() {
        this.reportDesign.db_showIncomeCat = this.incomeCheckBox.isSelected();
        this.updateList();
    }

    private void updateShowExpenseCat() {
        this.reportDesign.db_showExpenseCat = this.expenseCheckBox.isSelected();
        this.updateList();
    }

    private void updateShowTaxableCat() {
        this.reportDesign.db_showTaxableCat = this.taxableCheckBox.isSelected();
        this.updateList();
    }

    private void setTimeInterval() {
        this.reportDesign.db_interval = this.intervalComboBox.getSelectedIndex();
    }

    private void triggerShowAllCat() {
        this.taxableCheckBox.setSelected(true);
        this.reportDesign.db_showTaxableCat = true;
        this.incomeCheckBox.setSelected(true);
        this.reportDesign.db_showIncomeCat = true;
        this.expenseCheckBox.setSelected(true);
        this.reportDesign.db_showExpenseCat = true;
        this.updateList();
    }

    private void saveReportDesign() {
        String string = this.titleComboBox.getSelectedItem().toString();
        this.wrapPCB(this.titleComboBox).addItemToList(string);
        this.reportDesign.rename(string);
        this.saveReportDesign2();
    }

    public void saveReportDesign2() {
        if (this.reportDesign != null) {
            this.collectValues();
            this.reportDesign.writeValues();
        }
    }

    private void collectValues() {
        this.reportDesign.setCategoryList(this.categoryCheckList.getSelectedStrings());
        this.reportDesign.setAccountList(this.accountCheckList.getSelectedStrings());
        this.reportDesign.setSearchList(this.wrapPCB(this.searchComboBox).getDataList());
        this.reportDesign.db_listSubCategories = this.showSubCategoriesCheckBox.isSelected();
        this.reportDesign.db_listAllAccounts = this.showAllAccountsCheckBox.isSelected();
        this.reportDesign.db_enableSearching = this.searchCheckBox.isSelected();
        this.reportDesign.db_period = this.periodComboBox.getSelectedIndex();
        this.reportDesign.db_interval = this.intervalComboBox.getSelectedIndex();
        this.reportDesign.db_CategoryReportFormat = this.getReportFormat();
        this.reportDesign.db_extendedFormat = this.extendedCheckBox.isSelected();
        this.parent.programValues.db_autoShowReport = this.autoShowReportCheckBox.isSelected();
        this.parent.programValues.db_ShowDebugData = this.debugCheckBox.isSelected();
        this.parent.programValues.db_CaseSensitiveReportSearch = this.caseCheckBox.isSelected();
        this.readFilterItems();
    }

    private void deleteReportDesign() {
        if (this.reportDesign == null) {
            this.parent.beep();
            return;
        }
        String string = this.reportDesign.db_reportTitle;
        int n = JOptionPane.showConfirmDialog(this, "Okay to delete report design \"" + string + "\"?", "Delete Report Design", 1);
        if (n == 0) {
            this.wrapPCB(this.titleComboBox).deleteItem(string);
            File file = new File(this.reportDesign.fullPath);
            file.delete();
            this.reportDesign = null;
            this.wrapPCB(this.titleComboBox).addItemToList("Default");
            this.loadReportDesign("Default");
        }
    }

    private void setShowAllCategories(ActionEvent actionEvent) {
        this.setShowSubCategories(((JCheckBox)actionEvent.getSource()).isSelected());
    }

    private void setShowSubCategories(boolean bl) {
        this.showSubCategoriesCheckBox.setSelected(bl);
        this.reportDesign.db_listSubCategories = bl;
        this.updateList();
    }

    private void updateList() {
        Object[] objectArray = this.parent.categoryHandler.getCategoryList(this.reportDesign.db_showIncomeCat, this.reportDesign.db_showExpenseCat, this.reportDesign.db_showTaxableCat, this.reportDesign.db_listSubCategories);
        this.categoryCheckList.replaceListData(objectArray);
        this.revalidate();
    }

    private void setShowAllAccounts(ActionEvent actionEvent) {
        this.setShowAllAccounts(((JCheckBox)actionEvent.getSource()).isSelected());
    }

    private void setShowAllAccounts(boolean bl) {
        this.showAllAccountsCheckBox.setSelected(bl);
        this.reportDesign.db_listAllAccounts = bl;
        Object[] objectArray = this.parent.accountHandler.getAccountList(bl);
        this.accountCheckList.replaceListData(objectArray);
        this.revalidate();
    }

    private void closeForm() {
        this.saveReportDesign();
        this.parent.closeReportForm();
    }

    private void computeDateRange() {
        if (!this.noUpdate) {
            int n = this.periodComboBox.getSelectedIndex();
            this.drc = new DateRangeCalculator(this.parent);
            if (this.drc.computeDates(n, this.reportDesign)) {
                this.fromDateTextField.setText(this.drc.getDisplayDateString(this.drc.getStartDate()));
                this.reportDesign.db_startDate = this.drc.getStartDate().getTimeInMillis();
                this.toDateTextField.setText(this.drc.getDisplayDateString(this.drc.getEndDate()));
                this.reportDesign.db_endDate = this.drc.getEndDate().getTimeInMillis();
            }
        }
    }

    private void setAllItemCheckBoxes() {
        this.allItemsChecked(true);
    }

    private void clearAllItemCheckBoxes() {
        this.allItemsChecked(false);
    }

    private void allItemsChecked(boolean bl) {
        this.incomeItemCheckBox.setSelected(bl);
        this.expenseItemCheckBox.setSelected(bl);
        this.taxableItemCheckBox.setSelected(bl);
        this.depositItemCheckBox.setSelected(bl);
        this.outlayItemCheckBox.setSelected(bl);
        this.transferItemCheckBox.setSelected(bl);
        this.readFilterItems();
    }

    public boolean readFilterItems() {
        this.reportDesign.db_filterIncomeItem = this.incomeItemCheckBox.isSelected();
        this.reportDesign.db_filterExpenseItem = this.expenseItemCheckBox.isSelected();
        this.reportDesign.db_filterTaxableItem = this.taxableItemCheckBox.isSelected();
        this.reportDesign.db_filterDepositItem = this.depositItemCheckBox.isSelected();
        this.reportDesign.db_filterOutlayItem = this.outlayItemCheckBox.isSelected();
        this.reportDesign.db_filterTransferItem = this.transferItemCheckBox.isSelected();
        return this.reportDesign.db_filterIncomeItem || this.reportDesign.db_filterExpenseItem || this.reportDesign.db_filterTaxableItem || this.reportDesign.db_filterDepositItem || this.reportDesign.db_filterOutlayItem || this.reportDesign.db_filterTransferItem;
    }

    private void writeFilterItems() {
        this.incomeItemCheckBox.setSelected(this.reportDesign.db_filterIncomeItem);
        this.expenseItemCheckBox.setSelected(this.reportDesign.db_filterExpenseItem);
        this.taxableItemCheckBox.setSelected(this.reportDesign.db_filterTaxableItem);
        this.depositItemCheckBox.setSelected(this.reportDesign.db_filterDepositItem);
        this.outlayItemCheckBox.setSelected(this.reportDesign.db_filterOutlayItem);
        this.transferItemCheckBox.setSelected(this.reportDesign.db_filterTransferItem);
    }

    private void enableSearch() {
        this.reportDesign.db_enableSearching = this.searchCheckBox.isSelected();
        this.searchComboBox.setEnabled(this.reportDesign.db_enableSearching);
        this.resultTextArea.setEnabled(this.reportDesign.db_enableSearching);
        this.searchLabel1.setEnabled(this.reportDesign.db_enableSearching);
        this.searchLabel2.setEnabled(this.reportDesign.db_enableSearching);
        this.caseCheckBox.setEnabled(this.reportDesign.db_enableSearching);
        this.debugCheckBox.setEnabled(this.reportDesign.db_enableSearching);
    }

    private void setupSearch() {
        SearchEngine searchEngine = new SearchEngine(this.parent, this);
    }

    public String getSearchString() {
        String string = (String)this.searchComboBox.getSelectedItem();
        ((PriorityComboBox)this.searchComboBox).addItemToList(string);
        return string;
    }

    public void showResult(String string) {
        this.resultTextArea.setText(string);
    }

    public void addResult(String string) {
        this.showResult(this.resultTextArea.getText() + string);
    }

    private boolean getReportFormat() {
        return this.buttonGroup.isSelected(this.formatRadioButton1.getModel());
    }

    private void saveReportFormat() {
        this.reportDesign.db_CategoryReportFormat = this.getReportFormat();
        this.extendedCheckBox.setEnabled(!this.reportDesign.db_CategoryReportFormat);
    }

    private void setReportFormat(boolean bl) {
        this.buttonGroup.setSelected(this.formatRadioButton1.getModel(), bl);
        this.buttonGroup.setSelected(this.formatRadioButton2.getModel(), !bl);
        this.extendedCheckBox.setEnabled(!bl);
    }

    private void setExtendedFormat() {
        this.reportDesign.db_extendedFormat = this.extendedCheckBox.isSelected();
    }

    private void setAutoShowReport() {
        this.parent.programValues.db_autoShowReport = this.autoShowReportCheckBox.isSelected();
    }

    public void showReport() {
        if (this.reportDesign.webPagePath != null && new File(this.reportDesign.webPagePath).exists()) {
            this.parent.launchPageWithFullPath(this.reportDesign.webPagePath);
        }
    }

    public void listReports() {
        this.parent.launchPageWithFullPath(this.parent.programValues.db_ReportWebPageFilePath);
    }

    private void handleDateKeyTyped(KeyEvent keyEvent) {
        this.parent.commonCode.handleDateFieldKey(keyEvent, true);
    }

    private void setDebugMode() {
        this.parent.programValues.db_ShowDebugData = this.debugCheckBox.isSelected();
    }

    private void setCaseInsensitive() {
        this.parent.programValues.db_CaseSensitiveReportSearch = this.caseCheckBox.isSelected();
    }

    private void help_report() {
        this.parent.launchHelp("AdvancedOperations.html#Report_Tab");
    }

    private void help_accounts() {
        this.parent.launchHelp("AdvancedOperations.html#Accounts_Tab");
    }

    private void help_categories() {
        this.parent.launchHelp("AdvancedOperations.html#Categories_Tab");
    }

    private void help_search() {
        this.parent.launchHelp("AdvancedOperations.html#Search_Tab");
    }

    private void initComponents() {
        this.bottomPanel = new JPanel();
        this.jButton1 = new MyJButton();
        this.saveButton = new MyJButton();
        this.generateButton = new MyJButton();
        this.viewReportButton = new MyJButton();
        this.listReportsButton = new MyJButton();
        this.closeFormButton = new MyJButton();
        this.reportTabbedPane = new JTabbedPane();
        this.reportPanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.intervalComboBox = new JComboBox();
        this.titleComboBox = new PriorityComboBox();
        this.jPanel3 = new JPanel();
        this.incomeItemCheckBox = new JCheckBox();
        this.expenseItemCheckBox = new JCheckBox();
        this.taxableItemCheckBox = new JCheckBox();
        this.depositItemCheckBox = new JCheckBox();
        this.outlayItemCheckBox = new JCheckBox();
        this.transferItemCheckBox = new JCheckBox();
        this.allItemsButton = new MyJButton();
        this.noItemsButton = new MyJButton();
        this.autoShowReportCheckBox = new JCheckBox();
        this.jPanel6 = new JPanel();
        this.jPanel1 = new JPanel();
        this.periodComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.fromDateTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.toDateTextField = new JTextField();
        this.jPanel5 = new JPanel();
        this.formatRadioButton1 = new JRadioButton();
        this.formatRadioButton2 = new JRadioButton();
        this.extendedCheckBox = new JCheckBox();
        this.summaryLabel = new JLabel();
        this.helpButton = new MyJButton();
        this.accountsPanel = new JPanel();
        this.accountListScrollPane = new JScrollPane();
        this.selectAllButton = new MyJButton();
        this.clearAllButton = new MyJButton();
        this.showAllAccountsCheckBox = new JCheckBox();
        this.helpButton2 = new MyJButton();
        this.categoriesPanel = new JPanel();
        this.categoryListScrollPane = new JScrollPane();
        this.selectAllCatsButton = new MyJButton();
        this.clearAllCatsButton = new MyJButton();
        this.showSubCategoriesCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.expenseCheckBox = new JCheckBox();
        this.incomeCheckBox = new JCheckBox();
        this.taxableCheckBox = new JCheckBox();
        this.allButton = new MyJButton();
        this.helpButton3 = new MyJButton();
        this.searchPanel = new JPanel();
        this.searchLabel1 = new JLabel();
        this.searchComboBox = new PriorityComboBox();
        this.searchLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.resultTextArea = new JTextArea();
        this.searchCheckBox = new JCheckBox();
        this.debugCheckBox = new JCheckBox();
        this.caseCheckBox = new JCheckBox();
        this.helpButton4 = new MyJButton();
        this.setBorder(BorderFactory.createTitledBorder("Report Generator"));
        this.setMinimumSize(new Dimension(0, 0));
        this.setLayout(new BorderLayout());
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/icons/Delete.png")));
        this.jButton1.setToolTipText("Delete report design");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.jButton1);
        this.saveButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Save.png")));
        this.saveButton.setToolTipText("Save report design");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.saveButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.saveButton);
        this.generateButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentDraw.png")));
        this.generateButton.setToolTipText("Generate report");
        this.generateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.generateButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.generateButton);
        this.viewReportButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/LaptopIn.png")));
        this.viewReportButton.setToolTipText("View Report");
        this.viewReportButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.viewReportButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.viewReportButton);
        this.listReportsButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/DocumentMag.png")));
        this.listReportsButton.setToolTipText("Display a list of past reports");
        this.listReportsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.listReportsButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.listReportsButton);
        this.closeFormButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/FolderOut.png")));
        this.closeFormButton.setToolTipText("Close this form");
        this.closeFormButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.closeFormButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.closeFormButton);
        this.add((Component)this.bottomPanel, "South");
        this.reportPanel.setBorder(BorderFactory.createTitledBorder("Report overview"));
        this.reportPanel.setLayout(new GridBagLayout());
        this.jLabel3.setText("Report Name:");
        this.jLabel3.setToolTipText("The report's name and filename");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.reportPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText("Intervals:");
        this.jLabel4.setToolTipText("The time interval for each column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.reportPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.intervalComboBox.setToolTipText("The time interval for each column");
        this.intervalComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.intervalComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.intervalComboBox, gridBagConstraints);
        this.titleComboBox.setEditable(true);
        this.titleComboBox.setToolTipText("Type a report name or choose an existing report");
        this.titleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.titleComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.titleComboBox, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Choose Transactions"));
        this.jPanel3.setLayout(new GridBagLayout());
        this.incomeItemCheckBox.setText("Income");
        this.incomeItemCheckBox.setToolTipText("Transactions classed as income");
        this.incomeItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.incomeItemCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.incomeItemCheckBox, gridBagConstraints);
        this.expenseItemCheckBox.setText("Expense");
        this.expenseItemCheckBox.setToolTipText("Transactions classed as expenses");
        this.expenseItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.expenseItemCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.expenseItemCheckBox, gridBagConstraints);
        this.taxableItemCheckBox.setText("Tax-related");
        this.taxableItemCheckBox.setToolTipText("Tax-related transactions");
        this.taxableItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.taxableItemCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.taxableItemCheckBox, gridBagConstraints);
        this.depositItemCheckBox.setText("Deposits");
        this.depositItemCheckBox.setToolTipText("Deposit transactions");
        this.depositItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.depositItemCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.depositItemCheckBox, gridBagConstraints);
        this.outlayItemCheckBox.setText("Payments");
        this.outlayItemCheckBox.setToolTipText("Payment transactions");
        this.outlayItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.outlayItemCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.outlayItemCheckBox, gridBagConstraints);
        this.transferItemCheckBox.setText("Transfers");
        this.transferItemCheckBox.setToolTipText("Transfers between acocunts");
        this.transferItemCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.transferItemCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.transferItemCheckBox, gridBagConstraints);
        this.allItemsButton.setText("All");
        this.allItemsButton.setToolTipText("Select all transaction types");
        this.allItemsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.allItemsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.allItemsButton, gridBagConstraints);
        this.noItemsButton.setText("None");
        this.noItemsButton.setToolTipText("Clear all transaction types");
        this.noItemsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.noItemsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel3.add((Component)this.noItemsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.jPanel3, gridBagConstraints);
        this.autoShowReportCheckBox.setText("Automatically display report when completed");
        this.autoShowReportCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.autoShowReportCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.autoShowReportCheckBox, gridBagConstraints);
        this.jPanel6.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Report Period"));
        this.jPanel1.setToolTipText("The time period for the report");
        this.jPanel1.setLayout(new GridBagLayout());
        this.periodComboBox.setToolTipText("The time period for the report");
        this.periodComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.periodComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel1.add((Component)this.periodComboBox, gridBagConstraints);
        this.jLabel1.setText("From:");
        this.jLabel1.setToolTipText("Report starting date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.fromDateTextField.setHorizontalAlignment(4);
        this.fromDateTextField.setText("00/00/0000");
        this.fromDateTextField.setToolTipText("Enter a starting date here");
        this.fromDateTextField.setMinimumSize(new Dimension(100, 19));
        this.fromDateTextField.setPreferredSize(new Dimension(100, 19));
        this.fromDateTextField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ReportGeneratorForm.this.fromDateTextFieldMouseWheelMoved(mouseWheelEvent);
            }
        });
        this.fromDateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ReportGeneratorForm.this.fromDateTextFieldKeyReleased(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ReportGeneratorForm.this.fromDateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel1.add((Component)this.fromDateTextField, gridBagConstraints);
        this.jLabel2.setText("To:");
        this.jLabel2.setToolTipText("Report Ending Date");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.toDateTextField.setHorizontalAlignment(4);
        this.toDateTextField.setText("00/00/0000");
        this.toDateTextField.setToolTipText("Enter an ending date here");
        this.toDateTextField.setMinimumSize(new Dimension(100, 19));
        this.toDateTextField.setPreferredSize(new Dimension(100, 19));
        this.toDateTextField.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                ReportGeneratorForm.this.toDateTextFieldMouseWheelMoved(mouseWheelEvent);
            }
        });
        this.toDateTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                ReportGeneratorForm.this.toDateTextFieldKeyReleased(keyEvent);
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ReportGeneratorForm.this.toDateTextFieldKeyTyped(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel1.add((Component)this.toDateTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel6.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel5.setBorder(BorderFactory.createTitledBorder("Report Format"));
        this.jPanel5.setLayout(new GridBagLayout());
        this.formatRadioButton1.setText("By category");
        this.formatRadioButton1.setToolTipText("Category rows, date columns");
        this.formatRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.formatRadioButton1ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel5.add((Component)this.formatRadioButton1, gridBagConstraints);
        this.formatRadioButton2.setText("By transaction ");
        this.formatRadioButton2.setToolTipText("Transaction rows, field columns");
        this.formatRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.formatRadioButton2ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel5.add((Component)this.formatRadioButton2, gridBagConstraints);
        this.extendedCheckBox.setText("Extended");
        this.extendedCheckBox.setToolTipText("Show securities-related fields");
        this.extendedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.extendedCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel5.add((Component)this.extendedCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.jPanel6.add((Component)this.jPanel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.jPanel6, gridBagConstraints);
        this.summaryLabel.setText("Results:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.summaryLabel, gridBagConstraints);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton.setText("Help");
        this.helpButton.setToolTipText("Provide context-sensitive help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.helpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(1, 1, 1, 1);
        this.reportPanel.add((Component)this.helpButton, gridBagConstraints);
        this.reportTabbedPane.addTab("Report", this.reportPanel);
        this.accountsPanel.setBorder(BorderFactory.createTitledBorder("Accounts to include in report"));
        this.accountsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.accountsPanel.add((Component)this.accountListScrollPane, gridBagConstraints);
        this.selectAllButton.setText("Select All Accounts");
        this.selectAllButton.setToolTipText("");
        this.selectAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.selectAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.accountsPanel.add((Component)this.selectAllButton, gridBagConstraints);
        this.clearAllButton.setText("Clear All Accounts");
        this.clearAllButton.setToolTipText("");
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.clearAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.accountsPanel.add((Component)this.clearAllButton, gridBagConstraints);
        this.showAllAccountsCheckBox.setText("Show HIdden Accounts");
        this.showAllAccountsCheckBox.setToolTipText("");
        this.showAllAccountsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.showAllAccountsCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.accountsPanel.add((Component)this.showAllAccountsCheckBox, gridBagConstraints);
        this.helpButton2.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton2.setText("Help");
        this.helpButton2.setToolTipText("Provide context-sensitive help");
        this.helpButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.helpButton2ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.accountsPanel.add((Component)this.helpButton2, gridBagConstraints);
        this.reportTabbedPane.addTab("Accounts", this.accountsPanel);
        this.categoriesPanel.setBorder(BorderFactory.createTitledBorder("Categories to include in report"));
        this.categoriesPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.categoriesPanel.add((Component)this.categoryListScrollPane, gridBagConstraints);
        this.selectAllCatsButton.setText("Select All Displayed");
        this.selectAllCatsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.selectAllCatsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.categoriesPanel.add((Component)this.selectAllCatsButton, gridBagConstraints);
        this.clearAllCatsButton.setText("Clear All Categories");
        this.clearAllCatsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.clearAllCatsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.categoriesPanel.add((Component)this.clearAllCatsButton, gridBagConstraints);
        this.showSubCategoriesCheckBox.setText("Show subcategories");
        this.showSubCategoriesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.showSubCategoriesCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.categoriesPanel.add((Component)this.showSubCategoriesCheckBox, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Categories to display"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.expenseCheckBox.setText("Expense");
        this.expenseCheckBox.setToolTipText("List categories identified as expenses");
        this.expenseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.expenseCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.expenseCheckBox, gridBagConstraints);
        this.incomeCheckBox.setText("Income");
        this.incomeCheckBox.setToolTipText("List categories identified as income");
        this.incomeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.incomeCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.incomeCheckBox, gridBagConstraints);
        this.taxableCheckBox.setText("Taxable");
        this.taxableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.taxableCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.taxableCheckBox, gridBagConstraints);
        this.allButton.setText("All");
        this.allButton.setToolTipText("List all categories");
        this.allButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.allButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.allButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.categoriesPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.helpButton3.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton3.setText("Help");
        this.helpButton3.setToolTipText("Provide context-sensitive help");
        this.helpButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.helpButton3ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.categoriesPanel.add((Component)this.helpButton3, gridBagConstraints);
        this.reportTabbedPane.addTab("Categories", this.categoriesPanel);
        this.searchPanel.setBorder(BorderFactory.createTitledBorder("Transactions to search for"));
        this.searchPanel.setLayout(new GridBagLayout());
        this.searchLabel1.setText("Enter search:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.searchLabel1, gridBagConstraints);
        this.searchComboBox.setEditable(true);
        this.searchComboBox.setToolTipText("Type a search string here");
        this.searchComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.searchComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.searchComboBox, gridBagConstraints);
        this.searchLabel2.setText("Results:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.searchLabel2, gridBagConstraints);
        this.resultTextArea.setFont(new Font("Courier", 0, 12));
        this.resultTextArea.setToolTipText("Outcome of search and any error messages");
        this.jScrollPane1.setViewportView(this.resultTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.jScrollPane1, gridBagConstraints);
        this.searchCheckBox.setText("Enable Searching");
        this.searchCheckBox.setToolTipText("Allow this search to filter transactions");
        this.searchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.searchCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.searchCheckBox, gridBagConstraints);
        this.debugCheckBox.setText("Show debug info");
        this.debugCheckBox.setToolTipText("Display parsing errors and other information");
        this.debugCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.debugCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.debugCheckBox, gridBagConstraints);
        this.caseCheckBox.setText("Case");
        this.caseCheckBox.setToolTipText("Make search case sensitive");
        this.caseCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.caseCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.searchPanel.add((Component)this.caseCheckBox, gridBagConstraints);
        this.helpButton4.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton4.setText("Help");
        this.helpButton4.setToolTipText("Provide context-sensitive help");
        this.helpButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReportGeneratorForm.this.helpButton4ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        this.searchPanel.add((Component)this.helpButton4, gridBagConstraints);
        this.reportTabbedPane.addTab("Search", this.searchPanel);
        this.add((Component)this.reportTabbedPane, "Center");
    }

    private void helpButton3ActionPerformed(ActionEvent actionEvent) {
        this.help_categories();
    }

    private void helpButton4ActionPerformed(ActionEvent actionEvent) {
        this.help_search();
    }

    private void helpButton2ActionPerformed(ActionEvent actionEvent) {
        this.help_accounts();
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.help_report();
    }

    private void caseCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setCaseInsensitive();
    }

    private void debugCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setDebugMode();
    }

    private void listReportsButtonActionPerformed(ActionEvent actionEvent) {
        this.listReports();
    }

    private void toDateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.handleDateKeyTyped(keyEvent);
    }

    private void fromDateTextFieldKeyTyped(KeyEvent keyEvent) {
        this.handleDateKeyTyped(keyEvent);
    }

    private void autoShowReportCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setAutoShowReport();
    }

    private void viewReportButtonActionPerformed(ActionEvent actionEvent) {
        this.showReport();
    }

    private void extendedCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setExtendedFormat();
    }

    private void formatRadioButton2ActionPerformed(ActionEvent actionEvent) {
        this.saveReportFormat();
    }

    private void formatRadioButton1ActionPerformed(ActionEvent actionEvent) {
        this.saveReportFormat();
    }

    private void searchComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setupSearch();
    }

    private void searchCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.enableSearch();
    }

    private void transferItemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.readFilterItems();
    }

    private void outlayItemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.readFilterItems();
    }

    private void depositItemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.readFilterItems();
    }

    private void taxableItemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.readFilterItems();
    }

    private void expenseItemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.readFilterItems();
    }

    private void incomeItemCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.readFilterItems();
    }

    private void noItemsButtonActionPerformed(ActionEvent actionEvent) {
        this.clearAllItemCheckBoxes();
    }

    private void allItemsButtonActionPerformed(ActionEvent actionEvent) {
        this.setAllItemCheckBoxes();
    }

    private void intervalComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setTimeInterval();
    }

    private void generateButtonActionPerformed(ActionEvent actionEvent) {
        this.generateReport();
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.deleteReportDesign();
    }

    private void toDateTextFieldKeyReleased(KeyEvent keyEvent) {
        this.setCustomEndDate();
    }

    private void fromDateTextFieldKeyReleased(KeyEvent keyEvent) {
        this.setCustomStartDate();
    }

    private void allButtonActionPerformed(ActionEvent actionEvent) {
        this.triggerShowAllCat();
    }

    private void taxableCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateShowTaxableCat();
    }

    private void incomeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateShowIncomeCat();
    }

    private void expenseCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateShowExpenseCat();
    }

    private void titleComboBoxActionPerformed(ActionEvent actionEvent) {
        this.loadReportDesign();
    }

    private void saveButtonActionPerformed(ActionEvent actionEvent) {
        this.saveReportDesign();
    }

    private void periodComboBoxActionPerformed(ActionEvent actionEvent) {
        this.computeDateRange();
    }

    private void showSubCategoriesCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setShowAllCategories(actionEvent);
    }

    private void clearAllCatsButtonActionPerformed(ActionEvent actionEvent) {
        this.setSelectAllCategories(false);
    }

    private void selectAllCatsButtonActionPerformed(ActionEvent actionEvent) {
        this.setSelectAllCategories(true);
    }

    private void showAllAccountsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setShowAllAccounts(actionEvent);
    }

    private void clearAllButtonActionPerformed(ActionEvent actionEvent) {
        this.setSelectAllAccounts(false);
    }

    private void selectAllButtonActionPerformed(ActionEvent actionEvent) {
        this.setSelectAllAccounts(true);
    }

    private void closeFormButtonActionPerformed(ActionEvent actionEvent) {
        this.closeForm();
    }

    private void fromDateTextFieldMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.parent.commonCode.handleDateFieldMouseWheel(mouseWheelEvent, true);
    }

    private void toDateTextFieldMouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.parent.commonCode.handleDateFieldMouseWheel(mouseWheelEvent, true);
    }
}

