/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxHost;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.DumpWriter;
import com.dropbox.core.util.Dumpable;
import com.dropbox.core.util.StringUtil;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public class DbxAppInfo
extends Dumpable {
    private final String key;
    private final String secret;
    private final DbxHost host;
    public static final JsonReader<DbxAppInfo> Reader = new JsonReader<DbxAppInfo>(){

        @Override
        public final DbxAppInfo read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String key = null;
            String secret = null;
            DbxHost host = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                parser.nextToken();
                try {
                    if (fieldName.equals("key")) {
                        key = KeyReader.readField(parser, fieldName, key);
                        continue;
                    }
                    if (fieldName.equals("secret")) {
                        secret = SecretReader.readField(parser, fieldName, secret);
                        continue;
                    }
                    if (fieldName.equals("host")) {
                        host = DbxHost.Reader.readField(parser, fieldName, host);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (key == null) {
                throw new JsonReadException("missing field \"key\"", top);
            }
            if (host == null) {
                host = DbxHost.DEFAULT;
            }
            return new DbxAppInfo(key, secret, host);
        }
    };
    public static final JsonReader<String> KeyReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                String error = DbxAppInfo.getKeyFormatError(v);
                if (error != null) {
                    throw new JsonReadException("bad format for app key: " + error, parser.getTokenLocation());
                }
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };
    public static final JsonReader<String> SecretReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                String error = DbxAppInfo.getKeyFormatError(v);
                if (error != null) {
                    throw new JsonReadException("bad format for app secret: " + error, parser.getTokenLocation());
                }
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };

    public DbxAppInfo(String key) {
        this(key, null);
    }

    public DbxAppInfo(String key, String secret) {
        DbxAppInfo.checkKeyArg(key);
        DbxAppInfo.checkSecretArg(secret);
        this.key = key;
        this.secret = secret;
        this.host = DbxHost.DEFAULT;
    }

    public DbxAppInfo(String key, String secret, DbxHost host) {
        DbxAppInfo.checkKeyArg(key);
        DbxAppInfo.checkSecretArg(secret);
        this.key = key;
        this.secret = secret;
        this.host = host;
    }

    public String getKey() {
        return this.key;
    }

    public String getSecret() {
        return this.secret;
    }

    public DbxHost getHost() {
        return this.host;
    }

    public boolean hasSecret() {
        return this.secret != null;
    }

    @Override
    protected void dumpFields(DumpWriter out) {
        out.f("key").v(this.key);
        out.f("secret").v(this.secret);
    }

    public static String getKeyFormatError(String key) {
        return DbxAppInfo.getTokenPartError(key);
    }

    public static String getSecretFormatError(String key) {
        return DbxAppInfo.getTokenPartError(key);
    }

    public static String getTokenPartError(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return "can't be empty";
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '!' && c <= '~') continue;
            return "invalid character at index " + i + ": " + StringUtil.jq("" + c);
        }
        return null;
    }

    public static void checkKeyArg(String key) {
        String error = key == null ? "can't be null" : DbxAppInfo.getTokenPartError(key);
        if (error == null) {
            return;
        }
        throw new IllegalArgumentException("Bad 'key': " + error);
    }

    public static void checkSecretArg(String secret) {
        String error = DbxAppInfo.getTokenPartError(secret);
        if (error == null) {
            return;
        }
        throw new IllegalArgumentException("Bad 'secret': " + error);
    }
}

