/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.table;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.table.JTable;
import com.fathzer.soft.ajlib.swing.table.RowHeaderRenderer;
import com.fathzer.soft.ajlib.swing.table.RowModel;
import com.fathzer.soft.ajlib.swing.table.TitledRowsTableModel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;

public class Table
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JScrollPane scrollPane;
    private JTable table;
    private JTable rowView;

    public Table() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout(0, 0));
        this.add(this.getScrollPane());
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.setRowHeaderView(this.getRowJTable());
            this.scrollPane.setViewportView(this.getJTable());
        }
        return this.scrollPane;
    }

    public final JTable getRowJTable() {
        if (this.rowView == null) {
            this.rowView = new JTable();
            this.rowView.setDefaultRenderer(Object.class, new RowHeaderRenderer());
            this.rowView.setFocusable(false);
            this.rowView.setCellSelectionEnabled(false);
            this.setRowViewSize(this.rowView);
        }
        return this.rowView;
    }

    private void setRowViewSize(JTable rowView) {
        int width = 0;
        for (int i = 0; i < rowView.getColumnCount(); ++i) {
            width += Utils.packColumn(rowView, i, 2);
        }
        Dimension d = rowView.getPreferredScrollableViewportSize();
        d.width = width;
        rowView.setPreferredScrollableViewportSize(d);
    }

    public final JTable getJTable() {
        if (this.table == null) {
            this.table = this.buildJTable();
            if (this.table.getModel() instanceof TitledRowsTableModel) {
                this.installModelInRowJTable((TitledRowsTableModel)this.table.getModel());
            }
        }
        return this.table;
    }

    protected JTable buildJTable() {
        return new JTable();
    }

    public void setModel(TableModel model) {
        this.table.setModel(model);
        if (model instanceof TitledRowsTableModel) {
            this.installModelInRowJTable((TitledRowsTableModel)model);
        }
    }

    private void installModelInRowJTable(TitledRowsTableModel model) {
        RowModel rowHeaderModel = new RowModel(model);
        this.getRowJTable().setModel(rowHeaderModel);
        this.getRowJTable().getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnSelectionChanged(ListSelectionEvent e) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                Table.this.setRowViewSize(Table.this.getRowJTable());
            }

            @Override
            public void columnMoved(TableColumnModelEvent e) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent e) {
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                Table.this.setRowViewSize(Table.this.getRowJTable());
            }
        });
        this.setRowViewSize(this.getRowJTable());
    }

    public TableModel getModel() {
        return this.getJTable().getModel();
    }

    public int getRowHeight() {
        return this.getJTable().getRowHeight();
    }

    public void setRowHeight(int rowHeight) {
        this.getJTable().setRowHeight(rowHeight);
        this.getRowJTable().setRowHeight(rowHeight);
    }
}

