/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.IntegerWidget;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PageSelector
extends JPanel {
    private static final String RES_PATH = "/com/fathzer/soft/ajlib/swing/widget/";
    public static final String PAGE_SELECTED_PROPERTY_NAME = "PageSelected";
    private static final long serialVersionUID = 1L;
    private IntegerWidget pageNumber;
    private JButton nextPage;
    private JButton lastPage;
    private JButton previousPage;
    private JButton firstPage;
    private int pageCount = 0;
    private int currentPage = -1;
    private JLabel sizeLabel;

    public PageSelector() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints gbcFirstPage = new GridBagConstraints();
        gbcFirstPage.insets = new Insets(0, 0, 0, 5);
        gbcFirstPage.weighty = 1.0;
        gbcFirstPage.fill = 3;
        gbcFirstPage.gridx = 1;
        gbcFirstPage.gridy = 0;
        this.add((Component)this.getFirstPage(), gbcFirstPage);
        GridBagConstraints gbcPageNumber = new GridBagConstraints();
        gbcPageNumber.gridx = 3;
        gbcPageNumber.gridy = 0;
        gbcPageNumber.fill = 3;
        this.add((Component)this.getPageNumber(), gbcPageNumber);
        this.sizeLabel = new JLabel("/" + this.pageCount);
        GridBagConstraints gbcLabel = new GridBagConstraints();
        gbcLabel.insets = new Insets(0, 0, 0, 5);
        gbcLabel.gridx = 4;
        gbcLabel.gridy = 0;
        this.add((Component)this.sizeLabel, gbcLabel);
        GridBagConstraints gbcNextPage = new GridBagConstraints();
        gbcNextPage.fill = 3;
        gbcNextPage.insets = new Insets(0, 0, 0, 5);
        gbcNextPage.gridx = 5;
        gbcNextPage.gridy = 0;
        this.add((Component)this.getNextPage(), gbcNextPage);
        GridBagConstraints gbcLastPage = new GridBagConstraints();
        gbcLastPage.fill = 3;
        gbcLastPage.gridx = 6;
        gbcLastPage.gridy = 0;
        this.add((Component)this.getLastPage(), gbcLastPage);
        GridBagConstraints gbcPreviousPage = new GridBagConstraints();
        gbcPreviousPage.fill = 3;
        gbcPreviousPage.insets = new Insets(0, 0, 0, 5);
        gbcPreviousPage.gridx = 2;
        gbcPreviousPage.gridy = 0;
        this.add((Component)this.getPreviousPage(), gbcPreviousPage);
        this.restoreButtonStates();
    }

    public IntegerWidget getPageNumber() {
        if (this.pageNumber == null) {
            this.pageNumber = new IntegerWidget(this.pageCount == 0 ? BigInteger.ZERO : BigInteger.ONE, BigInteger.valueOf(this.pageCount));
            this.pageNumber.setColumns(2);
            this.pageNumber.addPropertyChangeListener("VALUE_PROPERTY", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getNewValue() != null) {
                        PageSelector.this.setPage(((BigInteger)evt.getNewValue()).intValue() - 1);
                    } else {
                        PageSelector.this.setPage(-1);
                    }
                }
            });
        }
        return this.pageNumber;
    }

    public JButton getNextPage() {
        if (this.nextPage == null) {
            this.nextPage = new JButton();
            this.nextPage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageSelector.this.setPage(PageSelector.this.getCurrentPage() + 1);
                }
            });
            this.nextPage.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/next.png"), 16 * this.getFont().getSize() / 12));
            this.setSelectionButtonSize(this.nextPage);
        }
        return this.nextPage;
    }

    public JButton getLastPage() {
        if (this.lastPage == null) {
            this.lastPage = new JButton();
            this.lastPage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageSelector.this.setPage(PageSelector.this.pageCount - 1);
                }
            });
            this.lastPage.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/last.png"), 16 * this.getFont().getSize() / 12));
            this.setSelectionButtonSize(this.lastPage);
        }
        return this.lastPage;
    }

    public JButton getPreviousPage() {
        if (this.previousPage == null) {
            this.previousPage = new JButton();
            this.previousPage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageSelector.this.setPage(PageSelector.this.getCurrentPage() - 1);
                }
            });
            this.previousPage.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/previous.png"), 16 * this.getFont().getSize() / 12));
            this.setSelectionButtonSize(this.previousPage);
        }
        return this.previousPage;
    }

    public JButton getFirstPage() {
        if (this.firstPage == null) {
            this.firstPage = new JButton();
            this.firstPage.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PageSelector.this.setPage(0);
                }
            });
            this.firstPage.setIcon(Utils.createIcon(this.getClass().getResource("/com/fathzer/soft/ajlib/swing/widget/first.png"), 16 * this.getFont().getSize() / 12));
            this.setSelectionButtonSize(this.firstPage);
        }
        return this.firstPage;
    }

    public void setPage(int index) {
        if (index >= this.getPageCount() || index < -1) {
            throw new IllegalArgumentException();
        }
        int old = this.getCurrentPage();
        if (index != old) {
            this.currentPage = index;
            this.pageNumber.setValue(index < 0 ? null : Integer.valueOf(index + 1));
            this.restoreButtonStates();
            this.firePropertyChange(PAGE_SELECTED_PROPERTY_NAME, old, this.currentPage);
        }
    }

    private void restoreButtonStates() {
        this.firstPage.setEnabled(this.getCurrentPage() > 0);
        this.previousPage.setEnabled(this.getCurrentPage() > 0);
        this.nextPage.setEnabled(this.getCurrentPage() < this.getPageCount() - 1);
        this.lastPage.setEnabled(this.getCurrentPage() < this.getPageCount() - 1);
    }

    private void setSelectionButtonSize(JButton button) {
        Dimension preferredSize = button.getPreferredSize();
        preferredSize.width = preferredSize.height;
        button.setPreferredSize(preferredSize);
    }

    public void setPageCount(int pageCount) {
        if (pageCount < 0) {
            throw new IllegalArgumentException();
        }
        this.pageCount = pageCount;
        BigInteger min = pageCount == 0 ? BigInteger.ZERO : BigInteger.ONE;
        BigInteger max = BigInteger.valueOf(pageCount);
        this.getPageNumber().setRange(min, max);
        this.sizeLabel.setText("/" + pageCount);
        if (this.getCurrentPage() >= pageCount) {
            this.setPage(pageCount - 1);
        } else {
            this.restoreButtonStates();
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }
}

