/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.ajlib.swing.widget.date;

import com.fathzer.soft.ajlib.swing.Utils;
import com.fathzer.soft.ajlib.swing.widget.date.CalendarWidget;
import com.fathzer.soft.ajlib.swing.widget.date.DateField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class DateWidget
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String DATE_PROPERTY = "date";
    public static final String CONTENT_VALID_PROPERTY = "contentValid";
    private DateField dateField = null;
    private CalendarWidget dateChooser;
    private JPopupMenu popup = new JPopupMenu();
    private JLabel jLabel = null;

    public DateWidget() {
        this.dateChooser = new CalendarWidget();
        this.popup.add(this.dateChooser);
        this.initialize();
        this.dateChooser.addPropertyChangeListener("DATE_PROPERTY", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DateWidget.this.getDateField().setDate((Date)evt.getNewValue());
                DateWidget.this.popup.setVisible(false);
            }
        });
    }

    public Date getDate() {
        return this.getDateField().getDate();
    }

    public void setDate(Date date) {
        this.getDateField().setDate(date);
    }

    public void setColumns(int nb) {
        this.getDateField().setColumns(nb);
    }

    @Override
    public void setLocale(Locale locale) {
        this.getDateField().setLocale(locale);
        this.dateChooser.setLocale(locale);
    }

    @Override
    public void setToolTipText(String text) {
        this.getDateField().setToolTipText(text);
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.fill = 3;
        gridBagConstraints11.gridy = 0;
        this.jLabel = new JLabel();
        this.jLabel.setIcon(Utils.createIcon(DateWidget.class.getResource("/com/fathzer/soft/ajlib/swing/widget/date/calendar.png"), 16 * this.getFont().getSize() / 12));
        this.jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DateWidget.this.jLabel.isEnabled() && !DateWidget.this.popup.isVisible()) {
                    DateField widget = DateWidget.this.getDateField();
                    DateWidget.this.dateChooser.setDate(widget.getDate());
                    DateWidget.this.popup.show(widget, 0, widget.getHeight());
                }
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getDateField(), gridBagConstraints);
        this.add((Component)this.jLabel, gridBagConstraints11);
    }

    public DateField getDateField() {
        if (this.dateField == null) {
            this.dateField = new DateField();
            PropertyChangeListener listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DateWidget.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
                }
            };
            this.dateField.addPropertyChangeListener(DATE_PROPERTY, listener);
            this.dateField.addPropertyChangeListener(CONTENT_VALID_PROPERTY, listener);
        }
        return this.dateField;
    }

    public void setIsEmptyNullDateIsValid(boolean valid) {
        this.getDateField().setIsEmptyNullDateIsValid(valid);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.dateField.setEnabled(enabled);
        this.jLabel.setEnabled(enabled);
    }

    public boolean isContentValid() {
        return this.dateField.isContentValid();
    }
}

