/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.dropbox;

import com.dropbox.client2.session.AccessTokenPair;
import com.dropbox.core.BadResponseCodeException;
import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxOAuth1AccessToken;
import com.dropbox.core.DbxOAuth1Upgrader;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.NetworkIOException;
import com.dropbox.core.ProtocolException;
import com.dropbox.core.ServerException;
import com.dropbox.core.v2.DbxClientV2;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.GetMetadataErrorException;
import com.dropbox.core.v2.files.ListFolderResult;
import com.dropbox.core.v2.files.ListRevisionsBuilder;
import com.dropbox.core.v2.files.Metadata;
import com.dropbox.core.v2.files.UploadBuilder;
import com.dropbox.core.v2.files.UploadUploader;
import com.dropbox.core.v2.files.WriteMode;
import com.dropbox.core.v2.users.SpaceAllocation;
import com.dropbox.core.v2.users.SpaceUsage;
import com.fathzer.soft.ajlib.utilities.StringUtils;
import com.fathzer.soft.jclop.Account;
import com.fathzer.soft.jclop.Cancellable;
import com.fathzer.soft.jclop.Entry;
import com.fathzer.soft.jclop.HostErrorException;
import com.fathzer.soft.jclop.InvalidConnectionDataException;
import com.fathzer.soft.jclop.JClopException;
import com.fathzer.soft.jclop.NoSpaceRemainingException;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.UnreachableHostException;
import com.fathzer.soft.jclop.dropbox.DbxConnectionData;
import com.fathzer.soft.jclop.dropbox.swing.MessagePack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.NoRouteToHostException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropboxService
extends Service {
    private static final String OAUTH2_PREFIX = "OAuth2-";
    private static final Logger LOGGER = LoggerFactory.getLogger(DropboxService.class);
    private static final int WAIT_DELAY = 30;
    private static final boolean SLOW_READING = Boolean.getBoolean("slowDataReading");
    public static final String URI_SCHEME = "dropbox";
    private DbxConnectionData data;
    private DbxClientV2 currentApi;
    private String currentId;

    public DropboxService(File root, DbxConnectionData data) throws IOException {
        super(root, false);
        this.data = data;
        this.currentId = null;
    }

    private DbxClientV2 getDropboxAPI(Account account) throws TokenUpgradeException {
        if (!account.getId().equals(this.currentId)) {
            Object connectionData = account.getConnectionData();
            if (connectionData instanceof AccessTokenPair) {
                connectionData = this.upgradeToken(((AccessTokenPair)connectionData).key, ((AccessTokenPair)connectionData).secret);
                account.setConnectionData((Serializable)connectionData);
                LOGGER.info("OAuth1 token upgraded");
            }
            this.currentApi = new DbxClientV2(this.data.getConfig(), (String)connectionData);
            this.currentId = account.getId();
        }
        return this.currentApi;
    }

    @Override
    public String getScheme() {
        return URI_SCHEME;
    }

    @Override
    public Collection<Entry> getRemoteEntries(Account account, Cancellable task) throws JClopException {
        DbxClientV2 api = this.getDropboxAPI(account);
        try {
            SpaceUsage spaceUsage = api.users().getSpaceUsage();
            SpaceAllocation allocation = spaceUsage.getAllocation();
            long quota = allocation.isIndividual() ? allocation.getIndividualValue().getAllocated() : allocation.getTeamValue().getAllocated();
            account.setQuota(quota);
            account.setUsed(spaceUsage.getUsed());
            if (task.isCancelled()) {
                return null;
            }
            ArrayList<Entry> result = new ArrayList<Entry>();
            ListFolderResult files = api.files().listFolder("");
            while (true) {
                for (Metadata metadata : files.getEntries()) {
                    Entry jclopEntry = this.getRemoteEntry(account, metadata.getName());
                    if (jclopEntry == null) continue;
                    result.add(jclopEntry);
                }
                if (!files.getHasMore()) break;
                files = api.files().listFolderContinue(files.getCursor());
            }
            return result;
        }
        catch (DbxException e) {
            throw this.getException(e);
        }
    }

    private JClopException getServerException(ServerException e) {
        return new HostErrorException(e);
    }

    private JClopException getException(DbxException e) throws JClopException {
        if (e instanceof BadResponseCodeException && ((BadResponseCodeException)e).getStatusCode() == 507) {
            return new NoSpaceRemainingException(e);
        }
        if (e instanceof InvalidAccessTokenException) {
            return new InvalidConnectionDataException(e);
        }
        if (e instanceof ProtocolException) {
            return new HostErrorException(e);
        }
        if (e instanceof NetworkIOException) {
            return new UnreachableHostException(e);
        }
        if (e instanceof ServerException) {
            return this.getServerException((ServerException)e);
        }
        Throwable cause = e.getCause();
        if (cause instanceof UnknownHostException || cause instanceof NoRouteToHostException) {
            return new UnreachableHostException(e);
        }
        throw new JClopException((Throwable)e){
            private static final long serialVersionUID = 1L;
        };
    }

    @Override
    public String getConnectionDataURIFragment(Serializable connectionData) {
        return OAUTH2_PREFIX + connectionData;
    }

    @Override
    public Serializable getConnectionData(String uriFragment) {
        if (uriFragment.startsWith(OAUTH2_PREFIX)) {
            return uriFragment.substring(OAUTH2_PREFIX.length());
        }
        String[] split = StringUtils.split(uriFragment, '-');
        return new AccessTokenPair(split[0], split[1]);
    }

    private String upgradeToken(String key, String secret) throws TokenUpgradeException {
        DbxOAuth1Upgrader upgrader = new DbxOAuth1Upgrader(this.getConnectionData().getConfig(), this.getConnectionData().getAppInfo());
        try {
            return upgrader.createOAuth2AccessToken(new DbxOAuth1AccessToken(key, secret));
        }
        catch (DbxException e) {
            throw new TokenUpgradeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean download(URI uri, OutputStream out, Cancellable task, Locale locale) throws JClopException, IOException {
        Entry entry = this.getEntry(uri);
        try {
            String path = this.getRemotePath(entry);
            DbxClientV2 api = this.getDropboxAPI(entry.getAccount());
            long totalSize = -1L;
            DbxDownloader<FileMetadata> downloader = api.files().download(path);
            if (task != null) {
                task.setPhase(this.getMessage("com.fathzer.soft.jclop.downloading", locale), downloader.getResult().getSize() > 0L ? 100 : -1);
            }
            InputStream dropboxStream = downloader.getInputStream();
            try {
                byte[] buf = new byte[1024];
                long red = 0L;
                int len = dropboxStream.read(buf);
                while (len > 0) {
                    out.write(buf, 0, len);
                    if (SLOW_READING) {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    if (task != null) {
                        if (task.isCancelled()) {
                            boolean e = false;
                            return e;
                        }
                        if (totalSize > 0L) {
                            int progress = (int)((red += (long)len) * 100L / totalSize);
                            task.reportProgress(progress);
                        }
                    }
                    len = dropboxStream.read(buf);
                }
                boolean bl = true;
                return bl;
            }
            finally {
                dropboxStream.close();
            }
        }
        catch (DbxException e) {
            throw this.getException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean upload(InputStream in, long length, URI uri, Cancellable task, Locale locale) throws JClopException, IOException {
        Entry entry = this.getEntry(uri);
        if (task != null) {
            task.setPhase(this.getMessage("com.fathzer.soft.jclop.uploading", locale), -1);
        }
        int chunkSize = (int)Math.min(Integer.MAX_VALUE, length);
        UploadBuilder uploaderBuilder = this.getDropboxAPI(entry.getAccount()).files().uploadBuilder(this.getRemotePath(entry));
        String rev = this.getRemoteRevision(uri);
        uploaderBuilder.withMode(rev == null ? WriteMode.ADD : WriteMode.update(rev));
        try {
            final UploadUploader uploader = uploaderBuilder.start();
            try {
                int bytesRead;
                if (task != null) {
                    task.setCancelAction(new Runnable(){

                        @Override
                        public void run() {
                            uploader.abort();
                        }
                    });
                }
                byte[] buffer = new byte[chunkSize];
                OutputStream out = uploader.getOutputStream();
                for (long byteSent = 0L; byteSent < length; byteSent += (long)bytesRead) {
                    int remaining = (int)Math.min(length - byteSent, (long)chunkSize);
                    bytesRead = in.read(buffer, 0, chunkSize);
                    if (bytesRead != remaining) {
                        uploader.abort();
                        throw new IOException("Premature end of input stream");
                    }
                    out.write(buffer, 0, bytesRead);
                    if (task == null || !task.isCancelled()) continue;
                    break;
                }
                if (task != null && task.isCancelled()) {
                    uploader.abort();
                } else {
                    out.flush();
                    uploader.finish();
                }
            }
            finally {
                uploader.close();
            }
        }
        catch (DbxException e) {
            throw this.getException(e);
        }
        finally {
            if (task != null) {
                task.setCancelAction(null);
            }
        }
        return task == null || !task.isCancelled();
    }

    @Override
    public String getRemoteRevision(URI uri) throws JClopException {
        Entry entry = this.getEntry(uri);
        DbxClientV2 api = this.getDropboxAPI(entry.getAccount());
        try {
            String remotePath = this.getRemotePath(entry);
            if (this.remoteExists(api, remotePath)) {
                ListRevisionsBuilder builder = api.files().listRevisionsBuilder(remotePath);
                builder.withLimit(1L);
                List<FileMetadata> revisions = builder.start().getEntries();
                return revisions.get(0).getRev();
            }
            return null;
        }
        catch (DbxException e) {
            throw this.getException(e);
        }
    }

    private boolean remoteExists(DbxClientV2 api, String remotePath) throws DbxException {
        try {
            api.files().getMetadata(remotePath);
            return true;
        }
        catch (GetMetadataErrorException e) {
            if (e.errorValue.isPath() && e.errorValue.getPathValue().isNotFound()) {
                return false;
            }
            throw e;
        }
    }

    @Override
    public String getMessage(String key, Locale locale) {
        try {
            String serviceKey = this.getClass().getPackage().getName() + key.substring("com.fathzer.soft.jclop".length());
            String result = MessagePack.getString(serviceKey, locale);
            return result;
        }
        catch (MissingResourceException e) {
            return com.fathzer.soft.jclop.swing.MessagePack.DEFAULT.getString(key, locale);
        }
    }

    @Override
    public Entry getEntry(URI uri) {
        if (!uri.getScheme().equals(this.getScheme())) {
            throw new IllegalArgumentException();
        }
        try {
            String path = URLDecoder.decode(uri.getPath().substring(1), "UTF-8");
            int index = path.indexOf(47);
            String accountName = path.substring(0, index);
            path = path.substring(index + 1);
            String[] split = StringUtils.split(uri.getUserInfo(), ':');
            String accountId = URLDecoder.decode(split[0], "UTF-8");
            Account account = this.getAccount(accountId);
            if (account == null) {
                Serializable connectionData = this.getConnectionData(split[1]);
                account = this.newAccount(accountId, accountName, connectionData);
            }
            return new Entry(account, path);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public DbxConnectionData getConnectionData() {
        return this.data;
    }

    public void setDisplayName(Account account) throws JClopException {
        try {
            account.setDisplayName(this.getDropboxAPI(account).users().getCurrentAccount().getName().getDisplayName());
        }
        catch (DbxException e) {
            throw this.getException(e);
        }
    }

    private static class TokenUpgradeException
    extends JClopException {
        private static final long serialVersionUID = -6814530850231595921L;

        public TokenUpgradeException(Throwable cause) {
            super(cause);
        }
    }
}

