/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.soft.jclop.swing;

import com.fathzer.soft.ajlib.swing.dialog.FileChooser;
import com.fathzer.soft.ajlib.utilities.NullUtils;
import com.fathzer.soft.jclop.FileSystemService;
import com.fathzer.soft.jclop.Service;
import com.fathzer.soft.jclop.swing.MessagePack;
import com.fathzer.soft.jclop.swing.URIChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class FileChooserPanel
extends JPanel
implements URIChooser {
    public static final String SCHEME = "file";
    private FileChooser fileChooser;

    public FileChooserPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getFileChooser(), "Center");
        this.getFileChooser().addPropertyChangeListener("SelectedFileChangedProperty", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                File newFile;
                URI newURI;
                File oldFile = (File)evt.getOldValue();
                URI oldURI = oldFile == null ? null : oldFile.toURI();
                if (!NullUtils.areEquals(oldURI, newURI = (newFile = (File)evt.getNewValue()) == null || newFile.isDirectory() || FileChooserPanel.this.getFileChooser().getDialogType() == 0 && !newFile.isFile() ? null : newFile.toURI())) {
                    FileChooserPanel.this.firePropertyChange("selectedUri", oldURI, newURI);
                }
            }
        });
    }

    @Override
    public String getTitle() {
        return MessagePack.DEFAULT.getString("com.fathzer.soft.jclop.FileChooserPanel.title", this.getLocale());
    }

    @Override
    public String getTooltip(boolean save) {
        return MessagePack.DEFAULT.getString(save ? "com.fathzer.soft.jclop.FileChooserPanel.tooltip.save" : "com.fathzer.soft.jclop.FileChooserPanel.tooltip.open", this.getLocale());
    }

    @Override
    public Icon getIcon() {
        return new ImageIcon(this.getClass().getResource("computer.png"));
    }

    private FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new FileChooser();
            this.fileChooser.setSelectionTestEnabled(false);
            this.fileChooser.setControlButtonsAreShown(false);
            this.fileChooser.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if ("ApproveSelection".equals(e.getActionCommand())) {
                        FileChooserPanel.this.firePropertyChange("uriApproved", false, true);
                    }
                }
            });
        }
        return this.fileChooser;
    }

    @Override
    public boolean updateSelectedURI() {
        return this.getFileChooser().isGetSelectedFileFixed();
    }

    @Override
    public URI getSelectedURI() {
        File selectedFile = this.getFileChooser().getSelectedFile();
        return selectedFile == null ? null : selectedFile.toURI();
    }

    @Override
    public void setUp() {
    }

    @Override
    public void setSaveType(boolean save) {
        this.fileChooser.setDialogType(save ? 1 : 0);
    }

    @Override
    public void setSelectedURI(URI uri) {
        if (uri == null) {
            if (this.fileChooser.getSelectedFile() != null) {
                this.fileChooser.setSelectedFiles(null);
            }
        } else {
            File file = new File(uri);
            if (this.getFileChooser().getDialogType() == 0) {
                if (file.isFile()) {
                    this.fileChooser.setSelectedFile(file);
                }
            } else if (!file.isDirectory()) {
                this.fileChooser.setSelectedFile(file);
            }
        }
    }

    @Override
    public String getScheme() {
        return SCHEME;
    }

    @Override
    public boolean isSelectedExist() {
        File selectedFile = this.getFileChooser().getSelectedFile();
        return selectedFile != null && selectedFile.exists();
    }

    @Override
    public String getDisabledCause() {
        FileChooser fc = this.getFileChooser();
        return fc.isGetSelectedFileFixed() ? fc.getDisabledCause() : null;
    }

    @Override
    public void setLocale(Locale locale) {
        this.getFileChooser().setLocale(locale);
        super.setLocale(locale);
    }

    @Override
    public Service getService() {
        return FileSystemService.INSTANCE;
    }
}

