/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.currency;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Calendar;
import java.util.TimeZone;
import net.yapbam.currency.AbstractCurrencyConverter;
import net.yapbam.currency.AbstractXMLCurrencyConverter;
import net.yapbam.currency.CountryCurrencyMap;
import net.yapbam.currency.CurrencyHandler;
import net.yapbam.remote.Cache;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Deprecated
public class YahooCurrencyConverter
extends AbstractXMLCurrencyConverter {
    private static final String YAHOO_RATES_URL = "https://finance.yahoo.com/webservice/v1/symbols/allcurrencies/quote?format=xml";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String FIELD_TAG = "field";

    public YahooCurrencyConverter(Proxy proxy, Cache cache) {
        super(proxy, cache);
    }

    @Override
    protected URL getSourceURL() {
        try {
            return new URL(YAHOO_RATES_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected CurrencyHandler getXMLHandler() {
        return new YahooHandler();
    }

    @Override
    protected boolean isDataExpired() {
        long dataTimeStamp;
        if (this.getTimeStamp() < 0L) {
            return true;
        }
        long now = System.currentTimeMillis();
        if (now - (dataTimeStamp = this.getTimeStamp()) < 360000L) {
            return false;
        }
        if (now - this.getLastRefreshTimeStamp() < 60000L) {
            return false;
        }
        if (this.isWeekEnd(now)) {
            return now - dataTimeStamp > 259200000L || !this.isWeekEnd(this.getRefreshTimeStamp());
        }
        return true;
    }

    private boolean isWeekEnd(long time) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTimeInMillis(time);
        int day = cal.get(7);
        int hour = cal.get(11);
        if (day == 7) {
            return hour >= 12 && cal.get(12) >= 30;
        }
        if (day == 1) {
            return hour < 19;
        }
        return false;
    }

    private static final class YahooHandler
    extends CurrencyHandler {
        private String currency;
        private long rate;
        private StringBuilder buffer = new StringBuilder();
        private Field field;
        private long maxTStamp = 0L;

        private YahooHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.field = YahooCurrencyConverter.FIELD_TAG.equals(qName) && "symbol".equals(attributes.getValue(YahooCurrencyConverter.NAME_ATTRIBUTE)) ? Field.CURRENCY : (YahooCurrencyConverter.FIELD_TAG.equals(qName) && "price".equals(attributes.getValue(YahooCurrencyConverter.NAME_ATTRIBUTE)) ? Field.RATE : (YahooCurrencyConverter.FIELD_TAG.equals(qName) && "ts".equals(attributes.getValue(YahooCurrencyConverter.NAME_ATTRIBUTE)) ? Field.TIME_STAMP : null));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("resource".equals(qName) && this.currency != null && this.rate != 0L) {
                if (CountryCurrencyMap.INSTANCE.getCountries(this.currency) != null) {
                    this.getData().setCurrencyRate(this.currency, this.rate);
                }
            } else if (YahooCurrencyConverter.FIELD_TAG.equals(qName) && this.field != null) {
                long tstamp;
                if (this.field.equals((Object)Field.CURRENCY)) {
                    this.currency = this.buffer.substring(0, 3);
                } else if (this.field.equals((Object)Field.RATE)) {
                    this.rate = AbstractCurrencyConverter.stringToLong(this.buffer.toString());
                } else if (this.field.equals((Object)Field.TIME_STAMP) && this.currency != null && this.rate != 0L && (tstamp = Long.parseLong(this.buffer.toString()) * 1000L) > this.maxTStamp) {
                    this.maxTStamp = tstamp;
                }
                this.field = null;
                this.buffer.delete(0, this.buffer.length());
            }
        }

        @Override
        public void characters(char[] buffer, int start, int length) {
            if (this.field != null) {
                this.buffer.append(buffer, start, length);
            }
        }

        @Override
        public void endDocument() throws SAXException {
            this.getData().setReferenceDate(this.maxTStamp);
            super.endDocument();
        }
    }

    private static enum Field {
        CURRENCY,
        RATE,
        TIME_STAMP;

    }
}

