/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.text.MessageFormat;
import java.util.Date;

public class BalanceHistoryElement {
    private double balance;
    private Date from;
    private Date to;

    public BalanceHistoryElement(double balance, Date from, Date to) {
        this.balance = balance;
        this.from = from;
        this.to = to;
    }

    public double getBalance() {
        return this.balance;
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public String toString() {
        return MessageFormat.format("([{0,date,short}->{1,date,short}[: {2,number,currency})", this.from, this.to, this.balance);
    }

    public int getRelativePosition(Date date) {
        long timeFrom = this.from == null ? Long.MIN_VALUE : this.from.getTime();
        long timeTo = this.to == null ? Long.MAX_VALUE : this.to.getTime();
        long time = date.getTime();
        int result = 0;
        if (time < timeFrom) {
            result = -1;
        } else if (time >= timeTo) {
            result = 1;
        }
        return result;
    }

    void add(double amount) {
        this.balance += amount;
    }

    void setTo(Date date) {
        this.to = date;
    }
}

