/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Account;
import net.yapbam.data.Category;
import net.yapbam.data.Mode;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.util.DateUtils;

public class PeriodicalTransaction
extends AbstractTransaction {
    private int nextDate;
    private boolean enabled;
    private DateStepper nextDateBuilder;

    public PeriodicalTransaction(String description, String comment, double amount, Account account, Mode mode, Category category, List<SubTransaction> subTransactions, Date nextDate, boolean enabled, DateStepper nextDateBuilder) {
        super(description, comment, amount, account, mode, category, subTransactions);
        Date last;
        if (enabled && nextDate == null) {
            throw new IllegalArgumentException("Next date is Null and enabled is true");
        }
        this.nextDate = DateUtils.dateToInteger(nextDate);
        Date date = last = nextDateBuilder == null ? null : nextDateBuilder.getLastDate();
        if (last != null && DateUtils.dateToInteger(last) < this.nextDate) {
            throw new IllegalArgumentException("Next date is after End date");
        }
        this.nextDateBuilder = nextDateBuilder;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Date getNextDate() {
        return DateUtils.integerToDate(this.nextDate);
    }

    public DateStepper getNextDateBuilder() {
        return this.nextDateBuilder;
    }

    PeriodicalTransaction change(Category oldCategory, Category newCategory) {
        if (!this.hasCategory(oldCategory)) {
            return null;
        }
        List<SubTransaction> subTransactions = this.changeSubTransactions(oldCategory, newCategory);
        return new PeriodicalTransaction(this.getDescription(), this.getComment(), this.getAmount(), this.getAccount(), this.getMode(), this.getCategory().equals(oldCategory) ? newCategory : this.getCategory(), subTransactions, this.getNextDate(), this.isEnabled(), this.getNextDateBuilder());
    }

    PeriodicalTransaction change(Account account, Mode oldMode, Mode newMode) {
        if (this.getAccount().equals(account) && this.getMode().equals(oldMode)) {
            ArrayList<SubTransaction> subTransactionsClone = new ArrayList<SubTransaction>();
            for (int i = 0; i < this.getSubTransactionSize(); ++i) {
                subTransactionsClone.add(this.getSubTransaction(i));
            }
            return new PeriodicalTransaction(this.getDescription(), this.getComment(), this.getAmount(), this.getAccount(), newMode, this.getCategory(), subTransactionsClone, this.getNextDate(), this.isEnabled(), this.getNextDateBuilder());
        }
        return null;
    }

    public List<Transaction> generate(Date date, List<Transaction> result) {
        if (result == null) {
            result = new ArrayList<Transaction>();
        }
        if (this.hasPendingTransactions(date)) {
            DateStepper vdStepper;
            double amount = this.getAmount();
            Mode mode = this.getMode();
            DateStepper dateStepper = vdStepper = amount < 0.0 ? mode.getExpenseVdc() : mode.getReceiptVdc();
            if (vdStepper == null) {
                vdStepper = DateStepper.IMMEDIATE;
            }
            Date tDate = this.getNextDate();
            while (tDate != null && tDate.compareTo(date) <= 0) {
                result.add(new Transaction(tDate, null, this.getDescription(), this.getComment(), amount, this.getAccount(), mode, this.getCategory(), vdStepper.getNextStep(tDate), null, Arrays.asList(this.getSubTransactions())));
                tDate = this.getNextDateBuilder().getNextStep(tDate);
            }
        }
        return result;
    }

    public boolean hasPendingTransactions(Date date) {
        return this.isEnabled() && DateUtils.dateToInteger(date) >= this.nextDate;
    }
}

