/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.comparator;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import net.yapbam.data.Account;
import net.yapbam.data.GlobalData;

public abstract class AccountComparator {
    private static final Object LOCK = new Object();
    private static Locale LOCALE;
    private static Comparator<Account> INSTANCE;

    private AccountComparator() {
    }

    public static Account[] getSortedAccounts(GlobalData data, Locale locale) {
        Account[] accounts = new Account[data.getAccountsNumber()];
        for (int i = 0; i < accounts.length; ++i) {
            accounts[i] = data.getAccount(i);
        }
        Arrays.sort(accounts, AccountComparator.getInstance(locale));
        return accounts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Comparator<Account> getInstance(final Locale locale) {
        Object object = LOCK;
        synchronized (object) {
            if (!locale.equals(LOCALE)) {
                INSTANCE = new Comparator<Account>(){
                    Collator c;
                    {
                        this.c = Collator.getInstance(locale);
                    }

                    @Override
                    public int compare(Account o1, Account o2) {
                        return this.c.compare(o1.getName(), o2.getName());
                    }
                };
                LOCALE = locale;
            }
            return INSTANCE;
        }
    }
}

