/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.event;

import net.yapbam.data.Account;
import net.yapbam.data.Checkbook;
import net.yapbam.data.GlobalData;
import net.yapbam.data.event.DataEvent;
import net.yapbam.util.NullUtils;

public class CheckbookPropertyChangedEvent
extends DataEvent {
    public static final int PREFIX = 1;
    public static final int FIRST = 2;
    public static final int NEXT = 4;
    public static final int SIZE = 8;
    private int changes;
    private Account account;
    private Checkbook oldBook;
    private Checkbook newBook;

    public CheckbookPropertyChangedEvent(GlobalData globalData, Account account, Checkbook oldBook, Checkbook newBook) {
        super(globalData);
        this.account = account;
        this.oldBook = oldBook;
        this.newBook = newBook;
        this.changes = 0;
        if (!oldBook.getPrefix().equals(newBook.getPrefix())) {
            ++this.changes;
        }
        if (!oldBook.getFirst().equals(newBook.getFirst())) {
            this.changes += 2;
        }
        if (!NullUtils.areEquals(oldBook.getNext(), newBook.getNext())) {
            this.changes += 4;
        }
        if (oldBook.size() != newBook.size()) {
            this.changes += 8;
        }
    }

    public int getChanges() {
        return this.changes;
    }

    public Account getAccount() {
        return this.account;
    }

    public Checkbook getOldCheckbook() {
        return this.oldBook;
    }

    public Checkbook getNewCheckbook() {
        return this.newBook;
    }
}

