/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.data.xml;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.yapbam.data.Account;
import net.yapbam.data.AlertThreshold;
import net.yapbam.data.Category;
import net.yapbam.data.Checkbook;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.ProgressReport;
import net.yapbam.data.SubTransaction;
import net.yapbam.data.Transaction;
import net.yapbam.data.xml.DelegateHandler;
import net.yapbam.data.xml.FilterHandler;
import net.yapbam.data.xml.ParsingCancelledException;
import net.yapbam.data.xml.PartialTransaction;
import net.yapbam.data.xml.SaxUnsupportedFileVersionException;
import net.yapbam.data.xml.XMLSerializer;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.date.helpers.DayDateStepper;
import net.yapbam.date.helpers.DeferredValueDateComputer;
import net.yapbam.date.helpers.MonthDateStepper;
import net.yapbam.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

class GlobalDataHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalDataHandler.class);
    private static final boolean SLOW_READING = Boolean.getBoolean("slowDataReading");
    private GlobalData data;
    private ProgressReport report;
    private Stack<Object> tempData;
    private int currentProgress;
    private Collection<Transaction> transactions;
    private Map<String, String> tagToCData;
    private String currentTag;
    private Locator locator;
    private DelegateHandler delegateHandler;
    private boolean schemaValidation;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    GlobalDataHandler(boolean schemaValidation, ProgressReport report) {
        this.schemaValidation = schemaValidation;
        this.report = report;
        this.data = new GlobalData();
        this.tempData = new Stack();
        this.transactions = new ArrayList<Transaction>();
        this.tagToCData = new HashMap<String, String>();
        if (report != null) {
            report.setMax(-1);
        }
    }

    private Map<String, String> buildMap(Attributes attributes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            result.put(attributes.getLocalName(i), attributes.getValue(i));
        }
        return result;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.report != null && this.report.isCancelled()) {
            throw new ParsingCancelledException();
        }
        if (this.delegateHandler != null) {
            this.delegateHandler.startElement(uri, localName, qName, attributes);
            return;
        }
        if (!this.schemaValidation) {
            if (this.currentTag == null && !qName.equals("DATA")) {
                throw new SAXParseException("DATA expected as root tag", this.locator);
            }
            if (this.currentTag != null && qName.equals("DATA")) {
                throw new SAXParseException("DATA expected as root tag", this.locator);
            }
        }
        this.currentTag = qName;
        if ("DATA".equals(qName)) {
            String attr;
            int version;
            try {
                if (SLOW_READING) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            String dummy = attributes.getValue("version");
            int n = version = dummy == null ? 0 : Integer.parseInt(dummy);
            if (version > 1) {
                throw new SaxUnsupportedFileVersionException(this.locator, version);
            }
            if (this.report != null) {
                attr = attributes.getValue("nbTransactions");
                if (attr != null) {
                    this.report.setMax(Integer.parseInt(attr));
                    this.currentProgress = 0;
                    this.report.reportProgress(this.currentProgress);
                } else {
                    this.currentProgress = -1;
                }
            }
            if ((attr = attributes.getValue("subCategorySeparator")) != null) {
                this.data.setSubCategorySeparator(attr.charAt(0));
            }
            if ((attr = attributes.getValue("locked")) != null) {
                this.data.setLocked(true);
            }
            if ((attr = attributes.getValue("archive")) != null) {
                this.data.setArchive(true);
            }
        } else if (qName.equals("ACCOUNT")) {
            AlertThreshold alertThreshold;
            String id = attributes.getValue("id");
            double balance = Double.parseDouble(attributes.getValue("initialBalance"));
            Account account = new Account(id, balance);
            this.data.add(account);
            String lessAttribute = attributes.getValue("alertThresholdLess");
            if (lessAttribute == null) {
                alertThreshold = AlertThreshold.DEFAULT;
            } else {
                try {
                    alertThreshold = new AlertThreshold(Double.parseDouble(lessAttribute), this.parseDouble(attributes, "alertThresholdMore", Double.POSITIVE_INFINITY));
                }
                catch (NumberFormatException e) {
                    throw new SAXParseException("Expecting double here", this.locator);
                }
            }
            this.data.setAlertThreshold(account, alertThreshold);
            this.tempData.push(account);
        } else if (qName.equals("CATEGORY")) {
            String id = attributes.getValue("id").trim();
            if (this.data.getCategory(id) == null) {
                Category cat = new Category(id);
                this.data.add(cat);
            }
        } else if (qName.equals("MODE")) {
            this.tempData.push(attributes.getValue("id"));
            this.tempData.push(attributes.getValue("checkbook") != null);
            this.tempData.push(new DateStepper[2]);
        } else if (qName.equals("CHECKBOOK")) {
            String prefix = attributes.getValue("prefix");
            BigInteger first = new BigInteger(attributes.getValue("first"));
            String value = attributes.getValue("next");
            BigInteger next = value == null ? null : new BigInteger(value);
            int size = Integer.parseInt(attributes.getValue("size"));
            this.tempData.push(new Checkbook(prefix, first, size, next));
        } else if (qName.equals("EXPENSE") || qName.equals("RECEIPT")) {
            int index;
            DateStepper vdc;
            String kind = attributes.getValue("kind");
            if (kind == null || kind.equals("immediate")) {
                vdc = DateStepper.IMMEDIATE;
            } else if (kind.equals("daily")) {
                int delay = Integer.parseInt(attributes.getValue("period"));
                vdc = new DayDateStepper(delay, null);
            } else if (kind.equals("deferred")) {
                int stopDay = Integer.parseInt(attributes.getValue("stopDay"));
                int debtDay = Integer.parseInt(attributes.getValue("debtDay"));
                vdc = new DeferredValueDateComputer(stopDay, debtDay);
            } else {
                throw new RuntimeException("Invalid ValueDateComputer kind : " + kind);
            }
            DateStepper[] vdcs = (DateStepper[])this.tempData.peek();
            int n = index = qName.equals("EXPENSE") ? 0 : 1;
            if (vdcs[index] != null) {
                LOGGER.warn("Too much value date computer");
            }
            vdcs[index] = vdc;
        } else if (qName.equals("FILTER")) {
            this.delegateHandler = new FilterHandler(this.data);
            this.delegateHandler.startElement(uri, localName, qName, attributes);
        } else if (qName.equals("TRANSACTION")) {
            this.tempData.push(this.buildMap(attributes));
            this.tempData.push(null);
        } else if (qName.equals("SUBTRANSACTION")) {
            double amount = Double.parseDouble(attributes.getValue("amount"));
            String description = attributes.getValue("description");
            String categoryId = attributes.getValue("category");
            if (categoryId != null) {
                categoryId = categoryId.trim();
            }
            Category category = this.data.getCategory(categoryId);
            SubTransaction sub = new SubTransaction(amount, description, category);
            ArrayList<SubTransaction> lst = (ArrayList<SubTransaction>)this.tempData.peek();
            if (lst == null) {
                lst = new ArrayList<SubTransaction>();
                this.tempData.pop();
                this.tempData.push(lst);
            }
            lst.add(sub);
        } else if (qName.equals("PERIODICAL")) {
            this.tempData.push(this.buildMap(attributes));
            this.tempData.push(null);
            this.tempData.push(new ArrayList());
        } else if (qName.equals("DATE_STEPPER")) {
            DateStepper stepper;
            int period;
            String kind = attributes.getValue("kind");
            if (kind.equals("monthly")) {
                period = Integer.parseInt(attributes.getValue("period"));
                if (period <= 0) {
                    throw new IllegalArgumentException();
                }
                int day = Integer.parseInt(attributes.getValue("day"));
                String dummy = attributes.getValue("last");
                Date lastDate = dummy == null ? null : DateUtils.integerToDate(XMLSerializer.toDate(dummy));
                stepper = new MonthDateStepper(period, day, lastDate);
            } else if (kind.equals("daily")) {
                period = Integer.parseInt(attributes.getValue("period"));
                String dummy = attributes.getValue("last");
                Date lastDate = dummy == null ? null : DateUtils.integerToDate(XMLSerializer.toDate(dummy));
                stepper = new DayDateStepper(period, lastDate);
            } else {
                throw new IllegalArgumentException("Unknown date stepper : " + kind);
            }
            Object obj = this.tempData.pop();
            Object old = this.tempData.pop();
            this.tempData.push(stepper);
            this.tempData.push(obj);
            if (old != null) {
                throw new IllegalStateException("Two date steppers found");
            }
        } else {
            LOGGER.warn("Unknown tag {}", (Object)qName);
        }
    }

    private double parseDouble(Attributes attributes, String attrName, double defaultValue) throws SAXParseException {
        try {
            String value = attributes.getValue(attrName);
            return value == null ? defaultValue : Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new SAXParseException("Expecting double here", this.locator);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.report != null && this.report.isCancelled()) {
            throw new ParsingCancelledException();
        }
        if (this.delegateHandler != null) {
            this.delegateHandler.endElement(uri, localName, qName);
            if (this.delegateHandler.isEndTag(qName)) {
                if ("FILTER".equals(qName)) {
                    this.data.add(((FilterHandler)this.delegateHandler).getFilter());
                }
                this.delegateHandler = null;
            }
            return;
        }
        if (qName.equals("DATA")) {
            this.data.add(this.transactions.toArray(new Transaction[this.transactions.size()]));
        } else if (qName.equals("ACCOUNT")) {
            Account account = (Account)this.tempData.pop();
            String lastCData = this.tagToCData.get(qName);
            if (lastCData != null) {
                this.data.setComment(account, lastCData);
                this.tagToCData.remove(qName);
            }
        } else if (qName.equals("MODE")) {
            DateStepper[] vdcs = (DateStepper[])this.tempData.pop();
            boolean useCheckbook = (Boolean)this.tempData.pop();
            String id = (String)this.tempData.pop();
            id = id.trim();
            Account account = (Account)this.tempData.peek();
            if (account.getMode(id) == null) {
                Mode mode = new Mode(id, vdcs[1], vdcs[0], useCheckbook);
                this.data.add(account, mode);
            }
        } else if (qName.equals("CHECKBOOK")) {
            Checkbook book = (Checkbook)this.tempData.pop();
            Account account = (Account)this.tempData.peek();
            this.data.add(account, book);
        } else if (qName.equals("TRANSACTION")) {
            List lst = (List)this.tempData.pop();
            Map attributes = (Map)this.tempData.pop();
            PartialTransaction p = new PartialTransaction(this.data, attributes);
            int date = XMLSerializer.toDate((String)attributes.get("date"));
            String number = (String)attributes.get("number");
            int valueDate = XMLSerializer.toDate((String)attributes.get("valueDate"));
            String statement = (String)attributes.get("statement");
            this.transactions.add(new Transaction(date, number, p.description, p.comment, p.amount, p.account, p.mode, p.category, valueDate, statement, (List<SubTransaction>)lst));
            if (this.report != null) {
                if (this.currentProgress >= 0) {
                    ++this.currentProgress;
                    this.report.reportProgress(this.currentProgress);
                }
                if (SLOW_READING) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        } else if (qName.equals("PERIODICAL")) {
            ArrayList lst = (ArrayList)this.tempData.pop();
            DateStepper stepper = (DateStepper)this.tempData.pop();
            Map attributes = (Map)this.tempData.pop();
            PartialTransaction p = new PartialTransaction(this.data, attributes);
            String attribute = (String)attributes.get("next");
            Date nextDate = attribute == null ? null : DateUtils.integerToDate(XMLSerializer.toDate(attribute));
            boolean enabled = Boolean.parseBoolean((String)attributes.get("enabled"));
            if (nextDate != null && stepper != null && stepper.getLastDate() != null && stepper.getLastDate().compareTo(nextDate) < 0) {
                nextDate = null;
            }
            if (nextDate == null) {
                enabled = false;
            }
            this.data.add(new PeriodicalTransaction(p.description, p.comment, p.amount, p.account, p.mode, p.category, lst, nextDate, enabled, stepper));
        } else if (qName.equals("CATEGORY") || qName.equals("EXPENSE") || qName.equals("RECEIPT") || qName.equals("SUBTRANSACTION") || qName.equals("DATE_STEPPER")) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String str = new String(ch, start, length).trim();
        if (str.length() > 0) {
            this.tagToCData.put(this.currentTag, str);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.data.clear();
        super.startDocument();
    }

    public GlobalData getData() {
        return this.data;
    }
}

