/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import java.awt.Component;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import javax.swing.JOptionPane;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.Preferences;
import net.yapbam.gui.dialogs.ErrorDialog;
import net.yapbam.util.ApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorManager.class);
    public static final ErrorManager INSTANCE = new ErrorManager();
    private static final String ENC = "UTF-8";
    private BlockingDeque<Message> errorsQueue;
    private Set<String> encounteredErrors = new HashSet<String>();

    private ErrorManager() {
        this.errorsQueue = new LinkedBlockingDeque<Message>();
        final Thread thread = new Thread((Runnable)new LogSender(), "LogSender");
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                thread.interrupt();
            }
        }));
        thread.setDaemon(true);
        thread.start();
    }

    public void display(Component parent, Throwable t) {
        this.display(parent, t, LocalizationData.get("ErrorManager.message"));
    }

    public void display(Component parent, Throwable t, String message) {
        if (t != null) {
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            String trace = writer.getBuffer().toString();
            message = message + "\n\n" + trace;
            LOGGER.error(message, t);
        }
        JOptionPane.showMessageDialog(parent, message, LocalizationData.get("ErrorManager.title"), 2);
    }

    public void log(Window parent, Throwable t) {
        try {
            String trace = this.getTraceKey(t);
            if (!this.encounteredErrors.add(trace)) {
                return;
            }
            int action = Preferences.safeGetCrashReportAction();
            if (action == 0) {
                ErrorDialog errorDialog = new ErrorDialog(parent, t);
                errorDialog.setVisible(true);
                Object result = errorDialog.getResult();
                errorDialog.dispose();
                if (result != null) {
                    action = 1;
                }
            }
            if (action == 1) {
                this.errorsQueue.add(new Message(t));
            } else {
                LOGGER.error("Exception catched", t);
            }
        }
        catch (Throwable e) {
            LOGGER.error("Error while logging exception", e);
        }
    }

    private String getTraceKey(Throwable t) {
        StackTraceElement[] elements = t.getStackTrace();
        StringBuilder buffer = new StringBuilder();
        buffer.append(t.toString());
        int i = 0;
        for (StackTraceElement element : elements) {
            if (i == 2) break;
            buffer.append(element.toString());
            ++i;
        }
        return buffer.toString();
    }

    private static class Message {
        private String version;
        private String country;
        private String lang;
        private String osName;
        private String osVersion;
        private String javaVendor;
        private String javaVersion;
        private Throwable error;

        Message(Throwable t) {
            this.error = t;
            this.version = ApplicationContext.getVersion().toString();
            this.country = LocalizationData.getLocale().getCountry();
            this.lang = LocalizationData.getLocale().getLanguage();
            this.osName = System.getProperty("os.name", "?");
            this.osVersion = System.getProperty("os.version", "?");
            this.javaVendor = System.getProperty("java.vendor", "?");
            this.javaVersion = System.getProperty("java.version", "?");
        }
    }

    private class LogSender
    implements Runnable {
        private LogSender() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.postToYapbam((Message)ErrorManager.this.errorsQueue.take());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        private void addToBuffer(StringBuilder buffer, String variable, String value) throws UnsupportedEncodingException {
            buffer.append("&").append(URLEncoder.encode(variable, ErrorManager.ENC)).append("=").append(URLEncoder.encode(value, ErrorManager.ENC));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postToYapbam(Message message) throws IOException {
            StringWriter writer = new StringWriter();
            message.error.printStackTrace(new PrintWriter(writer));
            String trace = writer.getBuffer().toString();
            StringBuilder data = new StringBuilder();
            data.append(URLEncoder.encode("error", ErrorManager.ENC)).append("=").append(URLEncoder.encode(trace, ErrorManager.ENC));
            this.addToBuffer(data, "country", message.country);
            this.addToBuffer(data, "javaVendor", message.javaVendor);
            this.addToBuffer(data, "javaVersion", message.javaVersion);
            this.addToBuffer(data, "lang", message.lang);
            this.addToBuffer(data, "osName", message.osName);
            this.addToBuffer(data, "osVersion", message.osVersion);
            this.addToBuffer(data, "version", message.version);
            URL url = new URL("https://www.yapbam.net/crashReport.php");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection(Preferences.INSTANCE.getHttpProxy());
            conn.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream(), ErrorManager.ENC);
            try {
                wr.write(data.toString());
                wr.flush();
                BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), ErrorManager.ENC));
                try {
                    String line = rd.readLine();
                    while (line != null) {
                        LOGGER.info(line);
                        line = rd.readLine();
                    }
                }
                finally {
                    rd.close();
                }
            }
            finally {
                wr.close();
            }
        }
    }
}

