/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class Launcher {
    private static final String REQUIRED_JAVA_VERSION = "1.6";
    private static final String JAR_FILE_NAME = "program.jar";
    private static final String CLASS_NAME = "net.yapbam.gui.MainFrame";
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$net$yapbam$gui$Launcher;

    private Launcher() {
    }

    public static void main(String[] args) {
        String current = System.getProperty("java.specification.version");
        if (Float.parseFloat(current) < Float.parseFloat(REQUIRED_JAVA_VERSION)) {
            String message = "Your current java version is " + current + "\nYapbam requires Java " + REQUIRED_JAVA_VERSION + " or more.\nPlease have a look at http://java.sun.com";
            Launcher.error(message);
        } else {
            try {
                Class<?> mainClass = Launcher.noJar() ? Class.forName(CLASS_NAME) : Launcher.getClassFromJar();
                Method method = mainClass.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Launcher.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
                method.invoke(null, new Object[]{args});
            }
            catch (ClassNotFoundException e) {
                Launcher.error(e);
            }
            catch (SecurityException e) {
                Launcher.error(e);
            }
            catch (NoSuchMethodException e) {
                Launcher.error(e);
            }
            catch (IllegalArgumentException e) {
                Launcher.error(e);
            }
            catch (IllegalAccessException e) {
                Launcher.error(e);
            }
            catch (InvocationTargetException e) {
                Launcher.error(e);
            }
        }
    }

    private static Class getClassFromJar() throws ClassNotFoundException {
        try {
            File jarFile;
            File runningSource = new File((class$net$yapbam$gui$Launcher == null ? (class$net$yapbam$gui$Launcher = Launcher.class$("net.yapbam.gui.Launcher")) : class$net$yapbam$gui$Launcher).getProtectionDomain().getCodeSource().getLocation().toURI());
            if (runningSource.isFile()) {
                runningSource = runningSource.getParentFile();
            }
            if (!(jarFile = new File(runningSource, JAR_FILE_NAME)).exists()) {
                Launcher.error("<html>A program file is missing (" + jarFile.getAbsolutePath() + ").<br><br>You should install Yapbam again in order to fix it.<br></html>");
            }
            return new URLClassLoader(new URL[]{jarFile.toURI().toURL()}).loadClass(CLASS_NAME);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean noJar() {
        try {
            Class.forName(CLASS_NAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static void error(Throwable e) {
        String pattern = "<html>A fatal error occurs ({0}).<br>Maybe a program file is corrupted.<br><br>You should install Yapbam again in order to fix it.<br></html>";
        Launcher.error(MessageFormat.format(pattern, e.toString()));
    }

    private static void error(String message) {
        JOptionPane.showMessageDialog(null, message, "Sorry, unable to launch Yapbam", 0);
        System.exit(-1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

