/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.yapbam.data.FilteredData;
import net.yapbam.gui.AbstractPlugIn;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.AdministrationPanel;
import net.yapbam.gui.administration.PeriodicalTransactionListPanel;

public class AdministrationPlugIn
extends AbstractPlugIn {
    private AdministrationPanel panel;
    private boolean supportFilter;

    public AdministrationPlugIn(FilteredData filteredData, Object restartData) {
        this.panel = new AdministrationPanel(filteredData);
        this.supportFilter = this.isPeriodicalTransactionDisplayed();
        this.panel.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean newSupportFilter = AdministrationPlugIn.this.isPeriodicalTransactionDisplayed();
                if (newSupportFilter != AdministrationPlugIn.this.supportFilter) {
                    AdministrationPlugIn.this.supportFilter = newSupportFilter;
                    AdministrationPlugIn.this.getPropertyChangeSupport().firePropertyChange("filter", !AdministrationPlugIn.this.supportFilter, AdministrationPlugIn.this.supportFilter);
                }
            }
        });
        this.setPanelTitle(LocalizationData.get("AdministrationPlugIn.title"));
        this.setPanelToolTip(LocalizationData.get("AdministrationPlugIn.toolTip"));
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void restoreState() {
        this.panel.restoreState();
    }

    @Override
    public void saveState() {
        this.panel.saveState();
    }

    @Override
    public boolean allowMenu(int menuId) {
        if (menuId == 2) {
            return this.isPeriodicalTransactionDisplayed();
        }
        return super.allowMenu(menuId);
    }

    private boolean isPeriodicalTransactionDisplayed() {
        return this.panel.getTabbedPane().getSelectedComponent() instanceof PeriodicalTransactionListPanel;
    }
}

