/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration;

import com.fathzer.jlocal.Formatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import net.yapbam.data.AbstractTransaction;
import net.yapbam.data.Filter;
import net.yapbam.data.FilteredData;
import net.yapbam.data.GlobalData;
import net.yapbam.data.Mode;
import net.yapbam.data.PeriodicalTransaction;
import net.yapbam.data.event.DataEvent;
import net.yapbam.data.event.DataListener;
import net.yapbam.data.event.EverythingChangedEvent;
import net.yapbam.data.event.PeriodicalTransactionsAddedEvent;
import net.yapbam.data.event.PeriodicalTransactionsRemovedEvent;
import net.yapbam.date.helpers.DateStepper;
import net.yapbam.date.helpers.DayDateStepper;
import net.yapbam.date.helpers.MonthDateStepper;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.PeriodicalTransactionListPanel;
import net.yapbam.gui.administration.PeriodicalTransactionsTableSettings;
import net.yapbam.gui.transactiontable.GenericTransactionTableModel;
import net.yapbam.gui.transactiontable.SpreadState;
import net.yapbam.gui.transactiontable.TransactionTableUtils;

final class PeriodicalTransactionTableModel
extends GenericTransactionTableModel {
    private final PeriodicalTransactionListPanel periodicTransactionListPanel;
    private PeriodicalTransactionsTableSettings settings;
    private boolean ignoreFilter;
    private List<PeriodicalTransaction> transactions;

    PeriodicalTransactionTableModel(PeriodicalTransactionListPanel periodicTransactionListPanel) {
        this.periodicTransactionListPanel = periodicTransactionListPanel;
        this.ignoreFilter = true;
        this.settings = new PeriodicalTransactionsTableSettings();
        this.transactions = new ArrayList<PeriodicalTransaction>();
        this.getGlobalData().addListener(new DataListener(){

            @Override
            public void processEvent(DataEvent event) {
                if (event instanceof PeriodicalTransactionsAddedEvent) {
                    PeriodicalTransactionTableModel.this.updateTransactionList();
                } else if (event instanceof PeriodicalTransactionsRemovedEvent) {
                    for (PeriodicalTransaction transaction : ((PeriodicalTransactionsRemovedEvent)event).getRemoved()) {
                        PeriodicalTransactionTableModel.this.setSpread(transaction, false);
                    }
                    PeriodicalTransactionTableModel.this.updateTransactionList();
                } else if (event instanceof EverythingChangedEvent) {
                    PeriodicalTransactionTableModel.this.clearSpreadData();
                    PeriodicalTransactionTableModel.this.transactions.clear();
                    PeriodicalTransactionTableModel.this.updateTransactionList();
                }
            }
        });
        ((FilteredData)this.periodicTransactionListPanel.data).getFilter().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (!PeriodicalTransactionTableModel.this.ignoreFilter) {
                    PeriodicalTransactionTableModel.this.updateTransactionList();
                }
            }
        });
        this.updateTransactionList();
    }

    private void updateTransactionList() {
        Filter filter = this.ignoreFilter ? null : ((FilteredData)this.periodicTransactionListPanel.data).getFilter();
        ArrayList<PeriodicalTransaction> oldList = new ArrayList<PeriodicalTransaction>(this.transactions);
        this.transactions.clear();
        for (int i = 0; i < this.getGlobalData().getPeriodicalTransactionsNumber(); ++i) {
            PeriodicalTransaction tr = this.getGlobalData().getPeriodicalTransaction(i);
            if (filter != null && filter.isActive() && !filter.isOk(tr)) continue;
            this.transactions.add(tr);
        }
        if (filter != null && filter.isActive()) {
            for (PeriodicalTransaction tr : oldList) {
                if (this.transactions.contains(tr)) continue;
                this.setSpread(tr, false);
            }
        }
        this.fireTableDataChanged();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == this.settings.getSpreadColumn()) {
            return LocalizationData.get("Transaction.0");
        }
        if (columnIndex == this.settings.getAccountColumn()) {
            return LocalizationData.get("Transaction.account");
        }
        if (columnIndex == this.settings.getDescriptionColumn()) {
            return LocalizationData.get("Transaction.description");
        }
        if (columnIndex == this.settings.getCommentColumn()) {
            return LocalizationData.get("Transaction.comment");
        }
        if (columnIndex == this.settings.getAmountColumn()) {
            return LocalizationData.get("Transaction.amount");
        }
        if (columnIndex == this.settings.getReceiptColumn()) {
            return LocalizationData.get("StatementView.receipt");
        }
        if (columnIndex == this.settings.getExpenseColumn()) {
            return LocalizationData.get("StatementView.debt");
        }
        if (columnIndex == this.settings.getCategoryColumn()) {
            return LocalizationData.get("Transaction.category");
        }
        if (columnIndex == this.settings.getModeColumn()) {
            return LocalizationData.get("Transaction.mode");
        }
        if (columnIndex == this.settings.getNextDateColumn()) {
            return LocalizationData.get("PeriodicalTransactionManager.nextDate.column");
        }
        if (columnIndex == this.settings.getPeriodColumn()) {
            return LocalizationData.get("PeriodicalTransactionManager.period.column");
        }
        if (columnIndex == this.settings.getActiveColumn()) {
            return LocalizationData.get("PeriodicalTransactionManager.active.column");
        }
        return "?";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == this.settings.getSpreadColumn()) {
            return SpreadState.class;
        }
        if (columnIndex == this.settings.getNextDateColumn()) {
            return Date.class;
        }
        if (columnIndex == this.settings.getAmountColumn() || columnIndex == this.settings.getReceiptColumn() || columnIndex == this.settings.getExpenseColumn()) {
            return double[].class;
        }
        if (columnIndex == this.settings.getActiveColumn()) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        boolean spread = this.isSpread(rowIndex);
        PeriodicalTransaction transaction = (PeriodicalTransaction)this.getTransaction(rowIndex);
        if (columnIndex == this.settings.getSpreadColumn()) {
            if (transaction.getSubTransactionSize() == 0) {
                return SpreadState.NOT_SPREADABLE;
            }
            return spread ? SpreadState.SPREAD : SpreadState.NOT_SPREAD;
        }
        if (columnIndex == this.settings.getAccountColumn()) {
            return transaction.getAccount().getName();
        }
        if (columnIndex == this.settings.getDescriptionColumn()) {
            return TransactionTableUtils.getDescription(transaction, spread, !this.settings.isCommentSeparatedFromDescription(), true);
        }
        if (columnIndex == this.settings.getCommentColumn()) {
            return TransactionTableUtils.getComment(transaction);
        }
        if (columnIndex == this.settings.getAmountColumn()) {
            return TransactionTableUtils.getAmount(transaction, spread);
        }
        if (columnIndex == this.settings.getReceiptColumn()) {
            return TransactionTableUtils.getExpenseReceipt(transaction, spread, false);
        }
        if (columnIndex == this.settings.getExpenseColumn()) {
            return TransactionTableUtils.getExpenseReceipt(transaction, spread, true);
        }
        if (columnIndex == this.settings.getCategoryColumn()) {
            return TransactionTableUtils.getCategory(transaction, spread);
        }
        if (columnIndex == this.settings.getModeColumn()) {
            Mode mode = transaction.getMode();
            return mode.equals(Mode.UNDEFINED) ? "" : mode.getName();
        }
        if (columnIndex == this.settings.getNextDateColumn()) {
            return transaction.getNextDate();
        }
        if (columnIndex == this.settings.getPeriodColumn()) {
            MonthDateStepper monthlyPeriod;
            DateStepper period = transaction.getNextDateBuilder();
            String result = period instanceof DayDateStepper ? (((DayDateStepper)period).getStep() == 1 ? LocalizationData.get("PeriodicalTransactionManager.period.daily.singular.content") : Formatter.format(LocalizationData.get("PeriodicalTransactionManager.period.daily.content"), ((DayDateStepper)period).getStep())) : (period instanceof MonthDateStepper ? ((monthlyPeriod = (MonthDateStepper)period).getPeriod() % 12 == 0 ? (monthlyPeriod.getPeriod() == 12 ? Formatter.format(LocalizationData.get("PeriodicalTransactionManager.period.yearly.singular.content"), monthlyPeriod.getDay()) : Formatter.format(LocalizationData.get("PeriodicalTransactionManager.period.yearly.content"), monthlyPeriod.getPeriod() / 12, monthlyPeriod.getDay())) : (monthlyPeriod.getPeriod() == 1 ? Formatter.format(LocalizationData.get("PeriodicalTransactionManager.period.monthly.singular.content"), monthlyPeriod.getDay()) : Formatter.format(LocalizationData.get("PeriodicalTransactionManager.period.monthly.content"), monthlyPeriod.getPeriod(), monthlyPeriod.getDay()))) : "");
            if (period != null && period.getLastDate() != null) {
                result = Formatter.format(LocalizationData.get("PeriodicalTransactionManager.period.until"), result, period.getLastDate());
            }
            return result;
        }
        if (columnIndex == this.settings.getActiveColumn()) {
            return transaction.isEnabled();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getRowCount() {
        return this.transactions.size();
    }

    @Override
    public int getColumnCount() {
        return this.settings.getColumnCount();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return (columnIndex == this.settings.getDescriptionColumn() || columnIndex == this.settings.getCommentColumn()) && columnIndex >= 0;
    }

    GlobalData getGlobalData() {
        return ((FilteredData)this.periodicTransactionListPanel.data).getGlobalData();
    }

    @Override
    public AbstractTransaction getTransaction(int rowIndex) {
        return this.transactions.get(rowIndex);
    }

    public PeriodicalTransactionsTableSettings getTableSettings() {
        return this.settings;
    }

    public void setIgnoreFilter(boolean ignore) {
        if (ignore != this.ignoreFilter) {
            this.ignoreFilter = ignore;
            this.updateTransactionList();
        }
    }
}

