/*
 * Decompiled with CFR 0.152.
 */
package net.yapbam.gui.administration.filter;

import com.fathzer.jlocal.Formatter;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import net.yapbam.data.Filter;
import net.yapbam.gui.LocalizationData;
import net.yapbam.gui.administration.filter.FilterNamePanel;
import net.yapbam.gui.dialogs.CustomFilterDialog;

public class FilterDialog
extends CustomFilterDialog {
    private static final long serialVersionUID = 1L;
    private FilterNamePanel namePanel;

    public FilterDialog(Window owner, CustomFilterDialog.FilterData data) {
        super(owner, data);
    }

    @Override
    protected Boolean buildResult() {
        Filter filter = ((CustomFilterDialog.FilterData)this.data).getFilter();
        filter.setSuspended(true);
        filter.setName(this.namePanel.getNameField().getText());
        return super.buildResult();
    }

    @Override
    protected JComponent createExtraComponent() {
        this.namePanel = new FilterNamePanel(this.getFilterPanel());
        this.namePanel.getNameField().addPropertyChangeListener("text", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FilterDialog.this.updateOkButtonEnabled();
            }
        });
        return this.namePanel;
    }

    @Override
    protected String getOkDisabledCause() {
        String cause = super.getOkDisabledCause();
        if (cause == null) {
            String oldName = ((CustomFilterDialog.FilterData)this.data).getFilter().getName();
            String name = this.namePanel.getNameField().getText();
            if (name.isEmpty()) {
                cause = LocalizationData.get("CustomFilterPanel.error.filterNameIsMissing");
            } else if (!name.equals(oldName) && ((CustomFilterDialog.FilterData)this.data).getGlobalData().getFilter(name) != null) {
                cause = Formatter.format(LocalizationData.get("CustomFilterPanel.error.filterNameExists"), name);
            }
        }
        return cause;
    }

    void setFilterName(String name) {
        this.namePanel.getNameField().setText(name);
    }
}

